/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.regression.AFTPoint;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\t5\u0011Q\"\u0011$U\u0003\u001e<'/Z4bi>\u0014(BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001a\u00031\u00117\rU1sC6,G/\u001a:t!\rQRdH\u0007\u00027)\u0011ADB\u0001\nEJ|\u0017\rZ2bgRL!AH\u000e\u0003\u0013\t\u0013x.\u00193dCN$\bc\u0001\u0011&O5\t\u0011E\u0003\u0002#G\u00051A.\u001b8bY\u001eT\u0011\u0001J\u0001\u0007EJ,WM_3\n\u0005\u0019\n#a\u0003#f]N,g+Z2u_J\u0004\"a\u0004\u0015\n\u0005%\u0002\"A\u0002#pk\ndW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u000311\u0017\u000e^%oi\u0016\u00148-\u001a9u!\tyQ&\u0003\u0002/!\t9!i\\8mK\u0006t\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u001b\t\u001cg)Z1ukJ,7o\u0015;e!\rQRD\r\t\u0004\u001fM:\u0013B\u0001\u001b\u0011\u0005\u0015\t%O]1z\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q!\u0001HO\u001e=!\tI\u0004!D\u0001\u0003\u0011\u0015AR\u00071\u0001\u001a\u0011\u0015YS\u00071\u0001-\u0011\u0015\u0001T\u00071\u00012\u0011\u001dq\u0004A1A\u0005\n}\na\u0001\\3oORDW#\u0001!\u0011\u0005=\t\u0015B\u0001\"\u0011\u0005\rIe\u000e\u001e\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002!\u0002\u000f1,gn\u001a;iA!Aa\t\u0001EC\u0002\u0013%q)\u0001\u0006qCJ\fW.\u001a;feN,\u0012a\b\u0015\u0003\u000b&\u0003\"a\u0004&\n\u0005-\u0003\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011!i\u0005\u0001#b\u0001\n\u00139\u0015\u0001D2pK\u001a4\u0017nY5f]R\u001c\bF\u0001'J\u0011!\u0001\u0006\u0001#b\u0001\n\u0013\t\u0016!C5oi\u0016\u00148-\u001a9u+\u00059\u0003FA(J\u0011!!\u0006\u0001#b\u0001\n\u0013\t\u0016!B:jO6\f\u0007FA*J\u0011\u001d9\u0006\u00011A\u0005\na\u000b\u0001\u0002^8uC2\u001ce\u000e^\u000b\u00023B\u0011qBW\u0005\u00037B\u0011A\u0001T8oO\"9Q\f\u0001a\u0001\n\u0013q\u0016\u0001\u0004;pi\u0006d7I\u001c;`I\u0015\fHCA0c!\ty\u0001-\u0003\u0002b!\t!QK\\5u\u0011\u001d\u0019G,!AA\u0002e\u000b1\u0001\u001f\u00132\u0011\u0019)\u0007\u0001)Q\u00053\u0006IAo\u001c;bY\u000esG\u000f\t\u0005\bO\u0002\u0001\r\u0011\"\u0003R\u0003\u001dawn]:Tk6Dq!\u001b\u0001A\u0002\u0013%!.A\u0006m_N\u001c8+^7`I\u0015\fHCA0l\u0011\u001d\u0019\u0007.!AA\u0002\u001dBa!\u001c\u0001!B\u00139\u0013\u0001\u00037pgN\u001cV/\u001c\u0011\t\u0011=\u0004\u0001R1A\u0005\nA\f\u0001c\u001a:bI&,g\u000e^*v[\u0006\u0013(/Y=\u0016\u0003IBQA\u001d\u0001\u0005\u0002a\u000bQaY8v]RDQ\u0001\u001e\u0001\u0005\u0002E\u000bA\u0001\\8tg\")a\u000f\u0001C\u0001\u000f\u0006AqM]1eS\u0016tG\u000fC\u0003y\u0001\u0011\u0005\u00110A\u0002bI\u0012$\"A_>\u000e\u0003\u0001AQ\u0001`<A\u0002u\fA\u0001Z1uCB\u0011\u0011H`\u0005\u0003\u007f\n\u0011\u0001\"\u0011$U!>Lg\u000e\u001e\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003\u0015iWM]4f)\rQ\u0018q\u0001\u0005\b\u0003\u0013\t\t\u00011\u00019\u0003\u0015yG\u000f[3s\u0001")
public class AFTAggregator
implements Serializable {
    private transient DenseVector<Object> parameters;
    private transient DenseVector<Object> coefficients;
    private transient double intercept;
    private transient double sigma;
    private double[] gradientSumArray;
    private final Broadcast<DenseVector<Object>> bcParameters;
    private final boolean fitIntercept;
    private final Broadcast<double[]> bcFeaturesStd;
    private final int length;
    private long totalCnt;
    private double lossSum;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    private int length() {
        return this.length;
    }

    private DenseVector<Object> parameters$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.parameters = (DenseVector)this.bcParameters.value();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.parameters;
    }

    private DenseVector<Object> parameters() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.parameters$lzycompute() : this.parameters;
    }

    private DenseVector<Object> coefficients$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.coefficients = this.parameters().slice$mcD$sp(2, this.length(), this.parameters().slice$default$3());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.coefficients;
    }

    private DenseVector<Object> coefficients() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.coefficients$lzycompute() : this.coefficients;
    }

    private double intercept$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.intercept = this.parameters().apply$mcD$sp(1);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.intercept;
    }

    private double intercept() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.intercept$lzycompute() : this.intercept;
    }

    private double sigma$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.sigma = package$.MODULE$.exp(this.parameters().apply$mcD$sp(0));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.sigma;
    }

    private double sigma() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.sigma$lzycompute() : this.sigma;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double lossSum() {
        return this.lossSum;
    }

    private void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        AFTAggregator aFTAggregator = this;
        synchronized (aFTAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = (double[])Array$.MODULE$.ofDim(this.length(), ClassTag$.MODULE$.Double());
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    private double[] gradientSumArray() {
        return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
    }

    public long count() {
        return this.totalCnt();
    }

    public double loss() {
        Predef$.MODULE$.require((double)this.totalCnt() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("The number of instances should be ").append(new StringBuilder(27).append("greater than 0.0, but got ").append(this.totalCnt()).append(".").toString()).toString());
        return this.lossSum() / (double)this.totalCnt();
    }

    public DenseVector<Object> gradient() {
        Predef$.MODULE$.require((double)this.totalCnt() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("The number of instances should be ").append(new StringBuilder(27).append("greater than 0.0, but got ").append(this.totalCnt()).append(".").toString()).toString());
        return new DenseVector.mcD.sp((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.gradientSumArray())).map((Function1)(JFunction1.mcDD.sp & java.io.Serializable & Serializable)x$2 -> x$2 / (double)this.totalCnt(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public AFTAggregator add(AFTPoint data) {
        Vector xi = data.features();
        double ti = data.label();
        double delta = data.censor();
        Predef$.MODULE$.require(ti > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "The lifetime or label should be  greater than 0.");
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        DoubleRef sum = DoubleRef.create((double)0.0);
        xi.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
            block0: {
                if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                sum$1.elem += this.coefficients().apply$mcD$sp(index) * (value / localFeaturesStd[index]);
            }
        });
        double margin = sum.elem + this.intercept();
        double epsilon = (package$.MODULE$.log(ti) - margin) / this.sigma();
        this.lossSum_$eq(this.lossSum() + (delta * package$.MODULE$.log(this.sigma()) - delta * epsilon + package$.MODULE$.exp(epsilon)));
        double multiplier = (delta - package$.MODULE$.exp(epsilon)) / this.sigma();
        this.gradientSumArray()[0] = this.gradientSumArray()[0] + (delta + multiplier * this.sigma() * epsilon);
        this.gradientSumArray()[1] = this.gradientSumArray()[1] + (this.fitIntercept ? multiplier : 0.0);
        xi.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
            block0: {
                if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                int n = index + 2;
                $this.gradientSumArray()[n] = this.gradientSumArray()[n] + multiplier * (value / localFeaturesStd[index]);
            }
        });
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public AFTAggregator merge(AFTAggregator other) {
        if (other.count() != 0L) {
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            this.lossSum_$eq(this.lossSum() + other.lossSum());
            for (int i = 0; i < this.length(); ++i) {
                int n = i;
                this.gradientSumArray()[n] = this.gradientSumArray()[n] + other.gradientSumArray()[i];
            }
        }
        return this;
    }

    public AFTAggregator(Broadcast<DenseVector<Object>> bcParameters, boolean fitIntercept, Broadcast<double[]> bcFeaturesStd) {
        this.bcParameters = bcParameters;
        this.fitIntercept = fitIntercept;
        this.bcFeaturesStd = bcFeaturesStd;
        this.length = ((DenseVector)bcParameters.value()).length();
        this.totalCnt = 0L;
        this.lossSum = 0.0;
    }
}

