/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTCostFun;
import org.apache.spark.ml.regression.AFTPoint;
import org.apache.spark.ml.regression.AFTSurvivalRegression$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u00015\u0011Q#\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|gN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u000191\u0012d\b\t\u0004\u001fA\u0011R\"\u0001\u0003\n\u0005E!!!C#ti&l\u0017\r^8s!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u000eB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u001c\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0005iiR\"A\u000e\u000b\u0005q!\u0011\u0001B;uS2L!AH\u000e\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mKB\u0011\u0001eI\u0007\u0002C)\u0011!EB\u0001\tS:$XM\u001d8bY&\u0011A%\t\u0002\b\u0019><w-\u001b8h\u0011!1\u0003A!b\u0001\n\u0003:\u0013aA;jIV\t\u0001\u0006\u0005\u0002*e9\u0011!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0003[1\ta\u0001\u0010:p_Rt$\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er\u0013A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0018)\u0007\u00152D\b\u0005\u00028u5\t\u0001H\u0003\u0002:\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005mB$!B*j]\u000e,\u0017%A\u001f\u0002\u000bErcG\f\u0019\t\u0011}\u0002!\u0011!Q\u0001\n!\nA!^5eA!\u001aaH\u000e\u001f\t\u000b\t\u0003A\u0011A\"\u0002\rqJg.\u001b;?)\t!U\t\u0005\u0002\u0014\u0001!)a%\u0011a\u0001Q!\u001aQI\u000e\u001f)\u0007\u00053D\bC\u0003C\u0001\u0011\u0005\u0011\nF\u0001EQ\rAe\u0007\u0010\u0005\u0006\u0019\u0002!\t!T\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\tqu*D\u0001\u0001\u0011\u0015\u00016\n1\u0001)\u0003\u00151\u0018\r\\;fQ\rYe\u0007\u0010\u0005\u0006'\u0002!\t\u0001V\u0001\fg\u0016$H*\u00192fY\u000e{G\u000e\u0006\u0002O+\")\u0001K\u0015a\u0001Q!\u001a!K\u000e\u001f\t\u000ba\u0003A\u0011A-\u0002\u0019M,GoQ3og>\u00148i\u001c7\u0015\u00059S\u0006\"\u0002)X\u0001\u0004A\u0003fA,7y!)Q\f\u0001C\u0001=\u0006\u00012/\u001a;Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003\u001d~CQ\u0001\u0015/A\u0002!B3\u0001\u0018\u001c=\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003a\u0019X\r^)vC:$\u0018\u000e\\3Qe>\u0014\u0017MY5mSRLWm\u001d\u000b\u0003\u001d\u0012DQ\u0001U1A\u0002\u0015\u00042AZ4j\u001b\u0005q\u0013B\u00015/\u0005\u0015\t%O]1z!\t1'.\u0003\u0002l]\t1Ai\\;cY\u0016D3!\u0019\u001c=\u0011\u0015q\u0007\u0001\"\u0001p\u0003=\u0019X\r^)vC:$\u0018\u000e\\3t\u0007>dGC\u0001(q\u0011\u0015\u0001V\u000e1\u0001)Q\rig\u0007\u0010\u0005\u0006g\u0002!\t\u0001^\u0001\u0010g\u0016$h)\u001b;J]R,'oY3qiR\u0011a*\u001e\u0005\u0006!J\u0004\rA\u001e\t\u0003M^L!\u0001\u001f\u0018\u0003\u000f\t{w\u000e\\3b]\"\u001a!O\u000e\u001f\t\u000bm\u0004A\u0011\u0001?\u0002\u0015M,G/T1y\u0013R,'\u000f\u0006\u0002O{\")\u0001K\u001fa\u0001}B\u0011am`\u0005\u0004\u0003\u0003q#aA%oi\"\u001a!P\u000e\u001f\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u000511/\u001a;U_2$2ATA\u0006\u0011\u0019\u0001\u0016Q\u0001a\u0001S\"\"\u0011Q\u0001\u001c=\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\t1c]3u\u0003\u001e<'/Z4bi&|g\u000eR3qi\"$2ATA\u000b\u0011\u0019\u0001\u0016q\u0002a\u0001}\"*\u0011q\u0002\u001c\u0002\u001a\u0005\u0012\u00111D\u0001\u0006e9\nd\u0006\r\u0005\t\u0003?\u0001A\u0011\u0003\u0003\u0002\"\u0005\u0001R\r\u001f;sC\u000e$\u0018I\u0012+Q_&tGo\u001d\u000b\u0005\u0003G\t)\u0004\u0005\u0004\u0002&\u0005-\u0012qF\u0007\u0003\u0003OQ1!!\u000b\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003[\t9CA\u0002S\t\u0012\u00032aEA\u0019\u0013\r\t\u0019D\u0001\u0002\t\u0003\u001a#\u0006k\\5oi\"A\u0011qGA\u000f\u0001\u0004\tI$A\u0004eCR\f7/\u001a;1\t\u0005m\u00121\n\t\u0007\u0003{\t\u0019%a\u0012\u000e\u0005\u0005}\"bAA!\r\u0005\u00191/\u001d7\n\t\u0005\u0015\u0013q\b\u0002\b\t\u0006$\u0018m]3u!\u0011\tI%a\u0013\r\u0001\u0011a\u0011QJA\u001b\u0003\u0003\u0005\tQ!\u0001\u0002P\t\u0019q\fJ\u0019\u0012\t\u0005E\u0013q\u000b\t\u0004M\u0006M\u0013bAA+]\t9aj\u001c;iS:<\u0007c\u00014\u0002Z%\u0019\u00111\f\u0018\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002`\u0001!\t%!\u0019\u0002\u0007\u0019LG\u000fF\u0002\u0013\u0003GB\u0001\"a\u000e\u0002^\u0001\u0007\u0011Q\r\u0019\u0005\u0003O\nY\u0007\u0005\u0004\u0002>\u0005\r\u0013\u0011\u000e\t\u0005\u0003\u0013\nY\u0007\u0002\u0007\u0002n\u0005\r\u0014\u0011!A\u0001\u0006\u0003\tyEA\u0002`IIBS!!\u00187\u0003c\n#!a\u001d\u0002\u000bIr\u0003G\f\u0019\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002|\u0005\u001d\u0005\u0003BA?\u0003\u0007k!!a \u000b\t\u0005\u0005\u0015qH\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u000b\u000byH\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001\"!#\u0002v\u0001\u0007\u00111P\u0001\u0007g\u000eDW-\\1)\t\u0005Ud\u0007\u0010\u0005\b\u0003\u001f\u0003A\u0011IAI\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0011\u000b\u0019\n\u0003\u0005\u0002\u0016\u00065\u0005\u0019AAL\u0003\u0015)\u0007\u0010\u001e:b!\u0011\tI*a(\u000e\u0005\u0005m%bAAO\t\u0005)\u0001/\u0019:b[&!\u0011\u0011UAN\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006BAGmqB3\u0001\u0001\u001c=Q\r\u0001\u0011\u0011\u0016\t\u0004o\u0005-\u0016bAAWq\taQ\t\u001f9fe&lWM\u001c;bY\u001e9\u0011\u0011\u0017\u0002\t\u0002\u0005M\u0016!F!G)N+(O^5wC2\u0014Vm\u001a:fgNLwN\u001c\t\u0004'\u0005UfAB\u0001\u0003\u0011\u0003\t9l\u0005\u0005\u00026\u0006e\u0016qXAc!\r1\u00171X\u0005\u0004\u0003{s#AB!osJ+g\r\u0005\u0003\u001b\u0003\u0003$\u0015bAAb7\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u00014\u0002H&\u0019\u0011\u0011\u001a\u0018\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f\t\u000b)\f\"\u0001\u0002NR\u0011\u00111\u0017\u0005\t\u0003#\f)\f\"\u0011\u0002T\u0006!An\\1e)\r!\u0015Q\u001b\u0005\b\u0003/\fy\r1\u0001)\u0003\u0011\u0001\u0018\r\u001e5)\t\u0005=g\u0007\u0010\u0005\u000b\u0003;\f),!A\u0005\n\u0005}\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!9\u0011\t\u0005\r\u0018Q^\u0007\u0003\u0003KTA!a:\u0002j\u0006!A.\u00198h\u0015\t\tY/\u0001\u0003kCZ\f\u0017\u0002BAx\u0003K\u0014aa\u00142kK\u000e$\b\u0006BA[mqBC!a,7y\u0001")
public class AFTSurvivalRegression
extends Estimator<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final IntParam aggregationDepth;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    public static MLReader<AFTSurvivalRegression> read() {
        return AFTSurvivalRegression$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return AFTSurvivalRegression$.MODULE$.load(string);
    }

    public static AFTSurvivalRegression load(String string) {
        return AFTSurvivalRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public AFTSurvivalRegression setFeaturesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegression setLabelCol(String value) {
        return (AFTSurvivalRegression)this.set(this.labelCol(), value);
    }

    public AFTSurvivalRegression setCensorCol(String value) {
        return (AFTSurvivalRegression)this.set(this.censorCol(), value);
    }

    public AFTSurvivalRegression setPredictionCol(String value) {
        return (AFTSurvivalRegression)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegression setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegression)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegression setQuantilesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.quantilesCol(), value);
    }

    public AFTSurvivalRegression setFitIntercept(boolean value) {
        return (AFTSurvivalRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public AFTSurvivalRegression setMaxIter(int value) {
        return (AFTSurvivalRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public AFTSurvivalRegression setTol(double value) {
        return (AFTSurvivalRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public AFTSurvivalRegression setAggregationDepth(int value) {
        return (AFTSurvivalRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public RDD<AFTPoint> extractAFTPoints(Dataset<?> dataset) {
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.$(this.censorCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Vector vector;
            Object censor;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object features = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    censor = ((SeqLike)some.get()).apply(2);
                    if (!(features instanceof Vector)) break block2;
                    vector = (Vector)features;
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (censor instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)censor);
            AFTPoint aFTPoint = new AFTPoint(vector, d, d2);
            return aFTPoint;
        }, ClassTag$.MODULE$.apply(AFTPoint.class));
    }

    @Override
    public AFTSurvivalRegressionModel fit(Dataset<?> dataset) {
        return (AFTSurvivalRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            RDD<AFTPoint> instances = this.extractAFTPoints(dataset);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            Function2 & Serializable & scala.Serializable seqOp = (Function2 & Serializable & scala.Serializable)(c, v) -> c.add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(v.features()));
            Function2 & Serializable & scala.Serializable combOp = (Function2 & Serializable & scala.Serializable)(c1, c2) -> c1.merge((MultivariateOnlineSummarizer)c2);
            MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)instances.treeAggregate((Object)new MultivariateOnlineSummarizer(), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
            double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            int numFeatures = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresStd)).size();
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.censorCol(), this.predictionCol(), this.quantilesCol(), this.fitIntercept(), this.maxIter(), this.tol(), this.aggregationDepth()}));
            instr.logNamedValue("quantileProbabilities.size", this.$(this.quantileProbabilities()).length);
            instr.logNumFeatures(numFeatures);
            instr.logNumExamples(featuresSummarizer.count());
            if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> featuresStd[i] == 0.0 && featuresSummarizer.mean().apply(i) != 0.0)) {
                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fitting AFTSurvivalRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is different from R survival::survreg.");
            }
            Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            AFTCostFun costFun = new AFTCostFun(instances, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<double[]>)bcFeaturesStd, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())));
            LBFGS optimizer = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
            Vector initialParameters = Vectors$.MODULE$.zeros(numFeatures + 2);
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialParameters.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            FirstOrderMinimizer.State state = null;
            while (states.hasNext()) {
                state = (FirstOrderMinimizer.State)states.next();
                arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
            }
            if (state == null) {
                String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                throw new SparkException(msg);
            }
            double[] parameters = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
            bcFeaturesStd.destroy(false);
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            double[] rawCoefficients = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(parameters)).slice(2, parameters.length);
            for (int i2 = 0; i2 < numFeatures; ++i2) {
                int n = i2;
                rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i2] != 0.0 ? 1.0 / featuresStd[i2] : 0.0);
            }
            Vector coefficients = Vectors$.MODULE$.dense(rawCoefficients);
            double intercept = parameters[1];
            double scale = package$.MODULE$.exp(parameters[0]);
            return this.copyValues(new AFTSurvivalRegressionModel(this.uid(), coefficients, intercept, scale).setParent(this), this.copyValues$default$2());
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, true);
    }

    @Override
    public AFTSurvivalRegression copy(ParamMap extra) {
        return (AFTSurvivalRegression)this.defaultCopy(extra);
    }

    public AFTSurvivalRegression(String uid) {
        this.uid = uid;
        HasFeaturesCol.$init$(this);
        HasLabelCol.$init$(this);
        HasPredictionCol.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
    }

    public AFTSurvivalRegression() {
        this(Identifiable$.MODULE$.randomUID("aftSurvReg"));
    }
}

