/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r%b\u0001B\u0001\u0003\u00015\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2T!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)]\u00012a\u0004\t\u0013\u001b\u0005!\u0011BA\t\u0005\u0005\u0015iu\u000eZ3m!\t\u0019\u0002!D\u0001\u0003!\t\u0019R#\u0003\u0002\u0017\u0005\tY\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>t\u0007+\u0019:b[N\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0003\u0002\tU$\u0018\u000e\\\u0005\u00039e\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!q\u0002A!b\u0001\n\u0003z\u0012aA;jIV\t\u0001\u0005\u0005\u0002\"U9\u0011!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K1\ta\u0001\u0010:p_Rt$\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2\u0013A\u0002)sK\u0012,g-\u0003\u0002,Y\t11\u000b\u001e:j]\u001eT!!\u000b\u0014)\u0007uqC\u0007\u0005\u00020e5\t\u0001G\u0003\u00022\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005M\u0002$!B*j]\u000e,\u0017%A\u001b\u0002\u000bErcG\f\u0019\t\u0011]\u0002!\u0011!Q\u0001\n\u0001\nA!^5eA!\u001aaG\f\u001b\t\u0011i\u0002!Q1A\u0005\u0002m\nAbY8fM\u001aL7-[3oiN,\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f\u0011\ta\u0001\\5oC2<\u0017BA!?\u0005\u00191Vm\u0019;pe\"\u001a\u0011HL\"\"\u0003\u0011\u000bQA\r\u00181]AB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\u000eG>,gMZ5dS\u0016tGo\u001d\u0011)\u0007\u0015s3\t\u0003\u0005J\u0001\t\u0015\r\u0011\"\u0001K\u0003%Ig\u000e^3sG\u0016\u0004H/F\u0001L!\taU*D\u0001'\u0013\tqeE\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u0011:\"\u0004\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B&\u0002\u0015%tG/\u001a:dKB$\b\u0005K\u0002Q]QB\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\tAS\u0001\u0006g\u000e\fG.\u001a\u0015\u0004':\"\u0004\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B&\u0002\rM\u001c\u0017\r\\3!Q\r1f\u0006\u000e\u0005\u00075\u0002!\t\u0001B.\u0002\rqJg.\u001b;?)\u0015\u0011BL\u00181c\u0011\u0015q\u0012\f1\u0001!Q\raf\u0006\u000e\u0005\u0006ue\u0003\r\u0001\u0010\u0015\u0004=:\u001a\u0005\"B%Z\u0001\u0004Y\u0005f\u00011/i!)A+\u0017a\u0001\u0017\"\u001a!M\f\u001b\t\u000b\u0015\u0004A\u0011\u00014\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011q\r[\u0007\u0002\u0001!)\u0011\u000e\u001aa\u0001A\u0005)a/\u00197vK\"\u001aAM\f\u001b\t\u000b1\u0004A\u0011A7\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGCA4o\u0011\u0015I7\u000e1\u0001!Q\rYg\u0006\u000e\u0005\u0006c\u0002!\tA]\u0001\u0019g\u0016$\u0018+^1oi&dW\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHCA4t\u0011\u0015I\u0007\u000f1\u0001u!\raUoS\u0005\u0003m\u001a\u0012Q!\u0011:sCfD3\u0001\u001d\u00185\u0011\u0015I\b\u0001\"\u0001{\u0003=\u0019X\r^)vC:$\u0018\u000e\\3t\u0007>dGCA4|\u0011\u0015I\u0007\u00101\u0001!Q\rAh\u0006\u000e\u0005\u0006}\u0002!\ta`\u0001\u0011aJ,G-[2u#V\fg\u000e^5mKN$2\u0001PA\u0001\u0011\u0019\t\u0019! a\u0001y\u0005Aa-Z1ukJ,7\u000fK\u0002~]\rCq!!\u0003\u0001\t\u0003\tY!A\u0004qe\u0016$\u0017n\u0019;\u0015\u0007-\u000bi\u0001C\u0004\u0002\u0004\u0005\u001d\u0001\u0019\u0001\u001f)\t\u0005\u001daf\u0011\u0005\b\u0003'\u0001A\u0011IA\u000b\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002\u0018\u0005e\u0002\u0003BA\r\u0003gqA!a\u0007\u0002.9!\u0011QDA\u0015\u001d\u0011\ty\"a\n\u000f\t\u0005\u0005\u0012Q\u0005\b\u0004G\u0005\r\u0012\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\r\tYCB\u0001\u0004gFd\u0017\u0002BA\u0018\u0003c\tq\u0001]1dW\u0006<WMC\u0002\u0002,\u0019IA!!\u000e\u00028\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003_\t\t\u0004\u0003\u0005\u0002<\u0005E\u0001\u0019AA\u001f\u0003\u001d!\u0017\r^1tKR\u0004D!a\u0010\u0002LA1\u0011\u0011IA\"\u0003\u000fj!!!\r\n\t\u0005\u0015\u0013\u0011\u0007\u0002\b\t\u0006$\u0018m]3u!\u0011\tI%a\u0013\r\u0001\u0011a\u0011QJA\u001d\u0003\u0003\u0005\tQ!\u0001\u0002P\t\u0019q\fJ\u001a\u0012\t\u0005E\u0013q\u000b\t\u0004\u0019\u0006M\u0013bAA+M\t9aj\u001c;iS:<\u0007c\u0001'\u0002Z%\u0019\u00111\f\u0014\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u0002\u00129\u001a\u0005bBA1\u0001\u0011\u0005\u00131M\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011QMA9!\u0011\t9'!\u001c\u000e\u0005\u0005%$\u0002BA6\u0003c\tQ\u0001^=qKNLA!a\u001c\u0002j\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u0005M\u0014q\fa\u0001\u0003K\naa]2iK6\f\u0007\u0006BA0]QBq!!\u001f\u0001\t\u0003\nY(\u0001\u0003d_BLHc\u0001\n\u0002~!A\u0011qPA<\u0001\u0004\t\t)A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9\tB\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005QCJ\fW.T1qQ\u0011\t9H\f\u001b\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\u0006)qO]5uKV\u0011\u0011Q\u0013\t\u00041\u0005]\u0015bAAM3\tAQ\nT,sSR,'\u000f\u000b\u0003\u0002\u0010:\"\u0004f\u0001\u0001/i!\u001a\u0001!!)\u0011\u0007=\n\u0019+C\u0002\u0002&B\u0012A\"\u0012=qKJLW.\u001a8uC2<q!!+\u0003\u0011\u0003\tY+\u0001\u000eB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000eE\u0002\u0014\u0003[3a!\u0001\u0002\t\u0002\u0005=6\u0003CAW\u0003c\u000b9,!0\u0011\u00071\u000b\u0019,C\u0002\u00026\u001a\u0012a!\u00118z%\u00164\u0007\u0003\u0002\r\u0002:JI1!a/\u001a\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0004\u0019\u0006}\u0016bAAaM\ta1+\u001a:jC2L'0\u00192mK\"9!,!,\u0005\u0002\u0005\u0015GCAAV\u0011!\tI-!,\u0005B\u0005-\u0017\u0001\u0002:fC\u0012,\"!!4\u0011\ta\tyME\u0005\u0004\u0003#L\"\u0001C'M%\u0016\fG-\u001a:)\t\u0005\u001dg\u0006\u000e\u0005\t\u0003/\fi\u000b\"\u0011\u0002Z\u0006!An\\1e)\r\u0011\u00121\u001c\u0005\b\u0003;\f)\u000e1\u0001!\u0003\u0011\u0001\u0018\r\u001e5)\t\u0005Ug\u0006\u000e\u0004\n\u0003G\fi\u000bAAW\u0003K\u0014\u0001%\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2<&/\u001b;feN1\u0011\u0011]AK\u0003O\u0004B!!;\u0002p6\u0011\u00111\u001e\u0006\u0004\u0003[4\u0011\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005E\u00181\u001e\u0002\b\u0019><w-\u001b8h\u0011)\t)0!9\u0003\u0002\u0003\u0006IAE\u0001\tS:\u001cH/\u00198dK\"9!,!9\u0005\u0002\u0005eH\u0003BA~\u0003\u007f\u0004B!!@\u0002b6\u0011\u0011Q\u0016\u0005\b\u0003k\f9\u00101\u0001\u0013\r\u001d\u0011\u0019!!9E\u0005\u000b\u0011A\u0001R1uCNA!\u0011AAY\u0005\u000f\ti\fE\u0002M\u0005\u0013I1Aa\u0003'\u0005\u001d\u0001&o\u001c3vGRD\u0011B\u000fB\u0001\u0005+\u0007I\u0011A\u001e\t\u0013\u0019\u0013\tA!E!\u0002\u0013a\u0004\"C%\u0003\u0002\tU\r\u0011\"\u0001K\u0011%\t&\u0011\u0001B\tB\u0003%1\nC\u0005U\u0005\u0003\u0011)\u001a!C\u0001\u0015\"IqK!\u0001\u0003\u0012\u0003\u0006Ia\u0013\u0005\b5\n\u0005A\u0011\u0001B\u000e)!\u0011iB!\t\u0003$\t\u0015\u0002\u0003\u0002B\u0010\u0005\u0003i!!!9\t\ri\u0012I\u00021\u0001=\u0011\u0019I%\u0011\u0004a\u0001\u0017\"1AK!\u0007A\u0002-C!\"!\u001f\u0003\u0002\u0005\u0005I\u0011\u0001B\u0015)!\u0011iBa\u000b\u0003.\t=\u0002\u0002\u0003\u001e\u0003(A\u0005\t\u0019\u0001\u001f\t\u0011%\u00139\u0003%AA\u0002-C\u0001\u0002\u0016B\u0014!\u0003\u0005\ra\u0013\u0005\u000b\u0005g\u0011\t!%A\u0005\u0002\tU\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005oQ3\u0001\u0010B\u001dW\t\u0011Y\u0004\u0005\u0003\u0003>\t\u0015SB\u0001B \u0015\u0011\u0011\tEa\u0011\u0002\u0013Ut7\r[3dW\u0016$'BA\u0019'\u0013\u0011\u00119Ea\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0003L\t\u0005\u0011\u0013!C\u0001\u0005\u001b\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003P)\u001a1J!\u000f\t\u0015\tM#\u0011AI\u0001\n\u0003\u0011i%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\t]#\u0011AA\u0001\n\u0003\u0012I&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00057\u0002BA!\u0018\u0003h5\u0011!q\f\u0006\u0005\u0005C\u0012\u0019'\u0001\u0003mC:<'B\u0001B3\u0003\u0011Q\u0017M^1\n\u0007-\u0012y\u0006\u0003\u0006\u0003l\t\u0005\u0011\u0011!C\u0001\u0005[\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u001c\u0011\u00071\u0013\t(C\u0002\u0003t\u0019\u00121!\u00138u\u0011)\u00119H!\u0001\u0002\u0002\u0013\u0005!\u0011P\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9Fa\u001f\t\u0015\tu$QOA\u0001\u0002\u0004\u0011y'A\u0002yIEB!B!!\u0003\u0002\u0005\u0005I\u0011\tBB\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BC!\u0019\u00119I!$\u0002X5\u0011!\u0011\u0012\u0006\u0004\u0005\u00173\u0013AC2pY2,7\r^5p]&!!q\u0012BE\u0005!IE/\u001a:bi>\u0014\bB\u0003BJ\u0005\u0003\t\t\u0011\"\u0001\u0003\u0016\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0018\nu\u0005c\u0001'\u0003\u001a&\u0019!1\u0014\u0014\u0003\u000f\t{w\u000e\\3b]\"Q!Q\u0010BI\u0003\u0003\u0005\r!a\u0016\t\u0015\t\u0005&\u0011AA\u0001\n\u0003\u0012\u0019+\u0001\u0005iCND7i\u001c3f)\t\u0011y\u0007\u0003\u0006\u0003(\n\u0005\u0011\u0011!C!\u0005S\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00057B!B!,\u0003\u0002\u0005\u0005I\u0011\tBX\u0003\u0019)\u0017/^1mgR!!q\u0013BY\u0011)\u0011iHa+\u0002\u0002\u0003\u0007\u0011qK\u0004\u000b\u0005k\u000b\t/!A\t\n\t]\u0016\u0001\u0002#bi\u0006\u0004BAa\b\u0003:\u001aQ!1AAq\u0003\u0003EIAa/\u0014\r\te&QXA_!%\u0011yL!2=\u0017.\u0013i\"\u0004\u0002\u0003B*\u0019!1\u0019\u0014\u0002\u000fI,h\u000e^5nK&!!q\u0019Ba\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\b5\neF\u0011\u0001Bf)\t\u00119\f\u0003\u0006\u0003(\ne\u0016\u0011!C#\u0005SC!B!5\u0003:\u0006\u0005I\u0011\u0011Bj\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011iB!6\u0003X\ne\u0007B\u0002\u001e\u0003P\u0002\u0007A\b\u0003\u0004J\u0005\u001f\u0004\ra\u0013\u0005\u0007)\n=\u0007\u0019A&\t\u0015\tu'\u0011XA\u0001\n\u0003\u0013y.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005(Q\u001e\t\u0006\u0019\n\r(q]\u0005\u0004\u0005K4#AB(qi&|g\u000e\u0005\u0004M\u0005Sd4jS\u0005\u0004\u0005W4#A\u0002+va2,7\u0007\u0003\u0006\u0003p\nm\u0017\u0011!a\u0001\u0005;\t1\u0001\u001f\u00131\u0011!\u0011\u00190!9\u0005R\tU\u0018\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\t](Q \t\u0004\u0019\ne\u0018b\u0001B~M\t!QK\\5u\u0011\u001d\tiN!=A\u0002\u00012qa!\u0001\u0002.\u0012\u0019\u0019A\u0001\u0011B\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148\u0003\u0002B\u0000\u0003\u001bDqA\u0017B\u0000\t\u0003\u00199\u0001\u0006\u0002\u0004\nA!\u0011Q B\u0000\u0011)\u0019iAa@C\u0002\u0013%!\u0011L\u0001\nG2\f7o\u001d(b[\u0016D\u0011b!\u0005\u0003\u0000\u0002\u0006IAa\u0017\u0002\u0015\rd\u0017m]:OC6,\u0007\u0005\u0003\u0005\u0002X\n}H\u0011IB\u000b)\r\u00112q\u0003\u0005\b\u0003;\u001c\u0019\u00021\u0001!\u0011)\u0019Y\"!,\u0002\u0002\u0013%1QD\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004 A!!QLB\u0011\u0013\u0011\u0019\u0019Ca\u0018\u0003\r=\u0013'.Z2uQ\u0011\tiK\f\u001b)\t\u0005\u001df\u0006\u000e")
public class AFTSurvivalRegressionModel
extends Model<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final IntParam aggregationDepth;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    public static /* bridge */ Object load(String string) {
        return AFTSurvivalRegressionModel$.MODULE$.load(string);
    }

    public static AFTSurvivalRegressionModel load(String string) {
        return AFTSurvivalRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    public AFTSurvivalRegressionModel setFeaturesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegressionModel setPredictionCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
        double k = 1.0 / this.scale();
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)q -> lambda * scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log(1.0 - q)) / k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return Vectors$.MODULE$.dense(quantiles);
    }

    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(null)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictQuantilesUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictQuantiles((Vector)features), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(null)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(null)));
        return this.hasQuantilesCol() ? dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).withColumn(this.$(this.quantilesCol()), predictQuantilesUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))) : dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, false);
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasFeaturesCol.$init$(this);
        HasLabelCol.$init$(this);
        HasPredictionCol.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
    }

    public static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            double d;
            Vector vector;
            Object scale;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().parquet(dataPath);
                    row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object coefficients = ((SeqLike)some.get()).apply(0);
                    Object intercept = ((SeqLike)some.get()).apply(1);
                    scale = ((SeqLike)some.get()).apply(2);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (!(intercept instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                    if (scale instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)scale);
            Tuple3 tuple3 = new Tuple3((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
            Tuple3 tuple32 = tuple3;
            Vector coefficients = (Vector)tuple32._1();
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data$module;
        private final AFTSurvivalRegressionModel instance;

        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                }
            }
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.coefficients();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients, double intercept, double scale) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

