/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasVarianceCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeRegressorParams;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0001\u0003\u00015\u0011Q\u0003R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgN|'O\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019i2\u0005E\u0003\u0010!IA\"$D\u0001\u0005\u0013\t\tBAA\u0005Qe\u0016$\u0017n\u0019;peB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0007Y&t\u0017\r\\4\n\u0005]!\"A\u0002,fGR|'\u000f\u0005\u0002\u001a\u00015\t!\u0001\u0005\u0002\u001a7%\u0011AD\u0001\u0002\u001c\t\u0016\u001c\u0017n]5p]R\u0013X-\u001a*fOJ,7o]5p]6{G-\u001a7\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\"\u0011\u0001\u0002;sK\u0016L!AI\u0010\u00037\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:peB\u000b'/Y7t!\t!s%D\u0001&\u0015\t1C!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016D\u0001B\u000b\u0001\u0003\u0006\u0004%\teK\u0001\u0004k&$W#\u0001\u0017\u0011\u000552dB\u0001\u00185!\ty#'D\u00011\u0015\t\tD\"\u0001\u0004=e>|GO\u0010\u0006\u0002g\u0005)1oY1mC&\u0011QGM\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026e!\u001a\u0011F\u000f!\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011AC1o]>$\u0018\r^5p]&\u0011q\b\u0010\u0002\u0006'&t7-Z\u0011\u0002\u0003\u0006)\u0011G\f\u001b/a!A1\t\u0001B\u0001B\u0003%A&\u0001\u0003vS\u0012\u0004\u0003f\u0001\";\u0001\")a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"\"\u0001\u0007%\t\u000b)*\u0005\u0019\u0001\u0017)\u0007!S\u0004\tK\u0002Fu\u0001CQA\u0012\u0001\u0005\u00021#\u0012\u0001\u0007\u0015\u0004\u0017j\u0002\u0005\"B(\u0001\t\u0003\u0002\u0016aC:fi6\u000b\u0007\u0010R3qi\"$\"!\u0015*\u000e\u0003\u0001AQa\u0015(A\u0002Q\u000bQA^1mk\u0016\u0004\"!\u0016,\u000e\u0003IJ!a\u0016\u001a\u0003\u0007%sG\u000fK\u0002Ou\u0001CQA\u0017\u0001\u0005Bm\u000b!b]3u\u001b\u0006D()\u001b8t)\t\tF\fC\u0003T3\u0002\u0007A\u000bK\u0002Zu\u0001CQa\u0018\u0001\u0005B\u0001\fac]3u\u001b&t\u0017J\\:uC:\u001cWm\u001d)fe:{G-\u001a\u000b\u0003#\u0006DQa\u00150A\u0002QC3A\u0018\u001eA\u0011\u0015!\u0007\u0001\"\u0011f\u00039\u0019X\r^'j]&sgm\\$bS:$\"!\u00154\t\u000bM\u001b\u0007\u0019A4\u0011\u0005UC\u0017BA53\u0005\u0019!u.\u001e2mK\"\u001a1M\u000f!\t\u000b1\u0004A\u0011I7\u0002!M,G/T1y\u001b\u0016lwN]=J]6\u0013ECA)o\u0011\u0015\u00196\u000e1\u0001UQ\rY'\b\u0011\u0005\u0006c\u0002!\tE]\u0001\u0010g\u0016$8)Y2iK:{G-Z%egR\u0011\u0011k\u001d\u0005\u0006'B\u0004\r\u0001\u001e\t\u0003+VL!A\u001e\u001a\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001O\u000f!\t\u000be\u0004A\u0011\t>\u0002+M,Go\u00115fG.\u0004x.\u001b8u\u0013:$XM\u001d<bYR\u0011\u0011k\u001f\u0005\u0006'b\u0004\r\u0001\u0016\u0015\u0004qj\u0002\u0005\"\u0002@\u0001\t\u0003z\u0018aC:fi&k\u0007/\u001e:jif$2!UA\u0001\u0011\u0015\u0019V\u00101\u0001-Q\ri(\b\u0011\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003\u001d\u0019X\r^*fK\u0012$2!UA\u0006\u0011\u001d\u0019\u0016Q\u0001a\u0001\u0003\u001b\u00012!VA\b\u0013\r\t\tB\r\u0002\u0005\u0019>tw\rK\u0003\u0002\u0006i\n)\"\t\u0002\u0002\u0018\u0005)\u0011G\f\u001c/a!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0011AD:fiZ\u000b'/[1oG\u0016\u001cu\u000e\u001c\u000b\u0004#\u0006}\u0001BB*\u0002\u001a\u0001\u0007A\u0006K\u0003\u0002\u001ai\n\u0019#\t\u0002\u0002&\u0005)!G\f\u0019/a!9\u0011\u0011\u0006\u0001\u0005R\u0005-\u0012!\u0002;sC&tGc\u0001\u000e\u0002.!A\u0011qFA\u0014\u0001\u0004\t\t$A\u0004eCR\f7/\u001a;1\t\u0005M\u00121\t\t\u0007\u0003k\tY$a\u0010\u000e\u0005\u0005]\"bAA\u001d\r\u0005\u00191/\u001d7\n\t\u0005u\u0012q\u0007\u0002\b\t\u0006$\u0018m]3u!\u0011\t\t%a\u0011\r\u0001\u0011a\u0011QIA\u0017\u0003\u0003\u0005\tQ!\u0001\u0002H\t\u0019q\fJ\u0019\u0012\t\u0005%\u0013q\n\t\u0004+\u0006-\u0013bAA'e\t9aj\u001c;iS:<\u0007cA+\u0002R%\u0019\u00111\u000b\u001a\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002*\u0001!\t\u0001BA,)\u001dQ\u0012\u0011LA;\u0003\u0017C\u0001\"a\u0017\u0002V\u0001\u0007\u0011QL\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002`\u0005\u0015\u0014\u0011N\u0007\u0003\u0003CR1!a\u0019\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003O\n\tGA\u0002S\t\u0012\u0003B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_\"\u0011a\u00024fCR,(/Z\u0005\u0005\u0003g\niG\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0003\u0005\u0002x\u0005U\u0003\u0019AA=\u0003-yG\u000eZ*ue\u0006$XmZ=\u0011\t\u0005m\u0014qQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006i1m\u001c8gS\u001e,(/\u0019;j_:T1\u0001IAB\u0015\r\t)IB\u0001\u0006[2d\u0017NY\u0005\u0005\u0003\u0013\u000biH\u0001\u0005TiJ\fG/Z4z\u0011\u001d\ti)!\u0016A\u00021\nQCZ3biV\u0014XmU;cg\u0016$8\u000b\u001e:bi\u0016<\u0017\u0010\u0003\u0005\u0002\u0012\u0002!\t\u0001BAJ\u000399W\r^(mIN#(/\u0019;fOf$B!!\u001f\u0002\u0016\"A\u0011qSAH\u0001\u0004\tI*A\ndCR,wm\u001c:jG\u0006dg)Z1ukJ,7\u000fE\u0003.\u00037#F+C\u0002\u0002\u001eb\u00121!T1q\u0011\u001d\t\t\u000b\u0001C!\u0003G\u000bAaY8qsR\u0019\u0001$!*\t\u0011\u0005\u001d\u0016q\u0014a\u0001\u0003S\u000bQ!\u001a=ue\u0006\u0004B!a+\u000226\u0011\u0011Q\u0016\u0006\u0004\u0003_#\u0011!\u00029be\u0006l\u0017\u0002BAZ\u0003[\u0013\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0005\u0003?S\u0004\tK\u0002\u0001u\u0001;q!a/\u0003\u0011\u0003\ti,A\u000bEK\u000eL7/[8o)J,WMU3he\u0016\u001c8o\u001c:\u0011\u0007e\tyL\u0002\u0004\u0002\u0005!\u0005\u0011\u0011Y\n\t\u0003\u007f\u000b\u0019-!3\u0002PB\u0019Q+!2\n\u0007\u0005\u001d'G\u0001\u0004B]f\u0014VM\u001a\t\u0005I\u0005-\u0007$C\u0002\u0002N\u0016\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002V\u0003#L1!a53\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d1\u0015q\u0018C\u0001\u0003/$\"!!0\t\u0015\u0005m\u0017q\u0018b\u0001\n\u000b\ti.A\ntkB\u0004xN\u001d;fI&k\u0007/\u001e:ji&,7/\u0006\u0002\u0002`B!Q+!9-\u0013\r\t\u0019O\r\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0003O\fy\f)A\u0007\u0003?\fAc];qa>\u0014H/\u001a3J[B,(/\u001b;jKN\u0004\u0003\u0002CAv\u0003\u007f#\t%!<\u0002\t1|\u0017\r\u001a\u000b\u00041\u0005=\bbBAy\u0003S\u0004\r\u0001L\u0001\u0005a\u0006$\b\u000eK\u0003\u0002jj\n\u0019\u0003\u0003\u0006\u0002x\u0006}\u0016\u0011!C\u0005\u0003s\f1B]3bIJ+7o\u001c7wKR\u0011\u00111 \t\u0005\u0003{\u00149!\u0004\u0002\u0002\u0000*!!\u0011\u0001B\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\t\u0015\u0011\u0001\u00026bm\u0006LAA!\u0003\u0002\u0000\n1qJ\u00196fGRDC!a0;\u0001\"\"\u0011\u0011\u0018\u001eA\u0001")
public class DecisionTreeRegressor
extends Predictor<Vector, DecisionTreeRegressor, DecisionTreeRegressionModel>
implements DecisionTreeRegressorParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> varianceCol;
    private final Param<String> impurity;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static MLReader<DecisionTreeRegressor> read() {
        return DecisionTreeRegressor$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return DecisionTreeRegressor$.MODULE$.load(string);
    }

    public static DecisionTreeRegressor load(String string) {
        return DecisionTreeRegressor$.MODULE$.load(string);
    }

    public static String[] supportedImpurities() {
        return DecisionTreeRegressor$.MODULE$.supportedImpurities();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$DecisionTreeRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return DecisionTreeRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getVarianceCol() {
        return HasVarianceCol.getVarianceCol$(this);
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams.getOldImpurity$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final Param<String> varianceCol() {
        return this.varianceCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasVarianceCol$_setter_$varianceCol_$eq(Param<String> x$1) {
        this.varianceCol = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public DecisionTreeRegressor setMaxDepth(int value) {
        return (DecisionTreeRegressor)this.set(this.maxDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setMaxBins(int value) {
        return (DecisionTreeRegressor)this.set(this.maxBins(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setMinInstancesPerNode(int value) {
        return (DecisionTreeRegressor)this.set(this.minInstancesPerNode(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setMinInfoGain(double value) {
        return (DecisionTreeRegressor)this.set(this.minInfoGain(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public DecisionTreeRegressor setMaxMemoryInMB(int value) {
        return (DecisionTreeRegressor)this.set(this.maxMemoryInMB(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setCacheNodeIds(boolean value) {
        return (DecisionTreeRegressor)this.set(this.cacheNodeIds(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public DecisionTreeRegressor setCheckpointInterval(int value) {
        return (DecisionTreeRegressor)this.set(this.checkpointInterval(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public DecisionTreeRegressor setImpurity(String value) {
        return (DecisionTreeRegressor)this.set(this.impurity(), value);
    }

    @Override
    public DecisionTreeRegressor setSeed(long value) {
        return (DecisionTreeRegressor)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public DecisionTreeRegressor setVarianceCol(String value) {
        return (DecisionTreeRegressor)this.set(this.varianceCol(), value);
    }

    @Override
    public DecisionTreeRegressionModel train(Dataset<?> dataset) {
        return (DecisionTreeRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
            RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
            Strategy strategy = this.getOldStrategy(categoricalFeatures);
            instr.logPipelineStage(this);
            instr.logDataset(oldDataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])this.params()));
            RDD<LabeledPoint> x$1 = oldDataset;
            Strategy x$2 = strategy;
            int x$3 = 1;
            String x$4 = "all";
            long x$5 = BoxesRunTime.unboxToLong((Object)this.$(this.seed()));
            Some x$6 = new Some(instr);
            Some x$7 = new Some((Object)this.uid());
            boolean x$8 = RandomForest$.MODULE$.run$default$7();
            DecisionTreeModel[] trees = RandomForest$.MODULE$.run(x$1, x$2, x$3, x$4, x$5, (Option<Instrumentation>)x$6, x$8, (Option<String>)x$7);
            return (DecisionTreeRegressionModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees)).head();
        });
    }

    public DecisionTreeRegressionModel train(RDD<LabeledPoint> data, Strategy oldStrategy, String featureSubsetStrategy) {
        return (DecisionTreeRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            instr.logPipelineStage(this);
            instr.logDataset(data);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])this.params()));
            RDD x$9 = data;
            Strategy x$10 = oldStrategy;
            int x$11 = 1;
            String x$12 = featureSubsetStrategy;
            long x$13 = BoxesRunTime.unboxToLong((Object)this.$(this.seed()));
            Some x$14 = new Some(instr);
            Some x$15 = new Some((Object)this.uid());
            boolean x$16 = RandomForest$.MODULE$.run$default$7();
            DecisionTreeModel[] trees = RandomForest$.MODULE$.run((RDD<LabeledPoint>)x$9, x$10, x$11, x$12, x$13, (Option<Instrumentation>)x$14, x$16, (Option<String>)x$15);
            return (DecisionTreeRegressionModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees)).head();
        });
    }

    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, 0, Algo$.MODULE$.Regression(), this.getOldImpurity(), 1.0);
    }

    @Override
    public DecisionTreeRegressor copy(ParamMap extra) {
        return (DecisionTreeRegressor)this.defaultCopy(extra);
    }

    public DecisionTreeRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeRegressorParams.$init$(this);
        HasVarianceCol.$init$(this);
        DecisionTreeRegressorParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public DecisionTreeRegressor() {
        this(Identifiable$.MODULE$.randomUID("dtr"));
    }
}

