/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u0001\u0003\u00015\u0011!c\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fY*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\b\u001bA\u0019b\u0003\u0003B\b\u0011%ai\u0011\u0001B\u0005\u0003#\u0011\u0011q\u0002\u0015:fI&\u001cG/[8o\u001b>$W\r\u001c\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\ta\u0001\\5oC2<\u0017BA\f\u0015\u0005\u00191Vm\u0019;peB\u0011\u0011\u0004A\u0007\u0002\u0005A\u00111DH\u0007\u00029)\u0011Q\u0004B\u0001\u0005iJ,W-\u0003\u0002 9\t\u0011rI\u0011+SK\u001e\u0014Xm]:peB\u000b'/Y7t!\rY\u0012eI\u0005\u0003Eq\u0011\u0011\u0003\u0016:fK\u0016s7/Z7cY\u0016lu\u000eZ3m!\tIB%\u0003\u0002&\u0005\tYB)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003W!\u0012!\"\u0014'Xe&$\u0018M\u00197f!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\u0019\u0004A!b\u0001\n\u0003\"\u0014aA;jIV\tQ\u0007\u0005\u00027{9\u0011qg\u000f\t\u0003q9j\u0011!\u000f\u0006\u0003u1\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f/\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qr\u0003\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\tULG\r\t\u0005\t\u0007\u0002\u0011)\u0019!C\u0005\t\u00061q\f\u001e:fKN,\u0012!\u0012\t\u0004[\u0019\u001b\u0013BA$/\u0005\u0015\t%O]1z\u0011!I\u0005A!A!\u0002\u0013)\u0015aB0ue\u0016,7\u000f\t\u0005\t\u0017\u0002\u0011)\u0019!C\u0005\u0019\u0006aq\f\u001e:fK^+\u0017n\u001a5ugV\tQ\nE\u0002.\r:\u0003\"!L(\n\u0005As#A\u0002#pk\ndW\r\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003N\u00035yFO]3f/\u0016Lw\r\u001b;tA!AA\u000b\u0001BC\u0002\u0013\u0005S+A\u0006ok64U-\u0019;ve\u0016\u001cX#\u0001,\u0011\u00055:\u0016B\u0001-/\u0005\rIe\u000e\u001e\u0005\t5\u0002\u0011\t\u0011)A\u0005-\u0006aa.^7GK\u0006$XO]3tA!1A\f\u0001C\u0001\tu\u000ba\u0001P5oSRtD#\u0002\r_?\u0002\f\u0007\"B\u001a\\\u0001\u0004)\u0004\"B\"\\\u0001\u0004)\u0005\"B&\\\u0001\u0004i\u0005\"\u0002+\\\u0001\u00041\u0006\"\u0002/\u0001\t\u0003\u0019G\u0003\u0002\reK\u001aDQa\r2A\u0002UBQa\u00112A\u0002\u0015CQa\u00132A\u00025C3A\u00195o!\tIG.D\u0001k\u0015\tYg!\u0001\u0006b]:|G/\u0019;j_:L!!\u001c6\u0003\u000bMKgnY3\"\u0003=\fQ!\r\u00185]ABQ!\u001d\u0001\u0005B\u0011\u000bQ\u0001\u001e:fKND3\u0001\u001d5o\u0011\u001d!\bA1A\u0005\u0002U\u000b1bZ3u\u001dVlGK]3fg\"\u001a1\u000f\u001b<\"\u0003]\fQA\r\u00181]ABa!\u001f\u0001!\u0002\u00131\u0016\u0001D4fi:+X\u000e\u0016:fKN\u0004\u0003f\u0001=im\")A\u0010\u0001C!\u0019\u0006YAO]3f/\u0016Lw\r\u001b;tQ\rY\bN\u001c\u0005\u0007\u007f\u0002!\t&!\u0001\u0002\u001bQ\u0014\u0018M\\:g_Jl\u0017*\u001c9m)\u0011\t\u0019!!\n\u0011\t\u0005\u0015\u0011q\u0004\b\u0005\u0003\u000f\tIB\u0004\u0003\u0002\n\u0005Ua\u0002BA\u0006\u0003'qA!!\u0004\u0002\u00129\u0019\u0001(a\u0004\n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011bAA\f\r\u0005\u00191/\u001d7\n\t\u0005m\u0011QD\u0001\ba\u0006\u001c7.Y4f\u0015\r\t9BB\u0005\u0005\u0003C\t\u0019CA\u0005ECR\fgI]1nK*!\u00111DA\u000f\u0011\u001d\t9C a\u0001\u0003S\tq\u0001Z1uCN,G\u000f\r\u0003\u0002,\u0005]\u0002CBA\u0017\u0003_\t\u0019$\u0004\u0002\u0002\u001e%!\u0011\u0011GA\u000f\u0005\u001d!\u0015\r^1tKR\u0004B!!\u000e\u000281\u0001A\u0001DA\u001d\u0003K\t\t\u0011!A\u0003\u0002\u0005m\"aA0%eE!\u0011QHA\"!\ri\u0013qH\u0005\u0004\u0003\u0003r#a\u0002(pi\"Lgn\u001a\t\u0004[\u0005\u0015\u0013bAA$]\t\u0019\u0011I\\=\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u00059\u0001O]3eS\u000e$Hc\u0001(\u0002P!9\u0011\u0011KA%\u0001\u0004\u0011\u0012\u0001\u00034fCR,(/Z:\t\u0011\u0005U\u0003A1A\u0005\u0002U\u000b\u0001B\\;n)J,Wm\u001d\u0005\b\u00033\u0002\u0001\u0015!\u0003W\u0003%qW/\u001c+sK\u0016\u001c\b\u0005C\u0004\u0002^\u0001!\t%a\u0018\u0002\t\r|\u0007/\u001f\u000b\u00041\u0005\u0005\u0004\u0002CA2\u00037\u0002\r!!\u001a\u0002\u000b\u0015DHO]1\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b\u0005\u0003\u0015\u0001\u0018M]1n\u0013\u0011\ty'!\u001b\u0003\u0011A\u000b'/Y7NCBDC!a\u0017i]\"9\u0011Q\u000f\u0001\u0005B\u0005]\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003UBC!a\u001di]\"Q\u0011Q\u0010\u0001\t\u0006\u0004%\t!a \u0002%\u0019,\u0017\r^;sK&k\u0007o\u001c:uC:\u001cWm]\u000b\u0002%!\"\u00111\u00105w\u0011!\t)\t\u0001C\u0001\t\u0005\u001d\u0015!\u0002;p\u001f2$WCAAE!\u0011\tY)a&\u000e\u0005\u00055%\u0002BAH\u0003#\u000bQ!\\8eK2T1!HAJ\u0015\r\t)JB\u0001\u0006[2d\u0017NY\u0005\u0005\u00033\u000biIA\rHe\u0006$\u0017.\u001a8u\u0005>|7\u000f^3e)J,Wm]'pI\u0016d\u0007bBAO\u0001\u0011\u0005\u0011qT\u0001\u0016KZ\fG.^1uK\u0016\u000b7\r[%uKJ\fG/[8o)\u0015i\u0015\u0011UAW\u0011!\t9#a'A\u0002\u0005\r\u0006\u0007BAS\u0003S\u0003b!!\f\u00020\u0005\u001d\u0006\u0003BA\u001b\u0003S#A\"a+\u0002\"\u0006\u0005\t\u0011!B\u0001\u0003w\u00111a\u0018\u00134\u0011\u001d\ty+a'A\u0002U\nA\u0001\\8tg\"*\u00111\u00145\u00024\u0006\u0012\u0011QW\u0001\u0006e9\"d\u0006\r\u0005\b\u0003s\u0003A\u0011IA^\u0003\u00159(/\u001b;f+\t\ti\fE\u0002(\u0003\u007fK1!!1)\u0005!iEj\u0016:ji\u0016\u0014\b\u0006BA\\QZD3\u0001\u00015o\u000f\u001d\tIM\u0001E\u0001\u0003\u0017\f!c\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fYB\u0019\u0011$!4\u0007\r\u0005\u0011\u0001\u0012AAh'\u001d\ti-!5\u0002X2\u00022!LAj\u0013\r\t)N\f\u0002\u0007\u0003:L(+\u001a4\u0011\t\u001d\nI\u000eG\u0005\u0004\u00037D#AC'M%\u0016\fG-\u00192mK\"9A,!4\u0005\u0002\u0005}GCAAf\u0011!\t\u0019/!4\u0005B\u0005\u0015\u0018\u0001\u0002:fC\u0012,\"!a:\u0011\t\u001d\nI\u000fG\u0005\u0004\u0003WD#\u0001C'M%\u0016\fG-\u001a:)\t\u0005\u0005\bN\u001e\u0005\t\u0003c\fi\r\"\u0011\u0002t\u0006!An\\1e)\rA\u0012Q\u001f\u0005\b\u0003o\fy\u000f1\u00016\u0003\u0011\u0001\u0018\r\u001e5)\t\u0005=\bN\u001e\u0004\n\u0003{\fi\rAAg\u0003\u007f\u0014\u0001d\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\u0011\tY0!0\t\u0015\t\r\u00111 B\u0001B\u0003%\u0001$\u0001\u0005j]N$\u0018M\\2f\u0011\u001da\u00161 C\u0001\u0005\u000f!BA!\u0003\u0003\u000eA!!1BA~\u001b\t\ti\rC\u0004\u0003\u0004\t\u0015\u0001\u0019\u0001\r\t\u0011\tE\u00111 C)\u0005'\t\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0005+\u0011Y\u0002E\u0002.\u0005/I1A!\u0007/\u0005\u0011)f.\u001b;\t\u000f\u0005](q\u0002a\u0001k\u00199!qDAg\t\t\u0005\"\u0001G$C)J+wM]3tg&|g.T8eK2\u0014V-\u00193feN!!QDAt\u0011\u001da&Q\u0004C\u0001\u0005K!\"Aa\n\u0011\t\t-!Q\u0004\u0005\u000b\u0005W\u0011iB1A\u0005\n\t5\u0012!C2mCN\u001ch*Y7f+\t\u0011y\u0003\u0005\u0003\u00032\tmRB\u0001B\u001a\u0015\u0011\u0011)Da\u000e\u0002\t1\fgn\u001a\u0006\u0003\u0005s\tAA[1wC&\u0019aHa\r\t\u0013\t}\"Q\u0004Q\u0001\n\t=\u0012AC2mCN\u001ch*Y7fA!Q!1\tB\u000f\u0005\u0004%IA!\f\u0002\u001bQ\u0014X-Z\"mCN\u001ch*Y7f\u0011%\u00119E!\b!\u0002\u0013\u0011y#\u0001\bue\u0016,7\t\\1tg:\u000bW.\u001a\u0011\t\u0011\u0005E(Q\u0004C!\u0005\u0017\"2\u0001\u0007B'\u0011\u001d\t9P!\u0013A\u0002UB\u0011B!\u0015\u0002N\u0012\u0005AAa\u0015\u0002\u000f\u0019\u0014x.\\(mIRI\u0001D!\u0016\u0003Z\t\r$Q\u000e\u0005\t\u0005/\u0012y\u00051\u0001\u0002\n\u0006Aq\u000e\u001c3N_\u0012,G\u000e\u0003\u0005\u0003\\\t=\u0003\u0019\u0001B/\u0003\u0019\u0001\u0018M]3oiB\u0019\u0011Da\u0018\n\u0007\t\u0005$A\u0001\u0007H\u0005R\u0013Vm\u001a:fgN|'\u000f\u0003\u0005\u0003f\t=\u0003\u0019\u0001B4\u0003M\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t!\u00151$\u0011\u000e,W\u0013\r\u0011Yg\u0010\u0002\u0004\u001b\u0006\u0004\b\u0002\u0003+\u0003PA\u0005\t\u0019\u0001,\t\u0017\tE\u0014QZI\u0001\n\u0003!!1O\u0001\u0012MJ|Wn\u00147eI\u0011,g-Y;mi\u0012\"TC\u0001B;U\r1&qO\u0016\u0003\u0005s\u0002BAa\u001f\u0003\u00046\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t)A\u0005v]\u000eDWmY6fI*\u00111NL\u0005\u0005\u0005\u000b\u0013iHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!B!#\u0002N\u0006\u0005I\u0011\u0002BF\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t5\u0005\u0003\u0002B\u0019\u0005\u001fKAA!%\u00034\t1qJ\u00196fGRDC!!4im\"\"\u0011q\u00195w\u0001")
public class GBTRegressionModel
extends PredictionModel<Vector, GBTRegressionModel>
implements GBTRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int getNumTrees;
    private final int numTrees;
    private int totalNumNodes;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam validationTol;
    private final DoubleParam stepSize;
    private final Param<String> validationIndicatorCol;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static /* bridge */ Object load(String string) {
        return GBTRegressionModel$.MODULE$.load(string);
    }

    public static GBTRegressionModel load(String string) {
        return GBTRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GBTRegressionModel> read() {
        return GBTRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams.getLossType$(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams.getOldLossType$(this);
    }

    @Override
    public Loss convertToOldLossType(String loss) {
        return GBTRegressorParams.convertToOldLossType$(this, loss);
    }

    @Override
    public TreeRegressorParams setImpurity(String value) {
        return TreeRegressorParams.setImpurity$(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public GBTParams setMaxIter(int value) {
        return GBTParams.setMaxIter$(this, value);
    }

    @Override
    public GBTParams setStepSize(double value) {
        return GBTParams.setStepSize$(this, value);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams.setSubsamplingRate$(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams.setFeatureSubsetStrategy$(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams.setMaxDepth$(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams.setMaxBins$(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams.setMinInstancesPerNode$(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams.setMinInfoGain$(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams.setSeed$(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams.setMaxMemoryInMB$(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams.setCacheNodeIds$(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams.setCheckpointInterval$(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTRegressionModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$transformImpl$1(bcastModel, features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public double predict(Vector features) {
        double[] treePredictions = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$predict$1(features, x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.numTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    public int numTrees() {
        return this.numTrees;
    }

    @Override
    public GBTRegressionModel copy(ParamMap extra) {
        return (GBTRegressionModel)((Model)this.copyValues(new GBTRegressionModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(37).append("GBTRegressionModel (uid=").append(this.uid()).append(") with ").append(this.numTrees()).append(" trees").toString();
    }

    private Vector featureImportances$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), this._treeWeights());
    }

    public double[] evaluateEachIteration(Dataset<?> dataset, String loss) {
        RDD data = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    features = ((SeqLike)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration((RDD<LabeledPoint>)data, this.trees(), this.treeWeights(), this.convertToOldLossType(loss), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new GBTRegressionModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transformImpl$1(Broadcast bcastModel$1, Object features) {
        return ((GBTRegressionModel)bcastModel$1.value()).predict((Vector)features);
    }

    public static final /* synthetic */ double $anonfun$predict$1(Vector features$1, DecisionTreeRegressionModel x$3) {
        return x$3.rootNode().predictImpl(features$1).prediction();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeRegressorParams.$init$(this);
        GBTRegressorParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "GBTRegressionModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("GBTRegressionModel given trees, treeWeights of").append(new StringBuilder(41).append(" non-matching lengths (").append(this._trees().length).append(", ").append(this._treeWeights().length).append(", respectively).").toString()).toString());
        this.getNumTrees = this.trees().length;
        this.numTrees = this.trees().length;
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1);
    }

    public static class GBTRegressionModelReader
    extends MLReader<GBTRegressionModel> {
        private final String className = GBTRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTRegressionModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            Tuple3 tuple32 = tuple3;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple32._1();
            Tuple2[] treesData = (Tuple2[])tuple32._2();
            double[] treeWeights2 = (double[])tuple32._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                return decisionTreeRegressionModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("GBTRegressionModel.load expected ").append(numTrees).append(new StringBuilder(42).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString()).toString());
            GBTRegressionModel model = new GBTRegressionModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GBTRegressionModelWriter
    extends MLWriter {
        private final GBTRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTRegressionModelWriter(GBTRegressionModel instance) {
            this.instance = instance;
        }
    }
}

