/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$FamilyAndLink$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r%c\u0001B\u0001\u0003\u00015\u0011\u0001eR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fY*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u001a9A!q\u0002\u0005\n\u0019\u001b\u0005\u0011\u0011BA\t\u0003\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0003\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001b\u0013\tY\"AA\u0010HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c\"bg\u0016\u0004\"!\b\u0011\u000e\u0003yQ!a\b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003Cy\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!\u0019\u0003A!b\u0001\n\u0003\"\u0013aA;jIV\tQ\u0005\u0005\u0002'_9\u0011q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0003U1\ta\u0001\u0010:p_Rt$\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\u0016)\u0007\t\u001a\u0014\b\u0005\u00025o5\tQG\u0003\u00027\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005a*$!B*j]\u000e,\u0017%\u0001\u001e\u0002\u000bIr\u0003G\f\u0019\t\u0011q\u0002!\u0011!Q\u0001\n\u0015\nA!^5eA!\u001a1hM\u001d\t\u0011}\u0002!Q1A\u0005\u0002\u0001\u000bAbY8fM\u001aL7-[3oiN,\u0012A\u0005\u0015\u0004}MJ\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u001b\r|WM\u001a4jG&,g\u000e^:!Q\r\u00115'\u000f\u0005\t\r\u0002\u0011)\u0019!C\u0001\u000f\u0006I\u0011N\u001c;fe\u000e,\u0007\u000f^\u000b\u0002\u0011B\u0011\u0011JS\u0007\u0002W%\u00111j\u000b\u0002\u0007\t>,(\r\\3)\u0007\u0015\u001b\u0014\b\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003I\u0003)Ig\u000e^3sG\u0016\u0004H\u000f\t\u0015\u0004\u001bNJ\u0004BB)\u0001\t\u0003!!+\u0001\u0004=S:LGO\u0010\u000b\u00051M+v\u000bC\u0003$!\u0002\u0007Q\u0005K\u0002TgeBQa\u0010)A\u0002IA3!V\u001a:\u0011\u00151\u0005\u000b1\u0001IQ\r96'\u000f\u0005\u00065\u0002!\taW\u0001\u0015g\u0016$H*\u001b8l!J,G-[2uS>t7i\u001c7\u0015\u0005qkV\"\u0001\u0001\t\u000byK\u0006\u0019A\u0013\u0002\u000bY\fG.^3)\u0007e\u001b\u0014\b\u0003\u0005b\u0001!\u0015\r\u0011\"\u0003c\u000351\u0017-\\5ms\u0006sG\rT5oWV\t1\r\u0005\u0002eO:\u0011q\"Z\u0005\u0003M\n\t1dR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>t\u0017B\u00015j\u000551\u0015-\\5ms\u0006sG\rT5oW*\u0011aM\u0001\u0005\u0006W\u0002!\t\u0005\\\u0001\baJ,G-[2u)\tAU\u000eC\u0003oU\u0002\u0007!#\u0001\u0005gK\u0006$XO]3t\u0011\u0015Y\u0007\u0001\"\u0003q)\rA\u0015O\u001d\u0005\u0006]>\u0004\rA\u0005\u0005\u0006g>\u0004\r\u0001S\u0001\u0007_\u001a47/\u001a;\t\u000bU\u0004A\u0011\u0002<\u0002\u0017A\u0014X\rZ5di2Kgn\u001b\u000b\u0004\u0011^D\b\"\u00028u\u0001\u0004\u0011\u0002\"B:u\u0001\u0004A\u0005\"\u0002>\u0001\t\u0003Z\u0018!\u0003;sC:\u001chm\u001c:n)\ra\u00181\u0004\t\u0004{\u0006Uab\u0001@\u0002\u00109\u0019q0a\u0003\u000f\t\u0005\u0005\u0011\u0011\u0002\b\u0005\u0003\u0007\t9AD\u0002)\u0003\u000bI\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0007\u00055a!A\u0002tc2LA!!\u0005\u0002\u0014\u00059\u0001/Y2lC\u001e,'bAA\u0007\r%!\u0011qCA\r\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002\u0012\u0005M\u0001bBA\u000fs\u0002\u0007\u0011qD\u0001\bI\u0006$\u0018m]3ua\u0011\t\t#!\f\u0011\r\u0005\r\u0012QEA\u0015\u001b\t\t\u0019\"\u0003\u0003\u0002(\u0005M!a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003W\ti\u0003\u0004\u0001\u0005\u0019\u0005=\u00121DA\u0001\u0002\u0003\u0015\t!!\r\u0003\u0007}##'\u0005\u0003\u00024\u0005e\u0002cA%\u00026%\u0019\u0011qG\u0016\u0003\u000f9{G\u000f[5oOB\u0019\u0011*a\u000f\n\u0007\u0005u2FA\u0002B]fDq!!\u0011\u0001\t#\n\u0019%A\u0007ue\u0006t7OZ8s[&k\u0007\u000f\u001c\u000b\u0004y\u0006\u0015\u0003\u0002CA\u000f\u0003\u007f\u0001\r!a\u00121\t\u0005%\u0013Q\n\t\u0007\u0003G\t)#a\u0013\u0011\t\u0005-\u0012Q\n\u0003\r\u0003\u001f\n)%!A\u0001\u0002\u000b\u0005\u0011\u0011\u0007\u0002\u0004?\u0012\u001a\u0004\"CA*\u0001\u0001\u0007I\u0011BA+\u0003=!(/Y5oS:<7+^7nCJLXCAA,!\u0015I\u0015\u0011LA/\u0013\r\tYf\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\ty&C\u0002\u0002b\t\u0011!fR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u0018\u0010C\u0005\u0002f\u0001\u0001\r\u0011\"\u0003\u0002h\u0005\u0019BO]1j]&twmU;n[\u0006\u0014\u0018p\u0018\u0013fcR!\u0011\u0011NA8!\rI\u00151N\u0005\u0004\u0003[Z#\u0001B+oSRD!\"!\u001d\u0002d\u0005\u0005\t\u0019AA,\u0003\rAH%\r\u0005\t\u0003k\u0002\u0001\u0015)\u0003\u0002X\u0005\u0001BO]1j]&twmU;n[\u0006\u0014\u0018\u0010\t\u0005\b\u0003s\u0002A\u0011AA>\u0003\u001d\u0019X/\\7bef,\"!!\u0018)\t\u0005]4'\u000f\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003)A\u0017m]*v[6\f'/_\u000b\u0003\u0003\u000b\u00032!SAD\u0013\r\tIi\u000b\u0002\b\u0005>|G.Z1oQ\u0011\tyhM\u001d\t\u0011\u0005=\u0005\u0001\"\u0001\u0003\u0003#\u000b!b]3u'VlW.\u0019:z)\ra\u00161\u0013\u0005\t\u0003s\ni\t1\u0001\u0002X!9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0015\u0001C3wC2,\u0018\r^3\u0015\t\u0005m\u0015\u0011\u0015\t\u0004\u001f\u0005u\u0015bAAP\u0005\t\u0011s)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:\u001cV/\\7befD\u0001\"!\b\u0002\u0016\u0002\u0007\u00111\u0015\u0019\u0005\u0003K\u000bI\u000b\u0005\u0004\u0002$\u0005\u0015\u0012q\u0015\t\u0005\u0003W\tI\u000b\u0002\u0007\u0002,\u0006\u0005\u0016\u0011!A\u0001\u0006\u0003\t\tDA\u0002`IQBC!!&4s!9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0016\u0001B2paf$2\u0001GA[\u0011!\t9,a,A\u0002\u0005e\u0016!B3yiJ\f\u0007\u0003BA^\u0003\u0003l!!!0\u000b\u0007\u0005}F!A\u0003qCJ\fW.\u0003\u0003\u0002D\u0006u&\u0001\u0003)be\u0006lW*\u00199)\t\u0005=6'\u000f\u0005\b\u0003\u0013\u0004A\u0011IAf\u0003\u00159(/\u001b;f+\t\ti\rE\u0002\u001e\u0003\u001fL1!!5\u001f\u0005!iEj\u0016:ji\u0016\u0014\b\u0006BAdgeB\u0011\"a6\u0001\u0005\u0004%\t%!7\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0003\u00037\u00042!SAo\u0013\r\tyn\u000b\u0002\u0004\u0013:$\b\u0002CAr\u0001\u0001\u0006I!a7\u0002\u00199,XNR3biV\u0014Xm\u001d\u0011)\u0007\u0001\u0019\u0014\bK\u0002\u0001\u0003S\u00042\u0001NAv\u0013\r\ti/\u000e\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\\\u0004\b\u0003c\u0014\u0001\u0012AAz\u0003\u0001:UM\\3sC2L'0\u001a3MS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7\u0011\u0007=\t)P\u0002\u0004\u0002\u0005!\u0005\u0011q_\n\t\u0003k\fI0a@\u0003\u0006A\u0019\u0011*a?\n\u0007\u0005u8F\u0001\u0004B]f\u0014VM\u001a\t\u0005;\t\u0005\u0001$C\u0002\u0003\u0004y\u0011!\"\u0014'SK\u0006$\u0017M\u00197f!\rI%qA\u0005\u0004\u0005\u0013Y#\u0001D*fe&\fG.\u001b>bE2,\u0007bB)\u0002v\u0012\u0005!Q\u0002\u000b\u0003\u0003gD\u0001B!\u0005\u0002v\u0012\u0005#1C\u0001\u0005e\u0016\fG-\u0006\u0002\u0003\u0016A!QDa\u0006\u0019\u0013\r\u0011IB\b\u0002\t\u001b2\u0013V-\u00193fe\"\"!qB\u001a:\u0011!\u0011y\"!>\u0005B\t\u0005\u0012\u0001\u00027pC\u0012$2\u0001\u0007B\u0012\u0011\u001d\u0011)C!\bA\u0002\u0015\nA\u0001]1uQ\"\"!QD\u001a:\r%\u0011Y#!>\u0001\u0003k\u0014iC\u0001\u0014HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016dwK]5uKJ\u001cbA!\u000b\u0002N\n=\u0002\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\u0007\tUb!\u0001\u0005j]R,'O\\1m\u0013\u0011\u0011IDa\r\u0003\u000f1{wmZ5oO\"Q!Q\bB\u0015\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0011%t7\u000f^1oG\u0016Dq!\u0015B\u0015\t\u0003\u0011\t\u0005\u0006\u0003\u0003D\t\u001d\u0003\u0003\u0002B#\u0005Si!!!>\t\u000f\tu\"q\ba\u00011\u00199!1\nB\u0015\t\n5#\u0001\u0002#bi\u0006\u001c\u0002B!\u0013\u0002z\n=#Q\u0001\t\u0004\u0013\nE\u0013b\u0001B*W\t9\u0001K]8ek\u000e$\b\"\u0003$\u0003J\tU\r\u0011\"\u0001H\u0011%q%\u0011\nB\tB\u0003%\u0001\nC\u0005@\u0005\u0013\u0012)\u001a!C\u0001\u0001\"I1I!\u0013\u0003\u0012\u0003\u0006IA\u0005\u0005\b#\n%C\u0011\u0001B0)\u0019\u0011\tG!\u001a\u0003hA!!1\rB%\u001b\t\u0011I\u0003\u0003\u0004G\u0005;\u0002\r\u0001\u0013\u0005\u0007\u007f\tu\u0003\u0019\u0001\n\t\u0015\u0005E&\u0011JA\u0001\n\u0003\u0011Y\u0007\u0006\u0004\u0003b\t5$q\u000e\u0005\t\r\n%\u0004\u0013!a\u0001\u0011\"AqH!\u001b\u0011\u0002\u0003\u0007!\u0003\u0003\u0006\u0003t\t%\u0013\u0013!C\u0001\u0005k\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003x)\u001a\u0001J!\u001f,\u0005\tm\u0004\u0003\u0002B?\u0005\u000bk!Aa \u000b\t\t\u0005%1Q\u0001\nk:\u001c\u0007.Z2lK\u0012T!AN\u0016\n\t\t\u001d%q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003BF\u0005\u0013\n\n\u0011\"\u0001\u0003\u000e\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BHU\r\u0011\"\u0011\u0010\u0005\u000b\u0005'\u0013I%!A\u0005B\tU\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0018B!!\u0011\u0014BR\u001b\t\u0011YJ\u0003\u0003\u0003\u001e\n}\u0015\u0001\u00027b]\u001eT!A!)\u0002\t)\fg/Y\u0005\u0004a\tm\u0005B\u0003BT\u0005\u0013\n\t\u0011\"\u0001\u0002Z\u0006a\u0001O]8ek\u000e$\u0018I]5us\"Q!1\u0016B%\u0003\u0003%\tA!,\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011\bBX\u0011)\t\tH!+\u0002\u0002\u0003\u0007\u00111\u001c\u0005\u000b\u0005g\u0013I%!A\u0005B\tU\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t]\u0006C\u0002B]\u0005\u007f\u000bI$\u0004\u0002\u0003<*\u0019!QX\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003B\nm&\u0001C%uKJ\fGo\u001c:\t\u0015\t\u0015'\u0011JA\u0001\n\u0003\u00119-\u0001\u0005dC:,\u0015/^1m)\u0011\t)I!3\t\u0015\u0005E$1YA\u0001\u0002\u0004\tI\u0004\u0003\u0006\u0003N\n%\u0013\u0011!C!\u0005\u001f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00037D!Ba5\u0003J\u0005\u0005I\u0011\tBk\u0003!!xn\u0015;sS:<GC\u0001BL\u0011)\u0011IN!\u0013\u0002\u0002\u0013\u0005#1\\\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015%Q\u001c\u0005\u000b\u0003c\u00129.!AA\u0002\u0005erA\u0003Bq\u0005S\t\t\u0011#\u0003\u0003d\u0006!A)\u0019;b!\u0011\u0011\u0019G!:\u0007\u0015\t-#\u0011FA\u0001\u0012\u0013\u00119o\u0005\u0004\u0003f\n%(Q\u0001\t\t\u0005W\u0014\t\u0010\u0013\n\u0003b5\u0011!Q\u001e\u0006\u0004\u0005_\\\u0013a\u0002:v]RLW.Z\u0005\u0005\u0005g\u0014iOA\tBEN$(/Y2u\rVt7\r^5p]JBq!\u0015Bs\t\u0003\u00119\u0010\u0006\u0002\u0003d\"Q!1\u001bBs\u0003\u0003%)E!6\t\u0015\tu(Q]A\u0001\n\u0003\u0013y0A\u0003baBd\u0017\u0010\u0006\u0004\u0003b\r\u000511\u0001\u0005\u0007\r\nm\b\u0019\u0001%\t\r}\u0012Y\u00101\u0001\u0013\u0011)\u00199A!:\u0002\u0002\u0013\u00055\u0011B\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Yaa\u0005\u0011\u000b%\u000bIf!\u0004\u0011\u000b%\u001by\u0001\u0013\n\n\u0007\rE1F\u0001\u0004UkBdWM\r\u0005\u000b\u0007+\u0019)!!AA\u0002\t\u0005\u0014a\u0001=%a!A1\u0011\u0004B\u0015\t#\u001aY\"\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\tIg!\b\t\u000f\t\u00152q\u0003a\u0001K\u001991\u0011EA{\t\r\r\"AJ$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3beJ+wM]3tg&|g.T8eK2\u0014V-\u00193feN!1q\u0004B\u000b\u0011\u001d\t6q\u0004C\u0001\u0007O!\"a!\u000b\u0011\t\t\u00153q\u0004\u0005\u000b\u0007[\u0019yB1A\u0005\n\tU\u0015!C2mCN\u001ch*Y7f\u0011%\u0019\tda\b!\u0002\u0013\u00119*\u0001\u0006dY\u0006\u001c8OT1nK\u0002B\u0001Ba\b\u0004 \u0011\u00053Q\u0007\u000b\u00041\r]\u0002b\u0002B\u0013\u0007g\u0001\r!\n\u0005\u000b\u0007w\t)0!A\u0005\n\ru\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa\u0010\u0011\t\te5\u0011I\u0005\u0005\u0007\u0007\u0012YJ\u0001\u0004PE*,7\r\u001e\u0015\u0005\u0003k\u001c\u0014\b\u000b\u0003\u0002pNJ\u0004")
public class GeneralizedLinearRegressionModel
extends RegressionModel<Vector, GeneralizedLinearRegressionModel>
implements GeneralizedLinearRegressionBase,
MLWritable {
    private GeneralizedLinearRegression.FamilyAndLink familyAndLink;
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> family;
    private final DoubleParam variancePower;
    private final Param<String> link;
    private final DoubleParam linkPower;
    private final Param<String> linkPredictionCol;
    private final Param<String> offsetCol;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final DoubleParam regParam;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final BooleanParam fitIntercept;
    private volatile boolean bitmap$0;

    public static /* bridge */ Object load(String string) {
        return GeneralizedLinearRegressionModel$.MODULE$.load(string);
    }

    public static GeneralizedLinearRegressionModel load(String string) {
        return GeneralizedLinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GeneralizedLinearRegressionModel> read() {
        return GeneralizedLinearRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return GeneralizedLinearRegressionBase.getFamily$(this);
    }

    @Override
    public double getVariancePower() {
        return GeneralizedLinearRegressionBase.getVariancePower$(this);
    }

    @Override
    public String getLink() {
        return GeneralizedLinearRegressionBase.getLink$(this);
    }

    @Override
    public double getLinkPower() {
        return GeneralizedLinearRegressionBase.getLinkPower$(this);
    }

    @Override
    public String getLinkPredictionCol() {
        return GeneralizedLinearRegressionBase.getLinkPredictionCol$(this);
    }

    @Override
    public String getOffsetCol() {
        return GeneralizedLinearRegressionBase.getOffsetCol$(this);
    }

    @Override
    public boolean hasWeightCol() {
        return GeneralizedLinearRegressionBase.hasWeightCol$(this);
    }

    @Override
    public boolean hasOffsetCol() {
        return GeneralizedLinearRegressionBase.hasOffsetCol$(this);
    }

    @Override
    public boolean hasLinkPredictionCol() {
        return GeneralizedLinearRegressionBase.hasLinkPredictionCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return GeneralizedLinearRegressionBase.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public final DoubleParam variancePower() {
        return this.variancePower;
    }

    @Override
    public final Param<String> link() {
        return this.link;
    }

    @Override
    public final DoubleParam linkPower() {
        return this.linkPower;
    }

    @Override
    public final Param<String> linkPredictionCol() {
        return this.linkPredictionCol;
    }

    @Override
    public final Param<String> offsetCol() {
        return this.offsetCol;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$variancePower_$eq(DoubleParam x$1) {
        this.variancePower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$link_$eq(Param<String> x$1) {
        this.link = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPower_$eq(DoubleParam x$1) {
        this.linkPower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPredictionCol_$eq(Param<String> x$1) {
        this.linkPredictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$offsetCol_$eq(Param<String> x$1) {
        this.offsetCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public GeneralizedLinearRegressionModel setLinkPredictionCol(String value) {
        return (GeneralizedLinearRegressionModel)this.set(this.linkPredictionCol(), value);
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if (!this.bitmap$0) {
                this.familyAndLink = GeneralizedLinearRegression$FamilyAndLink$.MODULE$.apply(this);
                this.bitmap$0 = true;
            }
        }
        return this.familyAndLink;
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink() {
        return !this.bitmap$0 ? this.familyAndLink$lzycompute() : this.familyAndLink;
    }

    @Override
    public double predict(Vector features) {
        return this.predict(features, 0.0);
    }

    private double predict(Vector features, double offset) {
        double eta = this.predictLink(features, offset);
        return this.familyAndLink().fitted(eta);
    }

    private double predictLink(Vector features, double offset) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept() + offset;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        return this.transformImpl(dataset);
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Dataset output;
        block1: {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(GeneralizedLinearRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(features, offset) -> BoxesRunTime.boxToDouble((double)this.predict(features, BoxesRunTime.unboxToDouble((Object)offset))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(GeneralizedLinearRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictLinkUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(features, offset) -> BoxesRunTime.boxToDouble((double)this.predictLink(features, BoxesRunTime.unboxToDouble((Object)offset))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
            Column offset2 = !this.hasOffsetCol() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0)) : functions$.MODULE$.col(this.$(this.offsetCol())).cast((DataType)DoubleType$.MODULE$);
            output = dataset;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                output = output.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset2})));
            }
            if (!this.hasLinkPredictionCol()) break block1;
            output = output.withColumn(this.$(this.linkPredictionCol()), predictLinkUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset2})));
        }
        return output.toDF();
    }

    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<GeneralizedLinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public GeneralizedLinearRegressionTrainingSummary summary() {
        return (GeneralizedLinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("No training summary available for this GeneralizedLinearRegressionModel");
        });
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public GeneralizedLinearRegressionModel setSummary(Option<GeneralizedLinearRegressionTrainingSummary> summary) {
        this.trainingSummary_$eq(summary);
        return this;
    }

    public GeneralizedLinearRegressionSummary evaluate(Dataset<?> dataset) {
        return new GeneralizedLinearRegressionSummary(dataset, this);
    }

    @Override
    public GeneralizedLinearRegressionModel copy(ParamMap extra) {
        GeneralizedLinearRegressionModel copied = this.copyValues(new GeneralizedLinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (GeneralizedLinearRegressionModel)copied.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new GeneralizedLinearRegressionModelWriter(this);
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public GeneralizedLinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasFitIntercept.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        GeneralizedLinearRegressionBase.$init$(this);
        MLWritable.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients.size();
    }

    public static class GeneralizedLinearRegressionModelReader
    extends MLReader<GeneralizedLinearRegressionModel> {
        private final String className = GeneralizedLinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GeneralizedLinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = (Row)this.sparkSession().read().parquet(dataPath).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            double intercept = data.getDouble(0);
            Vector coefficients = (Vector)data.getAs(1);
            GeneralizedLinearRegressionModel model = new GeneralizedLinearRegressionModel(metadata.uid(), coefficients, intercept);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GeneralizedLinearRegressionModelWriter
    extends MLWriter {
        private volatile GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data$module;
        private final GeneralizedLinearRegressionModel instance;

        private GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1(GeneralizedLinearRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            GeneralizedLinearRegressionModelWriter generalizedLinearRegressionModelWriter = this;
            synchronized (generalizedLinearRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$(this);
                }
            }
        }

        public GeneralizedLinearRegressionModelWriter(GeneralizedLinearRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ GeneralizedLinearRegressionModelWriter $outer;

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients) {
                return new Data(this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer(), intercept, coefficients);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GeneralizedLinearRegressionModelWriter org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GeneralizedLinearRegressionModelWriter $outer, double intercept, Vector coefficients) {
                this.intercept = intercept;
                this.coefficients = coefficients;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

