/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.IsotonicRegressionBase$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}4\u0001\"\u0001\u0002\u0011\u0002\u0007\u0005!\u0001\u0004\u0002\u0017\u0013N|Go\u001c8jGJ+wM]3tg&|gNQ1tK*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'!\u0001QbE\r E\u0015B\u0003C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\t\u0005)\u0001/\u0019:b[&\u0011\u0001$\u0006\u0002\u0007!\u0006\u0014\u0018-\\:\u0011\u0005iiR\"A\u000e\u000b\u0005q)\u0012AB:iCJ,G-\u0003\u0002\u001f7\tq\u0001*Y:GK\u0006$XO]3t\u0007>d\u0007C\u0001\u000e!\u0013\t\t3DA\u0006ICNd\u0015MY3m\u0007>d\u0007C\u0001\u000e$\u0013\t!3D\u0001\tICN\u0004&/\u001a3jGRLwN\\\"pYB\u0011!DJ\u0005\u0003Om\u0011A\u0002S1t/\u0016Lw\r\u001b;D_2\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0004\u0002\u0011%tG/\u001a:oC2L!!\f\u0016\u0003\u000f1{wmZ5oO\")q\u0006\u0001C\u0001c\u00051A%\u001b8ji\u0012\u001a\u0001\u0001F\u00013!\tq1'\u0003\u00025\u001f\t!QK\\5u\u0011\u001d1\u0004A1A\u0005\u0006]\n\u0001\"[:pi>t\u0017nY\u000b\u0002qA\u0011A#O\u0005\u0003uU\u0011ABQ8pY\u0016\fg\u000eU1sC6DQ\u0001\u0010\u0001\u0005\u0006u\n1bZ3u\u0013N|Go\u001c8jGV\ta\b\u0005\u0002\u000f\u007f%\u0011\u0001i\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011\u0005A1A\u0005\u0006\r\u000bABZ3biV\u0014X-\u00138eKb,\u0012\u0001\u0012\t\u0003)\u0015K!AR\u000b\u0003\u0011%sG\u000fU1sC6DQ\u0001\u0013\u0001\u0005\u0006%\u000bqbZ3u\r\u0016\fG/\u001e:f\u0013:$W\r_\u000b\u0002\u0015B\u0011abS\u0005\u0003\u0019>\u00111!\u00138u\u0011\u0019q\u0005\u0001\"\u0001\u0003{\u0005a\u0001.Y:XK&<\u0007\u000e^\"pY\"1\u0001\u000b\u0001C\t\tE\u000bA$\u001a=ue\u0006\u001cGoV3jO\"$X\r\u001a'bE\u0016dW\r\u001a)pS:$8\u000f\u0006\u0002S=B\u00191K\u0016-\u000e\u0003QS!!\u0016\u0004\u0002\u0007I$G-\u0003\u0002X)\n\u0019!\u000b\u0012#\u0011\u000b9I6lW.\n\u0005i{!A\u0002+va2,7\u0007\u0005\u0002\u000f9&\u0011Ql\u0004\u0002\u0007\t>,(\r\\3\t\u000b}{\u0005\u0019\u00011\u0002\u000f\u0011\fG/Y:fiB\u0012\u0011-\u001b\t\u0004E\u0016<W\"A2\u000b\u0005\u00114\u0011aA:rY&\u0011am\u0019\u0002\b\t\u0006$\u0018m]3u!\tA\u0017\u000e\u0004\u0001\u0005\u0013)t\u0016\u0011!A\u0001\u0006\u0003Y'aA0%cE\u0011An\u001c\t\u0003\u001d5L!A\\\b\u0003\u000f9{G\u000f[5oOB\u0011a\u0002]\u0005\u0003c>\u00111!\u00118z\u0011\u0019\u0019\b\u0001\"\u0005\u0005i\u0006Qb/\u00197jI\u0006$X-\u00118e)J\fgn\u001d4pe6\u001c6\r[3nCR\u0019Qo_?\u0011\u0005YLX\"A<\u000b\u0005a\u001c\u0017!\u0002;za\u0016\u001c\u0018B\u0001>x\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006yJ\u0004\r!^\u0001\u0007g\u000eDW-\\1\t\u000by\u0014\b\u0019\u0001 \u0002\u000f\u0019LG\u000f^5oO\u0002")
public interface IsotonicRegressionBase
extends HasFeaturesCol,
HasLabelCol,
HasPredictionCol,
HasWeightCol,
Logging {
    public void org$apache$spark$ml$regression$IsotonicRegressionBase$_setter_$isotonic_$eq(BooleanParam var1);

    public void org$apache$spark$ml$regression$IsotonicRegressionBase$_setter_$featureIndex_$eq(IntParam var1);

    public BooleanParam isotonic();

    public static /* synthetic */ boolean getIsotonic$(IsotonicRegressionBase $this) {
        return $this.getIsotonic();
    }

    default public boolean getIsotonic() {
        return BoxesRunTime.unboxToBoolean((Object)this.$(this.isotonic()));
    }

    public IntParam featureIndex();

    public static /* synthetic */ int getFeatureIndex$(IsotonicRegressionBase $this) {
        return $this.getFeatureIndex();
    }

    default public int getFeatureIndex() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.featureIndex()));
    }

    public static /* synthetic */ boolean hasWeightCol$(IsotonicRegressionBase $this) {
        return $this.hasWeightCol();
    }

    default public boolean hasWeightCol() {
        return this.isDefined(this.weightCol()) && new StringOps(Predef$.MODULE$.augmentString((String)this.$(this.weightCol()))).nonEmpty();
    }

    public static /* synthetic */ RDD extractWeightedLabeledPoints$(IsotonicRegressionBase $this, Dataset dataset) {
        return $this.extractWeightedLabeledPoints(dataset);
    }

    default public RDD<Tuple3<Object, Object, Object>> extractWeightedLabeledPoints(Dataset<?> dataset) {
        Column column;
        if (dataset.schema().apply(this.$(this.featuresCol())).dataType() instanceof VectorUDT) {
            int idx = BoxesRunTime.unboxToInt((Object)this.$(this.featureIndex()));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(IsotonicRegressionBase.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_IsotonicRegressionBase$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_IsotonicRegressionBase$$typecreator1$1(IsotonicRegressionBase $outer) {
                }
            }
            UserDefinedFunction extract = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)v.apply(idx)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_IsotonicRegressionBase$$typecreator1$1(null)));
            column = extract.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
        } else {
            column = functions$.MODULE$.col(this.$(this.featuresCol()));
        }
        Column f = column;
        Column w = this.hasWeightCol() ? functions$.MODULE$.col((String)this.$(this.weightCol())).cast((DataType)DoubleType$.MODULE$) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col((String)this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), f, w})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            double d2;
            Object weight;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object feature = ((SeqLike)some.get()).apply(1);
                    weight = ((SeqLike)some.get()).apply(2);
                    if (!(label instanceof Double)) break block2;
                    d2 = BoxesRunTime.unboxToDouble((Object)label);
                    if (!(feature instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)feature);
                    if (weight instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d3 = BoxesRunTime.unboxToDouble((Object)weight);
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d3));
            return tuple3;
        }, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public static /* synthetic */ StructType validateAndTransformSchema$(IsotonicRegressionBase $this, StructType schema, boolean fitting) {
        return $this.validateAndTransformSchema(schema, fitting);
    }

    default public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        DataType featuresType;
        if (fitting) {
            SchemaUtils$.MODULE$.checkNumericType(schema, (String)this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
            if (this.hasWeightCol()) {
                SchemaUtils$.MODULE$.checkNumericType(schema, (String)this.$(this.weightCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
            } else {
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> "The weight column is not defined. Treat all instance weights as 1.0.");
            }
        }
        DataType dataType = featuresType = schema.apply(this.$(this.featuresCol())).dataType();
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        Predef$.MODULE$.require(!(dataType == null ? doubleType$ != null : !dataType.equals(doubleType$)) || featuresType instanceof VectorUDT);
        return SchemaUtils$.MODULE$.appendColumn(schema, (String)this.$(this.predictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public static void $init$(IsotonicRegressionBase $this) {
        $this.org$apache$spark$ml$regression$IsotonicRegressionBase$_setter_$isotonic_$eq(new BooleanParam($this, "isotonic", "whether the output sequence should be isotonic/increasing (true) or antitonic/decreasing (false)"));
        $this.org$apache$spark$ml$regression$IsotonicRegressionBase$_setter_$featureIndex_$eq(new IntParam((Identifiable)$this, "featureIndex", "The index of the feature if featuresCol is a vector column, no effect otherwise (>= 0)", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0)));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.isotonic().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true)), $this.featureIndex().$minus$greater(BoxesRunTime.boxToInteger((int)0))}));
    }
}

