/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLoss;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.LinearRegressionModel$;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.GeneralMLWritable;
import org.apache.spark.ml.util.GeneralMLWriter;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u00015\u0011Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019IB\u0004\u0005\u0003\u0010!IAR\"\u0001\u0002\n\u0005E\u0011!a\u0004*fOJ,7o]5p]6{G-\u001a7\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011A\u00027j]\u0006dw-\u0003\u0002\u0018)\t1a+Z2u_J\u0004\"a\u0004\u0001\u0011\u0005=Q\u0012BA\u000e\u0003\u0005Ya\u0015N\\3beJ+wM]3tg&|g\u000eU1sC6\u001c\bCA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0011)H/\u001b7\n\u0005\u0005r\"!E$f]\u0016\u0014\u0018\r\\'M/JLG/\u00192mK\"A1\u0005\u0001BC\u0002\u0013\u0005C%A\u0002vS\u0012,\u0012!\n\t\u0003M=r!aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0005)b\u0011A\u0002\u001fs_>$hHC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3&\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018,Q\r\u00113'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0003m\u0019\t!\"\u00198o_R\fG/[8o\u0013\tATGA\u0003TS:\u001cW-I\u0001;\u0003\u0015\td\u0006\u000e\u00181\u0011!a\u0004A!A!\u0002\u0013)\u0013\u0001B;jI\u0002B3aO\u001a:\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0015\u0001D2pK\u001a4\u0017nY5f]R\u001cX#\u0001\n)\u0007y\u001a$)I\u0001D\u0003\u0015\u0011d\u0006\r\u00181\u0011!)\u0005A!A!\u0002\u0013\u0011\u0012!D2pK\u001a4\u0017nY5f]R\u001c\b\u0005K\u0002Eg\tC\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!S\u0001\nS:$XM]2faR,\u0012A\u0013\t\u0003\u00172k\u0011aK\u0005\u0003\u001b.\u0012a\u0001R8vE2,\u0007fA$4\u001f\u0006\n\u0001+A\u00032]Mr\u0003\u0007\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003K\u0003)Ig\u000e^3sG\u0016\u0004H\u000f\t\u0015\u0004#Nz\u0005\u0002C+\u0001\u0005\u000b\u0007I\u0011A%\u0002\u000bM\u001c\u0017\r\\3)\u0007Q\u001bt+I\u0001Y\u0003\u0015\u0011df\r\u00181\u0011!Q\u0006A!A!\u0002\u0013Q\u0015AB:dC2,\u0007\u0005K\u0002Zg]Ca!\u0018\u0001\u0005\u0002\u0011q\u0016A\u0002\u001fj]&$h\bF\u0003\u0019?\u0006\u001cW\rC\u0003$9\u0002\u0007Q\u0005K\u0002`geBQa\u0010/A\u0002IA3!Y\u001aC\u0011\u0015AE\f1\u0001KQ\r\u00197g\u0014\u0005\u0006+r\u0003\rA\u0013\u0015\u0004KN:\u0006BB/\u0001\t\u0003!\u0001\u000e\u0006\u0003\u0019S*\\\u0007\"B\u0012h\u0001\u0004)\u0003\"B h\u0001\u0004\u0011\u0002\"\u0002%h\u0001\u0004Q\u0005bB7\u0001\u0001\u0004%IA\\\u0001\u0010iJ\f\u0017N\\5oON+X.\\1ssV\tq\u000eE\u0002LaJL!!]\u0016\u0003\r=\u0003H/[8o!\ty1/\u0003\u0002u\u0005\tyB*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c+sC&t\u0017N\\4Tk6l\u0017M]=\t\u000fY\u0004\u0001\u0019!C\u0005o\u0006\u0019BO]1j]&twmU;n[\u0006\u0014\u0018p\u0018\u0013fcR\u0011\u0001p\u001f\t\u0003\u0017fL!A_\u0016\u0003\tUs\u0017\u000e\u001e\u0005\byV\f\t\u00111\u0001p\u0003\rAH%\r\u0005\u0007}\u0002\u0001\u000b\u0015B8\u0002!Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011IA\u0002\u0003-qW/\u001c$fCR,(/Z:\u0016\u0005\u0005\u0015\u0001cA&\u0002\b%\u0019\u0011\u0011B\u0016\u0003\u0007%sG\u000f\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0003\u00031qW/\u001c$fCR,(/Z:!\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tqa];n[\u0006\u0014\u00180F\u0001sQ\u0015\tyaMA\fC\t\tI\"A\u00032]Ur\u0003\u0007\u0003\u0005\u0002\u001e\u0001!\tAAA\u0010\u0003)\u0019X\r^*v[6\f'/\u001f\u000b\u0005\u0003C\t\u0019#D\u0001\u0001\u0011\u001d\t\t\"a\u0007A\u0002=Dq!a\n\u0001\t\u0003\tI#\u0001\u0006iCN\u001cV/\\7bef,\"!a\u000b\u0011\u0007-\u000bi#C\u0002\u00020-\u0012qAQ8pY\u0016\fg\u000eK\u0003\u0002&M\n9\u0002C\u0004\u00026\u0001!\t!a\u000e\u0002\u0011\u00154\u0018\r\\;bi\u0016$B!!\u000f\u0002@A\u0019q\"a\u000f\n\u0007\u0005u\"AA\fMS:,\u0017M\u001d*fOJ,7o]5p]N+X.\\1ss\"A\u0011\u0011IA\u001a\u0001\u0004\t\u0019%A\u0004eCR\f7/\u001a;1\t\u0005\u0015\u0013Q\u000b\t\u0007\u0003\u000f\ni%!\u0015\u000e\u0005\u0005%#bAA&\r\u0005\u00191/\u001d7\n\t\u0005=\u0013\u0011\n\u0002\b\t\u0006$\u0018m]3u!\u0011\t\u0019&!\u0016\r\u0001\u0011a\u0011qKA \u0003\u0003\u0005\tQ!\u0001\u0002Z\t\u0019q\f\n\u001a\u0012\t\u0005m\u0013\u0011\r\t\u0004\u0017\u0006u\u0013bAA0W\t9aj\u001c;iS:<\u0007cA&\u0002d%\u0019\u0011QM\u0016\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u00024M\u0012\u0005\u0002CA6\u0001\u0011\u0005!!!\u001c\u0002A\u0019Lg\u000eZ*v[6\f'/_'pI\u0016d\u0017I\u001c3Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003\u0003_\u0002RaSA91\u0015J1!a\u001d,\u0005\u0019!V\u000f\u001d7fe!9\u0011q\u000f\u0001\u0005B\u0005e\u0014a\u00029sK\u0012L7\r\u001e\u000b\u0004\u0015\u0006m\u0004bBA?\u0003k\u0002\rAE\u0001\tM\u0016\fG/\u001e:fg\"9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0015\u0001B2paf$2\u0001GAC\u0011!\t9)a A\u0002\u0005%\u0015!B3yiJ\f\u0007\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=E!A\u0003qCJ\fW.\u0003\u0003\u0002\u0014\u00065%\u0001\u0003)be\u0006lW*\u00199)\t\u0005}4'\u000f\u0005\b\u00033\u0003A\u0011IAN\u0003\u00159(/\u001b;f+\t\ti\nE\u0002\u001e\u0003?K1!!)\u001f\u0005=9UM\\3sC2lEj\u0016:ji\u0016\u0014\b&BALg\u0005\u0015\u0016EAAT\u0003\u0015\tdF\u000e\u00181Q\r\u00011gT\u0004\b\u0003[\u0013\u0001\u0012AAX\u0003Ua\u0015N\\3beJ+wM]3tg&|g.T8eK2\u00042aDAY\r\u0019\t!\u0001#\u0001\u00024NA\u0011\u0011WA[\u0003w\u000b\t\rE\u0002L\u0003oK1!!/,\u0005\u0019\te.\u001f*fMB!Q$!0\u0019\u0013\r\tyL\b\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007cA&\u0002D&\u0019\u0011QY\u0016\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fu\u000b\t\f\"\u0001\u0002JR\u0011\u0011q\u0016\u0005\t\u0003\u001b\f\t\f\"\u0011\u0002P\u0006!!/Z1e+\t\t\t\u000e\u0005\u0003\u001e\u0003'D\u0012bAAk=\tAQ\n\u0014*fC\u0012,'\u000fK\u0003\u0002LN\n)\u000b\u0003\u0005\u0002\\\u0006EF\u0011IAo\u0003\u0011aw.\u00193\u0015\u0007a\ty\u000eC\u0004\u0002b\u0006e\u0007\u0019A\u0013\u0002\tA\fG\u000f\u001b\u0015\u0006\u00033\u001c\u0014Q\u0015\u0004\b\u0003O\f\t\fBAu\u0005ma\u0015N\\3beJ+wM]3tg&|g.T8eK2\u0014V-\u00193feN!\u0011Q]Ai\u0011\u001di\u0016Q\u001dC\u0001\u0003[$\"!a<\u0011\t\u0005E\u0018Q]\u0007\u0003\u0003cC!\"!>\u0002f\n\u0007I\u0011BA|\u0003%\u0019G.Y:t\u001d\u0006lW-\u0006\u0002\u0002zB!\u00111 B\u0003\u001b\t\tiP\u0003\u0003\u0002\u0000\n\u0005\u0011\u0001\u00027b]\u001eT!Aa\u0001\u0002\t)\fg/Y\u0005\u0004a\u0005u\b\"\u0003B\u0005\u0003K\u0004\u000b\u0011BA}\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u0005\t\u00037\f)\u000f\"\u0011\u0003\u000eQ\u0019\u0001Da\u0004\t\u000f\u0005\u0005(1\u0002a\u0001K!Q!1CAY\u0003\u0003%IA!\u0006\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005/\u0001B!a?\u0003\u001a%!!1DA\u007f\u0005\u0019y%M[3di\"*\u0011\u0011W\u001a\u0002&\"*\u00111V\u001a\u0002&\u0002")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams,
GeneralMLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> solver;
    private final Param<String> loss;
    private final DoubleParam epsilon;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static /* bridge */ Object load(String string) {
        return LinearRegressionModel$.MODULE$.load(string);
    }

    public static LinearRegressionModel load(String string) {
        return LinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LinearRegressionModel> read() {
        return LinearRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams.getEpsilon$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getLoss() {
        return HasLoss.getLoss$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param<String> x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param<String> x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    private Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearRegressionTrainingSummary summary() {
        return (LinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("No training summary available for this LinearRegressionModel");
        });
    }

    public LinearRegressionModel setSummary(Option<LinearRegressionTrainingSummary> summary) {
        this.trainingSummary_$eq(summary);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LinearRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
        String predictionColName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
        Tuple2 tuple23 = tuple22;
        LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
        String predictionColName2 = (String)tuple23._2();
        return new LinearRegressionSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), summaryModel2, new double[]{0.0});
    }

    public Tuple2<LinearRegressionModel, String> findSummaryModelAndPredictionCol() {
        Tuple2 tuple2;
        String string = this.$(this.predictionCol());
        if ("".equals(string)) {
            String predictionColName = new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString();
            tuple2 = new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(predictionColName), (Object)predictionColName);
        } else {
            tuple2 = new Tuple2((Object)this, (Object)string);
        }
        return tuple2;
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (LinearRegressionModel)newModel.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public GeneralMLWriter write() {
        return new GeneralMLWriter(this);
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        HasLoss.$init$(this);
        LinearRegressionParams.$init$(this);
        MLWritable.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients.size();
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, coefficients, intercept, 1.0);
    }

    public static class LinearRegressionModelReader
    extends MLReader<LinearRegressionModel> {
        private final String className = LinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearRegressionModel load(String path) {
            LinearRegressionModel linearRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Vector vector;
                double d;
                Object scale;
                block12: {
                    Row row;
                    block11: {
                        Dataset data;
                        block7: {
                            double d2;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int majorVersion = tuple2._1$mcI$sp();
                                    int minorVersion = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(majorVersion, minorVersion);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int majorVersion2 = sp3._1$mcI$sp();
                                    int minorVersion2 = sp3._2$mcI$sp();
                                    if (majorVersion2 >= 2 && (majorVersion2 != 2 || minorVersion2 > 2)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block8;
                                    Object intercept = ((SeqLike)some.get()).apply(0);
                                    coefficients = ((SeqLike)some.get()).apply(1);
                                    if (!(intercept instanceof Double)) break block8;
                                    d2 = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d2), (Object)vector2);
                            Tuple2 tuple22 = tuple2;
                            double intercept = tuple22._1$mcD$sp();
                            Vector coefficients2 = (Vector)tuple22._2();
                            linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients2, intercept);
                            break block10;
                        }
                        row = (Row)data.select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients", "scale"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block11;
                        Object intercept = ((SeqLike)some.get()).apply(0);
                        Object coefficients = ((SeqLike)some.get()).apply(1);
                        scale = ((SeqLike)some.get()).apply(2);
                        if (!(intercept instanceof Double)) break block11;
                        d = BoxesRunTime.unboxToDouble((Object)intercept);
                        if (!(coefficients instanceof Vector)) break block11;
                        vector = (Vector)coefficients;
                        if (scale instanceof Double) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                double d3 = BoxesRunTime.unboxToDouble((Object)scale);
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector, (Object)BoxesRunTime.boxToDouble((double)d3));
                Tuple3 tuple32 = tuple3;
                double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                Vector coefficients = (Vector)tuple32._2();
                double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            }
            LinearRegressionModel model = linearRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }
}

