/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.image;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.image.ImageSchema$;
import org.apache.spark.ml.source.image.ImageOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.spark_project.guava.io.ByteStreams;
import org.spark_project.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u0001\u0003\u0001\tq!aD%nC\u001e,g)\u001b7f\r>\u0014X.\u0019;\u000b\u0005\r!\u0011!B5nC\u001e,'BA\u0003\u0007\u0003\u0019\u0019x.\u001e:dK*\u0011q\u0001C\u0001\u0003[2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=)r\u0004\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-ui\u0011a\u0006\u0006\u00031e\t1\u0002Z1uCN|WO]2fg*\u0011!dG\u0001\nKb,7-\u001e;j_:T!\u0001\b\u0005\u0002\u0007M\fH.\u0003\u0002\u001f/\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tZ\u0012aB:pkJ\u001cWm]\u0005\u0003I\u0005\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")a\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001*!\tQ\u0003!D\u0001\u0003\u0011\u0015a\u0003\u0001\"\u0011.\u0003-IgNZ3s'\u000eDW-\\1\u0015\t9:T(\u0014\t\u0004!=\n\u0014B\u0001\u0019\u0012\u0005\u0019y\u0005\u000f^5p]B\u0011!'N\u0007\u0002g)\u0011AgG\u0001\u0006if\u0004Xm]\u0005\u0003mM\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015A4\u00061\u0001:\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tQ4(D\u0001\u001c\u0013\ta4D\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003?W\u0001\u0007q(A\u0004paRLwN\\:\u0011\t\u0001;%J\u0013\b\u0003\u0003\u0016\u0003\"AQ\t\u000e\u0003\rS!\u0001R\u0014\u0002\rq\u0012xn\u001c;?\u0013\t1\u0015#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u00131!T1q\u0015\t1\u0015\u0003\u0005\u0002A\u0017&\u0011A*\u0013\u0002\u0007'R\u0014\u0018N\\4\t\u000b9[\u0003\u0019A(\u0002\u000b\u0019LG.Z:\u0011\u0007A+\u0006L\u0004\u0002R':\u0011!IU\u0005\u0002%%\u0011A+E\u0001\ba\u0006\u001c7.Y4f\u0013\t1vKA\u0002TKFT!\u0001V\t\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016A\u00014t\u0015\ti&\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003?j\u0013!BR5mKN#\u0018\r^;t\u0011\u0015\t\u0007\u0001\"\u0011c\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)\u0015\u0019gmZ8q!\t1B-\u0003\u0002f/\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")\u0001\b\u0019a\u0001s!)\u0001\u000e\u0019a\u0001S\u0006\u0019!n\u001c2\u0011\u0005)lW\"A6\u000b\u00051d\u0016!C7baJ,G-^2f\u0013\tq7NA\u0002K_\nDQA\u00101A\u0002}BQ!\u001d1A\u0002E\n!\u0002Z1uCN\u001b\u0007.Z7b\u0011\u0015\u0019\b\u0001\"\u0011u\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u0001K\u0011\u00151\b\u0001\"\u0015x\u0003-\u0011W/\u001b7e%\u0016\fG-\u001a:\u0015\u001fa\fy!!\u0005\u0002\u0014\u0005]\u00111DA\u0014\u0003S\u0001B\u0001E=|}&\u0011!0\u0005\u0002\n\rVt7\r^5p]F\u0002\"A\u0006?\n\u0005u<\"a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\tA{\u00181A\u0005\u0004\u0003\u00039&\u0001C%uKJ\fGo\u001c:\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\u001c\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\u0007\u0003\u000f\u00111\"\u00138uKJt\u0017\r\u001c*po\")\u0001(\u001ea\u0001s!)\u0011/\u001ea\u0001c!1\u0011QC;A\u0002E\nq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u00033)\b\u0019A\u0019\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011QD;A\u0002\u0005}\u0011a\u00024jYR,'o\u001d\t\u0005!V\u000b\t\u0003E\u0002!\u0003GI1!!\n\"\u0005\u00191\u0015\u000e\u001c;fe\")a(\u001ea\u0001\u007f!9\u00111F;A\u0002\u00055\u0012A\u00035bI>|\u0007oQ8oMB!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024q\u000bAaY8oM&!\u0011qGA\u0019\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0002")
public class ImageFileFormat
implements FileFormat,
DataSourceRegister {
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return FileFormat.isSplitable$((FileFormat)this, (SparkSession)sparkSession, options, (Path)path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType, (boolean)isReadPath);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)ImageSchema$.MODULE$.imageSchema());
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw new UnsupportedOperationException("Write is not supported for image data source");
    }

    public String shortName() {
        return "image";
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0 & Serializable & scala.Serializable)() -> "Image data source only produces a single data column named \"image\".");
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        ImageOptions imageSourceOptions = new ImageOptions(options);
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
            if (!imageSourceOptions.dropInvalid() && requiredSchema.isEmpty()) {
                iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnsafeRow[]{emptyUnsafeRow}));
            } else {
                Iterator filteredResult;
                byte[] byArray;
                String origin = file.filePath();
                Path path = new Path(origin);
                FileSystem fs = path.getFileSystem(((SerializableConfiguration)broadcastedHadoopConf.value()).value());
                FSDataInputStream stream = fs.open(path);
                try {
                    byArray = ByteStreams.toByteArray((InputStream)stream);
                }
                finally {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
                byte[] bytes = byArray;
                Option<Row> resultOpt = ImageSchema$.MODULE$.decode(origin, bytes);
                Iterator iterator2 = filteredResult = imageSourceOptions.dropInvalid() ? Option$.MODULE$.option2Iterable(resultOpt).toIterator() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{(Row)resultOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> ImageSchema$.MODULE$.invalidImageRow(origin))}));
                if (requiredSchema.isEmpty()) {
                    iterator = filteredResult.map((Function1 & Serializable & scala.Serializable)x$1 -> emptyUnsafeRow);
                } else {
                    ExpressionEncoder converter = RowEncoder$.MODULE$.apply(requiredSchema);
                    iterator = filteredResult.map((Function1 & Serializable & scala.Serializable)row -> converter.toRow(row));
                }
            }
            return iterator;
        };
    }

    public ImageFileFormat() {
        FileFormat.$init$((FileFormat)this);
    }
}

