/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.source.libsvm.LibSVMOptions;
import org.apache.spark.ml.source.libsvm.LibSVMOptions$;
import org.apache.spark.ml.source.libsvm.LibSVMOutputWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mc!B\u0001\u0003\u0001\tq!\u0001\u0005'jEN3VJR5mK\u001a{'/\\1u\u0015\t\u0019A!\u0001\u0004mS\n\u001ch/\u001c\u0006\u0003\u000b\u0019\taa]8ve\u000e,'BA\u0004\t\u0003\tiGN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\u0011\u0001q\"G\u0010\u0011\u0005A9R\"A\t\u000b\u0005I\u0019\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001F\u000b\u0002\u0013\u0015DXmY;uS>t'B\u0001\f\t\u0003\r\u0019\u0018\u000f\\\u0005\u00031E\u00111\u0003V3yi\n\u000b7/\u001a3GS2,gi\u001c:nCR\u0004\"AG\u000f\u000e\u0003mQ!\u0001H\u000b\u0002\u000fM|WO]2fg&\u0011ad\u0007\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002%C\t9Aj\\4hS:<\u0007\"\u0002\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003\tAQ\u0001\f\u0001\u0005B5\n\u0011b\u001d5peRt\u0015-\\3\u0015\u00039\u0002\"a\f\u001d\u000f\u0005A2\u0004CA\u00195\u001b\u0005\u0011$BA\u001a(\u0003\u0019a$o\\8u})\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9D\u0007C\u0003=\u0001\u0011\u0005S&\u0001\u0005u_N#(/\u001b8h\u0011\u0015q\u0004\u0001\"\u0003@\u000311XM]5gsN\u001b\u0007.Z7b)\r\u0001E\t\u0014\t\u0003\u0003\nk\u0011\u0001N\u0005\u0003\u0007R\u0012A!\u00168ji\")Q)\u0010a\u0001\r\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%+\u0012!\u0002;za\u0016\u001c\u0018BA&I\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u001bv\u0002\rAT\u0001\u000bM>\u0014xK]5uS:<\u0007CA!P\u0013\t\u0001FGA\u0004C_>dW-\u00198\t\u000bI\u0003A\u0011I*\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u0005)^k&\rE\u0002B+\u001aK!A\u0016\u001b\u0003\r=\u0003H/[8o\u0011\u0015A\u0016\u000b1\u0001Z\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tQ6,D\u0001\u0016\u0013\taVC\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003_#\u0002\u0007q,A\u0004paRLwN\\:\u0011\t=\u0002gFL\u0005\u0003Cj\u00121!T1q\u0011\u0015\u0019\u0017\u000b1\u0001e\u0003\u00151\u0017\u000e\\3t!\r)'.\u001c\b\u0003M\"t!!M4\n\u0003UJ!!\u001b\u001b\u0002\u000fA\f7m[1hK&\u00111\u000e\u001c\u0002\u0004'\u0016\f(BA55!\tq7/D\u0001p\u0015\t\u0001\u0018/\u0001\u0002gg*\u0011!OC\u0001\u0007Q\u0006$wn\u001c9\n\u0005Q|'A\u0003$jY\u0016\u001cF/\u0019;vg\")a\u000f\u0001C!o\u0006a\u0001O]3qCJ,wK]5uKR9\u0001p\u001f?\u0002\n\u0005-\u0001C\u0001\tz\u0013\tQ\u0018CA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003Yk\u0002\u0007\u0011\fC\u0003~k\u0002\u0007a0A\u0002k_\n\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004E\f\u0011\"\\1qe\u0016$WoY3\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0004\u0015>\u0014\u0007\"\u00020v\u0001\u0004y\u0006\"B#v\u0001\u00041\u0005bBA\b\u0001\u0011\u0005\u0013\u0011C\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000f\u0006\t\u0002\u0014\u0005E\u00121GA\u001b\u0003s\ti$!\u0013\u0002LA9\u0011)!\u0006\u0002\u001a\u0005}\u0011bAA\fi\tIa)\u001e8di&|g.\r\t\u0004!\u0005m\u0011bAA\u000f#\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003f\u0003C\t)#C\u0002\u0002$1\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111F\u000b\u0002\u0011\r\fG/\u00197zgRLA!a\f\u0002*\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0019A\u0016Q\u0002a\u00013\"1Q)!\u0004A\u0002\u0019Cq!a\u000e\u0002\u000e\u0001\u0007a)A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0011\u001d\tY$!\u0004A\u0002\u0019\u000baB]3rk&\u0014X\rZ*dQ\u0016l\u0017\r\u0003\u0005\u0002@\u00055\u0001\u0019AA!\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!\u001a6\u0002DA\u0019!$!\u0012\n\u0007\u0005\u001d3D\u0001\u0004GS2$XM\u001d\u0005\u0007=\u00065\u0001\u0019A0\t\u0011\u00055\u0013Q\u0002a\u0001\u0003\u001f\n!\u0002[1e_>\u00048i\u001c8g!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+c\u0006!1m\u001c8g\u0013\u0011\tI&a\u0015\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0001")
public class LibSVMFileFormat
extends TextBasedFileFormat
implements DataSourceRegister,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String shortName() {
        return "libsvm";
    }

    public String toString() {
        return "LibSVM";
    }

    private void verifySchema(StructType dataSchema, boolean forWriting) {
        if (dataSchema.size() != 2 || !dataSchema.apply(0).dataType().sameType(DataTypes.DoubleType) || !dataSchema.apply(1).dataType().sameType((DataType)new VectorUDT()) || !forWriting && (int)dataSchema.apply(1).metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES()) <= 0) {
            throw new IOException(new StringBuilder(39).append("Illegal schema for libsvm data, schema=").append(dataSchema).toString());
        }
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        int numFeatures = BoxesRunTime.unboxToInt((Object)libSVMOptions.numFeatures().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(files.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No input path specified for libsvm data");
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "'numFeatures' option not specified, determining the number of features by going though the input. If you know the number in advance, please specify it via 'numFeatures' option to avoid the extra scan.");
            Seq paths = (Seq)files.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toUri().toString(), Seq$.MODULE$.canBuildFrom());
            RDD<Tuple3<Object, int[], double[]>> parsed = MLUtils$.MODULE$.parseLibSVMFile(sparkSession, (Seq<String>)paths);
            return MLUtils$.MODULE$.computeNumFeatures(parsed);
        }));
        Metadata featuresMetadata = new MetadataBuilder().putLong(LibSVMOptions$.MODULE$.NUM_FEATURES(), (long)numFeatures).build();
        StructField structField = new StructField("label", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("features", (DataType)new VectorUDT(), false, featuresMetadata);
        return new Some((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema, true);
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new LibSVMOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(7).append(".libsvm").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        this.verifySchema(dataSchema, false);
        int numFeatures = (int)dataSchema.apply("features").metadata().getLong(LibSVMOptions$.MODULE$.NUM_FEATURES());
        Predef$.MODULE$.assert(numFeatures > 0);
        LibSVMOptions libSVMOptions = new LibSVMOptions(options);
        boolean isSparse = libSVMOptions.isSparse();
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return (Function1 & Serializable & scala.Serializable)file -> {
            HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, ((SerializableConfiguration)broadcastedHadoopConf.value()).value());
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$5 -> {
                linesReader.close();
                return BoxedUnit.UNIT;
            }));
            Iterator points = linesReader.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString().trim()).filterNot((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)LibSVMFileFormat.$anonfun$buildReader$5(line))).map((Function1 & Serializable & scala.Serializable)line -> {
                Tuple3<Object, int[], double[]> tuple3 = MLUtils$.MODULE$.parseLibSVMRecord((String)line);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                int[] indices = (int[])tuple3._2();
                double[] values = (double[])tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)indices, (Object)values);
                Tuple3 tuple33 = tuple32;
                double label2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
                int[] indices2 = (int[])tuple33._2();
                double[] values2 = (double[])tuple33._3();
                return new LabeledPoint(label2, Vectors$.MODULE$.sparse(numFeatures, indices2, values2));
            });
            ExpressionEncoder converter = RowEncoder$.MODULE$.apply(dataSchema);
            Seq fullOutput = (Seq)dataSchema.map((Function1 & Serializable & scala.Serializable)f -> {
                String x$8 = f.name();
                DataType x$9 = f.dataType();
                boolean x$10 = f.nullable();
                Metadata x$11 = f.metadata();
                ExprId x$12 = AttributeReference$.MODULE$.apply$default$5(x$8, x$9, x$10, x$11);
                Seq x$13 = AttributeReference$.MODULE$.apply$default$6(x$8, x$9, x$10, x$11);
                return new AttributeReference(x$8, x$9, x$10, x$11, x$12, x$13);
            }, Seq$.MODULE$.canBuildFrom());
            Seq requiredOutput = (Seq)fullOutput.filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)LibSVMFileFormat.$anonfun$buildReader$8(requiredSchema, a)));
            UnsafeProjection requiredColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)requiredOutput, fullOutput);
            return points.map((Function1 & Serializable & scala.Serializable)pt -> {
                SparseVector features = isSparse ? pt.features().toSparse() : pt.features().toDense();
                return requiredColumns.apply(converter.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)pt.label()), features}))));
            });
        };
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$5(String line) {
        return line.isEmpty() || line.startsWith("#");
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$8(StructType requiredSchema$1, AttributeReference a) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema$1.fieldNames())).contains((Object)a.name());
    }

    public LibSVMFileFormat() {
        Logging.$init$((Logging)this);
    }
}

