/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import java.io.Serializable;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class TreeEnsembleModel$ {
    public static TreeEnsembleModel$ MODULE$;

    static {
        new TreeEnsembleModel$();
    }

    public <M extends DecisionTreeModel> Vector featureImportances(M[] trees, int numFeatures) {
        Tuple2 tuple2;
        int d;
        int n;
        OpenHashMap.mcD.sp totalImportances = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees)).foreach(arg_0 -> TreeEnsembleModel$.$anonfun$featureImportances$1$adapted((OpenHashMap)totalImportances, arg_0));
        this.normalizeMapValues((OpenHashMap<Object, Object>)totalImportances);
        if (numFeatures != -1) {
            n = numFeatures;
        } else {
            int maxFeatureIndex = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees)).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.maxSplitFeatureIndex()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
            n = d = maxFeatureIndex + 1;
        }
        if (d == 0) {
            Predef$.MODULE$.assert(totalImportances.size() == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Unknown error in computing feature").append(" importance: No splits found, but some non-zero importances.").toString());
        }
        if ((tuple2 = ((GenericTraversableTemplate)totalImportances.iterator().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms())) == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq indices = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
        Tuple2 tuple23 = tuple22;
        Seq indices2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        return Vectors$.MODULE$.sparse(d, (int[])indices2.toArray(ClassTag$.MODULE$.Int()), (double[])values2.toArray(ClassTag$.MODULE$.Double()));
    }

    public <M extends DecisionTreeModel> Vector featureImportances(M tree, int numFeatures, ClassTag<M> evidence$1) {
        return this.featureImportances((DecisionTreeModel[])((Object[])new DecisionTreeModel[]{tree}), numFeatures);
    }

    public void computeFeatureImportance(Node node, OpenHashMap<Object, Object> importances) {
        Node node2;
        while ((node2 = node) instanceof InternalNode) {
            InternalNode internalNode = (InternalNode)node2;
            int feature = internalNode.split().featureIndex();
            double scaledGain = internalNode.gain() * (double)internalNode.impurityStats().count();
            importances.changeValue$mcD$sp((Object)BoxesRunTime.boxToInteger((int)feature), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> scaledGain, (Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$9 -> x$9 + scaledGain);
            this.computeFeatureImportance(internalNode.leftChild(), importances);
            node = internalNode.rightChild();
        }
        if (!(node2 instanceof LeafNode)) {
            throw new MatchError((Object)node2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void normalizeMapValues(OpenHashMap<Object, Object> map) {
        block0: {
            double total = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10._2$mcD$sp()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            if (total == 0.0) break block0;
            int[] keys = (int[])map.iterator().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11._1$mcI$sp())).toArray(ClassTag$.MODULE$.Int());
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)key -> map.changeValue$mcD$sp((Object)BoxesRunTime.boxToInteger((int)key), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$12 -> x$12 / total));
        }
    }

    public static final /* synthetic */ double $anonfun$featureImportances$3(OpenHashMap totalImportances$1, double treeNorm$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int idx = tuple2._1$mcI$sp();
        double impt = tuple2._2$mcD$sp();
        double normImpt = impt / treeNorm$1;
        double d = totalImportances$1.changeValue$mcD$sp((Object)BoxesRunTime.boxToInteger((int)idx), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> normImpt, (Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$5 -> x$5 + normImpt);
        return d;
    }

    public static final /* synthetic */ void $anonfun$featureImportances$1(OpenHashMap totalImportances$1, DecisionTreeModel tree) {
        block0: {
            OpenHashMap.mcD.sp importances = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
            MODULE$.computeFeatureImportance(tree.rootNode(), (OpenHashMap<Object, Object>)importances);
            double treeNorm = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)importances.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4._2$mcD$sp()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            if (treeNorm == 0.0) break block0;
            importances.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)TreeEnsembleModel$.$anonfun$featureImportances$3(totalImportances$1, treeNorm, x0$2)));
        }
    }

    private TreeEnsembleModel$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$featureImportances$1$adapted(OpenHashMap totalImportances$1, DecisionTreeModel tree) {
        TreeEnsembleModel$.$anonfun$featureImportances$1(totalImportances$1, tree);
        return BoxedUnit.UNIT;
    }
}

