/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.Serializable;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.EntropyAggregator;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.GiniAggregator;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.ImpurityAggregator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.impurity.VarianceAggregator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u00055b!B\u0001\u0003\u0001!q!!\u0005#U'R\fGo]!hOJ,w-\u0019;pe*\u00111\u0001B\u0001\u0005S6\u0004HN\u0003\u0002\u0006\r\u0005!AO]3f\u0015\t9\u0001\"\u0001\u0002nY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\t\u0017\u0013\t9\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u001c\u0003!iW\r^1eCR\f7\u0001A\u000b\u00029A\u0011QDH\u0007\u0002\u0005%\u0011qD\u0001\u0002\u0015\t\u0016\u001c\u0017n]5p]R\u0013X-Z'fi\u0006$\u0017\r^1\t\u0011\u0005\u0002!\u0011!Q\u0001\nq\t\u0011\"\\3uC\u0012\fG/\u0019\u0011\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nQBZ3biV\u0014XmU;cg\u0016$\bc\u0001\t&O%\u0011a%\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007AA#&\u0003\u0002*#\t)\u0011I\u001d:bsB\u0011\u0001cK\u0005\u0003YE\u00111!\u00138u\u0011\u0015q\u0003\u0001\"\u00010\u0003\u0019a\u0014N\\5u}Q\u0019\u0001'\r\u001a\u0011\u0005u\u0001\u0001\"B\r.\u0001\u0004a\u0002\"B\u0012.\u0001\u0004!\u0003b\u0002\u001b\u0001\u0005\u0004%\t!N\u0001\u0013S6\u0004XO]5us\u0006;wM]3hCR|'/F\u00017!\t9T(D\u00019\u0015\tI$(\u0001\u0005j[B,(/\u001b;z\u0015\t)1H\u0003\u0002=\u0011\u0005)Q\u000e\u001c7jE&\u0011a\b\u000f\u0002\u0013\u00136\u0004XO]5us\u0006;wM]3hCR|'\u000f\u0003\u0004A\u0001\u0001\u0006IAN\u0001\u0014S6\u0004XO]5us\u0006;wM]3hCR|'\u000f\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0003%\u0019H/\u0019;t'&TX-F\u0001+\u0011\u0019)\u0005\u0001)A\u0005U\u0005Q1\u000f^1ugNK'0\u001a\u0011\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\u00069a.^7CS:\u001cX#A\u0014\t\r)\u0003\u0001\u0015!\u0003(\u0003!qW/\u001c\"j]N\u0004\u0003b\u0002'\u0001\u0005\u0004%I\u0001S\u0001\u000fM\u0016\fG/\u001e:f\u001f\u001a47/\u001a;t\u0011\u0019q\u0005\u0001)A\u0005O\u0005ya-Z1ukJ,wJ\u001a4tKR\u001c\b\u0005C\u0004Q\u0001\t\u0007I\u0011B\"\u0002\u0019\u0005dGn\u0015;biN\u001c\u0016N_3\t\rI\u0003\u0001\u0015!\u0003+\u00035\tG\u000e\\*uCR\u001c8+\u001b>fA!9A\u000b\u0001b\u0001\n\u0013)\u0016\u0001C1mYN#\u0018\r^:\u0016\u0003Y\u00032\u0001\u0005\u0015X!\t\u0001\u0002,\u0003\u0002Z#\t1Ai\\;cY\u0016Daa\u0017\u0001!\u0002\u00131\u0016!C1mYN#\u0018\r^:!\u0011\u001di\u0006A1A\u0005\nU\u000b1\u0002]1sK:$8\u000b^1ug\"1q\f\u0001Q\u0001\nY\u000bA\u0002]1sK:$8\u000b^1ug\u0002BQ!\u0019\u0001\u0005\u0002\t\fQcZ3u\u00136\u0004XO]5us\u000e\u000bGnY;mCR|'\u000fF\u0002dM\"\u0004\"a\u000e3\n\u0005\u0015D$AE%naV\u0014\u0018\u000e^=DC2\u001cW\u000f\\1u_JDQa\u001a1A\u0002)\nQBZ3biV\u0014Xm\u00144gg\u0016$\b\"B5a\u0001\u0004Q\u0013\u0001\u00032j]&sG-\u001a=\t\u000b-\u0004A\u0011\u00017\u00027\u001d,G\u000fU1sK:$\u0018*\u001c9ve&$\u0018pQ1mGVd\u0017\r^8s)\u0005\u0019\u0007\"\u00028\u0001\t\u0003y\u0017AB;qI\u0006$X\rF\u0003qgV4\b\u0010\u0005\u0002\u0011c&\u0011!/\u0005\u0002\u0005+:LG\u000fC\u0003u[\u0002\u0007!&\u0001\u0007gK\u0006$XO]3J]\u0012,\u0007\u0010C\u0003j[\u0002\u0007!\u0006C\u0003x[\u0002\u0007q+A\u0003mC\n,G\u000eC\u0003z[\u0002\u0007q+\u0001\bj]N$\u0018M\\2f/\u0016Lw\r\u001b;\t\u000bm\u0004A\u0011\u0001?\u0002\u0019U\u0004H-\u0019;f!\u0006\u0014XM\u001c;\u0015\u0007Alh\u0010C\u0003xu\u0002\u0007q\u000bC\u0003zu\u0002\u0007q\u000bC\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u001b\u0019,\u0017\r^;sKV\u0003H-\u0019;f)%\u0001\u0018QAA\u0004\u0003\u0013\tY\u0001C\u0003h\u007f\u0002\u0007!\u0006C\u0003j\u007f\u0002\u0007!\u0006C\u0003x\u007f\u0002\u0007q\u000bC\u0003z\u007f\u0002\u0007q\u000bC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002!\u001d,GOR3biV\u0014Xm\u00144gg\u0016$Hc\u0001\u0016\u0002\u0014!1A/!\u0004A\u0002)Bq!a\u0006\u0001\t\u0003\tI\"A\bnKJ<WMR8s\r\u0016\fG/\u001e:f)\u001d\u0001\u00181DA\u000f\u0003?AaaZA\u000b\u0001\u0004Q\u0003BB5\u0002\u0016\u0001\u0007!\u0006C\u0004\u0002\"\u0005U\u0001\u0019\u0001\u0016\u0002\u001b=$\b.\u001a:CS:Le\u000eZ3y\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tQ!\\3sO\u0016$2\u0001MA\u0015\u0011\u001d\tY#a\tA\u0002A\nQa\u001c;iKJ\u0004")
public class DTStatsAggregator
implements scala.Serializable {
    private final DecisionTreeMetadata metadata;
    private final ImpurityAggregator impurityAggregator;
    private final int statsSize;
    private final int[] numBins;
    private final int[] featureOffsets;
    private final int allStatsSize;
    private final double[] allStats;
    private final double[] parentStats;

    public DecisionTreeMetadata metadata() {
        return this.metadata;
    }

    public ImpurityAggregator impurityAggregator() {
        return this.impurityAggregator;
    }

    private int statsSize() {
        return this.statsSize;
    }

    private int[] numBins() {
        return this.numBins;
    }

    private int[] featureOffsets() {
        return this.featureOffsets;
    }

    private int allStatsSize() {
        return this.allStatsSize;
    }

    private double[] allStats() {
        return this.allStats;
    }

    private double[] parentStats() {
        return this.parentStats;
    }

    public ImpurityCalculator getImpurityCalculator(int featureOffset, int binIndex) {
        return this.impurityAggregator().getCalculator(this.allStats(), featureOffset + binIndex * this.statsSize());
    }

    public ImpurityCalculator getParentImpurityCalculator() {
        return this.impurityAggregator().getCalculator(this.parentStats(), 0);
    }

    public void update(int featureIndex, int binIndex, double label, double instanceWeight) {
        int i = this.featureOffsets()[featureIndex] + binIndex * this.statsSize();
        this.impurityAggregator().update(this.allStats(), i, label, instanceWeight);
    }

    public void updateParent(double label, double instanceWeight) {
        this.impurityAggregator().update(this.parentStats(), 0, label, instanceWeight);
    }

    public void featureUpdate(int featureOffset, int binIndex, double label, double instanceWeight) {
        this.impurityAggregator().update(this.allStats(), featureOffset + binIndex * this.statsSize(), label, instanceWeight);
    }

    public int getFeatureOffset(int featureIndex) {
        return this.featureOffsets()[featureIndex];
    }

    public void mergeForFeature(int featureOffset, int binIndex, int otherBinIndex) {
        this.impurityAggregator().merge(this.allStats(), featureOffset + binIndex * this.statsSize(), featureOffset + otherBinIndex * this.statsSize());
    }

    public DTStatsAggregator merge(DTStatsAggregator other) {
        Predef$.MODULE$.require(this.allStatsSize() == other.allStatsSize(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("DTStatsAggregator.merge requires that both aggregators have the same length stats vectors.").append(new StringBuilder(50).append(" This aggregator is of length ").append(this.allStatsSize()).append(", but the other is ").append(other.allStatsSize()).append(".").toString()).toString());
        for (int i = 0; i < this.allStatsSize(); ++i) {
            int n = i;
            this.allStats()[n] = this.allStats()[n] + other.allStats()[i];
        }
        Predef$.MODULE$.require(this.statsSize() == other.statsSize(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("DTStatsAggregator.merge requires that both aggregators have the same length parent ").append(new StringBuilder(59).append("stats vectors. This aggregator's parent stats are length ").append(this.statsSize()).append(", ").toString()).append(new StringBuilder(18).append("but the other is ").append(other.statsSize()).append(".").toString()).toString());
        for (int j = 0; j < this.statsSize(); ++j) {
            int n = j;
            this.parentStats()[n] = this.parentStats()[n] + other.parentStats()[j];
        }
        return this;
    }

    public DTStatsAggregator(DecisionTreeMetadata metadata, Option<int[]> featureSubset) {
        ImpurityAggregator impurityAggregator;
        this.metadata = metadata;
        Impurity impurity = metadata.impurity();
        if (Gini$.MODULE$.equals(impurity)) {
            impurityAggregator = new GiniAggregator(metadata.numClasses());
        } else if (Entropy$.MODULE$.equals(impurity)) {
            impurityAggregator = new EntropyAggregator(metadata.numClasses());
        } else if (Variance$.MODULE$.equals(impurity)) {
            impurityAggregator = new VarianceAggregator();
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Bad impurity parameter: ").append(metadata.impurity()).toString());
        }
        this.impurityAggregator = impurityAggregator;
        this.statsSize = this.impurityAggregator().statsSize();
        this.numBins = featureSubset.isDefined() ? (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])featureSubset.get())).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> this.metadata().numBins()[x$1], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())) : metadata.numBins();
        this.featureOffsets = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.numBins())).scanLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(total, nBins) -> total + this.statsSize() * nBins, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.allStatsSize = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.featureOffsets())).last());
        this.allStats = new double[this.allStatsSize()];
        this.parentStats = new double[this.statsSize()];
    }
}

