/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3Q!\u0001\u0002\u0001\u00119\u00111\u0002V5nKR\u0013\u0018mY6fe*\u00111\u0001B\u0001\u0005S6\u0004HN\u0003\u0002\u0006\r\u0005!AO]3f\u0015\t9\u0001\"\u0001\u0002nY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\t\u0017\u0013\t9\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001a\u0001\u0011\u00051$\u0001\u0004=S:LGOP\u0002\u0001)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001bB\u0010\u0001\u0005\u0004%I\u0001I\u0001\u0007gR\f'\u000f^:\u0016\u0003\u0005\u0002BAI\u0014*i5\t1E\u0003\u0002%K\u00059Q.\u001e;bE2,'B\u0001\u0014\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Q\r\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002+c9\u00111f\f\t\u0003YEi\u0011!\f\u0006\u0003]i\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\n\u0002C\u0001\t6\u0013\t1\u0014C\u0001\u0003M_:<\u0007B\u0002\u001d\u0001A\u0003%\u0011%A\u0004ti\u0006\u0014Ho\u001d\u0011\t\u000fi\u0002!\u0019!C\u0005A\u00051Ao\u001c;bYNDa\u0001\u0010\u0001!\u0002\u0013\t\u0013a\u0002;pi\u0006d7\u000f\t\u0005\u0006}\u0001!\taP\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0001\u000e\u0003\"\u0001E!\n\u0005\t\u000b\"\u0001B+oSRDQ\u0001R\u001fA\u0002%\n!\u0002^5nKJd\u0015MY3m\u0011\u00151\u0005\u0001\"\u0001H\u0003\u0011\u0019Ho\u001c9\u0015\u0005![\u0005C\u0001\tJ\u0013\tQ\u0015C\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\t\u0016\u0003\r!\u000b\u0005\u0006\u001b\u0002!\tET\u0001\ti>\u001cFO]5oOR\t\u0011\u0006")
public class TimeTracker
implements Serializable {
    private final HashMap<String, Object> starts = new HashMap();
    private final HashMap<String, Object> totals = new HashMap();

    private HashMap<String, Object> starts() {
        return this.starts;
    }

    private HashMap<String, Object> totals() {
        return this.totals;
    }

    public void start(String timerLabel) {
        long currentTime = System.nanoTime();
        if (this.starts().contains((Object)timerLabel)) {
            throw new RuntimeException(new StringBuilder(45).append("TimeTracker.start(timerLabel) called again on").append(new StringBuilder(45).append(" timerLabel = ").append(timerLabel).append(" before that timer was stopped.").toString()).toString());
        }
        this.starts().update((Object)timerLabel, (Object)BoxesRunTime.boxToLong((long)currentTime));
    }

    public double stop(String timerLabel) {
        long currentTime = System.nanoTime();
        if (!this.starts().contains((Object)timerLabel)) {
            throw new RuntimeException(new StringBuilder(38).append("TimeTracker.stop(timerLabel) called on").append(new StringBuilder(47).append(" timerLabel = ").append(timerLabel).append(", but that timer was not started.").toString()).toString());
        }
        long elapsed = currentTime - BoxesRunTime.unboxToLong((Object)this.starts().apply((Object)timerLabel));
        this.starts().remove((Object)timerLabel);
        if (this.totals().contains((Object)timerLabel)) {
            this.totals().update((Object)timerLabel, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.totals().apply((Object)timerLabel)) + elapsed)));
        } else {
            this.totals().update((Object)timerLabel, (Object)BoxesRunTime.boxToLong((long)elapsed));
        }
        return (double)elapsed / 1.0E9;
    }

    public String toString() {
        return ((TraversableOnce)this.totals().map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String label = (String)tuple2._1();
            long elapsed = tuple2._2$mcJ$sp();
            String string = new StringBuilder(4).append("  ").append(label).append(": ").append((double)elapsed / 1.0E9).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }
}

