/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.PMMLExportable;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.util.Saveable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0019\u0001a\u0002\u0006\r\u001fIA\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u000be\u0016<'/Z:tS>t\u0017BA\n\u0011\u0005Y9UM\\3sC2L'0\u001a3MS:,\u0017M]'pI\u0016d\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005M\u0019E.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f!\ty\"%D\u0001!\u0015\t\tC!\u0001\u0003vi&d\u0017BA\u0012!\u0005!\u0019\u0016M^3bE2,\u0007CA\u0013)\u001b\u00051#BA\u0014\u0005\u0003\u0011\u0001X.\u001c7\n\u0005%2#A\u0004)N\u001b2+\u0005\u0010]8si\u0006\u0014G.\u001a\u0005\tW\u0001\u0011)\u0019!C!Y\u00059q/Z5hQR\u001cX#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0011A\u00027j]\u0006dw-\u0003\u00023_\t1a+Z2u_JD3A\u000b\u001b;!\t)\u0004(D\u00017\u0015\t9d!\u0001\u0006b]:|G/\u0019;j_:L!!\u000f\u001c\u0003\u000bMKgnY3\"\u0003m\nQ!\r\u00181]AB\u0011\"\u0010\u0001\u0003\u0002\u0003\u0006I!\f \u0002\u0011],\u0017n\u001a5ug\u0002J!a\u000b\n)\u0007q\"$\b\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0011C\u0003%Ig\u000e^3sG\u0016\u0004H/F\u0001D!\tIB)\u0003\u0002F5\t1Ai\\;cY\u0016D3\u0001\u0011\u001b;\u0011%A\u0005A!A!\u0002\u0013\u0019\u0015*\u0001\u0006j]R,'oY3qi\u0002J!!\u0011\n)\u0007\u001d#$\b\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001N\u0003-qW/\u001c$fCR,(/Z:\u0016\u00039\u0003\"!G(\n\u0005AS\"aA%oi\"\u001a1\n\u000e*\"\u0003M\u000bQ!\r\u00184]AB\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IAT\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0015\u0004)R\u0012\u0006\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011A'\u0002\u00159,Xn\u00117bgN,7\u000fK\u0002XiIC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006IAT\u0001\f]Vl7\t\\1tg\u0016\u001c\b\u0005K\u0002[iICQA\u0018\u0001\u0005\u0002}\u000ba\u0001P5oSRtD#\u00021bG\u0016<\u0007CA\u000b\u0001\u0011\u0015YS\f1\u0001.Q\r\tGG\u000f\u0005\u0006\u0003v\u0003\ra\u0011\u0015\u0004GRR\u0004\"\u0002'^\u0001\u0004q\u0005fA35%\")\u0001,\u0018a\u0001\u001d\"\u001aq\r\u000e*)\u0007u#$\u000bC\u0004l\u0001\t\u0007I\u0011B'\u0002!\u0011\fG/Y,ji\"\u0014\u0015.Y:TSj,\u0007BB7\u0001A\u0003%a*A\teCR\fw+\u001b;i\u0005&\f7oU5{K\u0002Bqa\u001c\u0001C\u0002\u0013%\u0001/\u0001\u0007xK&<\u0007\u000e^:BeJ\f\u00170F\u0001r!\rI\"oQ\u0005\u0003gj\u0011Q!\u0011:sCfDa!\u001e\u0001!\u0002\u0013\t\u0018!D<fS\u001eDGo]!se\u0006L\b\u0005C\u0003_\u0001\u0011\u0005q\u000fF\u0002aqfDQa\u000b<A\u00025BQ!\u0011<A\u0002\rC3A\u001e\u001b;\u0011\u001da\b\u00011A\u0005\nu\f\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0016\u0003y\u00042!G@D\u0013\r\t\tA\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\u0015\u0001\u00011A\u0005\n\u0005\u001d\u0011!\u0004;ie\u0016\u001c\bn\u001c7e?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005=\u0001cA\r\u0002\f%\u0019\u0011Q\u0002\u000e\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#\t\u0019!!AA\u0002y\f1\u0001\u001f\u00132\u0011\u001d\t)\u0002\u0001Q!\ny\f!\u0002\u001e5sKNDw\u000e\u001c3!\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tAb]3u)\"\u0014Xm\u001d5pY\u0012$B!!\b\u0002 5\t\u0001\u0001\u0003\u0004}\u0003/\u0001\ra\u0011\u0015\u0005\u0003/!$\b\u0003\u0004\u0002&\u0001!\t!`\u0001\rO\u0016$H\u000b\u001b:fg\"|G\u000e\u001a\u0015\u0005\u0003G!$\u000bC\u0004\u0002,\u0001!\t!!\f\u0002\u001d\rdW-\u0019:UQJ,7\u000f[8mIR\u0011\u0011Q\u0004\u0015\u0005\u0003S!$\bC\u0004\u00024\u0001!\t&!\u000e\u0002\u0019A\u0014X\rZ5diB{\u0017N\u001c;\u0015\u000f\r\u000b9$a\u000f\u0002@!9\u0011\u0011HA\u0019\u0001\u0004i\u0013A\u00033bi\u0006l\u0015\r\u001e:jq\"9\u0011QHA\u0019\u0001\u0004i\u0013\u0001D<fS\u001eDG/T1ue&D\bBB!\u00022\u0001\u00071\tC\u0004\u0002D\u0001!\t%!\u0012\u0002\tM\fg/\u001a\u000b\u0007\u0003\u0013\t9%a\u0015\t\u0011\u0005%\u0013\u0011\ta\u0001\u0003\u0017\n!a]2\u0011\t\u00055\u0013qJ\u0007\u0002\r%\u0019\u0011\u0011\u000b\u0004\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u0005U\u0013\u0011\ta\u0001\u0003/\nA\u0001]1uQB!\u0011\u0011LA4\u001d\u0011\tY&a\u0019\u0011\u0007\u0005u#$\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u0007\u0002\rq\u0012xn\u001c;?\u0013\r\t)GG\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00141\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015$\u0004\u000b\u0003\u0002BQ\u0012\u0006bBA9\u0001\u0011E\u00131O\u0001\u000eM>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005]\u0003bBA<\u0001\u0011\u0005\u0013\u0011P\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u000b\u0015\u0005\u0001Q\ni(\t\u0002\u0002\u0000\u0005)\u0001G\f\u001d/a\u001d9\u00111\u0011\u0002\t\u0002\u0005\u0015\u0015a\u0006'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\r)\u0012q\u0011\u0004\u0007\u0003\tA\t!!#\u0014\u000f\u0005\u001d\u00151RAI1A\u0019\u0011$!$\n\u0007\u0005=%D\u0001\u0004B]f\u0014VM\u001a\t\u0005?\u0005M\u0005-C\u0002\u0002\u0016\u0002\u0012a\u0001T8bI\u0016\u0014\bb\u00020\u0002\b\u0012\u0005\u0011\u0011\u0014\u000b\u0003\u0003\u000bC\u0001\"!(\u0002\b\u0012\u0005\u0013qT\u0001\u0005Y>\fG\rF\u0003a\u0003C\u000b\u0019\u000b\u0003\u0005\u0002J\u0005m\u0005\u0019AA&\u0011!\t)&a'A\u0002\u0005]\u0003\u0006BANiIC!\"!+\u0002\b\u0006\u0005I\u0011BAV\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0006\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\u0005Y\u0006twM\u0003\u0002\u00028\u0006!!.\u0019<b\u0013\u0011\tY,!-\u0003\r=\u0013'.Z2uQ\u0011\t9\t\u000e*)\t\u0005\u0005EG\u0015")
public class LogisticRegressionModel
extends GeneralizedLinearModel
implements ClassificationModel,
Saveable,
PMMLExportable {
    private final int numFeatures;
    private final int numClasses;
    private final int dataWithBiasSize;
    private final double[] weightsArray;
    private Option<Object> threshold;

    public static /* bridge */ Saveable load(SparkContext sparkContext, String string) {
        return LogisticRegressionModel$.MODULE$.load(sparkContext, string);
    }

    public static LogisticRegressionModel load(SparkContext sparkContext, String string) {
        return LogisticRegressionModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public void toPMML(String localPath) {
        PMMLExportable.toPMML$((PMMLExportable)this, localPath);
    }

    @Override
    public void toPMML(SparkContext sc, String path) {
        PMMLExportable.toPMML$(this, sc, path);
    }

    @Override
    public void toPMML(OutputStream outputStream) {
        PMMLExportable.toPMML$((PMMLExportable)this, outputStream);
    }

    @Override
    public String toPMML() {
        return PMMLExportable.toPMML$(this);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel.predict$(this, testData);
    }

    @Override
    public Vector weights() {
        return super.weights();
    }

    @Override
    public double intercept() {
        return super.intercept();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public int numClasses() {
        return this.numClasses;
    }

    private int dataWithBiasSize() {
        return this.dataWithBiasSize;
    }

    private double[] weightsArray() {
        return this.weightsArray;
    }

    private Option<Object> threshold() {
        return this.threshold;
    }

    private void threshold_$eq(Option<Object> x$1) {
        this.threshold = x$1;
    }

    public LogisticRegressionModel setThreshold(double threshold) {
        this.threshold_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)threshold)));
        return this;
    }

    public Option<Object> getThreshold() {
        return this.threshold();
    }

    public LogisticRegressionModel clearThreshold() {
        this.threshold_$eq((Option<Object>)None$.MODULE$);
        return this;
    }

    @Override
    public double predictPoint(Vector dataMatrix, Vector weightMatrix, double intercept) {
        double d;
        Predef$.MODULE$.require(dataMatrix.size() == this.numFeatures());
        if (this.numClasses() == 2) {
            double d2;
            double margin = BLAS$.MODULE$.dot(weightMatrix, dataMatrix) + intercept;
            double score = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
            Option<Object> option = this.threshold();
            if (option instanceof Some) {
                Some some = (Some)option;
                double t = BoxesRunTime.unboxToDouble((Object)some.value());
                d2 = score > t ? 1.0 : 0.0;
            } else if (None$.MODULE$.equals(option)) {
                d2 = score;
            } else {
                throw new MatchError(option);
            }
            d = d2;
        } else {
            IntRef bestClass = IntRef.create((int)0);
            DoubleRef maxMargin = DoubleRef.create((double)0.0);
            boolean withBias = dataMatrix.size() + 1 == this.dataWithBiasSize();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numClasses() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block1: {
                    DoubleRef margin = DoubleRef.create((double)0.0);
                    dataMatrix.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
                        block0: {
                            if (value == 0.0) break block0;
                            margin$1.elem += value * this.weightsArray()[i * this.dataWithBiasSize() + index];
                        }
                    });
                    if (withBias) {
                        margin.elem += this.weightsArray()[i * this.dataWithBiasSize() + dataMatrix.size()];
                    }
                    if (!(margin.elem > maxMargin$1.elem)) break block1;
                    maxMargin$1.elem = margin.elem;
                    bestClass$1.elem = i + 1;
                }
            });
            d = bestClass.elem;
        }
        return d;
    }

    @Override
    public void save(SparkContext sc, String path) {
        GLMClassificationModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getClass().getName(), this.numFeatures(), this.numClasses(), this.weights(), this.intercept(), this.threshold());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public String toString() {
        return new StringBuilder(29).append(super.toString()).append(", numClasses = ").append(this.numClasses()).append(", threshold = ").append(this.threshold().getOrElse((Function0 & Serializable & scala.Serializable)() -> "None")).toString();
    }

    public LogisticRegressionModel(Vector weights, double intercept, int numFeatures, int numClasses) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        super(weights, intercept);
        ClassificationModel.$init$(this);
        PMMLExportable.$init$(this);
        if (numClasses == 2) {
            Predef$.MODULE$.require(weights.size() == numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("LogisticRegressionModel with numClasses = 2 was given non-matching values:").append(new StringBuilder(36).append(" numFeatures = ").append(this.numFeatures()).append(", but weights.size = ").append(this.weights().size()).toString()).toString());
        } else {
            int weightsSizeWithoutIntercept = (numClasses - 1) * numFeatures;
            int weightsSizeWithIntercept = (numClasses - 1) * (numFeatures + 1);
            Predef$.MODULE$.require(weights.size() == weightsSizeWithoutIntercept || weights.size() == weightsSizeWithIntercept, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("LogisticRegressionModel.load with numClasses = ").append(this.numClasses()).append(" and numFeatures = ").append(this.numFeatures()).append(new StringBuilder(48).append(" expected weights of length ").append(weightsSizeWithoutIntercept).append(" (without intercept)").toString()).append(new StringBuilder(22).append(" or ").append(weightsSizeWithIntercept).append(" (with intercept),").toString()).append(new StringBuilder(33).append(" but was given weights of length ").append(this.weights().size()).toString()).toString());
        }
        this.dataWithBiasSize = weights.size() / (numClasses - 1);
        Vector vector = weights;
        if (!(vector instanceof DenseVector)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("weights only supports dense vector but got type ").append(weights.getClass()).append(".").toString());
        }
        DenseVector denseVector = (DenseVector)vector;
        double[] dArray = denseVector.values();
        this.weightsArray = dArray;
        this.threshold = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
    }

    public LogisticRegressionModel(Vector weights, double intercept) {
        this(weights, intercept, weights.size(), 2);
    }
}

