/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u00015\u0011!BT1jm\u0016\u0014\u0015-_3t\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001H\r\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001BA\u0002\u0013%q$\u0001\u0004mC6\u0014G-Y\u000b\u0002AA\u0011q\"I\u0005\u0003EA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0007I\u0011B\u0013\u0002\u00151\fWN\u00193b?\u0012*\u0017\u000f\u0006\u0002'SA\u0011qbJ\u0005\u0003QA\u0011A!\u00168ji\"9!fIA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!AA\u0006\u0001B\u0001B\u0003&\u0001%A\u0004mC6\u0014G-\u0019\u0011\t\u00119\u0002!\u00111A\u0005\n=\n\u0011\"\\8eK2$\u0016\u0010]3\u0016\u0003A\u0002\"!\r\u001d\u000f\u0005I2\u0004CA\u001a\u0011\u001b\u0005!$BA\u001b\r\u0003\u0019a$o\\8u}%\u0011q\u0007E\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028!!AA\b\u0001BA\u0002\u0013%Q(A\u0007n_\u0012,G\u000eV=qK~#S-\u001d\u000b\u0003MyBqAK\u001e\u0002\u0002\u0003\u0007\u0001\u0007\u0003\u0005A\u0001\t\u0005\t\u0015)\u00031\u0003)iw\u000eZ3m)f\u0004X\r\t\u0005\u0006\u0005\u0002!IaQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u00113u\t\u0005\u0002F\u00015\t!\u0001C\u0003\u001f\u0003\u0002\u0007\u0001\u0005C\u0003/\u0003\u0002\u0007\u0001\u0007C\u0003C\u0001\u0011\u0005\u0011\n\u0006\u0002E\u0015\")a\u0004\u0013a\u0001A!\u001a\u0001\n\u0014*\u0011\u00055\u0003V\"\u0001(\u000b\u0005=3\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011K\u0014\u0002\u0006'&t7-Z\u0011\u0002'\u0006)\u0011G\f\u001b/a!)!\t\u0001C\u0001+R\tA\tK\u0002U\u0019^\u000b\u0013\u0001W\u0001\u0006a9Jd\u0006\r\u0005\u00065\u0002!\taW\u0001\ng\u0016$H*Y7cI\u0006$\"\u0001\u0012/\t\u000byI\u0006\u0019\u0001\u0011)\u0007ecu\u000bC\u0003`\u0001\u0011\u0005q$A\u0005hKRd\u0015-\u001c2eC\"\u001aa\f\u0014*\t\u000b\t\u0004A\u0011A2\u0002\u0019M,G/T8eK2$\u0016\u0010]3\u0015\u0005\u0011#\u0007\"\u0002\u0018b\u0001\u0004\u0001\u0004fA1M%\")q\r\u0001C\u0001_\u0005aq-\u001a;N_\u0012,G\u000eV=qK\"\u001aa\r\u0014*\t\u000b)\u0004A\u0011A6\u0002\u0007I,h\u000e\u0006\u0002m_B\u0011Q)\\\u0005\u0003]\n\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0005\u0006a&\u0004\r!]\u0001\u0005I\u0006$\u0018\rE\u0002sk^l\u0011a\u001d\u0006\u0003i\u001a\t1A\u001d3e\u0013\t18OA\u0002S\t\u0012\u0003\"\u0001_>\u000e\u0003eT!A\u001f\u0003\u0002\u0015I,wM]3tg&|g.\u0003\u0002}s\naA*\u00192fY\u0016$\u0007k\\5oi\"\u001a\u0011\u000eT,)\u0007\u0001aukB\u0004\u0002\u0002\tA\t!a\u0001\u0002\u00159\u000b\u0017N^3CCf,7\u000fE\u0002F\u0003\u000b1a!\u0001\u0002\t\u0002\u0005\u001d1\u0003BA\u0003\u001dQAqAQA\u0003\t\u0003\tY\u0001\u0006\u0002\u0002\u0004!Q\u0011qBA\u0003\u0005\u0004%\tAA\u0018\u0002\u00175+H\u000e^5o_6L\u0017\r\u001c\u0005\t\u0003'\t)\u0001)A\u0005a\u0005aQ*\u001e7uS:|W.[1mA!Q\u0011qCA\u0003\u0005\u0004%\tAA\u0018\u0002\u0013\t+'O\\8vY2L\u0007\u0002CA\u000e\u0003\u000b\u0001\u000b\u0011\u0002\u0019\u0002\u0015\t+'O\\8vY2L\u0007\u0005C\u0006\u0002 \u0005\u0015!\u0019!C\u0001\u0005\u0005\u0005\u0012aE:vaB|'\u000f^3e\u001b>$W\r\u001c+za\u0016\u001cXCAA\u0012!\u0015\t)#a\f1\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012!C5n[V$\u0018M\u00197f\u0015\r\ti\u0003E\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0019\u0003O\u00111aU3u\u0011%\t)$!\u0002!\u0002\u0013\t\u0019#\u0001\u000btkB\u0004xN\u001d;fI6{G-\u001a7UsB,7\u000f\t\u0005\t\u0003s\t)\u0001\"\u0001\u0002<\u0005)AO]1j]R\u0019A.!\u0010\t\u000f\u0005}\u0012q\u0007a\u0001c\u0006)\u0011N\u001c9vi\"\"\u0011q\u0007'X\u0011!\tI$!\u0002\u0005\u0002\u0005\u0015C#\u00027\u0002H\u0005%\u0003bBA \u0003\u0007\u0002\r!\u001d\u0005\u0007=\u0005\r\u0003\u0019\u0001\u0011)\t\u0005\rCj\u0016\u0005\t\u0003s\t)\u0001\"\u0001\u0002PQ9A.!\u0015\u0002T\u0005U\u0003bBA \u0003\u001b\u0002\r!\u001d\u0005\u0007=\u00055\u0003\u0019\u0001\u0011\t\r9\ni\u00051\u00011Q\u0011\ti\u0005\u0014*\t\u0015\u0005m\u0013QAA\u0001\n\u0013\ti&A\u0006sK\u0006$'+Z:pYZ,GCAA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nA\u0001\\1oO*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002n\u0005\r$AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002\u00061;\u0006fA@M/\u0002")
public class NaiveBayes
implements scala.Serializable,
Logging {
    private double lambda;
    private String modelType;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d, String string) {
        return NaiveBayes$.MODULE$.train(rDD, d, string);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d) {
        return NaiveBayes$.MODULE$.train(rDD, d);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD) {
        return NaiveBayes$.MODULE$.train(rDD);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private double lambda() {
        return this.lambda;
    }

    private void lambda_$eq(double x$1) {
        this.lambda = x$1;
    }

    private String modelType() {
        return this.modelType;
    }

    private void modelType_$eq(String x$1) {
        this.modelType = x$1;
    }

    public NaiveBayes setLambda(double lambda) {
        Predef$.MODULE$.require(lambda >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Smoothing parameter must be nonnegative but got ").append(lambda).toString());
        this.lambda_$eq(lambda);
        return this;
    }

    public double getLambda() {
        return this.lambda();
    }

    public NaiveBayes setModelType(String modelType) {
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("NaiveBayes was created with an unknown modelType: ").append(modelType).append(".").toString());
        this.modelType_$eq(modelType);
        return this;
    }

    public String getModelType() {
        return this.modelType();
    }

    public NaiveBayesModel run(RDD<LabeledPoint> data) {
        public final class Org_apache_spark_mllib_classification_NaiveBayes$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_mllib_classification_NaiveBayes$$typecreator9$1(NaiveBayes $outer) {
            }
        }
        SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(data.context()).getOrCreate();
        org.apache.spark.ml.classification.NaiveBayes nb = new org.apache.spark.ml.classification.NaiveBayes().setModelType(this.modelType()).setSmoothing(this.lambda());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        Dataset dataset = spark.implicits().rddToDatasetHolder(data.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint == null) {
                throw new MatchError((Object)labeledPoint);
            }
            double label = labeledPoint.label();
            Vector features = labeledPoint.features();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)label), (Object)features.asML());
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_classification_NaiveBayes$$typecreator9$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"}));
        org.apache.spark.ml.classification.NaiveBayesModel newModel = nb.trainWithLabelCheck(dataset, false);
        double[] pi = newModel.pi().toArray();
        double[][] theta = (double[][])Array$.MODULE$.fill(newModel.numClasses(), newModel.numFeatures(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        newModel.theta().foreachActive((Function3 & Serializable & scala.Serializable)(x0$2, x1$1, x2$1) -> {
            NaiveBayes.$anonfun$run$3(theta, BoxesRunTime.unboxToInt((Object)x0$2), BoxesRunTime.unboxToInt((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(newModel.oldLabels() != null, (Function0 & Serializable & scala.Serializable)() -> "The underlying ML NaiveBayes training does not produce labels.");
        return new NaiveBayesModel(newModel.oldLabels(), pi, theta, this.modelType());
    }

    public static final /* synthetic */ void $anonfun$run$3(double[][] theta$1, int x0$2, int x1$1, double x2$1) {
        double v;
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        theta$1[i][j] = v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public NaiveBayes(double lambda, String modelType) {
        this.lambda = lambda;
        this.modelType = modelType;
        Logging.$init$((Logging)this);
    }

    public NaiveBayes(double lambda) {
        this(lambda, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayes() {
        this(1.0, NaiveBayes$.MODULE$.Multinomial());
    }
}

