/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.classification.NaiveBayesModel$SaveLoadV2_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\ref\u0001B\u0001\u0003\u00015\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qA\u0003G\u000e\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\nDY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u00103%\u0011!\u0004\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00039}i\u0011!\b\u0006\u0003=\u0011\tA!\u001e;jY&\u0011\u0001%\b\u0002\t'\u00064X-\u00192mK\"A!\u0005\u0001BC\u0002\u0013\u00051%\u0001\u0004mC\n,Gn]\u000b\u0002IA\u0019q\"J\u0014\n\u0005\u0019\u0002\"!B!se\u0006L\bCA\b)\u0013\tI\u0003C\u0001\u0004E_V\u0014G.\u001a\u0015\u0004C-\n\u0004C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003a5\u0012QaU5oG\u0016\f\u0013AM\u0001\u0006c9\u0002d\u0006\r\u0005\ti\u0001\u0011\t\u0011)A\u0005I\u00059A.\u00192fYN\u0004\u0003fA\u001a,c!Aq\u0007\u0001BC\u0002\u0013\u00051%\u0001\u0002qS\"\u001aagK\u001d\"\u0003i\nQ\u0001\r\u0018:]AB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0004a&\u0004\u0003fA\u001e,s!Aq\b\u0001BC\u0002\u0013\u0005\u0001)A\u0003uQ\u0016$\u0018-F\u0001B!\ryQ\u0005\n\u0015\u0004}-J\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\rQDW\r^1!Q\r\u00195&\u000f\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\u0006IQn\u001c3fYRK\b/Z\u000b\u0002\u0013B\u0011!*\u0015\b\u0003\u0017>\u0003\"\u0001\u0014\t\u000e\u00035S!A\u0014\u0007\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0006#\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)\u0011Q\r15&V\u0011\u0002-\u0006)\u0011G\f\u001b/a!A\u0001\f\u0001B\u0001B\u0003%\u0011*\u0001\u0006n_\u0012,G\u000eV=qK\u0002B3aV\u0016V\u0011\u0019Y\u0006\u0001\"\u0001\u00079\u00061A(\u001b8jiz\"R!\u00180aE\u0012\u0004\"!\u0006\u0001\t\u000b\tR\u0006\u0019\u0001\u0013)\u0007y[\u0013\u0007C\u000385\u0002\u0007A\u0005K\u0002aWeBQa\u0010.A\u0002\u0005C3AY\u0016:\u0011\u00159%\f1\u0001JQ\r!7&\u0016\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0003!\u0001\u0018NV3di>\u0014X#A5\u0011\u0005)lW\"A6\u000b\u00051$\u0011A\u00027j]\u0006dw-\u0003\u0002oW\nYA)\u001a8tKZ+7\r^8s\u0011\u0019\u0001\b\u0001)A\u0005S\u0006I\u0001/\u001b,fGR|'\u000f\t\u0005\be\u0002\u0011\r\u0011\"\u0003t\u0003-!\b.\u001a;b\u001b\u0006$(/\u001b=\u0016\u0003Q\u0004\"A[;\n\u0005Y\\'a\u0003#f]N,W*\u0019;sSbDa\u0001\u001f\u0001!\u0002\u0013!\u0018\u0001\u0004;iKR\fW*\u0019;sSb\u0004\u0003BB.\u0001\t\u0003!!\u0010\u0006\u0003^wrl\b\"\u0002\u0012z\u0001\u0004!\u0003\"B\u001cz\u0001\u0004!\u0003\"B z\u0001\u0004\t\u0005BB.\u0001\t\u0003!q\u0010F\u0004^\u0003\u0003\t\u0019\"!\u0006\t\r\tr\b\u0019AA\u0002!\u0015\t)!a\u0004(\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00027b]\u001eT!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t9A\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u00199d\u00101\u0001\u0002\u0004!1qH a\u0001\u0003/\u0001b!!\u0002\u0002\u0010\u0005\r\u0001\u0002DA\u000e\u0001A\u0005\t1!Q\u0001\n\u0005u\u0011a\u0001=%eA9q\"a\b\u0002$\u0005%\u0012bAA\u0011!\t1A+\u001e9mKJ\u0002BaDA\u0013i&\u0019\u0011q\u0005\t\u0003\r=\u0003H/[8o!\u0011y\u0011QE5\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012A\u0005;iKR\fW*\u001b8vg:+w\r\u00165fi\u0006,\"!a\t\t\u0011\u0005M\u0002\u0001)A\u0005\u0003G\t1\u0003\u001e5fi\u0006l\u0015N\\;t\u001d\u0016<G\u000b[3uC\u0002B\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\u0002\u00179,w\r\u00165fi\u0006\u001cV/\\\u000b\u0003\u0003SA\u0001\"!\u0010\u0001A\u0003%\u0011\u0011F\u0001\r]\u0016<G\u000b[3uCN+X\u000e\t\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0003\u001d\u0001(/\u001a3jGR$B!!\u0012\u0002RA)\u0011qIA'O5\u0011\u0011\u0011\n\u0006\u0004\u0003\u00172\u0011a\u0001:eI&!\u0011qJA%\u0005\r\u0011F\t\u0012\u0005\t\u0003'\ny\u00041\u0001\u0002V\u0005AA/Z:u\t\u0006$\u0018\r\u0005\u0004\u0002H\u00055\u0013q\u000b\t\u0004U\u0006e\u0013bAA.W\n1a+Z2u_JDC!a\u0010,c!9\u0011\u0011\t\u0001\u0005B\u0005\u0005DcA\u0014\u0002d!A\u00111KA0\u0001\u0004\t9\u0006\u000b\u0003\u0002`-\n\u0004bBA5\u0001\u0011\u0005\u00111N\u0001\u0015aJ,G-[2u!J|'-\u00192jY&$\u0018.Z:\u0015\t\u0005U\u0013Q\u000e\u0005\t\u0003'\n9\u00071\u0001\u0002V!*\u0011qM\u0016\u0002r\u0005\u0012\u00111O\u0001\u0006c9*d\u0006\r\u0005\b\u0003S\u0002A\u0011AA<)\u0011\t9&!\u001f\t\u0011\u0005M\u0013Q\u000fa\u0001\u0003/BS!!\u001e,\u0003cBq!a \u0001\t\u0013\t\t)\u0001\fnk2$\u0018N\\8nS\u0006d7)\u00197dk2\fG/[8o)\rI\u00171\u0011\u0005\t\u0003'\ni\b1\u0001\u0002X!9\u0011q\u0011\u0001\u0005\n\u0005%\u0015\u0001\u00062fe:|W\u000f\u001c7j\u0007\u0006d7-\u001e7bi&|g\u000eF\u0002j\u0003\u0017C\u0001\"a\u0015\u0002\u0006\u0002\u0007\u0011q\u000b\u0005\b\u0003\u001f\u0003A\u0011BAI\u0003Y\u0001xn\u001d;fe&|'\u000f\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHcA5\u0002\u0014\"9\u0011QSAG\u0001\u0004I\u0017a\u00027pOB\u0013xN\u0019\u0005\b\u00033\u0003A\u0011IAN\u0003\u0011\u0019\u0018M^3\u0015\r\u0005u\u00151UAX!\ry\u0011qT\u0005\u0004\u0003C\u0003\"\u0001B+oSRD\u0001\"!*\u0002\u0018\u0002\u0007\u0011qU\u0001\u0003g\u000e\u0004B!!+\u0002,6\ta!C\u0002\u0002.\u001a\u0011Ab\u00159be.\u001cuN\u001c;fqRDq!!-\u0002\u0018\u0002\u0007\u0011*\u0001\u0003qCRD\u0007&BALW\u0005U\u0016EAA\\\u0003\u0015\tdf\r\u00181\u0011\u0019\tY\f\u0001C)\u0011\u0006iam\u001c:nCR4VM]:j_:D3\u0001A\u0016:\u000f\u001d\t\tM\u0001E\u0001\u0003\u0007\fqBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\t\u0004+\u0005\u0015gAB\u0001\u0003\u0011\u0003\t9m\u0005\u0004\u0002F:\tI\r\u0007\t\u00059\u0005-W,C\u0002\u0002Nv\u0011a\u0001T8bI\u0016\u0014\bbB.\u0002F\u0012\u0005\u0011\u0011\u001b\u000b\u0003\u0003\u0007<\u0011\"!6\u0002F\"\u0005A!a6\u0002\u0019M\u000bg/\u001a'pC\u00124&g\u0018\u0019\u0011\t\u0005e\u00171\\\u0007\u0003\u0003\u000b4\u0011\"!8\u0002F\"\u0005A!a8\u0003\u0019M\u000bg/\u001a'pC\u00124&g\u0018\u0019\u0014\u0007\u0005mg\u0002C\u0004\\\u00037$\t!a9\u0015\u0005\u0005]\u0007bBAt\u00037$\t\u0001S\u0001\u0012i\"L7OR8s[\u0006$h+\u001a:tS>t\u0007bBAv\u00037$\t\u0001S\u0001\u000ei\"L7o\u00117bgNt\u0015-\\3\u0007\u000f\u0005=\u00181\u001c!\u0002r\n!A)\u0019;b'\u0019\tiODAz1A\u0019q\"!>\n\u0007\u0005]\bCA\u0004Qe>$Wo\u0019;\t\u0013\t\niO!f\u0001\n\u0003\u0019\u0003\"\u0003\u001b\u0002n\nE\t\u0015!\u0003%\u0011%9\u0014Q\u001eBK\u0002\u0013\u00051\u0005C\u0005=\u0003[\u0014\t\u0012)A\u0005I!Iq(!<\u0003\u0016\u0004%\t\u0001\u0011\u0005\n\t\u00065(\u0011#Q\u0001\n\u0005C\u0011bRAw\u0005+\u0007I\u0011\u0001%\t\u0013a\u000biO!E!\u0002\u0013I\u0005bB.\u0002n\u0012\u0005!1\u0002\u000b\u000b\u0005\u001b\u0011\tBa\u0005\u0003\u0016\t]\u0001\u0003\u0002B\b\u0003[l!!a7\t\r\t\u0012I\u00011\u0001%\u0011\u00199$\u0011\u0002a\u0001I!1qH!\u0003A\u0002\u0005Caa\u0012B\u0005\u0001\u0004I\u0005B\u0003B\u000e\u0003[\f\t\u0011\"\u0001\u0003\u001e\u0005!1m\u001c9z))\u0011iAa\b\u0003\"\t\r\"Q\u0005\u0005\tE\te\u0001\u0013!a\u0001I!AqG!\u0007\u0011\u0002\u0003\u0007A\u0005\u0003\u0005@\u00053\u0001\n\u00111\u0001B\u0011!9%\u0011\u0004I\u0001\u0002\u0004I\u0005B\u0003B\u0015\u0003[\f\n\u0011\"\u0001\u0003,\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0017U\r!#qF\u0016\u0003\u0005c\u0001BAa\r\u0003<5\u0011!Q\u0007\u0006\u0005\u0005o\u0011I$A\u0005v]\u000eDWmY6fI*\u0011a\u0006E\u0005\u0005\u0005{\u0011)DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!B!\u0011\u0002nF\u0005I\u0011\u0001B\u0016\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB!B!\u0012\u0002nF\u0005I\u0011\u0001B$\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\u0013+\u0007\u0005\u0013y\u0003\u0003\u0006\u0003N\u00055\u0018\u0013!C\u0001\u0005\u001f\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003R)\u001a\u0011Ja\f\t\u0015\tU\u0013Q^A\u0001\n\u0003\u00129&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00053\u0002B!!\u0002\u0003\\%\u0019!+a\u0002\t\u0015\t}\u0013Q^A\u0001\n\u0003\u0011\t'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003dA\u0019qB!\u001a\n\u0007\t\u001d\u0004CA\u0002J]RD!Ba\u001b\u0002n\u0006\u0005I\u0011\u0001B7\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u001c\u0003vA\u0019qB!\u001d\n\u0007\tM\u0004CA\u0002B]fD!Ba\u001e\u0003j\u0005\u0005\t\u0019\u0001B2\u0003\rAH%\r\u0005\u000b\u0005w\ni/!A\u0005B\tu\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t}\u0004C\u0002BA\u0005\u000f\u0013y'\u0004\u0002\u0003\u0004*\u0019!Q\u0011\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\n\n\r%\u0001C%uKJ\fGo\u001c:\t\u0015\t5\u0015Q^A\u0001\n\u0003\u0011y)\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\tJa&\u0011\u0007=\u0011\u0019*C\u0002\u0003\u0016B\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0003x\t-\u0015\u0011!a\u0001\u0005_B!Ba'\u0002n\u0006\u0005I\u0011\tBO\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B2\u0011)\u0011\t+!<\u0002\u0002\u0013\u0005#1U\u0001\ti>\u001cFO]5oOR\u0011!\u0011\f\u0005\u000b\u0005O\u000bi/!A\u0005B\t%\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0012\n-\u0006B\u0003B<\u0005K\u000b\t\u00111\u0001\u0003p\u001dQ!qVAn\u0003\u0003E\tA!-\u0002\t\u0011\u000bG/\u0019\t\u0005\u0005\u001f\u0011\u0019L\u0002\u0006\u0002p\u0006m\u0017\u0011!E\u0001\u0005k\u001bRAa-\u00038b\u0001\"B!/\u0003@\u0012\"\u0013)\u0013B\u0007\u001b\t\u0011YLC\u0002\u0003>B\tqA];oi&lW-\u0003\u0003\u0003B\nm&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oi!91La-\u0005\u0002\t\u0015GC\u0001BY\u0011)\u0011\tKa-\u0002\u0002\u0013\u0015#1\u0015\u0005\u000b\u0005\u0017\u0014\u0019,!A\u0005\u0002\n5\u0017!B1qa2LHC\u0003B\u0007\u0005\u001f\u0014\tNa5\u0003V\"1!E!3A\u0002\u0011Baa\u000eBe\u0001\u0004!\u0003BB \u0003J\u0002\u0007\u0011\t\u0003\u0004H\u0005\u0013\u0004\r!\u0013\u0005\u000b\u00053\u0014\u0019,!A\u0005\u0002\nm\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005;\u0014)\u000fE\u0003\u0010\u0003K\u0011y\u000eE\u0004\u0010\u0005C$C%Q%\n\u0007\t\r\bC\u0001\u0004UkBdW\r\u000e\u0005\u000b\u0005O\u00149.!AA\u0002\t5\u0011a\u0001=%a!Q!1\u001eBZ\u0003\u0003%IA!<\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005_\u0004B!!\u0002\u0003r&!!1_A\u0004\u0005\u0019y%M[3di\"A\u0011\u0011TAn\t\u0003\u00119\u0010\u0006\u0005\u0002\u001e\ne(1 B\u007f\u0011!\t)K!>A\u0002\u0005\u001d\u0006bBAY\u0005k\u0004\r!\u0013\u0005\t\u0005\u007f\u0014)\u00101\u0001\u0003\u000e\u0005!A-\u0019;b\u0011!\u0019\u0019!a7\u0005\u0002\r\u0015\u0011\u0001\u00027pC\u0012$R!XB\u0004\u0007\u0013A\u0001\"!*\u0004\u0002\u0001\u0007\u0011q\u0015\u0005\b\u0003c\u001b\t\u00011\u0001JQ\u0015\u0019\taKA[\u000f%\u0019y!!2\t\u0002\u0011\u0019\t\"\u0001\u0007TCZ,Gj\\1e-Fz\u0006\u0007\u0005\u0003\u0002Z\u000eMa!CB\u000b\u0003\u000bD\t\u0001BB\f\u00051\u0019\u0016M^3M_\u0006$g+M01'\r\u0019\u0019B\u0004\u0005\b7\u000eMA\u0011AB\u000e)\t\u0019\t\u0002C\u0004\u0002h\u000eMA\u0011\u0001%\t\u000f\u0005-81\u0003C\u0001\u0011\u001a9\u0011q^B\n\u0001\u000e\r2CBB\u0011\u001d\u0005M\b\u0004C\u0005#\u0007C\u0011)\u001a!C\u0001G!IAg!\t\u0003\u0012\u0003\u0006I\u0001\n\u0005\no\r\u0005\"Q3A\u0005\u0002\rB\u0011\u0002PB\u0011\u0005#\u0005\u000b\u0011\u0002\u0013\t\u0013}\u001a\tC!f\u0001\n\u0003\u0001\u0005\"\u0003#\u0004\"\tE\t\u0015!\u0003B\u0011\u001dY6\u0011\u0005C\u0001\u0007g!\u0002b!\u000e\u0004:\rm2Q\b\t\u0005\u0007o\u0019\t#\u0004\u0002\u0004\u0014!1!e!\rA\u0002\u0011BaaNB\u0019\u0001\u0004!\u0003BB \u00042\u0001\u0007\u0011\t\u0003\u0006\u0003\u001c\r\u0005\u0012\u0011!C\u0001\u0007\u0003\"\u0002b!\u000e\u0004D\r\u00153q\t\u0005\tE\r}\u0002\u0013!a\u0001I!Aqga\u0010\u0011\u0002\u0003\u0007A\u0005\u0003\u0005@\u0007\u007f\u0001\n\u00111\u0001B\u0011)\u0011Ic!\t\u0012\u0002\u0013\u0005!1\u0006\u0005\u000b\u0005\u0003\u001a\t#%A\u0005\u0002\t-\u0002B\u0003B#\u0007C\t\n\u0011\"\u0001\u0003H!Q!QKB\u0011\u0003\u0003%\tEa\u0016\t\u0015\t}3\u0011EA\u0001\n\u0003\u0011\t\u0007\u0003\u0006\u0003l\r\u0005\u0012\u0011!C\u0001\u0007+\"BAa\u001c\u0004X!Q!qOB*\u0003\u0003\u0005\rAa\u0019\t\u0015\tm4\u0011EA\u0001\n\u0003\u0012i\b\u0003\u0006\u0003\u000e\u000e\u0005\u0012\u0011!C\u0001\u0007;\"BA!%\u0004`!Q!qOB.\u0003\u0003\u0005\rAa\u001c\t\u0015\tm5\u0011EA\u0001\n\u0003\u0012i\n\u0003\u0006\u0003\"\u000e\u0005\u0012\u0011!C!\u0005GC!Ba*\u0004\"\u0005\u0005I\u0011IB4)\u0011\u0011\tj!\u001b\t\u0015\t]4QMA\u0001\u0002\u0004\u0011yg\u0002\u0006\u00030\u000eM\u0011\u0011!E\u0001\u0007[\u0002Baa\u000e\u0004p\u0019Q\u0011q^B\n\u0003\u0003E\ta!\u001d\u0014\u000b\r=41\u000f\r\u0011\u0013\te6Q\u000f\u0013%\u0003\u000eU\u0012\u0002BB<\u0005w\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001dY6q\u000eC\u0001\u0007w\"\"a!\u001c\t\u0015\t\u00056qNA\u0001\n\u000b\u0012\u0019\u000b\u0003\u0006\u0003L\u000e=\u0014\u0011!CA\u0007\u0003#\u0002b!\u000e\u0004\u0004\u000e\u00155q\u0011\u0005\u0007E\r}\u0004\u0019\u0001\u0013\t\r]\u001ay\b1\u0001%\u0011\u0019y4q\u0010a\u0001\u0003\"Q!\u0011\\B8\u0003\u0003%\tia#\u0015\t\r55Q\u0013\t\u0006\u001f\u0005\u00152q\u0012\t\u0007\u001f\rEE\u0005J!\n\u0007\rM\u0005C\u0001\u0004UkBdWm\r\u0005\u000b\u0005O\u001cI)!AA\u0002\rU\u0002B\u0003Bv\u0007_\n\t\u0011\"\u0003\u0003n\"A\u0011\u0011TB\n\t\u0003\u0019Y\n\u0006\u0005\u0002\u001e\u000eu5qTBQ\u0011!\t)k!'A\u0002\u0005\u001d\u0006bBAY\u00073\u0003\r!\u0013\u0005\t\u0005\u007f\u001cI\n1\u0001\u00046!A11AB\n\t\u0003\u0019)\u000bF\u0003^\u0007O\u001bI\u000b\u0003\u0005\u0002&\u000e\r\u0006\u0019AAT\u0011\u001d\t\tla)A\u0002%C\u0001ba\u0001\u0002F\u0012\u00053Q\u0016\u000b\u0006;\u000e=6\u0011\u0017\u0005\t\u0003K\u001bY\u000b1\u0001\u0002(\"9\u0011\u0011WBV\u0001\u0004I\u0005B\u0003Bv\u0003\u000b\f\t\u0011\"\u0003\u0003n\"*\u0011QY\u0016\u00026\"*\u0011qX\u0016\u00026\u0002")
public class NaiveBayesModel
implements ClassificationModel,
Saveable {
    private final double[] labels;
    private final double[] pi;
    private final double[][] theta;
    private final String modelType;
    private final DenseVector piVector;
    private final DenseMatrix thetaMatrix;
    private final /* synthetic */ Tuple2 x$2;
    private final Option<DenseMatrix> thetaMinusNegTheta;
    private final Option<DenseVector> negThetaSum;

    public static /* bridge */ Saveable load(SparkContext sparkContext, String string) {
        return NaiveBayesModel$.MODULE$.load(sparkContext, string);
    }

    public static NaiveBayesModel load(SparkContext sparkContext, String string) {
        return NaiveBayesModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel.predict$(this, testData);
    }

    public double[] labels() {
        return this.labels;
    }

    public double[] pi() {
        return this.pi;
    }

    public double[][] theta() {
        return this.theta;
    }

    public String modelType() {
        return this.modelType;
    }

    private DenseVector piVector() {
        return this.piVector;
    }

    private DenseMatrix thetaMatrix() {
        return this.thetaMatrix;
    }

    private Option<DenseMatrix> thetaMinusNegTheta() {
        return this.thetaMinusNegTheta;
    }

    private Option<DenseVector> negThetaSum() {
        return this.negThetaSum;
    }

    @Override
    public RDD<Object> predict(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            NaiveBayesModel model = (NaiveBayesModel)bcModel.value();
            return iter.map((Function1 & Serializable & scala.Serializable)testData -> BoxesRunTime.boxToDouble((double)model.predict(testData)));
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    @Override
    public double predict(Vector testData) {
        double d;
        String string = this.modelType();
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            d = this.labels()[this.multinomialCalculation(testData).argmax()];
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                d = this.labels()[this.bernoulliCalculation(testData).argmax()];
            } else {
                throw new MatchError((Object)string);
            }
        }
        return d;
    }

    public RDD<Vector> predictProbabilities(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            NaiveBayesModel model = (NaiveBayesModel)bcModel.value();
            return iter.map((Function1 & Serializable & scala.Serializable)testData -> model.predictProbabilities((Vector)testData));
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
    }

    public Vector predictProbabilities(Vector testData) {
        DenseVector denseVector;
        String string = this.modelType();
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            denseVector = this.posteriorProbabilities(this.multinomialCalculation(testData));
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                denseVector = this.posteriorProbabilities(this.bernoulliCalculation(testData));
            } else {
                throw new MatchError((Object)string);
            }
        }
        return denseVector;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector testData) {
        void var2_2;
        DenseVector prob = this.thetaMatrix().multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector testData) {
        void var2_2;
        testData.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x$3, value) -> {
            if (value != 0.0 && value != 1.0) {
                throw new SparkException(new StringBuilder(64).append("Bernoulli naive Bayes requires 0 or 1 feature values but found ").append(testData).append(".").toString());
            }
        });
        DenseVector prob = ((Matrix)this.thetaMinusNegTheta().get()).multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.negThetaSum().get(), (Vector)prob);
        return var2_2;
    }

    private DenseVector posteriorProbabilities(DenseVector logProb) {
        double[] logProbArray = logProb.toArray();
        double maxLog = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logProbArray)).max((Ordering)Ordering.Double$.MODULE$));
        double[] scaledProbs = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logProbArray)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)lp -> package$.MODULE$.exp(lp - maxLog), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double probSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(scaledProbs)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return new DenseVector((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(scaledProbs)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / probSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public void save(SparkContext sc, String path) {
        SaveLoadV2_0.Data data = new SaveLoadV2_0.Data(this.labels(), this.pi(), this.theta(), this.modelType());
        NaiveBayesModel$SaveLoadV2_0$.MODULE$.save(sc, path, data);
    }

    @Override
    public String formatVersion() {
        return "2.0";
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta, String modelType) {
        Tuple2 tuple2;
        this.labels = labels;
        this.pi = pi;
        this.theta = theta;
        this.modelType = modelType;
        ClassificationModel.$init$(this);
        this.piVector = new DenseVector(pi);
        this.thetaMatrix = new DenseMatrix(labels.length, theta[0].length, (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])theta)).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), ClassTag$.MODULE$.Double()), true);
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Invalid modelType ").append(this.modelType()).append(". Supported modelTypes are ").append(NaiveBayes$.MODULE$.supportedModelTypes()).append(".").toString());
        String string = modelType;
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                Matrix negTheta = this.thetaMatrix().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> package$.MODULE$.log(1.0 - package$.MODULE$.exp(value)));
                DenseVector ones = new DenseVector((double[])Array$.MODULE$.fill(this.thetaMatrix().numCols(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
                Matrix thetaMinusNegTheta = this.thetaMatrix().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> value - package$.MODULE$.log(1.0 - package$.MODULE$.exp(value)));
                tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)thetaMinusNegTheta), (Object)Option$.MODULE$.apply((Object)((DenseMatrix)negTheta).multiply(ones)));
            } else {
                throw new UnknownError(new StringBuilder(20).append("Invalid modelType: ").append(modelType).append(".").toString());
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option thetaMinusNegTheta = (Option)tuple22._1();
        Option negThetaSum = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)thetaMinusNegTheta, (Object)negThetaSum);
        this.x$2 = tuple23;
        this.thetaMinusNegTheta = (Option)this.x$2._1();
        this.negThetaSum = (Option)this.x$2._2();
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta) {
        this(labels, pi, theta, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayesModel(Iterable<Object> labels, Iterable<Object> pi, Iterable<Iterable<Object>> theta) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(labels).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(pi).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(theta).asScala()).toArray(ClassTag$.MODULE$.apply(Iterable.class)))).map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(Iterable<Object> x$1) {
                return (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala()).toArray(ClassTag$.MODULE$.Double());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
    }
}

