/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.mllib.clustering.BisectingKMeans;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class BisectingKMeans$
implements scala.Serializable {
    public static BisectingKMeans$ MODULE$;
    private final long org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX;
    private final long MAX_DIVISIBLE_CLUSTER_INDEX;
    private final double org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT;

    static {
        new BisectingKMeans$();
    }

    public long org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX() {
        return this.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX;
    }

    private long MAX_DIVISIBLE_CLUSTER_INDEX() {
        return this.MAX_DIVISIBLE_CLUSTER_INDEX;
    }

    public double org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT() {
        return this.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT;
    }

    public long org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(long index) {
        Predef$.MODULE$.require(index <= this.MAX_DIVISIBLE_CLUSTER_INDEX(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Child index out of bound: 2 * ").append(index).append(".").toString());
        return 2L * index;
    }

    public long org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(long index) {
        Predef$.MODULE$.require(index <= this.MAX_DIVISIBLE_CLUSTER_INDEX(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Child index out of bound: 2 * ").append(index).append(" + 1.").toString());
        return 2L * index + 1L;
    }

    public long org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(long index) {
        return index / 2L;
    }

    public Map<Object, BisectingKMeans.ClusterSummary> org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(int d, RDD<Tuple2<Object, VectorWithNorm>> assignments, DistanceMeasure distanceMeasure) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(assignments, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).aggregateByKey((Object)new BisectingKMeans.ClusterSummaryAggregator(d, distanceMeasure), (Function2 & Serializable & scala.Serializable)(agg, v) -> agg.add((VectorWithNorm)v), (Function2 & Serializable & scala.Serializable)(agg1, agg2) -> agg1.merge((BisectingKMeans.ClusterSummaryAggregator)agg2), ClassTag$.MODULE$.apply(BisectingKMeans.ClusterSummaryAggregator.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(BisectingKMeans.ClusterSummaryAggregator.class), (Ordering)Ordering.Long$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)x$6 -> x$6.summary()).collect())).toMap(Predef$.MODULE$.$conforms());
    }

    public Tuple2<VectorWithNorm, VectorWithNorm> org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(VectorWithNorm center, Random random, DistanceMeasure distanceMeasure) {
        int d = center.vector().size();
        double norm = center.norm();
        double level = 1.0E-4 * norm;
        Vector noise = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(d, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random.nextDouble(), ClassTag$.MODULE$.Double()));
        return distanceMeasure.symmetricCentroids(level, noise, center.vector());
    }

    public RDD<Tuple2<Object, VectorWithNorm>> org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments(RDD<Tuple2<Object, VectorWithNorm>> assignments, Set<Object> divisibleIndices, Map<Object, VectorWithNorm> newClusterCenters, DistanceMeasure distanceMeasure) {
        return assignments.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$6;
            if (tuple22 != null) {
                long index = tuple22._1$mcJ$sp();
                VectorWithNorm v = (VectorWithNorm)tuple22._2();
                if (divisibleIndices.contains((Object)BoxesRunTime.boxToLong((long)index))) {
                    Seq children = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index), MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index)}));
                    Seq newClusterChildren = (Seq)children.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)key -> newClusterCenters.contains((Object)BoxesRunTime.boxToLong((long)key)));
                    Map newClusterChildrenCenterToId = ((TraversableOnce)newClusterChildren.map((Function1 & Serializable & scala.Serializable)id -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(newClusterCenters.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)id)))), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)id))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    VectorWithNorm[] newClusterChildrenCenters = (VectorWithNorm[])newClusterChildrenCenterToId.keys().toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
                    if (newClusterChildren.nonEmpty()) {
                        int selected = distanceMeasure.findClosest((TraversableOnce<VectorWithNorm>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newClusterChildrenCenters)), v)._1$mcI$sp();
                        VectorWithNorm center = newClusterChildrenCenters[selected];
                        long id2 = BoxesRunTime.unboxToLong((Object)newClusterChildrenCenterToId.apply((Object)center));
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id2), (Object)v);
                    } else {
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)index), (Object)v);
                    }
                } else {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)index), (Object)v);
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public ClusteringTreeNode org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree(Map<Object, BisectingKMeans.ClusterSummary> clusters, DistanceMeasure distanceMeasure) {
        IntRef leafIndex = IntRef.create((int)0);
        IntRef internalIndex = IntRef.create((int)-1);
        return this.buildSubTree$1(this.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX(), clusters, distanceMeasure, leafIndex, internalIndex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final ClusteringTreeNode buildSubTree$1(long rawIndex2, Map clusters$1, DistanceMeasure distanceMeasure$2, IntRef leafIndex$1, IntRef internalIndex$1) {
        ClusteringTreeNode clusteringTreeNode;
        BisectingKMeans.ClusterSummary cluster = (BisectingKMeans.ClusterSummary)clusters$1.apply((Object)BoxesRunTime.boxToLong((long)rawIndex2));
        long size = cluster.size();
        VectorWithNorm center = cluster.center();
        double cost = cluster.cost();
        boolean isInternal = clusters$1.contains((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(rawIndex2)));
        if (isInternal) {
            int index = internalIndex$1.elem--;
            long leftIndex = this.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(rawIndex2);
            long rightIndex = this.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(rawIndex2);
            Seq indexes = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{leftIndex, rightIndex}))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)key -> clusters$1.contains((Object)BoxesRunTime.boxToLong((long)key)));
            double height = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)indexes.map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)childIndex -> distanceMeasure$2.distance(center, ((BisectingKMeans.ClusterSummary)clusters$1.apply((Object)BoxesRunTime.boxToLong((long)childIndex))).center()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            ClusteringTreeNode[] children = (ClusteringTreeNode[])((TraversableOnce)indexes.map((Function1 & Serializable & scala.Serializable)rawIndex -> this.buildSubTree$1(BoxesRunTime.unboxToLong((Object)rawIndex), clusters$1, distanceMeasure$2, leafIndex$1, internalIndex$1), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ClusteringTreeNode.class));
            clusteringTreeNode = new ClusteringTreeNode(index, size, center, cost, height, children);
        } else {
            int index = leafIndex$1.elem++;
            double height = 0.0;
            clusteringTreeNode = new ClusteringTreeNode(index, size, center, cost, height, (ClusteringTreeNode[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ClusteringTreeNode.class)));
        }
        return clusteringTreeNode;
    }

    private BisectingKMeans$() {
        MODULE$ = this;
        this.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX = 1L;
        this.MAX_DIVISIBLE_CLUSTER_INDEX = 0x3FFFFFFFFFFFFFFFL;
        this.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT = package$.MODULE$.log10(9.223372036854776E18) / package$.MODULE$.log10(2.0);
    }
}

