/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.BisectingKMeans$;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Seq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0005g\u0001B\u0001\u0003\u00015\u0011qBQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!a\u0001\n\u0013a\u0012!A6\u0016\u0003u\u0001\"a\u0004\u0010\n\u0005}\u0001\"aA%oi\"A\u0011\u0005\u0001BA\u0002\u0013%!%A\u0003l?\u0012*\u0017\u000f\u0006\u0002$MA\u0011q\u0002J\u0005\u0003KA\u0011A!\u00168ji\"9q\u0005IA\u0001\u0002\u0004i\u0012a\u0001=%c!A\u0011\u0006\u0001B\u0001B\u0003&Q$\u0001\u0002lA!A1\u0006\u0001BA\u0002\u0013%A$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\t[\u0001\u0011\t\u0019!C\u0005]\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\rz\u0003bB\u0014-\u0003\u0003\u0005\r!\b\u0005\tc\u0001\u0011\t\u0011)Q\u0005;\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002C\u001a\u0001\u0005\u0003\u0007I\u0011\u0002\u001b\u0002/5Lg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,W#A\u001b\u0011\u0005=1\u0014BA\u001c\u0011\u0005\u0019!u.\u001e2mK\"A\u0011\b\u0001BA\u0002\u0013%!(A\u000enS:$\u0015N^5tS\ndWm\u00117vgR,'oU5{K~#S-\u001d\u000b\u0003GmBqa\n\u001d\u0002\u0002\u0003\u0007Q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015)\u00036\u0003ai\u0017N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\r\t\u0005\t\u007f\u0001\u0011\t\u0019!C\u0005\u0001\u0006!1/Z3e+\u0005\t\u0005CA\bC\u0013\t\u0019\u0005C\u0001\u0003M_:<\u0007\u0002C#\u0001\u0005\u0003\u0007I\u0011\u0002$\u0002\u0011M,W\rZ0%KF$\"aI$\t\u000f\u001d\"\u0015\u0011!a\u0001\u0003\"A\u0011\n\u0001B\u0001B\u0003&\u0011)A\u0003tK\u0016$\u0007\u0005\u0003\u0005L\u0001\t\u0005\r\u0011\"\u0003M\u0003=!\u0017n\u001d;b]\u000e,W*Z1tkJ,W#A'\u0011\u00059+fBA(T!\t\u0001\u0006#D\u0001R\u0015\t\u0011F\"\u0001\u0004=e>|GOP\u0005\u0003)B\ta\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011A\u000b\u0005\u0005\t3\u0002\u0011\t\u0019!C\u00055\u0006\u0019B-[:uC:\u001cW-T3bgV\u0014Xm\u0018\u0013fcR\u00111e\u0017\u0005\bOa\u000b\t\u00111\u0001N\u0011!i\u0006A!A!B\u0013i\u0015\u0001\u00053jgR\fgnY3NK\u0006\u001cXO]3!\u0011\u0015y\u0006\u0001\"\u0003a\u0003\u0019a\u0014N\\5u}Q1\u0011m\u00193fM\u001e\u0004\"A\u0019\u0001\u000e\u0003\tAQa\u00070A\u0002uAQa\u000b0A\u0002uAQa\r0A\u0002UBQa\u00100A\u0002\u0005CQa\u00130A\u00025CQa\u0018\u0001\u0005\u0002%$\u0012!\u0019\u0015\u0004Q.\f\bC\u00017p\u001b\u0005i'B\u00018\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003a6\u0014QaU5oG\u0016\f\u0013A]\u0001\u0006c92d\u0006\r\u0005\u0006i\u0002!\t!^\u0001\u0005g\u0016$8\n\u0006\u0002wo6\t\u0001\u0001C\u0003\u001cg\u0002\u0007Q\u0004K\u0002tWFDQA\u001f\u0001\u0005\u0002q\tAaZ3u\u0017\"\u001a\u0011p[9\t\u000bu\u0004A\u0011\u0001@\u0002!M,G/T1y\u0013R,'/\u0019;j_:\u001cHC\u0001<\u0000\u0011\u0015YC\u00101\u0001\u001eQ\ra8.\u001d\u0005\u0007\u0003\u000b\u0001A\u0011\u0001\u000f\u0002!\u001d,G/T1y\u0013R,'/\u0019;j_:\u001c\b\u0006BA\u0002WFDq!a\u0003\u0001\t\u0003\ti!\u0001\u000etKRl\u0015N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\rF\u0002w\u0003\u001fAaaMA\u0005\u0001\u0004)\u0004\u0006BA\u0005WFDa!!\u0006\u0001\t\u0003!\u0014AG4fi6Kg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,\u0007\u0006BA\nWFDq!a\u0007\u0001\t\u0003\ti\"A\u0004tKR\u001cV-\u001a3\u0015\u0007Y\fy\u0002\u0003\u0004@\u00033\u0001\r!\u0011\u0015\u0005\u00033Y\u0017\u000f\u0003\u0004\u0002&\u0001!\t\u0001Q\u0001\bO\u0016$8+Z3eQ\u0011\t\u0019c[9\t\r\u0005-\u0002\u0001\"\u0001M\u0003I9W\r\u001e#jgR\fgnY3NK\u0006\u001cXO]3)\u000b\u0005%2.a\f\"\u0005\u0005E\u0012!\u0002\u001a/i9\u0002\u0004bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\u0013g\u0016$H)[:uC:\u001cW-T3bgV\u0014X\rF\u0002w\u0003sAaaSA\u001a\u0001\u0004i\u0005&BA\u001aW\u0006=\u0002\u0002CA \u0001\u0011\u0005a!!\u0011\u0002\u0007I,h\u000e\u0006\u0004\u0002D\u0005%\u0013Q\r\t\u0004E\u0006\u0015\u0013bAA$\u0005\t!\")[:fGRLgnZ&NK\u0006t7/T8eK2D\u0001\"a\u0013\u0002>\u0001\u0007\u0011QJ\u0001\u0006S:\u0004X\u000f\u001e\t\u0007\u0003\u001f\n)&!\u0017\u000e\u0005\u0005E#bAA*\r\u0005\u0019!\u000f\u001a3\n\t\u0005]\u0013\u0011\u000b\u0002\u0004%\u0012#\u0005\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}C!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003G\niF\u0001\u0004WK\u000e$xN\u001d\u0005\t\u0003O\ni\u00041\u0001\u0002j\u0005)\u0011N\\:ueB)q\"a\u001b\u0002p%\u0019\u0011Q\u000e\t\u0003\r=\u0003H/[8o!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\nA!\u001e;jY*\u0019\u0011\u0011\u0010\u0004\u0002\u00055d\u0017\u0002BA?\u0003g\u0012q\"\u00138tiJ,X.\u001a8uCRLwN\u001c\u0005\b\u0003\u007f\u0001A\u0011AAA)\u0011\t\u0019%a!\t\u0011\u0005-\u0013q\u0010a\u0001\u0003\u001bBC!a lc\"9\u0011q\b\u0001\u0005\u0002\u0005%E\u0003BA\"\u0003\u0017C\u0001\"!$\u0002\b\u0002\u0007\u0011qR\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002\u0012\u0006m\u0015\u0011L\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006!!.\u0019<b\u0015\r\tIJB\u0001\u0004CBL\u0017\u0002BAO\u0003'\u0013qAS1wCJ#E\tK\u0002\u0001WF<q!a)\u0003\u0011\u0013\t)+A\bCSN,7\r^5oO.kU-\u00198t!\r\u0011\u0017q\u0015\u0004\u0007\u0003\tAI!!+\u0014\u000b\u0005\u001df\"a+\u0011\u0007=\ti+C\u0002\u00020B\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqaXAT\t\u0003\t\u0019\f\u0006\u0002\u0002&\"I\u0011qWAT\u0005\u0004%I\u0001Q\u0001\u000b%>{EkX%O\t\u0016C\u0006\u0002CA^\u0003O\u0003\u000b\u0011B!\u0002\u0017I{u\nV0J\u001d\u0012+\u0005\f\t\u0005\n\u0003\u007f\u000b9K1A\u0005\n\u0001\u000b1$T!Y?\u0012Ke+S*J\u00052+ul\u0011'V'R+%kX%O\t\u0016C\u0006\u0002CAb\u0003O\u0003\u000b\u0011B!\u000295\u000b\u0005l\u0018#J-&\u001b\u0016J\u0011'F?\u000ecUk\u0015+F%~Ke\nR#YA!I\u0011qYAT\u0005\u0004%I\u0001N\u0001\f\u0019\u00163V\tT0M\u00136KE\u000b\u0003\u0005\u0002L\u0006\u001d\u0006\u0015!\u00036\u00031aUIV#M?2KU*\u0013+!\u0011!\ty-a*\u0005\n\u0005E\u0017A\u00047fMR\u001c\u0005.\u001b7e\u0013:$W\r\u001f\u000b\u0004\u0003\u0006M\u0007bBAk\u0003\u001b\u0004\r!Q\u0001\u0006S:$W\r\u001f\u0005\t\u00033\f9\u000b\"\u0003\u0002\\\u0006y!/[4ii\u000eC\u0017\u000e\u001c3J]\u0012,\u0007\u0010F\u0002B\u0003;Dq!!6\u0002X\u0002\u0007\u0011\t\u0003\u0005\u0002b\u0006\u001dF\u0011BAr\u0003-\u0001\u0018M]3oi&sG-\u001a=\u0015\u0007\u0005\u000b)\u000fC\u0004\u0002V\u0006}\u0007\u0019A!\t\u0011\u0005%\u0018q\u0015C\u0005\u0003W\f\u0011b];n[\u0006\u0014\u0018N_3\u0015\u0011\u00055(\u0011\u0018B_\u0005\u0013\u0004bATAx\u0003\u0006M\u0018bAAy/\n\u0019Q*\u00199\u0011\t\u0005U\u0018q_\u0007\u0003\u0003O3q!!?\u0002(\u0012\u000bYP\u0001\bDYV\u001cH/\u001a:Tk6l\u0017M]=\u0014\u000f\u0005]h\"!@\u0002,B\u0019q\"a@\n\u0007\t\u0005\u0001CA\u0004Qe>$Wo\u0019;\t\u0015\t\u0015\u0011q\u001fBK\u0002\u0013\u0005\u0001)\u0001\u0003tSj,\u0007B\u0003B\u0005\u0003o\u0014\t\u0012)A\u0005\u0003\u0006)1/\u001b>fA!Y!QBA|\u0005+\u0007I\u0011\u0001B\b\u0003\u0019\u0019WM\u001c;feV\u0011!\u0011\u0003\t\u0004E\nM\u0011b\u0001B\u000b\u0005\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0007b\u0003B\r\u0003o\u0014\t\u0012)A\u0005\u0005#\tqaY3oi\u0016\u0014\b\u0005\u0003\u0006\u0003\u001e\u0005](Q3A\u0005\u0002Q\nAaY8ti\"Q!\u0011EA|\u0005#\u0005\u000b\u0011B\u001b\u0002\u000b\r|7\u000f\u001e\u0011\t\u000f}\u000b9\u0010\"\u0001\u0003&QA\u00111\u001fB\u0014\u0005S\u0011Y\u0003C\u0004\u0003\u0006\t\r\u0002\u0019A!\t\u0011\t5!1\u0005a\u0001\u0005#AqA!\b\u0003$\u0001\u0007Q\u0007\u0003\u0006\u00030\u0005]\u0018\u0011!C\u0001\u0005c\tAaY8qsRA\u00111\u001fB\u001a\u0005k\u00119\u0004C\u0005\u0003\u0006\t5\u0002\u0013!a\u0001\u0003\"Q!Q\u0002B\u0017!\u0003\u0005\rA!\u0005\t\u0013\tu!Q\u0006I\u0001\u0002\u0004)\u0004B\u0003B\u001e\u0003o\f\n\u0011\"\u0001\u0003>\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B U\r\t%\u0011I\u0016\u0003\u0005\u0007\u0002BA!\u0012\u0003N5\u0011!q\t\u0006\u0005\u0005\u0013\u0012Y%A\u0005v]\u000eDWmY6fI*\u0011a\u000eE\u0005\u0005\u0005\u001f\u00129EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!Ba\u0015\u0002xF\u0005I\u0011\u0001B+\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0016+\t\tE!\u0011\t\u0005\u000b\u00057\n90%A\u0005\u0002\tu\u0013AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005?R3!\u000eB!\u0011)\u0011\u0019'a>\u0002\u0002\u0013\u0005#QM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u001d\u0004\u0003\u0002B5\u0005cj!Aa\u001b\u000b\t\t5$qN\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016&\u0019aKa\u001b\t\u0013\tU\u0014q_A\u0001\n\u0003a\u0012\u0001\u00049s_\u0012,8\r^!sSRL\bB\u0003B=\u0003o\f\t\u0011\"\u0001\u0003|\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B?\u0005\u0007\u00032a\u0004B@\u0013\r\u0011\t\t\u0005\u0002\u0004\u0003:L\b\u0002C\u0014\u0003x\u0005\u0005\t\u0019A\u000f\t\u0015\t\u001d\u0015q_A\u0001\n\u0003\u0012I)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\t\u0005\u0004\u0003\u000e\nM%QP\u0007\u0003\u0005\u001fS1A!%\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005+\u0013yI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011I*a>\u0002\u0002\u0013\u0005!1T\u0001\tG\u0006tW)];bYR!!Q\u0014BR!\ry!qT\u0005\u0004\u0005C\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\nO\t]\u0015\u0011!a\u0001\u0005{B!Ba*\u0002x\u0006\u0005I\u0011\tBU\u0003!A\u0017m\u001d5D_\u0012,G#A\u000f\t\u0015\t5\u0016q_A\u0001\n\u0003\u0012y+\u0001\u0005u_N#(/\u001b8h)\t\u00119\u0007\u0003\u0006\u00034\u0006]\u0018\u0011!C!\u0005k\u000ba!Z9vC2\u001cH\u0003\u0002BO\u0005oC\u0011b\nBY\u0003\u0003\u0005\rA! \t\u000f\tm\u0016q\u001da\u0001;\u0005\tA\r\u0003\u0005\u0003@\u0006\u001d\b\u0019\u0001Ba\u0003-\t7o]5h]6,g\u000e^:\u0011\r\u0005=\u0013Q\u000bBb!\u0019y!QY!\u0003\u0012%\u0019!q\u0019\t\u0003\rQ+\b\u000f\\33\u0011\u001dY\u0015q\u001da\u0001\u0005\u0017\u00042A\u0019Bg\u0013\r\u0011yM\u0001\u0002\u0010\t&\u001cH/\u00198dK6+\u0017m];sK\u001a9!1[AT\t\tU'\u0001G\"mkN$XM]*v[6\f'/_!hOJ,w-\u0019;peN)!\u0011\u001b\b\u0002,\"Q!1\u0018Bi\u0005\u000b\u0007I\u0011\u0001\u000f\t\u0015\tm'\u0011\u001bB\u0001B\u0003%Q$\u0001\u0002eA!Q1J!5\u0003\u0006\u0004%\tAa8\u0016\u0005\t-\u0007BC/\u0003R\n\u0005\t\u0015!\u0003\u0003L\"9qL!5\u0005\u0002\t\u0015HC\u0002Bt\u0005S\u0014Y\u000f\u0005\u0003\u0002v\nE\u0007b\u0002B^\u0005G\u0004\r!\b\u0005\b\u0017\n\r\b\u0019\u0001Bf\u0011%\u0011yO!5A\u0002\u0013%\u0001)A\u0001o\u0011)\u0011\u0019P!5A\u0002\u0013%!Q_\u0001\u0006]~#S-\u001d\u000b\u0004G\t]\b\u0002C\u0014\u0003r\u0006\u0005\t\u0019A!\t\u0011\tm(\u0011\u001bQ!\n\u0005\u000b!A\u001c\u0011\t\u0015\t}(\u0011\u001bb\u0001\n\u0013\u0019\t!A\u0002tk6,\"!!\u0017\t\u0013\r\u0015!\u0011\u001bQ\u0001\n\u0005e\u0013\u0001B:v[\u0002B\u0011b!\u0003\u0003R\u0002\u0007I\u0011\u0002\u001b\u0002\u000bM,XnU9\t\u0015\r5!\u0011\u001ba\u0001\n\u0013\u0019y!A\u0005tk6\u001c\u0016o\u0018\u0013fcR\u00191e!\u0005\t\u0011\u001d\u001aY!!AA\u0002UB\u0001b!\u0006\u0003R\u0002\u0006K!N\u0001\u0007gVl7+\u001d\u0011\t\u0011\re!\u0011\u001bC\u0001\u00077\t1!\u00193e)\u0011\u0019iba\b\u000e\u0005\tE\u0007\u0002CB\u0011\u0007/\u0001\rA!\u0005\u0002\u0003YD\u0001b!\n\u0003R\u0012\u00051qE\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0005\u0007;\u0019I\u0003\u0003\u0005\u0004,\r\r\u0002\u0019\u0001Bt\u0003\u0015yG\u000f[3s\u0011!\u0019yC!5\u0005\u0002\rE\u0012aB:v[6\f'/_\u000b\u0003\u0003gD\u0001b!\u000e\u0002(\u0012%1qG\u0001\fgBd\u0017\u000e^\"f]R,'\u000f\u0006\u0005\u0004:\rm2QHB&!\u001dy!Q\u0019B\t\u0005#A\u0001B!\u0004\u00044\u0001\u0007!\u0011\u0003\u0005\t\u0007\u007f\u0019\u0019\u00041\u0001\u0004B\u00051!/\u00198e_6\u0004Baa\u0011\u0004H5\u00111Q\t\u0006\u0005\u0003k\u0012y'\u0003\u0003\u0004J\r\u0015#A\u0002*b]\u0012|W\u000eC\u0004L\u0007g\u0001\rAa3\t\u0011\r=\u0013q\u0015C\u0005\u0007#\n\u0011#\u001e9eCR,\u0017i]:jO:lWM\u001c;t))\u0011\tma\u0015\u0004V\r}3Q\r\u0005\t\u0005\u007f\u001bi\u00051\u0001\u0003B\"A1qKB'\u0001\u0004\u0019I&\u0001\teSZL7/\u001b2mK&sG-[2fgB!aja\u0017B\u0013\r\u0019if\u0016\u0002\u0004'\u0016$\b\u0002CB1\u0007\u001b\u0002\raa\u0019\u0002#9,wo\u00117vgR,'oQ3oi\u0016\u00148\u000f\u0005\u0004O\u0003_\f%\u0011\u0003\u0005\b\u0017\u000e5\u0003\u0019\u0001Bf\u0011!\u0019I'a*\u0005\n\r-\u0014!\u00032vS2$GK]3f)\u0019\u0019iga\u001d\u0004xA\u0019!ma\u001c\n\u0007\rE$A\u0001\nDYV\u001cH/\u001a:j]\u001e$&/Z3O_\u0012,\u0007\u0002CB;\u0007O\u0002\r!!<\u0002\u0011\rdWo\u001d;feNDqaSB4\u0001\u0004\u0011Ym\u0002\u0006\u0004|\u0005\u001d\u0016\u0011!E\u0005\u0007{\nab\u00117vgR,'oU;n[\u0006\u0014\u0018\u0010\u0005\u0003\u0002v\u000e}dACA}\u0003O\u000b\t\u0011#\u0003\u0004\u0002N11qPBB\u0003W\u0003\"b!\"\u0004\f\u0006\u0013\t\"NAz\u001b\t\u00199IC\u0002\u0004\nB\tqA];oi&lW-\u0003\u0003\u0004\u000e\u000e\u001d%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9qla \u0005\u0002\rEECAB?\u0011)\u0011ika \u0002\u0002\u0013\u0015#q\u0016\u0005\u000b\u0007/\u001by(!A\u0005\u0002\u000ee\u0015!B1qa2LH\u0003CAz\u00077\u001bija(\t\u000f\t\u00151Q\u0013a\u0001\u0003\"A!QBBK\u0001\u0004\u0011\t\u0002C\u0004\u0003\u001e\rU\u0005\u0019A\u001b\t\u0015\r\r6qPA\u0001\n\u0003\u001b)+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\u001d6q\u0016\t\u0006\u001f\u0005-4\u0011\u0016\t\b\u001f\r-\u0016I!\u00056\u0013\r\u0019i\u000b\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0015\rE6\u0011UA\u0001\u0002\u0004\t\u00190A\u0002yIAB!b!.\u0004\u0000\u0005\u0005I\u0011BB\\\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\re\u0006\u0003\u0002B5\u0007wKAa!0\u0003l\t1qJ\u00196fGRD!b!.\u0002(\u0006\u0005I\u0011BB\\\u0001")
public class BisectingKMeans
implements Logging {
    private int k;
    private int maxIterations;
    private double minDivisibleClusterSize;
    private long seed;
    private String distanceMeasure;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    private void minDivisibleClusterSize_$eq(double x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public BisectingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("k must be positive but got ").append(k).append(".").toString());
        this.k_$eq(k);
        return this;
    }

    public int getK() {
        return this.k();
    }

    public BisectingKMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("maxIterations must be positive but got ").append(maxIterations).append(".").toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public BisectingKMeans setMinDivisibleClusterSize(double minDivisibleClusterSize) {
        Predef$.MODULE$.require(minDivisibleClusterSize > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("minDivisibleClusterSize must be positive but got ").append(minDivisibleClusterSize).append(".").toString());
        this.minDivisibleClusterSize_$eq(minDivisibleClusterSize);
        return this;
    }

    public double getMinDivisibleClusterSize() {
        return this.minDivisibleClusterSize();
    }

    public BisectingKMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public BisectingKMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    public BisectingKMeansModel run(RDD<Vector> input, Option<Instrumentation> instr) {
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(105).append("The input RDD ").append(input.id()).append(" is not directly cached, which may hurt performance if").append(" its parent RDDs are also not cached.").toString());
        }
        int d = BoxesRunTime.unboxToInt((Object)input.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), ClassTag$.MODULE$.Int()).first());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Feature dimension: ").append(d).append(".").toString());
        DistanceMeasure dMeasure = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        RDD norms = input.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)Vectors$.MODULE$.norm(v, 2.0)), ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD vectors = input.zip(norms, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector x = (Vector)tuple2._1();
            double norm = tuple2._2$mcD$sp();
            VectorWithNorm vectorWithNorm = new VectorWithNorm(x, norm);
            return vectorWithNorm;
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        ObjectRef assignments = ObjectRef.create((Object)vectors.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()), v), ClassTag$.MODULE$.apply(Tuple2.class)));
        ObjectRef activeClusters = ObjectRef.create(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), dMeasure));
        instr.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.logNumExamples(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((Map)activeClusters.elem).values().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            return BoxedUnit.UNIT;
        });
        ClusterSummary rootSummary = (ClusterSummary)((Map)activeClusters.elem).apply((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()));
        long n = rootSummary.size();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Number of points: ").append(n).append(".").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Initial cost: ").append(rootSummary.cost()).append(".").toString());
        long minSize = this.minDivisibleClusterSize() >= 1.0 ? (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize()) : (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize() * (double)n);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("The minimum number of points of a divisible cluster is ").append(minSize).append(".").toString());
        scala.collection.mutable.Seq inactiveClusters = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        Random random = new Random(this.seed());
        int numLeafClustersNeeded = this.k() - 1;
        IntRef level = IntRef.create((int)1);
        RDD preIndices = null;
        RDD indices = null;
        while (((Map)activeClusters.elem).nonEmpty() && numLeafClustersNeeded > 0 && (double)level.elem < BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT()) {
            Map divisibleClusters = (Map)((Map)activeClusters.elem).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)BisectingKMeans.$anonfun$run$12(minSize, x0$2)));
            if (divisibleClusters.size() > numLeafClustersNeeded) {
                divisibleClusters = ((TraversableOnce)((IterableLike)divisibleClusters.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)BisectingKMeans.$anonfun$run$13(x0$3)), (Ordering)Ordering.Long$.MODULE$)).take(numLeafClustersNeeded)).toMap(Predef$.MODULE$.$conforms());
            }
            if (divisibleClusters.nonEmpty()) {
                Set divisibleIndices = divisibleClusters.keys().toSet();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Dividing ").append(divisibleIndices.size()).append(" clusters on level ").append(level$1.elem).append(".").toString());
                ObjectRef newClusterCenters = ObjectRef.create((Object)((Map)((TraversableLike)divisibleClusters.flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2;
                    long index;
                    Tuple2 tuple22 = x0$4;
                    if (tuple22 != null) {
                        index = tuple22._1$mcJ$sp();
                        ClusterSummary summary = (ClusterSummary)tuple22._2();
                        Tuple2<VectorWithNorm, VectorWithNorm> tuple23 = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(summary.center(), random, dMeasure);
                        if (tuple23 == null) {
                            throw new MatchError(tuple23);
                        }
                        VectorWithNorm left = (VectorWithNorm)tuple23._1();
                        VectorWithNorm right = (VectorWithNorm)tuple23._2();
                        tuple2 = new Tuple2((Object)left, (Object)right);
                    } else {
                        throw new MatchError((Object)tuple22);
                    }
                    Tuple2 tuple24 = tuple2;
                    VectorWithNorm left = (VectorWithNorm)tuple24._1();
                    VectorWithNorm right = (VectorWithNorm)tuple24._2();
                    Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index)), (Object)left), new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index)), (Object)right)}));
                    return iterator;
                }, Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())));
                ObjectRef newClusters = ObjectRef.create(null);
                ObjectRef newAssignments = ObjectRef.create(null);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxIterations()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                    newAssignments$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments$1.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters$1.elem), dMeasure).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)BisectingKMeans.$anonfun$run$18(divisibleIndices, x0$5)));
                    newClusters$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)newAssignments$1.elem), dMeasure);
                    newClusterCenters$1.elem = (Map)((Map)newClusters$1.elem).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> x$5.center()).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom());
                });
                Object object = preIndices != null ? preIndices.unpersist(false) : BoxedUnit.UNIT;
                preIndices = indices;
                indices = RDD$.MODULE$.rddToPairRDDFunctions(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters.elem), dMeasure), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).keys().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                assignments.elem = indices.zip(vectors, ClassTag$.MODULE$.apply(VectorWithNorm.class));
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = (Map)newClusters.elem;
                numLeafClustersNeeded -= divisibleClusters.size();
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("None active and divisible clusters left on level ").append(level$1.elem).append(". Stop iterations.").toString());
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = Predef$.MODULE$.Map().empty();
            }
            ++level.elem;
        }
        Object object = preIndices != null ? preIndices.unpersist(false) : BoxedUnit.UNIT;
        Object object2 = indices != null ? indices.unpersist(false) : BoxedUnit.UNIT;
        norms.unpersist(false);
        Map clusters = ((Map)activeClusters.elem).$plus$plus((GenTraversableOnce)inactiveClusters);
        ClusteringTreeNode root = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree((Map<Object, ClusterSummary>)clusters, dMeasure);
        return new BisectingKMeansModel(root, this.distanceMeasure());
    }

    public BisectingKMeansModel run(RDD<Vector> input) {
        return this.run(input, (Option<Instrumentation>)None$.MODULE$);
    }

    public BisectingKMeansModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    public static final /* synthetic */ boolean $anonfun$run$12(long minSize$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ClusterSummary summary = (ClusterSummary)tuple2._2();
        boolean bl = summary.size() >= minSize$1 && summary.cost() > MLUtils$.MODULE$.EPSILON() * (double)summary.size();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$run$13(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ClusterSummary summary = (ClusterSummary)tuple2._2();
        long l = -summary.size();
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$run$18(Set divisibleIndices$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long index = tuple2._1$mcJ$sp();
        boolean bl = divisibleIndices$1.contains((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(index)));
        return bl;
    }

    private BisectingKMeans(int k, int maxIterations, double minDivisibleClusterSize, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.minDivisibleClusterSize = minDivisibleClusterSize;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
    }

    public BisectingKMeans() {
        this(4, 20, 1.0, Statics.anyHash((Object)BisectingKMeans.class.getName()), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public static class ClusterSummary
    implements Product,
    scala.Serializable {
        private final long size;
        private final VectorWithNorm center;
        private final double cost;

        public long size() {
            return this.size;
        }

        public VectorWithNorm center() {
            return this.center;
        }

        public double cost() {
            return this.cost;
        }

        public ClusterSummary copy(long size, VectorWithNorm center, double cost) {
            return new ClusterSummary(size, center, cost);
        }

        public long copy$default$1() {
            return this.size();
        }

        public VectorWithNorm copy$default$2() {
            return this.center();
        }

        public double copy$default$3() {
            return this.cost();
        }

        public String productPrefix() {
            return "ClusterSummary";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                    break;
                }
                case 1: {
                    object = this.center();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this.cost());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClusterSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.center()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cost()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClusterSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ClusterSummary clusterSummary = (ClusterSummary)x$1;
            if (this.size() != clusterSummary.size()) return false;
            VectorWithNorm vectorWithNorm = this.center();
            VectorWithNorm vectorWithNorm2 = clusterSummary.center();
            if (vectorWithNorm == null) {
                if (vectorWithNorm2 != null) {
                    return false;
                }
            } else if (!vectorWithNorm.equals(vectorWithNorm2)) return false;
            if (this.cost() != clusterSummary.cost()) return false;
            if (!clusterSummary.canEqual(this)) return false;
            return true;
        }

        public ClusterSummary(long size, VectorWithNorm center, double cost) {
            this.size = size;
            this.center = center;
            this.cost = cost;
            Product.$init$((Product)this);
        }
    }

    public static class ClusterSummaryAggregator
    implements scala.Serializable {
        private final int d;
        private final DistanceMeasure distanceMeasure;
        private long n;
        private final Vector sum;
        private double sumSq;

        public int d() {
            return this.d;
        }

        public DistanceMeasure distanceMeasure() {
            return this.distanceMeasure;
        }

        private long n() {
            return this.n;
        }

        private void n_$eq(long x$1) {
            this.n = x$1;
        }

        private Vector sum() {
            return this.sum;
        }

        private double sumSq() {
            return this.sumSq;
        }

        private void sumSq_$eq(double x$1) {
            this.sumSq = x$1;
        }

        public ClusterSummaryAggregator add(VectorWithNorm v) {
            this.n_$eq(this.n() + 1L);
            this.sumSq_$eq(this.sumSq() + v.norm() * v.norm());
            this.distanceMeasure().updateClusterSum(v, this.sum());
            return this;
        }

        public ClusterSummaryAggregator merge(ClusterSummaryAggregator other) {
            this.n_$eq(this.n() + other.n());
            this.sumSq_$eq(this.sumSq() + other.sumSq());
            this.distanceMeasure().updateClusterSum(new VectorWithNorm(other.sum()), this.sum());
            return this;
        }

        public ClusterSummary summary() {
            VectorWithNorm center = this.distanceMeasure().centroid(this.sum().copy(), this.n());
            double cost = this.distanceMeasure().clusterCost(center, new VectorWithNorm(this.sum()), this.n(), this.sumSq());
            return new ClusterSummary(this.n(), center, cost);
        }

        public ClusterSummaryAggregator(int d, DistanceMeasure distanceMeasure) {
            this.d = d;
            this.distanceMeasure = distanceMeasure;
            this.n = 0L;
            this.sum = Vectors$.MODULE$.zeros(d);
            this.sumSq = 0.0;
        }
    }
}

