/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0001\u0003\u0001\ta!AE\"mkN$XM]5oOR\u0013X-\u001a(pI\u0016T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\b\u0015\u0013\t)rB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0018\u0001\t\u0015\r\u0011\"\u0001\u001a\u0003\u0015Ig\u000eZ3y\u0007\u0001)\u0012A\u0007\t\u0003\u001dmI!\u0001H\b\u0003\u0007%sG\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0019Ig\u000eZ3yA!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011%\u0001\u0003tSj,W#\u0001\u0012\u0011\u00059\u0019\u0013B\u0001\u0013\u0010\u0005\u0011auN\\4\t\u0011\u0019\u0002!\u0011!Q\u0001\n\t\nQa]5{K\u0002B\u0011\u0002\u000b\u0001\u0003\u0006\u0004%\tAA\u0015\u0002\u001d\r,g\u000e^3s/&$\bNT8s[V\t!\u0006\u0005\u0002,Y5\t!!\u0003\u0002.\u0005\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u001f\r,g\u000e^3s/&$\bNT8s[\u0002B\u0001\"\r\u0001\u0003\u0006\u0004%\tAM\u0001\u0005G>\u001cH/F\u00014!\tqA'\u0003\u00026\u001f\t1Ai\\;cY\u0016D\u0001b\u000e\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0006G>\u001cH\u000f\t\u0005\ts\u0001\u0011)\u0019!C\u0001e\u00051\u0001.Z5hQRD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006IaM\u0001\bQ\u0016Lw\r\u001b;!\u0011!i\u0004A!b\u0001\n\u0003q\u0014\u0001C2iS2$'/\u001a8\u0016\u0003}\u00022A\u0004!C\u0013\t\tuBA\u0003BeJ\f\u0017\u0010\u0005\u0002,\u0001!AA\t\u0001B\u0001B\u0003%q(A\u0005dQ&dGM]3oA!1a\t\u0001C\u0001\u0005\u001d\u000ba\u0001P5oSRtDc\u0002\"I\u0013*[E*\u0014\u0005\u0006/\u0015\u0003\rA\u0007\u0005\u0006A\u0015\u0003\rA\t\u0005\u0006Q\u0015\u0003\rA\u000b\u0005\u0006c\u0015\u0003\ra\r\u0005\u0006s\u0015\u0003\ra\r\u0005\u0006{\u0015\u0003\ra\u0010\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0003\u0019I7\u000fT3bMV\t\u0011\u000b\u0005\u0002\u000f%&\u00111k\u0004\u0002\b\u0005>|G.Z1o\u0011\u0019)\u0006\u0001)A\u0005#\u00069\u0011n\u001d'fC\u001a\u0004\u0003\"B,\u0001\t\u0003A\u0016AB2f]R,'/F\u0001Z!\tQV,D\u0001\\\u0015\taF!\u0001\u0004mS:\fGnZ\u0005\u0003=n\u0013aAV3di>\u0014\b\"\u00021\u0001\t\u0003\t\u0017a\u00029sK\u0012L7\r\u001e\u000b\u00045\t$\u0007\"B2`\u0001\u0004I\u0016!\u00029pS:$\b\"B3`\u0001\u00041\u0017a\u00043jgR\fgnY3NK\u0006\u001cXO]3\u0011\u0005-:\u0017B\u00015\u0003\u0005=!\u0015n\u001d;b]\u000e,W*Z1tkJ,\u0007\"\u00026\u0001\t\u0003Y\u0017a\u00039sK\u0012L7\r\u001e)bi\"$2a\u00107n\u0011\u0015\u0019\u0017\u000e1\u0001Z\u0011\u0015)\u0017\u000e1\u0001g\u0011\u0015Q\u0007\u0001\"\u0003p)\r\u0001HP \t\u0004cf\u0014eB\u0001:x\u001d\t\u0019h/D\u0001u\u0015\t)\b$\u0001\u0004=e>|GOP\u0005\u0002!%\u0011\u0001pD\u0001\ba\u0006\u001c7.Y4f\u0013\tQ8P\u0001\u0003MSN$(B\u0001=\u0010\u0011\u0015ih\u000e1\u0001+\u00035\u0001x.\u001b8u/&$\bNT8s[\")QM\u001ca\u0001M\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0011aC2p[B,H/Z\"pgR$RaMA\u0003\u0003\u000fAQaY@A\u0002eCQ!Z@A\u0002\u0019Da\u0001\u0019\u0001\u0005\n\u0005-ACBA\u0007\u0003'\t)\u0002E\u0003\u000f\u0003\u001fQ2'C\u0002\u0002\u0012=\u0011a\u0001V;qY\u0016\u0014\u0004BB?\u0002\n\u0001\u0007!\u0006\u0003\u0004f\u0003\u0013\u0001\rA\u001a\u0005\u0007A\u0002!I!!\u0007\u0015\u0011\u00055\u00111DA\u000f\u0003?Aa!`A\f\u0001\u0004Q\u0003BB\u0019\u0002\u0018\u0001\u00071\u0007\u0003\u0004f\u0003/\u0001\rA\u001a\u0015\u0005\u0003/\t\u0019\u0003\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tIcD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003O\u0011q\u0001^1jYJ,7\r\u0003\u0004\u00022\u0001!\tAP\u0001\nY\u0016\fgMT8eKNDS\u0001AA\u001b\u0003\u007f\u0001B!a\u000e\u0002<5\u0011\u0011\u0011\b\u0006\u0004\u0003S1\u0011\u0002BA\u001f\u0003s\u0011QaU5oG\u0016\f#!!\u0011\u0002\u000bErcG\f\u0019")
public class ClusteringTreeNode
implements Serializable {
    private final int index;
    private final long size;
    private final VectorWithNorm centerWithNorm;
    private final double cost;
    private final double height;
    private final ClusteringTreeNode[] children;
    private final boolean isLeaf;

    public int index() {
        return this.index;
    }

    public long size() {
        return this.size;
    }

    public VectorWithNorm centerWithNorm() {
        return this.centerWithNorm;
    }

    public double cost() {
        return this.cost;
    }

    public double height() {
        return this.height;
    }

    public ClusteringTreeNode[] children() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public Vector center() {
        return this.centerWithNorm().vector();
    }

    public int predict(Vector point, DistanceMeasure distanceMeasure) {
        int index;
        Tuple2<Object, Object> tuple2 = this.predict(new VectorWithNorm(point), distanceMeasure);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int n = index = tuple2._1$mcI$sp();
        int index2 = n;
        return index2;
    }

    public ClusteringTreeNode[] predictPath(Vector point, DistanceMeasure distanceMeasure) {
        return (ClusteringTreeNode[])this.predictPath(new VectorWithNorm(point), distanceMeasure).toArray(ClassTag$.MODULE$.apply(ClusteringTreeNode.class));
    }

    private List<ClusteringTreeNode> predictPath(VectorWithNorm pointWithNorm, DistanceMeasure distanceMeasure) {
        List list;
        if (this.isLeaf()) {
            ClusteringTreeNode clusteringTreeNode = this;
            list = Nil$.MODULE$.$colon$colon((Object)clusteringTreeNode);
        } else {
            ClusteringTreeNode selected;
            ClusteringTreeNode clusteringTreeNode = selected = (ClusteringTreeNode)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.children())).minBy((Function1 & java.io.Serializable & Serializable)child -> BoxesRunTime.boxToDouble((double)distanceMeasure.distance(((ClusteringTreeNode)child).centerWithNorm(), pointWithNorm)), (Ordering)Ordering.Double$.MODULE$);
            list = selected.predictPath(pointWithNorm, distanceMeasure).$colon$colon((Object)clusteringTreeNode);
        }
        return list;
    }

    public double computeCost(Vector point, DistanceMeasure distanceMeasure) {
        double cost;
        Tuple2<Object, Object> tuple2 = this.predict(new VectorWithNorm(point), distanceMeasure);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double d = cost = tuple2._2$mcD$sp();
        double cost2 = d;
        return cost2;
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm, DistanceMeasure distanceMeasure) {
        return this.predict(pointWithNorm, distanceMeasure.cost(this.centerWithNorm(), pointWithNorm), distanceMeasure);
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm, double cost, DistanceMeasure distanceMeasure) {
        while (!this_.isLeaf()) {
            double minCost;
            Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this_.children())).map((Function1 & java.io.Serializable & Serializable)child -> new Tuple2(child, (Object)BoxesRunTime.boxToDouble((double)distanceMeasure.cost(child.centerWithNorm(), pointWithNorm))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).minBy((Function1 & java.io.Serializable & Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ClusteringTreeNode selectedChild = (ClusteringTreeNode)tuple2._1();
            double minCost2 = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)selectedChild, (Object)BoxesRunTime.boxToDouble((double)minCost2));
            Tuple2 tuple23 = tuple22;
            ClusteringTreeNode selectedChild2 = (ClusteringTreeNode)tuple23._1();
            cost = minCost = tuple23._2$mcD$sp();
            ClusteringTreeNode this_ = selectedChild2;
        }
        return new Tuple2.mcID.sp(this_.index(), cost);
    }

    public ClusteringTreeNode[] leafNodes() {
        return this.isLeaf() ? (ClusteringTreeNode[])((Object[])new ClusteringTreeNode[]{this}) : (ClusteringTreeNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.children())).flatMap((Function1 & java.io.Serializable & Serializable)x$11 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ClusteringTreeNode)x$11).leafNodes())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClusteringTreeNode.class)));
    }

    public ClusteringTreeNode(int index, long size, VectorWithNorm centerWithNorm, double cost, double height, ClusteringTreeNode[] children) {
        this.index = index;
        this.size = size;
        this.centerWithNorm = centerWithNorm;
        this.cost = cost;
        this.height = height;
        this.children = children;
        this.isLeaf = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).isEmpty();
        Predef$.MODULE$.require(this.isLeaf() && index >= 0 || !this.isLeaf() && index < 0);
    }
}

