/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}dAB\u0001\u0003\u0003\u00031ABA\bESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011a\u0002F\u0005\u0003+=\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQa\u0006\u0001\u0005\u0002e\ta\u0001P5oSRt4\u0001\u0001\u000b\u00025A\u00111\u0004A\u0007\u0002\u0005!)Q\u0004\u0001C\u0001=\u0005Ya-\u001b8e\u00072|7/Z:u)\ry\u0002&\u000f\t\u0005\u001d\u0001\u0012S%\u0003\u0002\"\u001f\t1A+\u001e9mKJ\u0002\"AD\u0012\n\u0005\u0011z!aA%oiB\u0011aBJ\u0005\u0003O=\u0011a\u0001R8vE2,\u0007\"B\u0015\u001d\u0001\u0004Q\u0013aB2f]R,'o\u001d\t\u0004WM2dB\u0001\u00172\u001d\ti\u0003'D\u0001/\u0015\ty\u0003$\u0001\u0004=e>|GOP\u0005\u0002!%\u0011!gD\u0001\ba\u0006\u001c7.Y4f\u0013\t!TGA\bUe\u00064XM]:bE2,wJ\\2f\u0015\t\u0011t\u0002\u0005\u0002\u001co%\u0011\u0001H\u0001\u0002\u000f-\u0016\u001cGo\u001c:XSRDgj\u001c:n\u0011\u0015QD\u00041\u00017\u0003\u0015\u0001x.\u001b8u\u0011\u0015a\u0004\u0001\"\u0001>\u0003%\u0001x.\u001b8u\u0007>\u001cH\u000fF\u0002&}}BQ!K\u001eA\u0002)BQAO\u001eA\u0002YBQ!\u0011\u0001\u0005\u0002\t\u000b\u0011#[:DK:$XM]\"p]Z,'oZ3e)\u0011\u0019e\t\u0013&\u0011\u00059!\u0015BA#\u0010\u0005\u001d\u0011un\u001c7fC:DQa\u0012!A\u0002Y\n\u0011b\u001c7e\u0007\u0016tG/\u001a:\t\u000b%\u0003\u0005\u0019\u0001\u001c\u0002\u00139,woQ3oi\u0016\u0014\b\"B&A\u0001\u0004)\u0013aB3qg&dwN\u001c\u0005\u0006\u001b\u00021\tAT\u0001\tI&\u001cH/\u00198dKR\u0019QeT)\t\u000bAc\u0005\u0019\u0001\u001c\u0002\u0005Y\f\u0004\"\u0002*M\u0001\u00041\u0014A\u0001<3\u0011\u0015!\u0006A\"\u0001V\u0003-\u0019G.^:uKJ\u001cun\u001d;\u0015\u000b\u00152\u0006LW0\t\u000b]\u001b\u0006\u0019\u0001\u001c\u0002\u0011\r,g\u000e\u001e:pS\u0012DQ!W*A\u0002Y\n\u0011\u0002]8j]R\u001c8+^7\t\u000bm\u001b\u0006\u0019\u0001/\u0002\u001d9,XNY3s\u001f\u001a\u0004v.\u001b8ugB\u0011a\"X\u0005\u0003=>\u0011A\u0001T8oO\")\u0001m\u0015a\u0001K\u0005\t\u0002o\\5oiN\u001c\u0016/^1sK\u0012tuN]7\t\u000b\t\u0004A\u0011A2\u0002!U\u0004H-\u0019;f\u00072,8\u000f^3s'VlGc\u00013hQB\u0011a\"Z\u0005\u0003M>\u0011A!\u00168ji\")!(\u0019a\u0001m!)\u0011.\u0019a\u0001U\u0006\u00191/^7\u0011\u0005-tW\"\u00017\u000b\u00055$\u0011A\u00027j]\u0006dw-\u0003\u0002pY\n1a+Z2u_JDQa\u0016\u0001\u0005\u0002E$2A\u000e:t\u0011\u0015I\u0007\u000f1\u0001k\u0011\u0015!\b\u000f1\u0001]\u0003\u0015\u0019w.\u001e8u\u0011\u00151\b\u0001\"\u0001x\u0003I\u0019\u00180\\7fiJL7mQ3oiJ|\u0017\u000eZ:\u0015\taL80 \t\u0005\u001d\u00012d\u0007C\u0003{k\u0002\u0007Q%A\u0003mKZ,G\u000eC\u0003}k\u0002\u0007!.A\u0003o_&\u001cX\rC\u0003Xk\u0002\u0007!\u000e\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0005G>\u001cH\u000fF\u0003&\u0003\u0007\t)\u0001C\u0003;}\u0002\u0007a\u0007C\u0003X}\u0002\u0007agB\u0004\u0002\n\tA\t!a\u0003\u0002\u001f\u0011K7\u000f^1oG\u0016lU-Y:ve\u0016\u00042aGA\u0007\r\u0019\t!\u0001#\u0001\u0002\u0010M!\u0011QB\u0007\u0014\u0011\u001d9\u0012Q\u0002C\u0001\u0003'!\"!a\u0003\t\u0015\u0005]\u0011Q\u0002b\u0001\n\u0003\tI\"A\u0005F+\u000ec\u0015\nR#B\u001dV\u0011\u00111\u0004\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002 \t11\u000b\u001e:j]\u001eDc!!\u0006\u0002.\u0005e\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005Mb!\u0001\u0006b]:|G/\u0019;j_:LA!a\u000e\u00022\t)1+\u001b8dK\u0006\u0012\u00111H\u0001\u0006e9\"d\u0006\r\u0005\n\u0003\u007f\ti\u0001)A\u0005\u00037\t!\"R+D\u0019&#U)\u0011(!Q\u0019\ti$!\f\u0002:!Q\u0011QIA\u0007\u0005\u0004%\t!!\u0007\u0002\r\r{5+\u0013(FQ\u0019\t\u0019%!\f\u0002:!I\u00111JA\u0007A\u0003%\u00111D\u0001\b\u0007>\u001b\u0016JT#!Q\u0019\tI%!\f\u0002:!I\u0011\u0011KA\u0007\t\u00031\u00111K\u0001\u0011I\u0016\u001cw\u000eZ3Ge>l7\u000b\u001e:j]\u001e$2AGA+\u0011!\t9&a\u0014A\u0002\u0005e\u0013a\u00043jgR\fgnY3NK\u0006\u001cXO]3\u0011\t\u0005m\u00131\r\b\u0005\u0003;\ny\u0006\u0005\u0002.\u001f%\u0019\u0011\u0011M\b\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#!\u001a\u000b\u0007\u0005\u0005t\u0002C\u0005\u0002j\u00055A\u0011\u0001\u0004\u0002l\u00059b/\u00197jI\u0006$X\rR5ti\u0006t7-Z'fCN,(/\u001a\u000b\u0004\u0007\u00065\u0004\u0002CA,\u0003O\u0002\r!!\u0017\t\u0015\u0005E\u0014QBA\u0001\n\u0013\t\u0019(A\u0006sK\u0006$'+Z:pYZ,GCAA;!\u0011\ti\"a\u001e\n\t\u0005e\u0014q\u0004\u0002\u0007\u001f\nTWm\u0019;)\r\u00055\u0011QFA\u001dQ\u0019\t9!!\f\u0002:\u0001")
public abstract class DistanceMeasure
implements Serializable {
    public static String COSINE() {
        return DistanceMeasure$.MODULE$.COSINE();
    }

    public static String EUCLIDEAN() {
        return DistanceMeasure$.MODULE$.EUCLIDEAN();
    }

    public Tuple2<Object, Object> findClosest(TraversableOnce<VectorWithNorm> centers, VectorWithNorm point) {
        DoubleRef bestDistance = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        IntRef bestIndex = IntRef.create((int)0);
        IntRef i = IntRef.create((int)0);
        centers.foreach((Function1 & java.io.Serializable & Serializable)center -> {
            DistanceMeasure.$anonfun$findClosest$1(this, point, bestDistance, bestIndex, i, center);
            return BoxedUnit.UNIT;
        });
        return new Tuple2.mcID.sp(bestIndex.elem, bestDistance.elem);
    }

    public double pointCost(TraversableOnce<VectorWithNorm> centers, VectorWithNorm point) {
        return this.findClosest(centers, point)._2$mcD$sp();
    }

    public boolean isCenterConverged(VectorWithNorm oldCenter, VectorWithNorm newCenter, double epsilon) {
        return this.distance(oldCenter, newCenter) <= epsilon;
    }

    public abstract double distance(VectorWithNorm var1, VectorWithNorm var2);

    public abstract double clusterCost(VectorWithNorm var1, VectorWithNorm var2, long var3, double var5);

    public void updateClusterSum(VectorWithNorm point, Vector sum) {
        BLAS$.MODULE$.axpy(1.0, point.vector(), sum);
    }

    public VectorWithNorm centroid(Vector sum, long count) {
        BLAS$.MODULE$.scal(1.0 / (double)count, sum);
        return new VectorWithNorm(sum);
    }

    public Tuple2<VectorWithNorm, VectorWithNorm> symmetricCentroids(double level, Vector noise, Vector centroid) {
        Vector left = centroid.copy();
        BLAS$.MODULE$.axpy(-level, noise, left);
        Vector right = centroid.copy();
        BLAS$.MODULE$.axpy(level, noise, right);
        return new Tuple2((Object)new VectorWithNorm(left), (Object)new VectorWithNorm(right));
    }

    public double cost(VectorWithNorm point, VectorWithNorm centroid) {
        return this.distance(point, centroid);
    }

    public static final /* synthetic */ void $anonfun$findClosest$1(DistanceMeasure $this, VectorWithNorm point$1, DoubleRef bestDistance$1, IntRef bestIndex$1, IntRef i$1, VectorWithNorm center) {
        double currentDistance = $this.distance(center, point$1);
        if (currentDistance < bestDistance$1.elem) {
            bestDistance$1.elem = currentDistance;
            bestIndex$1.elem = i$1.elem;
        }
        ++i$1.elem;
    }
}

