/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.NumericOps;
import breeze.linalg.normalize$;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.util.PeriodicGraphCheckpointer;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDA$;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u00055\u0011a\"R'M\t\u0006{\u0005\u000f^5nSj,'O\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0007M\t\u0006{\u0005\u000f^5nSj,'\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011Q\u0003\u0001\u0005\b;\u0001\u0001\r\u0011\"\u0003\u001f\u0003IYW-\u001a9MCN$8\t[3dWB|\u0017N\u001c;\u0016\u0003}\u0001\"a\u0004\u0011\n\u0005\u0005\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\bG\u0001\u0001\r\u0011\"\u0003%\u0003YYW-\u001a9MCN$8\t[3dWB|\u0017N\u001c;`I\u0015\fHCA\u0013)!\tya%\u0003\u0002(!\t!QK\\5u\u0011\u001dI#%!AA\u0002}\t1\u0001\u001f\u00132\u0011\u0019Y\u0003\u0001)Q\u0005?\u0005\u00192.Z3q\u0019\u0006\u001cHo\u00115fG.\u0004x.\u001b8uA!)Q\u0006\u0001C\u0001=\u0005)r-\u001a;LK\u0016\u0004H*Y:u\u0007\",7m\u001b9pS:$\bf\u0001\u00170kA\u0011\u0001gM\u0007\u0002c)\u0011!GB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u001b2\u0005\u0015\u0019\u0016N\\2fC\u00051\u0014!\u0002\u001a/a9\u0002\u0004\"\u0002\u001d\u0001\t\u0003I\u0014!F:fi.+W\r\u001d'bgR\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\u0003umj\u0011\u0001\u0001\u0005\u0006;]\u0002\ra\b\u0015\u0004o=*\u0004\u0002\u0003 \u0001\u0001\u0004%\tAA \u0002\u000b\u001d\u0014\u0018\r\u001d5\u0016\u0003\u0001\u0003B!\u0011#G\u001b6\t!I\u0003\u0002D\r\u00051qM]1qQbL!!\u0012\"\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0011\u0005\u001dSeBA\u000bI\u0013\tI%!A\u0002M\t\u0006K!a\u0013'\u0003\u0017Q{\u0007/[2D_VtGo\u001d\u0006\u0003\u0013\n\u0001\"a\u0012(\n\u0005=c%A\u0003+pW\u0016t7i\\;oi\"A\u0011\u000b\u0001a\u0001\n\u0003\u0011!+A\u0005he\u0006\u0004\bn\u0018\u0013fcR\u0011Qe\u0015\u0005\bSA\u000b\t\u00111\u0001A\u0011\u0019)\u0006\u0001)Q\u0005\u0001\u00061qM]1qQ\u0002B\u0001b\u0016\u0001A\u0002\u0013\u0005!\u0001W\u0001\u0002WV\t\u0011\f\u0005\u0002\u00105&\u00111\f\u0005\u0002\u0004\u0013:$\b\u0002C/\u0001\u0001\u0004%\tA\u00010\u0002\u000b-|F%Z9\u0015\u0005\u0015z\u0006bB\u0015]\u0003\u0003\u0005\r!\u0017\u0005\u0007C\u0002\u0001\u000b\u0015B-\u0002\u0005-\u0004\u0003\u0002C2\u0001\u0001\u0004%\tA\u0001-\u0002\u0013Y|7-\u00192TSj,\u0007\u0002C3\u0001\u0001\u0004%\tA\u00014\u0002\u001bY|7-\u00192TSj,w\fJ3r)\t)s\rC\u0004*I\u0006\u0005\t\u0019A-\t\r%\u0004\u0001\u0015)\u0003Z\u0003)1xnY1c'&TX\r\t\u0005\tW\u0002\u0001\r\u0011\"\u0001\u0003Y\u0006\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002[B\u0011qB\\\u0005\u0003_B\u0011a\u0001R8vE2,\u0007\u0002C9\u0001\u0001\u0004%\tA\u0001:\u0002)\u0011|7mQ8oG\u0016tGO]1uS>tw\fJ3r)\t)3\u000fC\u0004*a\u0006\u0005\t\u0019A7\t\rU\u0004\u0001\u0015)\u0003n\u0003E!wnY\"p]\u000e,g\u000e\u001e:bi&|g\u000e\t\u0005\to\u0002\u0001\r\u0011\"\u0001\u0003Y\u0006\u0011Bo\u001c9jG\u000e{gnY3oiJ\fG/[8o\u0011!I\b\u00011A\u0005\u0002\tQ\u0018A\u0006;pa&\u001c7i\u001c8dK:$(/\u0019;j_:|F%Z9\u0015\u0005\u0015Z\bbB\u0015y\u0003\u0003\u0005\r!\u001c\u0005\u0007{\u0002\u0001\u000b\u0015B7\u0002'Q|\u0007/[2D_:\u001cWM\u001c;sCRLwN\u001c\u0011\t\u0011}\u0004\u0001\u0019!C\u0001\u0005a\u000b!c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY\"Q\u00111\u0001\u0001A\u0002\u0013\u0005!!!\u0002\u0002-\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\0%KF$2!JA\u0004\u0011!I\u0013\u0011AA\u0001\u0002\u0004I\u0006bBA\u0006\u0001\u0001\u0006K!W\u0001\u0014G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\t\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0005\u0003#\t\u0011c\u001a:ba\"\u001c\u0005.Z2la>Lg\u000e^3s+\t\t\u0019\u0002\u0005\u0004\u0002\u0016\u0005ma)T\u0007\u0003\u0003/Q1!!\u0007C\u0003\u0011)H/\u001b7\n\t\u0005u\u0011q\u0003\u0002\u001a!\u0016\u0014\u0018n\u001c3jG\u001e\u0013\u0018\r\u001d5DQ\u0016\u001c7\u000e]8j]R,'\u000fC\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$\u0005)rM]1qQ\u000eCWmY6q_&tG/\u001a:`I\u0015\fHcA\u0013\u0002&!I\u0011&a\b\u0002\u0002\u0003\u0007\u00111\u0003\u0005\t\u0003S\u0001\u0001\u0015)\u0003\u0002\u0014\u0005\u0011rM]1qQ\u000eCWmY6q_&tG/\u001a:!\u0011!\ti\u0003\u0001C!\u0005\u0005=\u0012AC5oSRL\u0017\r\\5{KR)1$!\r\u0002Z!A\u00111GA\u0016\u0001\u0004\t)$\u0001\u0003e_\u000e\u001c\bCBA\u001c\u0003{\t\t%\u0004\u0002\u0002:)\u0019\u00111\b\u0004\u0002\u0007I$G-\u0003\u0003\u0002@\u0005e\"a\u0001*E\tB9q\"a\u0011\u0002H\u00055\u0013bAA#!\t1A+\u001e9mKJ\u00022aDA%\u0013\r\tY\u0005\u0005\u0002\u0005\u0019>tw\r\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019\u0006B\u0001\u0007Y&t\u0017\r\\4\n\t\u0005]\u0013\u0011\u000b\u0002\u0007-\u0016\u001cGo\u001c:\t\u0011\u0005m\u00131\u0006a\u0001\u0003;\n1\u0001\u001c3b!\r)\u0012qL\u0005\u0004\u0003C\u0012!a\u0001'E\u0003\"9\u0011Q\r\u0001\u0005B\tQ\u0012\u0001\u00028fqRD!\"!\u001b\u0001\u0001\u0004%\tAAA6\u0003E9Gn\u001c2bYR{\u0007/[2U_R\fGn]\u000b\u0002\r\"Q\u0011q\u000e\u0001A\u0002\u0013\u0005!!!\u001d\u0002+\u001ddwNY1m)>\u0004\u0018n\u0019+pi\u0006d7o\u0018\u0013fcR\u0019Q%a\u001d\t\u0011%\ni'!AA\u0002\u0019Cq!a\u001e\u0001A\u0003&a)\u0001\nhY>\u0014\u0017\r\u001c+pa&\u001cGk\u001c;bYN\u0004\u0003bBA>\u0001\u0011%\u0011QP\u0001\u0019G>l\u0007/\u001e;f\u000f2|'-\u00197U_BL7\rV8uC2\u001cH#\u0001$\t\u0011\u0005\u0005\u0005\u0001\"\u0011\u0003\u0003\u0007\u000b1bZ3u\u0019\u0012\u000bUj\u001c3fYR!\u0011QQAF!\r)\u0012qQ\u0005\u0004\u0003\u0013\u0013!\u0001\u0003'E\u00036{G-\u001a7\t\u0011\u00055\u0015q\u0010a\u0001\u0003\u001f\u000ba\"\u001b;fe\u0006$\u0018n\u001c8US6,7\u000f\u0005\u0003\u0010\u0003#k\u0017bAAJ!\t)\u0011I\u001d:bs\"\u001a\u0001!a&\u0011\u0007A\nI*C\u0002\u0002\u001cF\u0012A\u0002R3wK2|\u0007/\u001a:Ba&DC\u0001A\u0018\u0002 \u0006\u0012\u0011\u0011U\u0001\u0006c9\"d\u0006\r")
public final class EMLDAOptimizer
implements LDAOptimizer {
    private boolean keepLastCheckpoint = true;
    private Graph<DenseVector<Object>, Object> graph = null;
    private int k = 0;
    private int vocabSize = 0;
    private double docConcentration = 0.0;
    private double topicConcentration = 0.0;
    private int checkpointInterval = 10;
    private PeriodicGraphCheckpointer<DenseVector<Object>, Object> graphCheckpointer = null;
    private DenseVector<Object> globalTopicTotals = null;

    private boolean keepLastCheckpoint() {
        return this.keepLastCheckpoint;
    }

    private void keepLastCheckpoint_$eq(boolean x$1) {
        this.keepLastCheckpoint = x$1;
    }

    public boolean getKeepLastCheckpoint() {
        return this.keepLastCheckpoint();
    }

    public EMLDAOptimizer setKeepLastCheckpoint(boolean keepLastCheckpoint) {
        this.keepLastCheckpoint_$eq(keepLastCheckpoint);
        return this;
    }

    public Graph<DenseVector<Object>, Object> graph() {
        return this.graph;
    }

    public void graph_$eq(Graph<DenseVector<Object>, Object> x$1) {
        this.graph = x$1;
    }

    public int k() {
        return this.k;
    }

    public void k_$eq(int x$1) {
        this.k = x$1;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    public double docConcentration() {
        return this.docConcentration;
    }

    public void docConcentration_$eq(double x$1) {
        this.docConcentration = x$1;
    }

    public double topicConcentration() {
        return this.topicConcentration;
    }

    public void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    public void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    private PeriodicGraphCheckpointer<DenseVector<Object>, Object> graphCheckpointer() {
        return this.graphCheckpointer;
    }

    private void graphCheckpointer_$eq(PeriodicGraphCheckpointer<DenseVector<Object>, Object> x$1) {
        this.graphCheckpointer = x$1;
    }

    @Override
    public EMLDAOptimizer initialize(RDD<Tuple2<Object, Vector>> docs, LDA lda) {
        double docConcentration = lda.getDocConcentration();
        double topicConcentration = lda.getTopicConcentration();
        int k = lda.getK();
        Predef$.MODULE$.require(docConcentration > 1.0 || docConcentration == -1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("LDA docConcentration must be").append(new StringBuilder(57).append(" > 1.0 (or -1 for auto) for EM Optimizer, but was set to ").append(docConcentration).toString()).toString());
        Predef$.MODULE$.require(topicConcentration > 1.0 || topicConcentration == -1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("LDA topicConcentration ").append(new StringBuilder(64).append("must be > 1.0 (or -1 for auto) for EM Optimizer, but was set to ").append(topicConcentration).toString()).toString());
        this.docConcentration_$eq(docConcentration == (double)-1 ? 50.0 / (double)k + 1.0 : docConcentration);
        this.topicConcentration_$eq(topicConcentration == (double)-1 ? 1.1 : topicConcentration);
        long randomSeed = lda.getSeed();
        RDD edges = docs.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            long l;
            Vector termCounts;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    long docID = tuple2._1$mcJ$sp();
                    termCounts = (Vector)tuple2._2();
                    l = docID;
                    if (termCounts != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Vector vector = termCounts;
            Iterator iterator = vector.asBreeze().activeIterator().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EMLDAOptimizer.$anonfun$initialize$4(x$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int term = tuple2._1$mcI$sp();
                double cnt = tuple2._2$mcD$sp();
                Edge.mcD.sp sp2 = new Edge.mcD.sp(l, LDA$.MODULE$.term2index(term), cnt);
                return sp2;
            });
            return iterator;
        }, ClassTag$.MODULE$.apply(Edge.class));
        RDD verticesTMP = edges.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> EMLDAOptimizer.$anonfun$initialize$6(k, randomSeed, BoxesRunTime.unboxToInt((Object)x0$3), x1$1), edges.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD docTermVertices = RDD$.MODULE$.rddToPairRDDFunctions(verticesTMP, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class), (Ordering)Ordering.Long$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (DenseVector)x$2.$plus(x$3, DenseVector$.MODULE$.canAddD()));
        this.graph_$eq((Graph<DenseVector<Object>, Object>)Graph$.MODULE$.apply(docTermVertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(DenseVector.class), ClassTag$.MODULE$.apply(Double.TYPE)).partitionBy((PartitionStrategy)PartitionStrategy.EdgePartition1D$.MODULE$));
        this.k_$eq(k);
        this.vocabSize_$eq(((Vector)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])docs.take(1))).head())._2()).size());
        this.checkpointInterval_$eq(lda.getCheckpointInterval());
        this.graphCheckpointer_$eq((PeriodicGraphCheckpointer<DenseVector<Object>, Object>)new PeriodicGraphCheckpointer(this.checkpointInterval(), this.graph().vertices().sparkContext()));
        this.graphCheckpointer().update(this.graph());
        this.globalTopicTotals_$eq(this.computeGlobalTopicTotals());
        return this;
    }

    @Override
    public EMLDAOptimizer next() {
        Predef$.MODULE$.require(this.graph() != null, (Function0 & Serializable & scala.Serializable)() -> "graph is null, EMLDAOptimizer not initialized.");
        double eta = this.topicConcentration();
        int W = this.vocabSize();
        double alpha = this.docConcentration();
        DenseVector<Object> N_k = this.globalTopicTotals();
        Function1 & Serializable & scala.Serializable sendMsg = (Function1 & Serializable & scala.Serializable)edgeContext -> {
            EMLDAOptimizer.$anonfun$next$2(eta, W, alpha, N_k, edgeContext);
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable mergeMsg = (Function2 & Serializable & scala.Serializable)(m0, m1) -> {
            DenseVector sum = m0._1$mcZ$sp() ? (DenseVector)((NumericOps)m0._2()).$plus$eq(m1._2(), DenseVector$.MODULE$.canAddIntoD()) : (m1._1$mcZ$sp() ? (DenseVector)((NumericOps)m1._2()).$plus$eq(m0._2(), DenseVector$.MODULE$.canAddIntoD()) : (DenseVector)((NumericOps)m0._2()).$plus(m1._2(), DenseVector$.MODULE$.canAddD()));
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)sum);
        };
        Graph<DenseVector<Object>, Object> qual$1 = this.graph();
        Function1 & Serializable & scala.Serializable x$15 = sendMsg;
        Function2 & Serializable & scala.Serializable x$16 = mergeMsg;
        TripletFields x$17 = qual$1.aggregateMessages$default$3();
        VertexRDD docTopicDistributions = qual$1.aggregateMessages((Function1)x$15, (Function2)x$16, x$17, ClassTag$.MODULE$.apply(Tuple2.class)).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> (DenseVector)x$4._2(), ClassTag$.MODULE$.apply(DenseVector.class));
        Graph newGraph = Graph$.MODULE$.apply((RDD)docTopicDistributions, (RDD)this.graph().edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(DenseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
        this.graph_$eq((Graph<DenseVector<Object>, Object>)newGraph);
        this.graphCheckpointer().update((Object)newGraph);
        this.globalTopicTotals_$eq(this.computeGlobalTopicTotals());
        return this;
    }

    public DenseVector<Object> globalTopicTotals() {
        return this.globalTopicTotals;
    }

    public void globalTopicTotals_$eq(DenseVector<Object> x$1) {
        this.globalTopicTotals = x$1;
    }

    private DenseVector<Object> computeGlobalTopicTotals() {
        int numTopics = this.k();
        return (DenseVector)RDD$.MODULE$.rddToPairRDDFunctions((RDD)this.graph().vertices().filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)LDA$.MODULE$.isTermVertex(v))), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class), (Ordering)Ordering.Long$.MODULE$).values().fold((Object)DenseVector$.MODULE$.zeros$mDc$sp(numTopics, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> (DenseVector)x$5.$plus$eq(x$6, DenseVector$.MODULE$.canAddIntoD()));
    }

    @Override
    public LDAModel getLDAModel(double[] iterationTimes) {
        String[] stringArray;
        Predef$.MODULE$.require(this.graph() != null, (Function0 & Serializable & scala.Serializable)() -> "graph is null, EMLDAOptimizer not initialized.");
        if (this.keepLastCheckpoint()) {
            this.graphCheckpointer().deleteAllCheckpointsButLast();
            stringArray = this.graphCheckpointer().getAllCheckpointFiles();
        } else {
            this.graphCheckpointer().deleteAllCheckpoints();
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        String[] checkpointFiles = stringArray;
        return new DistributedLDAModel(this.graph(), this.globalTopicTotals(), this.k(), this.vocabSize(), Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> this.docConcentration(), ClassTag$.MODULE$.Double())), this.topicConcentration(), iterationTimes, DistributedLDAModel$.MODULE$.defaultGammaShape(), checkpointFiles);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$4(Tuple2 x$1) {
        return x$1._2$mcD$sp() != 0.0;
    }

    public static final /* synthetic */ Iterator $anonfun$initialize$6(int k$1, long randomSeed$1, int x0$3, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int partIndex = tuple2._1$mcI$sp();
        Iterator partEdges = (Iterator)tuple2._2();
        Random random = new Random((long)partIndex + randomSeed$1);
        Iterator iterator = partEdges.flatMap((Function1 & Serializable & scala.Serializable)edge -> {
            DenseVector gamma = (DenseVector)normalize$.MODULE$.apply((Object)DenseVector$.MODULE$.fill(k$1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random.nextDouble(), ClassTag$.MODULE$.Double()), (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
            DenseVector sum = (DenseVector)gamma.$times((Object)BoxesRunTime.boxToDouble((double)edge.attr$mcD$sp()), DenseVector$.MODULE$.dv_s_Op_Double_OpMulMatrix());
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.srcId()), (Object)sum), new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.dstId()), (Object)sum)}));
        });
        return iterator;
    }

    public static final /* synthetic */ void $anonfun$next$2(double eta$1, int W$1, double alpha$1, DenseVector N_k$1, EdgeContext edgeContext) {
        double N_wj = BoxesRunTime.unboxToDouble((Object)edgeContext.attr());
        DenseVector scaledTopicDistribution = (DenseVector)LDA$.MODULE$.computePTopic((DenseVector<Object>)((DenseVector)edgeContext.srcAttr()), (DenseVector<Object>)((DenseVector)edgeContext.dstAttr()), (DenseVector<Object>)N_k$1, W$1, eta$1, alpha$1).$times$eq((Object)BoxesRunTime.boxToDouble((double)N_wj), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpMulScalar());
        edgeContext.sendToDst((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)scaledTopicDistribution));
        edgeContext.sendToSrc((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)scaledTopicDistribution));
    }
}

