/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.mllib.clustering.ExpectationSum;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ExpectationSum$
implements scala.Serializable {
    public static ExpectationSum$ MODULE$;

    static {
        new ExpectationSum$();
    }

    public ExpectationSum zero(int k, int d) {
        return new ExpectationSum(0.0, (double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()), (DenseVector[])Array$.MODULE$.fill(k, (Function0 & Serializable & scala.Serializable)() -> DenseVector$.MODULE$.zeros$mDc$sp(d, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), ClassTag$.MODULE$.apply(DenseVector.class)), (DenseMatrix[])Array$.MODULE$.fill(k, (Function0 & Serializable & scala.Serializable)() -> DenseMatrix$.MODULE$.zeros$mDc$sp(d, d, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), ClassTag$.MODULE$.apply(DenseMatrix.class)));
    }

    public ExpectationSum add(double[] weights, MultivariateGaussian[] dists, ExpectationSum sums, Vector<Object> x) {
        double[] p = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dists), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)ExpectationSum$.$anonfun$add$1(x, x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double pSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        sums.logLikelihood_$eq(sums.logLikelihood() + package$.MODULE$.log(pSum));
        for (int i = 0; i < sums.k(); ++i) {
            int n = i;
            p[n] = p[n] / pSum;
            int n2 = i;
            sums.weights()[n2] = sums.weights()[n2] + p[i];
            sums.means()[i].$plus$eq(x.$times((Object)BoxesRunTime.boxToDouble((double)p[i]), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
            BLAS$.MODULE$.syr(p[i], Vectors$.MODULE$.fromBreeze(x), (org.apache.spark.mllib.linalg.DenseMatrix)Matrices$.MODULE$.fromBreeze((Matrix<Object>)sums.sigmas()[i]));
        }
        return sums;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ double $anonfun$add$1(Vector x$11, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double weight = tuple2._1$mcD$sp();
        MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
        double d = MLUtils$.MODULE$.EPSILON() + weight * dist.pdf((Vector<Object>)x$11);
        return d;
    }

    private ExpectationSum$() {
        MODULE$ = this;
    }
}

