/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}g\u0001B\u0001\u0003\u00015\u0011AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d'BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001dG\u0007\u00023)\u0011!\u0004B\u0001\u0005kRLG.\u0003\u0002\u001d3\tA1+\u0019<fC\ndW\r\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0001 \u0003\u001d9X-[4iiN,\u0012\u0001\t\t\u0004\u001f\u0005\u001a\u0013B\u0001\u0012\u0011\u0005\u0015\t%O]1z!\tyA%\u0003\u0002&!\t1Ai\\;cY\u0016D3!H\u0014.!\tA3&D\u0001*\u0015\tQc!\u0001\u0006b]:|G/\u0019;j_:L!\u0001L\u0015\u0003\u000bMKgnY3\"\u00039\nQ!\r\u00184]AB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\to\u0016Lw\r\u001b;tA!\u001aqfJ\u0017\t\u0011M\u0002!Q1A\u0005\u0002Q\n\u0011bZ1vgNL\u0017M\\:\u0016\u0003U\u00022aD\u00117!\t9D(D\u00019\u0015\tI$(\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002<\t\u0005!1\u000f^1u\u0013\ti\u0004H\u0001\u000bNk2$\u0018N^1sS\u0006$XmR1vgNL\u0017M\u001c\u0015\u0004e\u001dj\u0003\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u0015\u001d\fWo]:jC:\u001c\b\u0005K\u0002@O5BQa\u0011\u0001\u0005\u0002\u0011\u000ba\u0001P5oSRtDcA#H\u0013B\u0011a\tA\u0007\u0002\u0005!)aD\u0011a\u0001A!\u001aqiJ\u0017\t\u000bM\u0012\u0005\u0019A\u001b)\u0007%;S\u0006K\u0002CO5BQ!\u0014\u0001\u0005R9\u000bQBZ8s[\u0006$h+\u001a:tS>tW#A(\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016\u0001\u00027b]\u001eT\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u0002W#\n11\u000b\u001e:j]\u001eDQ\u0001\u0017\u0001\u0005Be\u000bAa]1wKR\u0019!,X2\u0011\u0005=Y\u0016B\u0001/\u0011\u0005\u0011)f.\u001b;\t\u000by;\u0006\u0019A0\u0002\u0005M\u001c\u0007C\u00011b\u001b\u00051\u0011B\u00012\u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015!w\u000b1\u0001f\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005\u0019lgBA4l!\tA\u0007#D\u0001j\u0015\tQG\"\u0001\u0004=e>|GOP\u0005\u0003YB\ta\u0001\u0015:fI\u00164\u0017B\u0001,o\u0015\ta\u0007\u0003K\u0002XOA\f\u0013!]\u0001\u0006c9\"d\u0006\r\u0005\u0006g\u0002!\t\u0001^\u0001\u0002WV\tQ\u000f\u0005\u0002\u0010m&\u0011q\u000f\u0005\u0002\u0004\u0013:$\bf\u0001:([!)!\u0010\u0001C\u0001w\u00069\u0001O]3eS\u000e$Hc\u0001?\u0002\u0006A!Q0!\u0001v\u001b\u0005q(BA@\u0007\u0003\r\u0011H\rZ\u0005\u0004\u0003\u0007q(a\u0001*E\t\"9\u0011qA=A\u0002\u0005%\u0011A\u00029pS:$8\u000fE\u0003~\u0003\u0003\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002B\u0001\u0007Y&t\u0017\r\\4\n\t\u0005U\u0011q\u0002\u0002\u0007-\u0016\u001cGo\u001c:)\u0007e<S\u0006\u0003\u0004{\u0001\u0011\u0005\u00111\u0004\u000b\u0004k\u0006u\u0001\u0002CA\u0010\u00033\u0001\r!a\u0003\u0002\u000bA|\u0017N\u001c;)\u000b\u0005eq%a\t\"\u0005\u0005\u0015\u0012!B\u0019/k9\u0002\u0004B\u0002>\u0001\t\u0003\tI\u0003\u0006\u0003\u0002,\u0005}\u0002CBA\u0017\u0003k\tI$\u0004\u0002\u00020)\u0019A+!\r\u000b\u0007\u0005Mb!A\u0002ba&LA!a\u000e\u00020\t9!*\u0019<b%\u0012#\u0005c\u0001)\u0002<%\u0019\u0011QH)\u0003\u000f%sG/Z4fe\"A\u0011qAA\u0014\u0001\u0004\t\t\u0005\u0005\u0004\u0002.\u0005U\u00121\u0002\u0015\u0005\u0003O9\u0003\u000fC\u0004\u0002H\u0001!\t!!\u0013\u0002\u0017A\u0014X\rZ5diN{g\r\u001e\u000b\u0005\u0003\u0017\ni\u0005\u0005\u0003~\u0003\u0003\u0001\u0003\u0002CA\u0004\u0003\u000b\u0002\r!!\u0003)\t\u0005\u0015s%\f\u0005\b\u0003\u000f\u0002A\u0011AA*)\r\u0001\u0013Q\u000b\u0005\t\u0003?\t\t\u00061\u0001\u0002\f!\"\u0011\u0011K\u0014q\u0011\u001d\tY\u0006\u0001C\u0005\u0003;\nacY8naV$XmU8gi\u0006\u001b8/[4o[\u0016tGo\u001d\u000b\nA\u0005}\u0013\u0011OA;\u0003oB\u0001\"!\u0019\u0002Z\u0001\u0007\u00111M\u0001\u0003aR\u0004R!!\u001a\u0002n\rj!!a\u001a\u000b\t\u0005E\u0011\u0011\u000e\u0006\u0003\u0003W\naA\u0019:fKj,\u0017\u0002BA8\u0003O\u00121\u0002R3og\u00164Vm\u0019;pe\"9\u00111OA-\u0001\u0004)\u0014!\u00023jgR\u001c\bB\u0002\u0010\u0002Z\u0001\u0007\u0001\u0005\u0003\u0004t\u00033\u0002\r!\u001e\u0015\u0004\u0001\u001djsaBA?\u0005!\u0005\u0011qP\u0001\u0015\u000f\u0006,8o]5b]6K\u0007\u0010^;sK6{G-\u001a7\u0011\u0007\u0019\u000b\tI\u0002\u0004\u0002\u0005!\u0005\u00111Q\n\u0007\u0003\u0003s\u0011Q\u0011\u000b\u0011\ta\t9)R\u0005\u0004\u0003\u0013K\"A\u0002'pC\u0012,'\u000fC\u0004D\u0003\u0003#\t!!$\u0015\u0005\u0005}t\u0001CAI\u0003\u0003CI!a%\u0002\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0011\t\u0005U\u0015qS\u0007\u0003\u0003\u00033\u0001\"!'\u0002\u0002\"%\u00111\u0014\u0002\r'\u00064X\rT8bIZ\u000bt\fM\n\u0004\u0003/s\u0001bB\"\u0002\u0018\u0012\u0005\u0011q\u0014\u000b\u0003\u0003'3q!a)\u0002\u0018\u0002\u000b)K\u0001\u0003ECR\f7CBAQ\u001d\u0005\u001dF\u0003E\u0002\u0010\u0003SK1!a+\u0011\u0005\u001d\u0001&o\u001c3vGRD1\"a,\u0002\"\nU\r\u0011\"\u0001\u00022\u00061q/Z5hQR,\u0012a\t\u0005\u000b\u0003k\u000b\tK!E!\u0002\u0013\u0019\u0013aB<fS\u001eDG\u000f\t\u0005\f\u0003s\u000b\tK!f\u0001\n\u0003\tY,\u0001\u0002nkV\u0011\u00111\u0002\u0005\f\u0003\u007f\u000b\tK!E!\u0002\u0013\tY!A\u0002nk\u0002B1\"a1\u0002\"\nU\r\u0011\"\u0001\u0002F\u0006)1/[4nCV\u0011\u0011q\u0019\t\u0005\u0003\u001b\tI-\u0003\u0003\u0002L\u0006=!AB'biJL\u0007\u0010C\u0006\u0002P\u0006\u0005&\u0011#Q\u0001\n\u0005\u001d\u0017AB:jO6\f\u0007\u0005C\u0004D\u0003C#\t!a5\u0015\u0011\u0005U\u0017\u0011\\An\u0003;\u0004B!a6\u0002\"6\u0011\u0011q\u0013\u0005\b\u0003_\u000b\t\u000e1\u0001$\u0011!\tI,!5A\u0002\u0005-\u0001\u0002CAb\u0003#\u0004\r!a2\t\u0015\u0005\u0005\u0018\u0011UA\u0001\n\u0003\t\u0019/\u0001\u0003d_BLH\u0003CAk\u0003K\f9/!;\t\u0013\u0005=\u0016q\u001cI\u0001\u0002\u0004\u0019\u0003BCA]\u0003?\u0004\n\u00111\u0001\u0002\f!Q\u00111YAp!\u0003\u0005\r!a2\t\u0015\u00055\u0018\u0011UI\u0001\n\u0003\ty/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E(fA\u0012\u0002t.\u0012\u0011Q\u001f\t\u0005\u0003o\fy0\u0004\u0002\u0002z*!\u00111`A\u007f\u0003%)hn\u00195fG.,GM\u0003\u0002+!%!!\u0011AA}\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u000b\t\t+%A\u0005\u0002\t\u001d\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0013QC!a\u0003\u0002t\"Q!QBAQ#\u0003%\tAa\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0003\u0016\u0005\u0003\u000f\f\u0019\u0010C\u0005\u0003\u0016\u0005\u0005\u0016\u0011!C!\u001d\u0006i\u0001O]8ek\u000e$\bK]3gSbD\u0011B!\u0007\u0002\"\u0006\u0005I\u0011\u0001;\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\tu\u0011\u0011UA\u0001\n\u0003\u0011y\"\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\u0005\"q\u0005\t\u0004\u001f\t\r\u0012b\u0001B\u0013!\t\u0019\u0011I\\=\t\u0013\t%\"1DA\u0001\u0002\u0004)\u0018a\u0001=%c!Q!QFAQ\u0003\u0003%\tEa\f\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\r\u0011\r\tM\"\u0011\bB\u0011\u001b\t\u0011)DC\u0002\u00038A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YD!\u000e\u0003\u0011%#XM]1u_JD!Ba\u0010\u0002\"\u0006\u0005I\u0011\u0001B!\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\"\u0005\u0013\u00022a\u0004B#\u0013\r\u00119\u0005\u0005\u0002\b\u0005>|G.Z1o\u0011)\u0011IC!\u0010\u0002\u0002\u0003\u0007!\u0011\u0005\u0005\u000b\u0005\u001b\n\t+!A\u0005B\t=\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003UD!Ba\u0015\u0002\"\u0006\u0005I\u0011\tB+\u0003!!xn\u0015;sS:<G#A(\t\u0015\te\u0013\u0011UA\u0001\n\u0003\u0012Y&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0007\u0012i\u0006\u0003\u0006\u0003*\t]\u0013\u0011!a\u0001\u0005C9!B!\u0019\u0002\u0018\u0006\u0005\t\u0012\u0001B2\u0003\u0011!\u0015\r^1\u0011\t\u0005]'Q\r\u0004\u000b\u0003G\u000b9*!A\t\u0002\t\u001d4#\u0002B3\u0005S\"\u0002c\u0003B6\u0005c\u001a\u00131BAd\u0003+l!A!\u001c\u000b\u0007\t=\u0004#A\u0004sk:$\u0018.\\3\n\t\tM$Q\u000e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004bB\"\u0003f\u0011\u0005!q\u000f\u000b\u0003\u0005GB!Ba\u0015\u0003f\u0005\u0005IQ\tB+\u0011)\u0011iH!\u001a\u0002\u0002\u0013\u0005%qP\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003+\u0014\tIa!\u0003\u0006\"9\u0011q\u0016B>\u0001\u0004\u0019\u0003\u0002CA]\u0005w\u0002\r!a\u0003\t\u0011\u0005\r'1\u0010a\u0001\u0003\u000fD!B!#\u0003f\u0005\u0005I\u0011\u0011BF\u0003\u001d)h.\u00199qYf$BA!$\u0003\u001aB)qBa$\u0003\u0014&\u0019!\u0011\u0013\t\u0003\r=\u0003H/[8o!!y!QS\u0012\u0002\f\u0005\u001d\u0017b\u0001BL!\t1A+\u001e9mKNB!Ba'\u0003\b\u0006\u0005\t\u0019AAk\u0003\rAH\u0005\r\u0005\u000b\u0005?\u0013)'!A\u0005\n\t\u0005\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa)\u0011\u0007A\u0013)+C\u0002\u0003(F\u0013aa\u00142kK\u000e$\b\"\u0003BV\u0003/\u0013\r\u0011\"\u0001O\u0003E1wN]7biZ+'o]5p]Z\u000bt\f\r\u0005\t\u0005_\u000b9\n)A\u0005\u001f\u0006\u0011bm\u001c:nCR4VM]:j_:4\u0016g\u0018\u0019!\u0011%\u0011\u0019,a&C\u0002\u0013\u0005a*A\u0007dY\u0006\u001c8OT1nKZ\u000bt\f\r\u0005\t\u0005o\u000b9\n)A\u0005\u001f\u0006q1\r\\1tg:\u000bW.\u001a,2?B\u0002\u0003b\u0002-\u0002\u0018\u0012\u0005!1\u0018\u000b\n5\nu&q\u0018Ba\u0005\u0007DaA\u0018B]\u0001\u0004y\u0006B\u00023\u0003:\u0002\u0007Q\r\u0003\u0004\u001f\u0005s\u0003\r\u0001\t\u0005\u0007g\te\u0006\u0019A\u001b\t\u0011\t\u001d\u0017q\u0013C\u0001\u0005\u0013\fA\u0001\\8bIR)QIa3\u0003N\"1aL!2A\u0002}Ca\u0001\u001aBc\u0001\u0004)\u0007\u0002\u0003Bd\u0003\u0003#\tE!5\u0015\u000b\u0015\u0013\u0019N!6\t\ry\u0013y\r1\u0001`\u0011\u0019!'q\u001aa\u0001K\"\"!qZ\u0014q\u0011)\u0011y*!!\u0002\u0002\u0013%!\u0011\u0015\u0015\u0005\u0003\u0003;\u0003\u000f\u000b\u0003\u0002|\u001d\u0002\b")
public class GaussianMixtureModel
implements scala.Serializable,
Saveable {
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;

    public static /* bridge */ Saveable load(SparkContext sparkContext, String string) {
        return GaussianMixtureModel$.MODULE$.load(sparkContext, string);
    }

    public static GaussianMixtureModel load(SparkContext sparkContext, String string) {
        return GaussianMixtureModel$.MODULE$.load(sparkContext, string);
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        GaussianMixtureModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.weights(), this.gaussians());
    }

    public int k() {
        return this.weights().length;
    }

    public RDD<Object> predict(RDD<Vector> points) {
        RDD<double[]> responsibilityMatrix = this.predictSoft(points);
        return responsibilityMatrix.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)GaussianMixtureModel.$anonfun$predict$1(r)), ClassTag$.MODULE$.Int());
    }

    public int predict(Vector point) {
        double[] r = this.predictSoft(point);
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).indexOf(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).max((Ordering)Ordering.Double$.MODULE$));
    }

    public JavaRDD<Integer> predict(JavaRDD<Vector> points) {
        return this.predict((RDD<Vector>)points.rdd()).toJavaRDD();
    }

    public RDD<double[]> predictSoft(RDD<Vector> points) {
        SparkContext sc = points.sparkContext();
        Broadcast bcDists = sc.broadcast((Object)this.gaussians(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(MultivariateGaussian.class)));
        Broadcast bcWeights = sc.broadcast((Object)this.weights(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return points.map((Function1 & Serializable & scala.Serializable)x -> this.computeSoftAssignments((DenseVector<Object>)x.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), (MultivariateGaussian[])bcDists.value(), (double[])bcWeights.value(), this.k()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[] predictSoft(Vector point) {
        return this.computeSoftAssignments((DenseVector<Object>)point.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), this.gaussians(), this.weights(), this.k());
    }

    private double[] computeSoftAssignments(DenseVector<Object> pt, MultivariateGaussian[] dists, double[] weights, int k) {
        double[] p = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dists), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)GaussianMixtureModel.$anonfun$computeSoftAssignments$1(pt, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double pSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            p$1[i] = p[i] / pSum;
        });
        return p;
    }

    public static final /* synthetic */ int $anonfun$predict$1(double[] r) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).indexOf(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).max((Ordering)Ordering.Double$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$computeSoftAssignments$1(DenseVector pt$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double weight = tuple2._1$mcD$sp();
        MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
        double d = MLUtils$.MODULE$.EPSILON() + weight * dist.pdf((breeze.linalg.Vector<Object>)pt$1);
        return d;
    }

    public GaussianMixtureModel(double[] weights, MultivariateGaussian[] gaussians) {
        this.weights = weights;
        this.gaussians = gaussians;
        Predef$.MODULE$.require(weights.length == gaussians.length, (Function0 & Serializable & scala.Serializable)() -> "Length of weight and Gaussian arrays must match");
    }
}

