/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rb\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001dG\u0007\u00023)\u0011!DB\u0001\tS:$XM\u001d8bY&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0011!q\u0002A!a\u0001\n\u0013y\u0012!A6\u0016\u0003\u0001\u0002\"aD\u0011\n\u0005\t\u0002\"aA%oi\"AA\u0005\u0001BA\u0002\u0013%Q%A\u0003l?\u0012*\u0017\u000f\u0006\u0002'SA\u0011qbJ\u0005\u0003QA\u0011A!\u00168ji\"9!fIA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!AA\u0006\u0001B\u0001B\u0003&\u0001%\u0001\u0002lA!Aa\u0006\u0001BA\u0002\u0013%q$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\ta\u0001\u0011\t\u0019!C\u0005c\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0019\u0012\u0004b\u0002\u00160\u0003\u0003\u0005\r\u0001\t\u0005\ti\u0001\u0011\t\u0011)Q\u0005A\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0007I\u0011B\u001c\u0002%%t\u0017\u000e^5bY&T\u0018\r^5p]6{G-Z\u000b\u0002qA\u0011\u0011\b\u0011\b\u0003uy\u0002\"a\u000f\t\u000e\u0003qR!!\u0010\u0007\u0002\rq\u0012xn\u001c;?\u0013\ty\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003\n\u0013aa\u0015;sS:<'BA \u0011\u0011!!\u0005A!a\u0001\n\u0013)\u0015AF5oSRL\u0017\r\\5{CRLwN\\'pI\u0016|F%Z9\u0015\u0005\u00192\u0005b\u0002\u0016D\u0003\u0003\u0005\r\u0001\u000f\u0005\t\u0011\u0002\u0011\t\u0011)Q\u0005q\u0005\u0019\u0012N\\5uS\u0006d\u0017N_1uS>tWj\u001c3fA!A!\n\u0001BA\u0002\u0013%q$A\nj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\u0003\u0005M\u0001\t\u0005\r\u0011\"\u0003N\u0003]Ig.\u001b;jC2L'0\u0019;j_:\u001cF/\u001a9t?\u0012*\u0017\u000f\u0006\u0002'\u001d\"9!fSA\u0001\u0002\u0004\u0001\u0003\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0011\u0002)%t\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:!\u0011!\u0011\u0006A!a\u0001\n\u0013\u0019\u0016aB3qg&dwN\\\u000b\u0002)B\u0011q\"V\u0005\u0003-B\u0011a\u0001R8vE2,\u0007\u0002\u0003-\u0001\u0005\u0003\u0007I\u0011B-\u0002\u0017\u0015\u00048/\u001b7p]~#S-\u001d\u000b\u0003MiCqAK,\u0002\u0002\u0003\u0007A\u000b\u0003\u0005]\u0001\t\u0005\t\u0015)\u0003U\u0003!)\u0007o]5m_:\u0004\u0003\u0002\u00030\u0001\u0005\u0003\u0007I\u0011B0\u0002\tM,W\rZ\u000b\u0002AB\u0011q\"Y\u0005\u0003EB\u0011A\u0001T8oO\"AA\r\u0001BA\u0002\u0013%Q-\u0001\u0005tK\u0016$w\fJ3r)\t1c\rC\u0004+G\u0006\u0005\t\u0019\u00011\t\u0011!\u0004!\u0011!Q!\n\u0001\fQa]3fI\u0002B\u0001B\u001b\u0001\u0003\u0002\u0004%IaN\u0001\u0010I&\u001cH/\u00198dK6+\u0017m];sK\"AA\u000e\u0001BA\u0002\u0013%Q.A\neSN$\u0018M\\2f\u001b\u0016\f7/\u001e:f?\u0012*\u0017\u000f\u0006\u0002']\"9!f[A\u0001\u0002\u0004A\u0004\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u001d\u0002!\u0011L7\u000f^1oG\u0016lU-Y:ve\u0016\u0004\u0003\"\u0002:\u0001\t\u0013\u0019\u0018A\u0002\u001fj]&$h\b\u0006\u0005um^D\u0018P_>}!\t)\b!D\u0001\u0003\u0011\u0015q\u0012\u000f1\u0001!\u0011\u0015q\u0013\u000f1\u0001!\u0011\u00151\u0014\u000f1\u00019\u0011\u0015Q\u0015\u000f1\u0001!\u0011\u0015\u0011\u0016\u000f1\u0001U\u0011\u0015q\u0016\u000f1\u0001a\u0011\u0015Q\u0017\u000f1\u00019\u0011\u0015\u0011\b\u0001\"\u0003\u007f)1!x0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0011\u0015qR\u00101\u0001!\u0011\u0015qS\u00101\u0001!\u0011\u00151T\u00101\u00019\u0011\u0015QU\u00101\u0001!\u0011\u0015\u0011V\u00101\u0001U\u0011\u0015qV\u00101\u0001aQ\u0015i\u0018QBA\r!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0011\u0011\u0003\u0002\u0006'&t7-Z\u0011\u0003\u00037\tQ\u0001\r\u00189]ABaA\u001d\u0001\u0005\u0002\u0005}A#\u0001;)\r\u0005u\u0011QBA\r\u0011\u0019\t)\u0003\u0001C\u0001?\u0005!q-\u001a;LQ\u0019\t\u0019#!\u0004\u0002*\u0005\u0012\u00111F\u0001\u0006c9\"d\u0006\r\u0005\b\u0003_\u0001A\u0011AA\u0019\u0003\u0011\u0019X\r^&\u0015\t\u0005M\u0012QG\u0007\u0002\u0001!1a$!\fA\u0002\u0001Bc!!\f\u0002\u000e\u0005e\u0001BBA\u001e\u0001\u0011\u0005q$\u0001\thKRl\u0015\r_%uKJ\fG/[8og\"2\u0011\u0011HA\u0007\u0003SAq!!\u0011\u0001\t\u0003\t\u0019%\u0001\ttKRl\u0015\r_%uKJ\fG/[8ogR!\u00111GA#\u0011\u0019q\u0013q\ba\u0001A!2\u0011qHA\u0007\u00033Aa!a\u0013\u0001\t\u00039\u0014!F4fi&s\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u0015\u0007\u0003\u0013\ni!!\u000b\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\u0005)2/\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8N_\u0012,G\u0003BA\u001a\u0003+BaANA(\u0001\u0004A\u0004FBA(\u0003\u001b\tI\u0002\u0003\u0004\u0002\\\u0001!\taH\u0001\bO\u0016$(+\u001e8tQ!\tI&a\u0018\u0002f\u0005%\u0004cA\b\u0002b%\u0019\u00111\r\t\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002h\u00059C\u000b[5tA!\f7\u000f\t8pA\u00154g-Z2uA\u0005tG\rI1mo\u0006L8\u000f\t:fiV\u0014hn\u001d\u00112C\t\tY'A\u00033]Er\u0003\u0007\u000b\u0004\u0002Z\u00055\u0011\u0011\u0006\u0005\b\u0003c\u0002A\u0011AA:\u0003\u001d\u0019X\r\u001e*v]N$B!a\r\u0002v!9\u0011qOA8\u0001\u0004\u0001\u0013\u0001\u0002:v]ND\u0003\"a\u001c\u0002`\u0005m\u0014\u0011N\u0011\u0003\u0003{\n!\u0003\u00165jg\u0002B\u0017m\u001d\u0011o_\u0002*gMZ3di\"2\u0011qNA\u0007\u00033Aa!a!\u0001\t\u0003y\u0012AF4fi&s\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:)\r\u0005\u0005\u0015QBA\u0015\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017\u000bac]3u\u0013:LG/[1mSj\fG/[8o'R,\u0007o\u001d\u000b\u0005\u0003g\ti\t\u0003\u0004K\u0003\u000f\u0003\r\u0001\t\u0015\u0007\u0003\u000f\u000bi!!\u0007\t\r\u0005M\u0005\u0001\"\u0001T\u0003)9W\r^#qg&dwN\u001c\u0015\u0007\u0003#\u000bi!!\u000b\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\u0006Q1/\u001a;FaNLGn\u001c8\u0015\t\u0005M\u0012Q\u0014\u0005\u0007%\u0006]\u0005\u0019\u0001+)\r\u0005]\u0015QBA\r\u0011\u0019\t\u0019\u000b\u0001C\u0001?\u00069q-\u001a;TK\u0016$\u0007FBAQ\u0003\u001b\tI\u0003C\u0004\u0002*\u0002!\t!a+\u0002\u000fM,GoU3fIR!\u00111GAW\u0011\u0019q\u0016q\u0015a\u0001A\"2\u0011qUA\u0007\u0003SAa!a-\u0001\t\u00039\u0014AE4fi\u0012K7\u000f^1oG\u0016lU-Y:ve\u0016Dc!!-\u0002\u000e\u0005]\u0016EAA]\u0003\u0015\u0011d\u0006\u000e\u00181\u0011\u001d\ti\f\u0001C\u0001\u0003\u007f\u000b!c]3u\t&\u001cH/\u00198dK6+\u0017m];sKR!\u00111GAa\u0011\u0019Q\u00171\u0018a\u0001q!2\u00111XA\u0007\u0003oC\u0011\"a2\u0001\u0001\u0004%I!!3\u0002\u0019%t\u0017\u000e^5bY6{G-\u001a7\u0016\u0005\u0005-\u0007#B\b\u0002N\u0006E\u0017bAAh!\t1q\n\u001d;j_:\u00042!^Aj\u0013\r\t)N\u0001\u0002\f\u00176+\u0017M\\:N_\u0012,G\u000eC\u0005\u0002Z\u0002\u0001\r\u0011\"\u0003\u0002\\\u0006\u0001\u0012N\\5uS\u0006dWj\u001c3fY~#S-\u001d\u000b\u0004M\u0005u\u0007\"\u0003\u0016\u0002X\u0006\u0005\t\u0019AAf\u0011!\t\t\u000f\u0001Q!\n\u0005-\u0017!D5oSRL\u0017\r\\'pI\u0016d\u0007\u0005C\u0004\u0002f\u0002!\t!a:\u0002\u001fM,G/\u00138ji&\fG.T8eK2$B!a\r\u0002j\"A\u00111^Ar\u0001\u0004\t\t.A\u0003n_\u0012,G\u000e\u000b\u0004\u0002d\u00065\u0011\u0011\u0006\u0005\b\u0003c\u0004A\u0011AAz\u0003\r\u0011XO\u001c\u000b\u0005\u0003#\f)\u0010\u0003\u0005\u0002x\u0006=\b\u0019AA}\u0003\u0011!\u0017\r^1\u0011\r\u0005m(\u0011\u0001B\u0003\u001b\t\tiPC\u0002\u0002\u0000\u001a\t1A\u001d3e\u0013\u0011\u0011\u0019!!@\u0003\u0007I#E\t\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\r\u0011Y\u0001B\u0001\u0007Y&t\u0017\r\\4\n\t\t=!\u0011\u0002\u0002\u0007-\u0016\u001cGo\u001c:)\r\u0005=\u0018QBA\r\u0011!\t\t\u0010\u0001C\u0001\r\tUACBAi\u0005/\u0011I\u0002\u0003\u0005\u0002x\nM\u0001\u0019AA}\u0011!\u0011YBa\u0005A\u0002\tu\u0011!B5ogR\u0014\b#B\b\u0002N\n}\u0001\u0003\u0002B\u0011\u0005Wi!Aa\t\u000b\t\t\u0015\"qE\u0001\u0005kRLGNC\u0002\u0003*\u0019\t!!\u001c7\n\t\t5\"1\u0005\u0002\u0010\u0013:\u001cHO];nK:$\u0018\r^5p]\"9!\u0011\u0007\u0001\u0005\n\tM\u0012\u0001\u0004:v]\u0006cwm\u001c:ji\"lGCBAi\u0005k\u0011y\u0004\u0003\u0005\u0002x\n=\u0002\u0019\u0001B\u001c!\u0019\tYP!\u0001\u0003:A\u0019QOa\u000f\n\u0007\tu\"A\u0001\bWK\u000e$xN],ji\"tuN]7\t\u0011\tm!q\u0006a\u0001\u0005;AqAa\u0011\u0001\t\u0013\u0011)%\u0001\u0006j]&$(+\u00198e_6$BAa\u0012\u0003NA)qB!\u0013\u0003:%\u0019!1\n\t\u0003\u000b\u0005\u0013(/Y=\t\u0011\u0005](\u0011\ta\u0001\u0005oA\u0001B!\u0015\u0001\t\u0003\u0011!1K\u0001\u0013S:LGoS'fC:\u001c\b+\u0019:bY2,G\u000e\u0006\u0004\u0003H\tU#q\u000b\u0005\t\u0003o\u0014y\u00051\u0001\u00038!A!\u0011\fB(\u0001\u0004\u0011Y&A\feSN$\u0018M\\2f\u001b\u0016\f7/\u001e:f\u0013:\u001cH/\u00198dKB\u0019QO!\u0018\n\u0007\t}#AA\bESN$\u0018M\\2f\u001b\u0016\f7/\u001e:fQ\u0015\u0001\u0011QBA\r\u000f\u001d\u0011)G\u0001E\u0001\u0005O\naaS'fC:\u001c\bcA;\u0003j\u00191\u0011A\u0001E\u0001\u0005W\u001aBA!\u001b\u000f)!9!O!\u001b\u0005\u0002\t=DC\u0001B4\u0011)\u0011\u0019H!\u001bC\u0002\u0013\u0005!QO\u0001\u0007%\u0006sEiT'\u0016\u0005\t]\u0004\u0003\u0002B=\u0005\u0007k!Aa\u001f\u000b\t\tu$qP\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0002\u0006!!.\u0019<b\u0013\r\t%1\u0010\u0015\u0007\u0005c\ni!!\u0007\t\u0013\t%%\u0011\u000eQ\u0001\n\t]\u0014a\u0002*B\u001d\u0012{U\n\t\u0015\u0007\u0005\u000f\u000bi!!\u0007\t\u0015\t=%\u0011\u000eb\u0001\n\u0003\u0011)(\u0001\tL?6+\u0015IT*`!\u0006\u0013\u0016\t\u0014'F\u0019\"2!QRA\u0007\u00033A\u0011B!&\u0003j\u0001\u0006IAa\u001e\u0002#-{V*R!O'~\u0003\u0016IU!M\u0019\u0016c\u0005\u0005\u000b\u0004\u0003\u0014\u00065\u0011\u0011\u0004\u0005\t\u00057\u0013I\u0007\"\u0001\u0003\u001e\u0006)AO]1j]Ra\u0011\u0011\u001bBP\u0005C\u0013\u0019K!*\u0003(\"A\u0011q\u001fBM\u0001\u0004\tI\u0010\u0003\u0004\u001f\u00053\u0003\r\u0001\t\u0005\u0007]\te\u0005\u0019\u0001\u0011\t\rY\u0012I\n1\u00019\u0011\u0019q&\u0011\u0014a\u0001A\"2!\u0011TA\u0007\u0003SB\u0001Ba'\u0003j\u0011\u0005!Q\u0016\u000b\u000b\u0003#\u0014yK!-\u00034\nU\u0006\u0002CA|\u0005W\u0003\r!!?\t\ry\u0011Y\u000b1\u0001!\u0011\u0019q#1\u0016a\u0001A!1aGa+A\u0002aBcAa+\u0002\u000e\u0005%\u0004\u0002\u0003BN\u0005S\"\tAa/\u0015\u001d\u0005E'Q\u0018B`\u0005\u0003\u0014\u0019M!2\u0003H\"A\u0011q\u001fB]\u0001\u0004\tI\u0010\u0003\u0004\u001f\u0005s\u0003\r\u0001\t\u0005\u0007]\te\u0006\u0019\u0001\u0011\t\u000f\u0005]$\u0011\u0018a\u0001A!1aG!/A\u0002aBaA\u0018B]\u0001\u0004\u0001\u0007\u0006\u0003B]\u0003?\u0012Y-!\u001b\"\u0005\t5\u0017aH+tK\u0002\"(/Y5oA5,G\u000f[8eA]LG\u000f[8vi\u0002:#/\u001e8tO!2!\u0011XA\u0007\u0005#\f#Aa5\u0002\u000bEr3G\f\u0019\t\u0011\tm%\u0011\u000eC\u0001\u0005/$B\"!5\u0003Z\nm'Q\u001cBp\u0005CD\u0001\"a>\u0003V\u0002\u0007\u0011\u0011 \u0005\u0007=\tU\u0007\u0019\u0001\u0011\t\r9\u0012)\u000e1\u0001!\u0011\u001d\t9H!6A\u0002\u0001BaA\u000eBk\u0001\u0004A\u0004\u0006\u0003Bk\u0003?\u0012Y-!\u001b)\r\tU\u0017QBA\r\u0011!\u0011YJ!\u001b\u0005\u0002\t%H\u0003CAi\u0005W\u0014iOa<\t\u0011\u0005](q\u001da\u0001\u0003sDaA\bBt\u0001\u0004\u0001\u0003B\u0002\u0018\u0003h\u0002\u0007\u0001\u0005\u000b\u0004\u0003h\u00065\u0011\u0011\u0004\u0005\t\u00057\u0013I\u0007\"\u0001\u0003vRQ\u0011\u0011\u001bB|\u0005s\u0014YP!@\t\u0011\u0005](1\u001fa\u0001\u0003sDaA\bBz\u0001\u0004\u0001\u0003B\u0002\u0018\u0003t\u0002\u0007\u0001\u0005C\u0004\u0002x\tM\b\u0019\u0001\u0011)\u0011\tM\u0018q\fBf\u0003SBcAa=\u0002\u000e\u0005e\u0001\"CB\u0003\u0005S\"\tABB\u0004\u0003A1\u0018\r\\5eCR,\u0017J\\5u\u001b>$W\r\u0006\u0003\u0004\n\r=\u0001cA\b\u0004\f%\u00191Q\u0002\t\u0003\u000f\t{w\u000e\\3b]\"91\u0011CB\u0002\u0001\u0004A\u0014\u0001C5oSRlu\u000eZ3\t\u0015\rU!\u0011NA\u0001\n\u0013\u00199\"A\u0006sK\u0006$'+Z:pYZ,GCAB\r!\u0011\u0011Iha\u0007\n\t\ru!1\u0010\u0002\u0007\u001f\nTWm\u0019;)\r\t%\u0014QBA\rQ\u0019\u0011\u0019'!\u0004\u0002\u001a\u0001")
public class KMeans
implements scala.Serializable,
Logging {
    private int k;
    private int maxIterations;
    private String initializationMode;
    private int initializationSteps;
    private double epsilon;
    private long seed;
    private String distanceMeasure;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string, l);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String initializationMode() {
        return this.initializationMode;
    }

    private void initializationMode_$eq(String x$1) {
        this.initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    private double epsilon() {
        return this.epsilon;
    }

    private void epsilon_$eq(double x$1) {
        this.epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public int getK() {
        return this.k();
    }

    public KMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.initializationMode_$eq(initializationMode);
        return this;
    }

    public int getRuns() {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Getting number of runs has no effect since Spark 2.0.0.");
        return 1;
    }

    public KMeans setRuns(int runs) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Setting number of runs has no effect since Spark 2.0.0.");
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        Predef$.MODULE$.require(initializationSteps > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Number of initialization steps must be positive but got ").append(initializationSteps).toString());
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        Predef$.MODULE$.require(epsilon >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Distance threshold must be nonnegative but got ").append(epsilon).toString());
        this.epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public KMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.k(), (Function0 & Serializable & scala.Serializable)() -> "mismatched cluster count");
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        return this.run(data, (Option<Instrumentation>)None$.MODULE$);
    }

    public KMeansModel run(RDD<Vector> data, Option<Instrumentation> instr) {
        KMeansModel model;
        block1: {
            StorageLevel storageLevel = data.getStorageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.");
            }
            RDD norms = data.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)Vectors$.MODULE$.norm(x$1, 2.0)), ClassTag$.MODULE$.Double());
            norms.persist();
            RDD zippedData = data.zip(norms, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector v = (Vector)tuple2._1();
                double norm = tuple2._2$mcD$sp();
                VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm);
                return vectorWithNorm;
            }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
            model = this.runAlgorithm((RDD<VectorWithNorm>)zippedData, instr);
            norms.unpersist(norms.unpersist$default$1());
            StorageLevel storageLevel3 = data.getStorageLevel();
            StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
            if (storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.");
        }
        return model;
    }

    private KMeansModel runAlgorithm(RDD<VectorWithNorm> data, Option<Instrumentation> instr) {
        VectorWithNorm[] vectorWithNormArray;
        SparkContext sc = data.sparkContext();
        long initStartTime = System.nanoTime();
        DistanceMeasure distanceMeasureInstance = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        Option<KMeansModel> option = this.initialModel();
        if (option instanceof Some) {
            Some some = (Some)option;
            KMeansModel kMeansCenters = (KMeansModel)some.value();
            vectorWithNormArray = (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters())).map((Function1 & Serializable & scala.Serializable)x$2 -> new VectorWithNorm((Vector)x$2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
        } else if (None$.MODULE$.equals(option)) {
            String string = this.initializationMode();
            String string2 = KMeans$.MODULE$.RANDOM();
            vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data, distanceMeasureInstance);
        } else {
            throw new MatchError(option);
        }
        VectorWithNorm[] centers = vectorWithNormArray;
        double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String arg$macro$1 = this.initializationMode();
            double arg$macro$2 = initTimeInSeconds;
            return new StringOps("Initialization with %s took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2)}));
        });
        BooleanRef converged = BooleanRef.create((boolean)false);
        DoubleRef cost = DoubleRef.create((double)0.0);
        IntRef iteration = IntRef.create((int)0);
        long iterationStartTime = System.nanoTime();
        instr.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.logNumFeatures(((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).head()).vector().size());
            return BoxedUnit.UNIT;
        });
        while (iteration.elem < this.maxIterations() && !converged.elem) {
            DoubleAccumulator costAccum = sc.doubleAccumulator();
            Broadcast bcCenters = sc.broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            Map collected = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1 & Serializable & scala.Serializable)points -> {
                VectorWithNorm[] thisCenters = (VectorWithNorm[])bcCenters.value();
                int dims = ((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thisCenters)).head()).vector().size();
                Vector[] sums = (Vector[])Array$.MODULE$.fill(thisCenters.length, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.zeros(dims), ClassTag$.MODULE$.apply(Vector.class));
                long[] counts = (long[])Array$.MODULE$.fill(thisCenters.length, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long());
                points.foreach((Function1 & Serializable & scala.Serializable)point -> {
                    KMeans.$anonfun$runAlgorithm$7(distanceMeasureInstance, costAccum, thisCenters, sums, counts, point);
                    return BoxedUnit.UNIT;
                });
                return ((IndexedSeqLike)((TraversableLike)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(counts)).indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> counts[x$5] > 0L)).map((Function1 & Serializable & scala.Serializable)j -> KMeans.$anonfun$runAlgorithm$9(sums, counts, BoxesRunTime.unboxToInt((Object)j)), IndexedSeq$.MODULE$.canBuildFrom())).iterator();
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                long count1;
                Vector sum1;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$2, x1$1);
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        sum1 = (Vector)tuple23._1();
                        count1 = tuple23._2$mcJ$sp();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Vector sum2 = (Vector)tuple2._1();
                long count2 = tuple2._2$mcJ$sp();
                BLAS$.MODULE$.axpy(1.0, sum2, sum1);
                Tuple2 tuple24 = new Tuple2((Object)sum1, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
                return tuple24;
            }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            if (iteration.elem == 0) {
                instr.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                    x$6.logNumExamples(BoxesRunTime.unboxToLong((Object)((TraversableOnce)collected.values().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._2$mcJ$sp()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                    return BoxedUnit.UNIT;
                });
            }
            Map newCenters = collected.mapValues((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector sum = (Vector)tuple2._1();
                long count = tuple2._2$mcJ$sp();
                VectorWithNorm vectorWithNorm = distanceMeasureInstance.centroid(sum, count);
                return vectorWithNorm;
            });
            bcCenters.destroy(false);
            converged.elem = true;
            newCenters.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                KMeans.$anonfun$runAlgorithm$14(this, distanceMeasureInstance, centers, converged, x0$4);
                return BoxedUnit.UNIT;
            });
            cost.elem = Predef$.MODULE$.Double2double(costAccum.value());
            ++iteration.elem;
        }
        double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            double arg$macro$3 = iterationTimeInSeconds;
            return new StringOps("Iterations took %.3f seconds.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
        });
        if (iteration.elem == this.maxIterations()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("KMeans reached the max number of iterations: ").append(this.maxIterations()).append(".").toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("KMeans converged in ").append(iteration$1.elem).append(" iterations.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("The cost is ").append(cost$1.elem).append(".").toString());
        return new KMeansModel((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))), this.distanceMeasure(), cost.elem, iteration.elem);
    }

    private VectorWithNorm[] initRandom(RDD<VectorWithNorm> data) {
        return (VectorWithNorm[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.takeSample(false, this.k(), (long)new XORShiftRandom(this.seed()).nextInt()))).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))))).distinct())).map((Function1 & Serializable & scala.Serializable)x$10 -> new VectorWithNorm((Vector)x$10), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
    }

    public VectorWithNorm[] initKMeansParallel(RDD<VectorWithNorm> data, DistanceMeasure distanceMeasureInstance) {
        VectorWithNorm[] vectorWithNormArray;
        RDD costs = data.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$1(x$11)), ClassTag$.MODULE$.Double());
        int seed = new XORShiftRandom(this.seed()).nextInt();
        VectorWithNorm[] sample = (VectorWithNorm[])data.takeSample(false, 1, (long)seed);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("No samples available from ").append(data).toString());
        ArrayBuffer centers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq newCenters = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VectorWithNorm[]{((VectorWithNorm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sample)).head()).toDense()}));
        centers.$plus$plus$eq((TraversableOnce)newCenters);
        IntRef step = IntRef.create((int)0);
        ArrayBuffer bcNewCentersList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(Seq.class));
            bcNewCentersList.$plus$eq((Object)bcNewCenters);
            RDD preCosts = costs;
            costs = data.zip(preCosts, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToDouble((double)KMeans.$anonfun$initKMeansParallel$3(distanceMeasureInstance, bcNewCenters, x0$5)), ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double sumCosts = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(costs).sum();
            bcNewCenters.unpersist(false);
            preCosts.unpersist(false);
            RDD qual$1 = data.zip(costs, ClassTag$.MODULE$.Double());
            Function2 & Serializable & scala.Serializable x$19 = (Function2 & Serializable & scala.Serializable)(index, pointCosts) -> KMeans.$anonfun$initKMeansParallel$4(this, seed, step, sumCosts, BoxesRunTime.unboxToInt((Object)index), pointCosts);
            boolean x$20 = qual$1.mapPartitionsWithIndex$default$2();
            VectorWithNorm[] chosen = (VectorWithNorm[])qual$1.mapPartitionsWithIndex((Function2)x$19, x$20, ClassTag$.MODULE$.apply(VectorWithNorm.class)).collect();
            newCenters = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chosen)).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toDense(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            centers.$plus$plus$eq((TraversableOnce)newCenters);
            ++step.elem;
        }
        costs.unpersist(false);
        bcNewCentersList.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.destroy(false);
            return BoxedUnit.UNIT;
        });
        ArrayBuffer distinctCenters = (ArrayBuffer)((TraversableLike)((SeqLike)centers.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.vector(), ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$16 -> new VectorWithNorm((Vector)x$16), ArrayBuffer$.MODULE$.canBuildFrom());
        if (distinctCenters.size() <= this.k()) {
            vectorWithNormArray = (VectorWithNorm[])distinctCenters.toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
        } else {
            Broadcast bcCenters = data.context().broadcast((Object)distinctCenters, ClassTag$.MODULE$.apply(ArrayBuffer.class));
            Map countMap = data.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)KMeans.$anonfun$initKMeansParallel$11(distanceMeasureInstance, bcCenters, x$17)), ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
            bcCenters.destroy(false);
            double[] myWeights = (double[])((TraversableOnce)distinctCenters.indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$18 -> BoxesRunTime.unboxToLong((Object)countMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)x$18), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            vectorWithNormArray = LocalKMeans$.MODULE$.kMeansPlusPlus(0, (VectorWithNorm[])distinctCenters.toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class)), myWeights, this.k(), 30);
        }
        return vectorWithNormArray;
    }

    public static final /* synthetic */ void $anonfun$runAlgorithm$7(DistanceMeasure distanceMeasureInstance$1, DoubleAccumulator costAccum$1, VectorWithNorm[] thisCenters$1, Vector[] sums$1, long[] counts$1, VectorWithNorm point) {
        Tuple2<Object, Object> tuple2 = distanceMeasureInstance$1.findClosest((TraversableOnce<VectorWithNorm>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thisCenters$1)), point);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bestCenter = tuple2._1$mcI$sp();
        double cost = tuple2._2$mcD$sp();
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(bestCenter, cost);
        Tuple2.mcID.sp sp3 = sp2;
        int bestCenter2 = sp3._1$mcI$sp();
        double cost2 = sp3._2$mcD$sp();
        costAccum$1.add(cost2);
        distanceMeasureInstance$1.updateClusterSum(point, sums$1[bestCenter2]);
        counts$1[bestCenter2] = counts$1[bestCenter2] + 1L;
    }

    public static final /* synthetic */ Tuple2 $anonfun$runAlgorithm$9(Vector[] sums$1, long[] counts$1, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple2((Object)sums$1[j], (Object)BoxesRunTime.boxToLong((long)counts$1[j])));
    }

    public static final /* synthetic */ void $anonfun$runAlgorithm$14(KMeans $this, DistanceMeasure distanceMeasureInstance$1, VectorWithNorm[] centers$1, BooleanRef converged$1, Tuple2 x0$4) {
        VectorWithNorm newCenter;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            int j = tuple2._1$mcI$sp();
            newCenter = (VectorWithNorm)tuple2._2();
            if (converged$1.elem && !distanceMeasureInstance$1.isCenterConverged(centers$1[j], newCenter, $this.epsilon())) {
                converged$1.elem = false;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        centers$1[j] = newCenter;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$1(VectorWithNorm x$11) {
        return Double.POSITIVE_INFINITY;
    }

    public static final /* synthetic */ double $anonfun$initKMeansParallel$3(DistanceMeasure distanceMeasureInstance$2, Broadcast bcNewCenters$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        VectorWithNorm point = (VectorWithNorm)tuple2._1();
        double cost = tuple2._2$mcD$sp();
        double d = package$.MODULE$.min(distanceMeasureInstance$2.pointCost((TraversableOnce<VectorWithNorm>)((TraversableOnce)bcNewCenters$1.value()), point), cost);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$initKMeansParallel$5(KMeans $this, double sumCosts$1, XORShiftRandom rand$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double c = tuple2._2$mcD$sp();
        boolean bl = rand$1.nextDouble() < 2.0 * c * (double)$this.k() / sumCosts$1;
        return bl;
    }

    public static final /* synthetic */ Iterator $anonfun$initKMeansParallel$4(KMeans $this, int seed$1, IntRef step$1, double sumCosts$1, int index, Iterator pointCosts) {
        XORShiftRandom rand = new XORShiftRandom((long)(seed$1 ^ step$1.elem << 16 ^ index));
        return pointCosts.filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)KMeans.$anonfun$initKMeansParallel$5($this, sumCosts$1, rand, x0$6))).map((Function1 & Serializable & scala.Serializable)x$12 -> (VectorWithNorm)x$12._1());
    }

    public static final /* synthetic */ int $anonfun$initKMeansParallel$11(DistanceMeasure distanceMeasureInstance$2, Broadcast bcCenters$2, VectorWithNorm x$17) {
        return distanceMeasureInstance$2.findClosest((TraversableOnce<VectorWithNorm>)((TraversableOnce)bcCenters$2.value()), x$17)._1$mcI$sp();
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.epsilon = epsilon;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this(k, maxIterations, initializationMode, initializationSteps, epsilon, seed, DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public KMeans() {
        this(2, 20, KMeans$.MODULE$.K_MEANS_PARALLEL(), 2, 1.0E-4, Utils$.MODULE$.random().nextLong(), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }
}

