/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001B\u0001\u0003\u00015\u00111\u0001\u0014#B\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017BA\r\u0017\u0005\u001daunZ4j]\u001eD\u0001b\u0007\u0001\u0003\u0002\u0004%I\u0001H\u0001\u0002WV\tQ\u0004\u0005\u0002\u0010=%\u0011q\u0004\u0005\u0002\u0004\u0013:$\b\u0002C\u0011\u0001\u0005\u0003\u0007I\u0011\u0002\u0012\u0002\u000b-|F%Z9\u0015\u0005\r2\u0003CA\b%\u0013\t)\u0003C\u0001\u0003V]&$\bbB\u0014!\u0003\u0003\u0005\r!H\u0001\u0004q\u0012\n\u0004\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0015B\u000f\u0002\u0005-\u0004\u0003\u0002C\u0016\u0001\u0005\u0003\u0007I\u0011\u0002\u000f\u0002\u001b5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t\u0011!i\u0003A!a\u0001\n\u0013q\u0013!E7bq&#XM]1uS>t7o\u0018\u0013fcR\u00111e\f\u0005\bO1\n\t\u00111\u0001\u001e\u0011!\t\u0004A!A!B\u0013i\u0012AD7bq&#XM]1uS>t7\u000f\t\u0005\tg\u0001\u0011\t\u0019!C\u0005i\u0005\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001\bB\u0001\u0007Y&t\u0017\r\\4\n\u0005i:$A\u0002,fGR|'\u000f\u0003\u0005=\u0001\t\u0005\r\u0011\"\u0003>\u0003Q!wnY\"p]\u000e,g\u000e\u001e:bi&|gn\u0018\u0013fcR\u00111E\u0010\u0005\bOm\n\t\u00111\u00016\u0011!\u0001\u0005A!A!B\u0013)\u0014!\u00053pG\u000e{gnY3oiJ\fG/[8oA!A!\t\u0001BA\u0002\u0013%1)\u0001\nu_BL7mQ8oG\u0016tGO]1uS>tW#\u0001#\u0011\u0005=)\u0015B\u0001$\u0011\u0005\u0019!u.\u001e2mK\"A\u0001\n\u0001BA\u0002\u0013%\u0011*\u0001\fu_BL7mQ8oG\u0016tGO]1uS>tw\fJ3r)\t\u0019#\nC\u0004(\u000f\u0006\u0005\t\u0019\u0001#\t\u00111\u0003!\u0011!Q!\n\u0011\u000b1\u0003^8qS\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002B\u0001B\u0014\u0001\u0003\u0002\u0004%IaT\u0001\u0005g\u0016,G-F\u0001Q!\ty\u0011+\u0003\u0002S!\t!Aj\u001c8h\u0011!!\u0006A!a\u0001\n\u0013)\u0016\u0001C:fK\u0012|F%Z9\u0015\u0005\r2\u0006bB\u0014T\u0003\u0003\u0005\r\u0001\u0015\u0005\t1\u0002\u0011\t\u0011)Q\u0005!\u0006)1/Z3eA!A!\f\u0001BA\u0002\u0013%A$\u0001\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0007\u0002\u0003/\u0001\u0005\u0003\u0007I\u0011B/\u0002-\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\0%KF$\"a\t0\t\u000f\u001dZ\u0016\u0011!a\u0001;!A\u0001\r\u0001B\u0001B\u0003&Q$A\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0007\u0005\u0003\u0005c\u0001\t\u0005\r\u0011\"\u0003d\u00031aG-Y(qi&l\u0017N_3s+\u0005!\u0007CA3g\u001b\u0005\u0011\u0011BA4\u0003\u00051aE)Q(qi&l\u0017N_3s\u0011!I\u0007A!a\u0001\n\u0013Q\u0017\u0001\u00057eC>\u0003H/[7ju\u0016\u0014x\fJ3r)\t\u00193\u000eC\u0004(Q\u0006\u0005\t\u0019\u00013\t\u00115\u0004!\u0011!Q!\n\u0011\fQ\u0002\u001c3b\u001fB$\u0018.\\5{KJ\u0004\u0003\"B8\u0001\t\u0013\u0001\u0018A\u0002\u001fj]&$h\b\u0006\u0005reN$XO^<y!\t)\u0007\u0001C\u0003\u001c]\u0002\u0007Q\u0004C\u0003,]\u0002\u0007Q\u0004C\u00034]\u0002\u0007Q\u0007C\u0003C]\u0002\u0007A\tC\u0003O]\u0002\u0007\u0001\u000bC\u0003[]\u0002\u0007Q\u0004C\u0003c]\u0002\u0007A\rC\u0003p\u0001\u0011\u0005!\u0010F\u0001rQ\u0011IH0!\u0002\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyh!\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001\u007f\u0005\u0015\u0019\u0016N\\2fC\t\t9!A\u00032]Mr\u0003\u0007\u0003\u0004\u0002\f\u0001!\t\u0001H\u0001\u0005O\u0016$8\nK\u0003\u0002\nq\f)\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\tM,Go\u0013\u000b\u0005\u0003+\t9\"D\u0001\u0001\u0011\u0019Y\u0012q\u0002a\u0001;!*\u0011q\u0002?\u0002\u0006!1\u0011Q\u0004\u0001\u0005\u0002Q\nQdZ3u\u0003NLX.\\3ue&\u001cGi\\2D_:\u001cWM\u001c;sCRLwN\u001c\u0015\u0006\u00037a\u0018\u0011E\u0011\u0003\u0003G\tQ!\r\u00186]ABa!a\n\u0001\t\u0003\u0019\u0015aE4fi\u0012{7mQ8oG\u0016tGO]1uS>t\u0007&BA\u0013y\u0006\u0015\u0001bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0014g\u0016$Hi\\2D_:\u001cWM\u001c;sCRLwN\u001c\u000b\u0005\u0003+\t\t\u0004\u0003\u00044\u0003W\u0001\r!\u000e\u0015\u0006\u0003Wa\u0018\u0011\u0005\u0005\b\u0003[\u0001A\u0011AA\u001c)\u0011\t)\"!\u000f\t\rM\n)\u00041\u0001EQ\u0015\t)\u0004`A\u0003\u0011\u0019\ty\u0004\u0001C\u0001i\u0005\u0011r-\u001a;BgflW.\u001a;sS\u000e\fE\u000e\u001d5bQ\u0015\ti\u0004`A\u0011\u0011\u0019\t)\u0005\u0001C\u0001\u0007\u0006Aq-\u001a;BYBD\u0017\rK\u0003\u0002Dq\f)\u0001C\u0004\u0002L\u0001!\t!!\u0014\u0002\u0011M,G/\u00117qQ\u0006$B!!\u0006\u0002P!9\u0011\u0011KA%\u0001\u0004)\u0014!B1ma\"\f\u0007&BA%y\u0006\u0005\u0002bBA&\u0001\u0011\u0005\u0011q\u000b\u000b\u0005\u0003+\tI\u0006C\u0004\u0002R\u0005U\u0003\u0019\u0001#)\u000b\u0005UC0!\u0002\t\r\u0005}\u0003\u0001\"\u0001D\u0003U9W\r\u001e+pa&\u001c7i\u001c8dK:$(/\u0019;j_:DS!!\u0018}\u0003\u000bAq!!\u001a\u0001\t\u0003\t9'A\u000btKR$v\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\u0015\t\u0005U\u0011\u0011\u000e\u0005\u0007\u0005\u0006\r\u0004\u0019\u0001#)\u000b\u0005\rD0!\u0002\t\r\u0005=\u0004\u0001\"\u0001D\u0003\u001d9W\r\u001e\"fi\u0006DS!!\u001c}\u0003\u000bAq!!\u001e\u0001\t\u0003\t9(A\u0004tKR\u0014U\r^1\u0015\t\u0005U\u0011\u0011\u0010\u0005\b\u0003w\n\u0019\b1\u0001E\u0003\u0011\u0011W\r^1)\u000b\u0005MD0!\u0002\t\r\u0005\u0005\u0005\u0001\"\u0001\u001d\u0003A9W\r^'bq&#XM]1uS>t7\u000fK\u0003\u0002\u0000q\f)\u0001C\u0004\u0002\b\u0002!\t!!#\u0002!M,G/T1y\u0013R,'/\u0019;j_:\u001cH\u0003BA\u000b\u0003\u0017CaaKAC\u0001\u0004i\u0002&BACy\u0006\u0015\u0001BBAI\u0001\u0011\u0005q*A\u0004hKR\u001cV-\u001a3)\u000b\u0005=E0!\u0002\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u000691/\u001a;TK\u0016$G\u0003BA\u000b\u00037CaATAK\u0001\u0004\u0001\u0006&BAKy\u0006\u0015\u0001BBAQ\u0001\u0011\u0005A$A\u000bhKR\u001c\u0005.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197)\u000b\u0005}E0!\u0002\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006)2/\u001a;DQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dG\u0003BA\u000b\u0003WCaAWAS\u0001\u0004i\u0002&BASy\u0006\u0015\u0001BBAY\u0001\u0011\u00051-\u0001\u0007hKR|\u0005\u000f^5nSj,'\u000f\u000b\u0003\u00020\u0006U\u0006cA?\u00028&\u0019\u0011\u0011\u0018@\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5)\u000b\u0005=F0!0\"\u0005\u0005}\u0016!B\u0019/i9\u0002\u0004bBAb\u0001\u0011\u0005\u0011QY\u0001\rg\u0016$x\n\u001d;j[&TXM\u001d\u000b\u0005\u0003+\t9\rC\u0004\u0002J\u0006\u0005\u0007\u0019\u00013\u0002\u0013=\u0004H/[7ju\u0016\u0014\b\u0006BAa\u0003kCS!!1}\u0003{Cq!a1\u0001\t\u0003\t\t\u000e\u0006\u0003\u0002\u0016\u0005M\u0007\u0002CAk\u0003\u001f\u0004\r!a6\u0002\u001b=\u0004H/[7ju\u0016\u0014h*Y7f!\u0011\tI.a:\u000f\t\u0005m\u00171\u001d\t\u0004\u0003;\u0004RBAAp\u0015\r\t\t\u000fD\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015\b#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\fYO\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003K\u0004\u0002&BAhy\u0006u\u0006bBAy\u0001\u0011\u0005\u00111_\u0001\u0004eVtG\u0003BA{\u0003w\u00042!ZA|\u0013\r\tIP\u0001\u0002\t\u0019\u0012\u000bUj\u001c3fY\"A\u0011Q`Ax\u0001\u0004\ty0A\u0005e_\u000e,X.\u001a8ugB1!\u0011\u0001B\u0004\u0005\u0017i!Aa\u0001\u000b\u0007\t\u0015a!A\u0002sI\u0012LAA!\u0003\u0003\u0004\t\u0019!\u000b\u0012#\u0011\u000b=\u0011i\u0001U\u001b\n\u0007\t=\u0001C\u0001\u0004UkBdWM\r\u0015\u0006\u0003_d\u0018Q\u0001\u0005\b\u0003c\u0004A\u0011\u0001B\u000b)\u0011\t)Pa\u0006\t\u0011\u0005u(1\u0003a\u0001\u00053\u0001rAa\u0007\u0003&\t%R'\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003\u0011Q\u0017M^1\u000b\u0007\t\rb!A\u0002ba&LAAa\n\u0003\u001e\tY!*\u0019<b!\u0006L'O\u0015#E!\u0011\u0011YCa\r\u000e\u0005\t5\"\u0002\u0002B\u0018\u0005c\tA\u0001\\1oO*\u0011!qD\u0005\u0004%\n5\u0002&\u0002B\ny\u0006\u0015\u0001\u0006\u0002\u0001}\u0003\u000b9\u0001Ba\u000f\u0003\u0011\u0003\u0011!QH\u0001\u0004\u0019\u0012\u000b\u0005cA3\u0003@\u00199\u0011A\u0001E\u0001\u0005\t\u00053c\u0001B \u001d!9qNa\u0010\u0005\u0002\t\u0015CC\u0001B\u001f\u000b!\u0011IEa\u0010\u0001\u0005\t-#a\u0003+pa&\u001c7i\\;oiN\u0004RA!\u0014\u0003V\u0011k!Aa\u0014\u000b\u0007a\u0012\tF\u0003\u0002\u0003T\u00051!M]3fu\u0016LAAa\u0016\u0003P\tYA)\u001a8tKZ+7\r^8s\u000b\u001d\u0011YFa\u0010\u0001\u0005\u0011\u0013!\u0002V8lK:\u001cu.\u001e8u\u0011%\u0011yFa\u0010\u0005\u0002\t\u0011\t'\u0001\u0006uKJl''\u001b8eKb$2\u0001\u0015B2\u0011\u001d\u0011)G!\u0018A\u0002u\tA\u0001^3s[\"I!\u0011\u000eB \t\u0003\u0011!1N\u0001\u000bS:$W\r\u001f\u001auKJlGcA\u000f\u0003n!9!q\u000eB4\u0001\u0004\u0001\u0016!\u0003;fe6Le\u000eZ3y\u0011%\u0011\u0019Ha\u0010\u0005\u0002\t\u0011)(\u0001\tjg\u0012{7-^7f]R4VM\u001d;fqR!!q\u000fB?!\ry!\u0011P\u0005\u0004\u0005w\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0005\u007f\u0012\t\b1\u0001\u0003\u0002\u0006\ta\u000f\r\u0003\u0003\u0004\n-\u0006cB\b\u0003\u000e\t\u0015%q\u0015\t\u0005\u0005\u000f\u0013\tK\u0004\u0003\u0003\n\nme\u0002\u0002BF\u0005/sAA!$\u0003\u0016:!!q\u0012BJ\u001d\u0011\tiN!%\n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011b\u0001BM\r\u00051qM]1qQbLAA!(\u0003 \u00069\u0001/Y2lC\u001e,'b\u0001BM\r%!!1\u0015BS\u0005!1VM\u001d;fq&#'\u0002\u0002BO\u0005?\u0003BA!+\u0003,2\u0001A\u0001\u0004BW\u0005{\n\t\u0011!A\u0003\u0002\t=&aA0%cE!!\u0011\u0017B\\!\ry!1W\u0005\u0004\u0005k\u0003\"a\u0002(pi\"Lgn\u001a\t\u0004\u001f\te\u0016b\u0001B^!\t\u0019\u0011I\\=\t\u0013\t}&q\bC\u0001\u0005\t\u0005\u0017\u0001D5t)\u0016\u0014XNV3si\u0016DH\u0003\u0002B<\u0005\u0007D\u0001Ba \u0003>\u0002\u0007!Q\u0019\u0019\u0005\u0005\u000f\u0014Y\rE\u0004\u0010\u0005\u001b\u0011)I!3\u0011\t\t%&1\u001a\u0003\r\u0005\u001b\u0014\u0019-!A\u0001\u0002\u000b\u0005!q\u0016\u0002\u0004?\u0012\u0012\u0004\"\u0003Bi\u0005\u007f!\tA\u0001Bj\u00035\u0019w.\u001c9vi\u0016\u0004Fk\u001c9jGRq!Q\u001bBm\u0005;\u0014\tO!:\u0003j\n5\b\u0003\u0002Bl\u0005\u000fj!Aa\u0010\t\u0011\tm'q\u001aa\u0001\u0005+\fa\u0002Z8d)>\u0004\u0018nY\"pk:$8\u000f\u0003\u0005\u0003`\n=\u0007\u0019\u0001Bk\u0003=!XM]7U_BL7mQ8v]R\u001c\b\u0002\u0003Br\u0005\u001f\u0004\rA!6\u0002!Q|G/\u00197U_BL7mQ8v]R\u001c\bb\u0002Bt\u0005\u001f\u0004\r!H\u0001\nm>\u001c\u0017MY*ju\u0016DqAa;\u0003P\u0002\u0007A)A\u0002fi\u0006Dq!!\u0015\u0003P\u0002\u0007A\t")
public class LDA
implements Logging {
    private int k;
    private int maxIterations;
    private Vector docConcentration;
    private double topicConcentration;
    private long seed;
    private int checkpointInterval;
    private LDAOptimizer ldaOptimizer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private Vector docConcentration() {
        return this.docConcentration;
    }

    private void docConcentration_$eq(Vector x$1) {
        this.docConcentration = x$1;
    }

    private double topicConcentration() {
        return this.topicConcentration;
    }

    private void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int checkpointInterval() {
        return this.checkpointInterval;
    }

    private void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    private LDAOptimizer ldaOptimizer() {
        return this.ldaOptimizer;
    }

    private void ldaOptimizer_$eq(LDAOptimizer x$1) {
        this.ldaOptimizer = x$1;
    }

    public int getK() {
        return this.k();
    }

    public LDA setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("LDA k (number of clusters) must be > 0, but was set to ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public Vector getAsymmetricDocConcentration() {
        return this.docConcentration();
    }

    /*
     * WARNING - void declaration
     */
    public double getDocConcentration() {
        double d;
        double parameter = this.docConcentration().apply(0);
        if (this.docConcentration().size() == 1) {
            d = parameter;
        } else {
            void var1_1;
            Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.docConcentration().toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 == parameter));
            d = var1_1;
        }
        return d;
    }

    public LDA setDocConcentration(Vector docConcentration) {
        Predef$.MODULE$.require(docConcentration.size() == 1 || docConcentration.size() == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Size of docConcentration must be 1 or ").append(this.k()).append(" but got ").append(docConcentration.size()).toString());
        this.docConcentration_$eq(docConcentration);
        return this;
    }

    public LDA setDocConcentration(double docConcentration) {
        this.docConcentration_$eq(Vectors$.MODULE$.dense(docConcentration, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])));
        return this;
    }

    public Vector getAsymmetricAlpha() {
        return this.getAsymmetricDocConcentration();
    }

    public double getAlpha() {
        return this.getDocConcentration();
    }

    public LDA setAlpha(Vector alpha) {
        return this.setDocConcentration(alpha);
    }

    public LDA setAlpha(double alpha) {
        return this.setDocConcentration(alpha);
    }

    public double getTopicConcentration() {
        return this.topicConcentration();
    }

    public LDA setTopicConcentration(double topicConcentration) {
        this.topicConcentration_$eq(topicConcentration);
        return this;
    }

    public double getBeta() {
        return this.getTopicConcentration();
    }

    public LDA setBeta(double beta) {
        return this.setTopicConcentration(beta);
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public LDA setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public LDA setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public int getCheckpointInterval() {
        return this.checkpointInterval();
    }

    public LDA setCheckpointInterval(int checkpointInterval) {
        Predef$.MODULE$.require(checkpointInterval == -1 || checkpointInterval > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Period between checkpoints must be -1 or positive but got ").append(checkpointInterval).toString());
        this.checkpointInterval_$eq(checkpointInterval);
        return this;
    }

    @DeveloperApi
    public LDAOptimizer getOptimizer() {
        return this.ldaOptimizer();
    }

    @DeveloperApi
    public LDA setOptimizer(LDAOptimizer optimizer) {
        this.ldaOptimizer_$eq(optimizer);
        return this;
    }

    public LDA setOptimizer(String optimizerName) {
        LDAOptimizer lDAOptimizer;
        String string = optimizerName.toLowerCase(Locale.ROOT);
        if ("em".equals(string)) {
            lDAOptimizer = new EMLDAOptimizer();
        } else if ("online".equals(string)) {
            lDAOptimizer = new OnlineLDAOptimizer();
        } else {
            throw new IllegalArgumentException(new StringBuilder(39).append("Only em, online are supported but got ").append(string).append(".").toString());
        }
        this.ldaOptimizer_$eq(lDAOptimizer);
        return this;
    }

    public LDAModel run(RDD<Tuple2<Object, Vector>> documents) {
        LDAOptimizer state = this.ldaOptimizer().initialize(documents, this);
        double[] iterationTimes = (double[])Array$.MODULE$.fill(this.maxIterations(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        for (int iter = 0; iter < this.maxIterations(); ++iter) {
            double elapsedSeconds;
            long start = System.nanoTime();
            state.next();
            iterationTimes[iter] = elapsedSeconds = (double)(System.nanoTime() - start) / 1.0E9;
        }
        return state.getLDAModel(iterationTimes);
    }

    public LDAModel run(JavaPairRDD<Long, Vector> documents) {
        return this.run((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private LDA(int k, int maxIterations, Vector docConcentration, double topicConcentration, long seed, int checkpointInterval, LDAOptimizer ldaOptimizer) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.seed = seed;
        this.checkpointInterval = checkpointInterval;
        this.ldaOptimizer = ldaOptimizer;
        Logging.$init$((Logging)this);
    }

    public LDA() {
        this(10, 20, Vectors$.MODULE$.dense(-1.0, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])), -1.0, Utils$.MODULE$.random().nextLong(), 10, new EMLDAOptimizer());
    }
}

