/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.normalize$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaPairRDD$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.LocalLDAModel$SaveLoadV1_0$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\r=c\u0001B\u0001\u0003\u00015\u0011Q\u0002T8dC2dE)Q'pI\u0016d'BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011\u0001\u0002\u0014#B\u001b>$W\r\u001c\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t3\u0001\u0011)\u0019!C\u00015\u00051Ao\u001c9jGN,\u0012a\u0007\t\u00039}i\u0011!\b\u0006\u0003=\u0011\ta\u0001\\5oC2<\u0017B\u0001\u0011\u001e\u0005\u0019i\u0015\r\u001e:jq\"\u001a\u0001D\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u00152\u0011AC1o]>$\u0018\r^5p]&\u0011q\u0005\n\u0002\u0006'&t7-Z\u0011\u0002S\u0005)\u0011GL\u001a/a!A1\u0006\u0001B\u0001B\u0003%1$A\u0004u_BL7m\u001d\u0011)\u0007)\u0012\u0003\u0006\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00110\u0003A!wnY\"p]\u000e,g\u000e\u001e:bi&|g.F\u00011!\ta\u0012'\u0003\u00023;\t1a+Z2u_JD3!\f\u00125C\u0005)\u0014!B\u0019/k9\u0002\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002#\u0011|7mQ8oG\u0016tGO]1uS>t\u0007\u0005K\u00027EQB\u0001B\u000f\u0001\u0003\u0006\u0004%\teO\u0001\u0013i>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|g.F\u0001=!\t\u0019R(\u0003\u0002?)\t1Ai\\;cY\u0016D3!\u000f\u00125\u0011!\t\u0005A!A!\u0002\u0013a\u0014a\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:\u0004\u0003f\u0001!#i!IA\t\u0001BC\u0002\u0013EcaO\u0001\u000bO\u0006lW.Y*iCB,\u0007\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0017\u001d\fW.\\1TQ\u0006\u0004X\r\t\u0005\u0007\u0011\u0002!\tAB%\u0002\rqJg.\u001b;?)\u0015Q5*T(R!\ty\u0001\u0001C\u0003\u001a\u000f\u0002\u00071\u0004K\u0002LE!BQAL$A\u0002AB3!\u0014\u00125\u0011\u0015Qt\t1\u0001=Q\ry%\u0005\u000e\u0005\b\t\u001e\u0003\n\u00111\u0001=\u0011\u001d\u0019\u0006\u00011A\u0005\nQ\u000bAa]3fIV\tQ\u000b\u0005\u0002\u0014-&\u0011q\u000b\u0006\u0002\u0005\u0019>tw\rC\u0004Z\u0001\u0001\u0007I\u0011\u0002.\u0002\u0011M,W\rZ0%KF$\"a\u00170\u0011\u0005Ma\u0016BA/\u0015\u0005\u0011)f.\u001b;\t\u000f}C\u0016\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\t\r\u0005\u0004\u0001\u0015)\u0003V\u0003\u0015\u0019X-\u001a3!\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003\u0005YW#A3\u0011\u0005M1\u0017BA4\u0015\u0005\rIe\u000e\u001e\u0015\u0004E\nB\u0003\"\u00026\u0001\t\u0003\"\u0017!\u0003<pG\u0006\u00147+\u001b>fQ\rI'\u0005\u000b\u0005\u0006[\u0002!\tEG\u0001\ri>\u0004\u0018nY:NCR\u0014\u0018\u000e\u001f\u0015\u0004Y\nB\u0003\"\u00029\u0001\t\u0003\n\u0018A\u00043fg\u000e\u0014\u0018NY3U_BL7m\u001d\u000b\u0003ej\u00042aE:v\u0013\t!HCA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0014mbL\u0018BA<\u0015\u0005\u0019!V\u000f\u001d7feA\u00191c]3\u0011\u0007M\u0019H\bC\u0003|_\u0002\u0007Q-\u0001\tnCb$VM]7t!\u0016\u0014Hk\u001c9jG\"\u001aqN\t\u0015\t\u000by\u0004A\u0011K@\u0002\u001b\u0019|'/\\1u-\u0016\u00148/[8o+\t\t\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\tAA[1wC&!\u0011qBA\u0003\u0005\u0019\u0019FO]5oO\"1\u00111\u0003\u0001\u0005\u0002Q\u000bqaZ3u'\u0016,G\rK\u0003\u0002\u0012\t\n9\"\t\u0002\u0002\u001a\u0005)!G\f\u001b/a!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011aB:fiN+W\r\u001a\u000b\u0005\u0003C\t\u0019#D\u0001\u0001\u0011\u0019\u0019\u00161\u0004a\u0001+\"*\u00111\u0004\u0012\u0002\u0018!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012\u0001B:bm\u0016$RaWA\u0017\u0003sA\u0001\"a\f\u0002(\u0001\u0007\u0011\u0011G\u0001\u0003g\u000e\u0004B!a\r\u000265\ta!C\u0002\u00028\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\"a\u000f\u0002(\u0001\u0007\u0011QH\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002@\u00055c\u0002BA!\u0003\u0013\u00022!a\u0011\u0015\u001b\t\t)EC\u0002\u0002H1\ta\u0001\u0010:p_Rt\u0014bAA&)\u00051\u0001K]3eK\u001aLA!a\u0004\u0002P)\u0019\u00111\n\u000b)\t\u0005\u001d\"\u0005\u000e\u0005\b\u0003+\u0002A\u0011AA,\u00035awn\u001a'jW\u0016d\u0017\u000e[8pIR\u0019A(!\u0017\t\u0011\u0005m\u00131\u000ba\u0001\u0003;\n\u0011\u0002Z8dk6,g\u000e^:\u0011\r\u0005}\u0013QMA5\u001b\t\t\tGC\u0002\u0002d\u0019\t1A\u001d3e\u0013\u0011\t9'!\u0019\u0003\u0007I#E\t\u0005\u0003\u0014mV\u0003\u0004\u0006BA*EQBq!!\u0016\u0001\t\u0003\ty\u0007F\u0002=\u0003cB\u0001\"a\u0017\u0002n\u0001\u0007\u00111\u000f\t\b\u0003k\ni(!!1\u001b\t\t9H\u0003\u0003\u0002\f\u0005e$bAA>\r\u0005\u0019\u0011\r]5\n\t\u0005}\u0014q\u000f\u0002\f\u0015\u00064\u0018\rU1jeJ#E\t\u0005\u0003\u0002\u0004\u0005\r\u0015bA,\u0002\u0006!\"\u0011Q\u000e\u00125\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017\u000bQ\u0002\\8h!\u0016\u0014\b\u000f\\3ySRLHc\u0001\u001f\u0002\u000e\"A\u00111LAD\u0001\u0004\ti\u0006\u000b\u0003\u0002\b\n\"\u0004bBAE\u0001\u0011\u0005\u00111\u0013\u000b\u0004y\u0005U\u0005\u0002CA.\u0003#\u0003\r!a\u001d)\t\u0005E%\u0005\u000e\u0005\b\u00037\u0003A\u0011BAO\u0003Iawn\u001a'jW\u0016d\u0017\u000e[8pI\n{WO\u001c3\u0015\u001fq\ny*!)\u0002&\u0006%\u00161XA_\u0003\u007fC\u0001\"a\u0017\u0002\u001a\u0002\u0007\u0011Q\f\u0005\b\u0003G\u000bI\n1\u00011\u0003\u0015\tG\u000e\u001d5b\u0011\u001d\t9+!'A\u0002q\n1!\u001a;b\u0011!\tY+!'A\u0002\u00055\u0016A\u00027b[\n$\u0017\rE\u0003\u00020\u0006]F(\u0004\u0002\u00022*\u0019a$a-\u000b\u0005\u0005U\u0016A\u00022sK\u0016TX-\u0003\u0003\u0002:\u0006E&a\u0003#f]N,W*\u0019;sSbDa\u0001RAM\u0001\u0004a\u0004BB2\u0002\u001a\u0002\u0007Q\r\u0003\u0004k\u00033\u0003\r!\u0016\u0005\b\u0003\u0007\u0004A\u0011AAc\u0003I!x\u000e]5d\t&\u001cHO]5ckRLwN\\:\u0015\t\u0005u\u0013q\u0019\u0005\t\u00037\n\t\r1\u0001\u0002^!\"\u0011\u0011\u0019\u0012)\u0011!\ti\r\u0001C\u0001\r\u0005=\u0017AG4fiR{\u0007/[2ESN$(/\u001b2vi&|g.T3uQ>$WCAAi!\u0015\u0019\u00121\u001b\u00191\u0013\r\t)\u000e\u0006\u0002\n\rVt7\r^5p]FBq!!7\u0001\t\u0003\tY.A\tu_BL7\rR5tiJL'-\u001e;j_:$2\u0001MAo\u0011\u001d\ty.a6A\u0002A\n\u0001\u0002Z8dk6,g\u000e\u001e\u0015\u0006\u0003/\u0014\u00131]\u0011\u0003\u0003K\fQA\r\u00181]ABq!a1\u0001\t\u0003\tI\u000f\u0006\u0003\u0002t\u0005-\b\u0002CA.\u0003O\u0004\r!a\u001d)\u000b\u0005\u001d(%a<\"\u0005\u0005E\u0018!B\u0019/i9\n\u0004f\u0001\u0001#Q\u001d9\u0011q\u001f\u0002\t\u0002\u0005e\u0018!\u0004'pG\u0006dG\nR!N_\u0012,G\u000eE\u0002\u0010\u0003w4a!\u0001\u0002\t\u0002\u0005u8cBA~\u0003\u007f\u0014)A\u0005\t\u0004'\t\u0005\u0011b\u0001B\u0002)\t1\u0011I\\=SK\u001a\u0004RAa\u0002\u0003\u000e)k!A!\u0003\u000b\u0007\t-A!\u0001\u0003vi&d\u0017\u0002\u0002B\b\u0005\u0013\u0011a\u0001T8bI\u0016\u0014\bb\u0002%\u0002|\u0012\u0005!1\u0003\u000b\u0003\u0003s<\u0001Ba\u0006\u0002|\"%!\u0011D\u0001\r'\u00064X\rT8bIZ\u000bt\f\r\t\u0005\u00057\u0011i\"\u0004\u0002\u0002|\u001aA!qDA~\u0011\u0013\u0011\tC\u0001\u0007TCZ,Gj\\1e-Fz\u0006g\u0005\u0003\u0003\u001e\u0005}\bb\u0002%\u0003\u001e\u0011\u0005!Q\u0005\u000b\u0003\u00053A\u0011B!\u000b\u0003\u001e\t\u0007I\u0011A@\u0002#QD\u0017n\u001d$pe6\fGOV3sg&|g\u000eC\u0005\u0003.\tu\u0001\u0015!\u0003\u0002\u0002\u0005\u0011B\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8!\u0011%\u0011\tD!\bC\u0002\u0013\u0005q0A\u0007uQ&\u001c8\t\\1tg:\u000bW.\u001a\u0005\n\u0005k\u0011i\u0002)A\u0005\u0003\u0003\ta\u0002\u001e5jg\u000ec\u0017m]:OC6,\u0007EB\u0004\u0003:\tu\u0001Ia\u000f\u0003\t\u0011\u000bG/Y\n\b\u0005o\tyP!\u0010\u0013!\r\u0019\"qH\u0005\u0004\u0005\u0003\"\"a\u0002)s_\u0012,8\r\u001e\u0005\u000b\u0005\u000b\u00129D!f\u0001\n\u0003y\u0013!\u0002;pa&\u001c\u0007B\u0003B%\u0005o\u0011\t\u0012)A\u0005a\u00051Ao\u001c9jG\u0002B!B!\u0014\u00038\tU\r\u0011\"\u0001e\u0003\u0015Ig\u000eZ3y\u0011)\u0011\tFa\u000e\u0003\u0012\u0003\u0006I!Z\u0001\u0007S:$W\r\u001f\u0011\t\u000f!\u00139\u0004\"\u0001\u0003VQ1!q\u000bB.\u0005;\u0002BA!\u0017\u000385\u0011!Q\u0004\u0005\b\u0005\u000b\u0012\u0019\u00061\u00011\u0011\u001d\u0011iEa\u0015A\u0002\u0015D!B!\u0019\u00038\u0005\u0005I\u0011\u0001B2\u0003\u0011\u0019w\u000e]=\u0015\r\t]#Q\rB4\u0011%\u0011)Ea\u0018\u0011\u0002\u0003\u0007\u0001\u0007C\u0005\u0003N\t}\u0003\u0013!a\u0001K\"Q!1\u000eB\u001c#\u0003%\tA!\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u000e\u0016\u0004a\tE4F\u0001B:!\u0011\u0011)H! \u000e\u0005\t]$\u0002\u0002B=\u0005w\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0015\"\u0012\u0002\u0002B@\u0005o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011\u0019Ia\u000e\u0012\u0002\u0013\u0005!QQ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119IK\u0002f\u0005cB\u0011Ba#\u00038\u0005\u0005I\u0011I@\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011%\u0011yIa\u000e\u0002\u0002\u0013\u0005A-\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0003\u0014\n]\u0012\u0011!C\u0001\u0005+\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0018\nu\u0005cA\n\u0003\u001a&\u0019!1\u0014\u000b\u0003\u0007\u0005s\u0017\u0010\u0003\u0005`\u0005#\u000b\t\u00111\u0001f\u0011)\u0011\tKa\u000e\u0002\u0002\u0013\u0005#1U\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0015\t\u0007\u0005O\u0013iKa&\u000e\u0005\t%&b\u0001BV)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=&\u0011\u0016\u0002\t\u0013R,'/\u0019;pe\"Q!1\u0017B\u001c\u0003\u0003%\tA!.\u0002\u0011\r\fg.R9vC2$BAa.\u0003>B\u00191C!/\n\u0007\tmFCA\u0004C_>dW-\u00198\t\u0013}\u0013\t,!AA\u0002\t]\u0005B\u0003Ba\u0005o\t\t\u0011\"\u0011\u0003D\u0006A\u0001.Y:i\u0007>$W\rF\u0001f\u0011)\u00119Ma\u000e\u0002\u0002\u0013\u0005#\u0011Z\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u0001\u0005\u000b\u0005\u001b\u00149$!A\u0005B\t=\u0017AB3rk\u0006d7\u000f\u0006\u0003\u00038\nE\u0007\"C0\u0003L\u0006\u0005\t\u0019\u0001BL\u000f)\u0011)N!\b\u0002\u0002#\u0005!q[\u0001\u0005\t\u0006$\u0018\r\u0005\u0003\u0003Z\tegA\u0003B\u001d\u0005;\t\t\u0011#\u0001\u0003\\N)!\u0011\u001cBo%AA!q\u001cBsa\u0015\u00149&\u0004\u0002\u0003b*\u0019!1\u001d\u000b\u0002\u000fI,h\u000e^5nK&!!q\u001dBq\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b\u0011\neG\u0011\u0001Bv)\t\u00119\u000e\u0003\u0006\u0003H\ne\u0017\u0011!C#\u0005\u0013D!B!=\u0003Z\u0006\u0005I\u0011\u0011Bz\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u00119F!>\u0003x\"9!Q\tBx\u0001\u0004\u0001\u0004b\u0002B'\u0005_\u0004\r!\u001a\u0005\u000b\u0005w\u0014I.!A\u0005\u0002\nu\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u007f\u001c9\u0001E\u0003\u0014\u0007\u0003\u0019)!C\u0002\u0004\u0004Q\u0011aa\u00149uS>t\u0007\u0003B\nwa\u0015D!b!\u0003\u0003z\u0006\u0005\t\u0019\u0001B,\u0003\rAH\u0005\r\u0005\u000b\u0007\u001b\u0011I.!A\u0005\n\r=\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\u0005\u0011\t\u0005\r11C\u0005\u0005\u0007+\t)A\u0001\u0004PE*,7\r\u001e\u0005\t\u0003S\u0011i\u0002\"\u0001\u0004\u001aQi1la\u0007\u0004\u001e\r}1\u0011EB\u0012\u0007KA\u0001\"a\f\u0004\u0018\u0001\u0007\u0011\u0011\u0007\u0005\t\u0003w\u00199\u00021\u0001\u0002>!1Qna\u0006A\u0002mAaALB\f\u0001\u0004\u0001\u0004B\u0002\u001e\u0004\u0018\u0001\u0007A\b\u0003\u0004E\u0007/\u0001\r\u0001\u0010\u0005\t\u0007S\u0011i\u0002\"\u0001\u0004,\u0005!An\\1e)-Q5QFB\u0018\u0007c\u0019\u0019d!\u000e\t\u0011\u0005=2q\u0005a\u0001\u0003cA\u0001\"a\u000f\u0004(\u0001\u0007\u0011Q\b\u0005\u0007]\r\u001d\u0002\u0019\u0001\u0019\t\ri\u001a9\u00031\u0001=\u0011\u0019!5q\u0005a\u0001y!A1\u0011FA~\t\u0003\u001aI\u0004F\u0003K\u0007w\u0019i\u0004\u0003\u0005\u00020\r]\u0002\u0019AA\u0019\u0011!\tYda\u000eA\u0002\u0005u\u0002\u0006BB\u001cEQB1ba\u0011\u0002|F\u0005I\u0011\u0001\u0004\u0004F\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"aa\u0012+\u0007q\u0012\t\b\u0003\u0006\u0004\u000e\u0005m\u0018\u0011!C\u0005\u0007\u001fAC!a?#i!\"\u0011Q\u001f\u00125\u0001")
public class LocalLDAModel
extends LDAModel
implements scala.Serializable {
    private final Matrix topics;
    private final Vector docConcentration;
    private final double topicConcentration;
    private final double gammaShape;
    private long seed;

    public static /* bridge */ Saveable load(SparkContext sparkContext, String string) {
        return LocalLDAModel$.MODULE$.load(sparkContext, string);
    }

    public static LocalLDAModel load(SparkContext sparkContext, String string) {
        return LocalLDAModel$.MODULE$.load(sparkContext, string);
    }

    public Matrix topics() {
        return this.topics;
    }

    @Override
    public Vector docConcentration() {
        return this.docConcentration;
    }

    @Override
    public double topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public double gammaShape() {
        return this.gammaShape;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    @Override
    public int k() {
        return this.topics().numCols();
    }

    @Override
    public int vocabSize() {
        return this.topics().numRows();
    }

    @Override
    public Matrix topicsMatrix() {
        return this.topics();
    }

    @Override
    public Tuple2<int[], double[]>[] describeTopics(int maxTermsPerTopic) {
        DenseMatrix brzTopics = this.topics().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        return (Tuple2[])((TraversableOnce)package$.MODULE$.Range().apply(0, this.k()).map((Function1 & Serializable & scala.Serializable)topicIndex -> LocalLDAModel.$anonfun$describeTopics$1(maxTermsPerTopic, brzTopics, BoxesRunTime.unboxToInt((Object)topicIndex)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    public long getSeed() {
        return this.seed();
    }

    public LocalLDAModel setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    @Override
    public void save(SparkContext sc, String path) {
        LocalLDAModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.topicsMatrix(), this.docConcentration(), this.topicConcentration(), this.gammaShape());
    }

    public double logLikelihood(RDD<Tuple2<Object, Vector>> documents) {
        return this.logLikelihoodBound(documents, this.docConcentration(), this.topicConcentration(), (DenseMatrix<Object>)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), this.gammaShape(), this.k(), this.vocabSize());
    }

    public double logLikelihood(JavaPairRDD<Long, Vector> documents) {
        return this.logLikelihood((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    public double logPerplexity(RDD<Tuple2<Object, Vector>> documents) {
        double corpusTokenCount = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$logPerplexity$1(x0$1)), ClassTag$.MODULE$.Double())).sum();
        return -this.logLikelihood(documents) / corpusTokenCount;
    }

    public double logPerplexity(JavaPairRDD<Long, Vector> documents) {
        return this.logPerplexity((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private double logLikelihoodBound(RDD<Tuple2<Object, Vector>> documents, Vector alpha, double eta, DenseMatrix<Object> lambda, double gammaShape, int k, long vocabSize) {
        DenseVector brzAlpha = alpha.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
        DenseMatrix Elogbeta = (DenseMatrix)LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)lambda.t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose());
        Broadcast ElogbetaBc = documents.sparkContext().broadcast((Object)Elogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        long gammaSeed = this.seed();
        double corpusPart = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalLDAModel.$anonfun$logLikelihoodBound$1(x$3))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$logLikelihoodBound$2(gammaShape, k, brzAlpha, ElogbetaBc, gammaSeed, x0$2)), ClassTag$.MODULE$.Double())).sum();
        ElogbetaBc.destroy(false);
        double sumEta = eta * (double)vocabSize;
        double topicsPart = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)eta))).$minus(lambda, DenseMatrix$.MODULE$.s_dm_op_Double_OpSub())).$times$colon$times((Object)Elogbeta, DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply(lambda, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).$minus((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(eta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)), DenseMatrix$.MODULE$.op_DM_S_Double_OpSub()), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(sumEta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)))).$minus(package.lgamma$.MODULE$.apply(sum$.MODULE$.apply(lambda.apply((Object)package$.MODULE$.$colon$colon(), (Object)$times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(DenseMatrix$.MODULE$.handholdCanMapRows())), sum$.MODULE$.vectorizeCols_Double(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, sum$.MODULE$.helper_Double())), Transpose$.MODULE$.liftUFunc(package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))), DenseVector$.MODULE$.liftDMOpToDVTransposeOp(DenseMatrix$.MODULE$.s_dm_op_Double_OpSub())), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues())));
        return corpusPart + topicsPart;
    }

    public RDD<Tuple2<Object, Vector>> topicDistributions(RDD<Tuple2<Object, Vector>> documents) {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        Broadcast expElogbetaBc = documents.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        breeze.linalg.Vector<Object> docConcentrationBrz = this.docConcentration().asBreeze();
        double gammaShape = this.gammaShape();
        int k = this.k();
        long gammaSeed = this.seed();
        return documents.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$4;
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            long id = tuple22._1$mcJ$sp();
            Vector termCounts = (Vector)tuple22._2();
            long l = id;
            if (termCounts == null) throw new MatchError((Object)tuple22);
            Vector vector = termCounts;
            if (vector.numNonzeros() == 0) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.zeros(k));
                return tuple2;
            } else {
                DenseVector gamma;
                Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)expElogbetaBc.value()), docConcentrationBrz, gammaShape, k, gammaSeed + l);
                if (tuple3 == null) throw new MatchError(tuple3);
                DenseVector denseVector = gamma = (DenseVector)tuple3._1();
                DenseVector gamma2 = denseVector;
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())));
            }
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Function1<Vector, Vector> getTopicDistributionMethod() {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        breeze.linalg.Vector<Object> docConcentrationBrz = this.docConcentration().asBreeze();
        double gammaShape = this.gammaShape();
        int k = this.k();
        long gammaSeed = this.seed();
        return (Function1 & Serializable & scala.Serializable)termCounts -> {
            Vector vector;
            if (termCounts.numNonzeros() == 0) {
                vector = Vectors$.MODULE$.zeros(k);
            } else {
                DenseVector gamma;
                Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference((Vector)termCounts, (DenseMatrix<Object>)expElogbeta, docConcentrationBrz, gammaShape, k, gammaSeed);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                DenseVector denseVector = gamma = (DenseVector)tuple3._1();
                DenseVector gamma2 = denseVector;
                vector = Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double()));
            }
            return vector;
        };
    }

    public Vector topicDistribution(Vector document) {
        Vector vector;
        long gammaSeed = this.seed();
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        if (document.numNonzeros() == 0) {
            vector = Vectors$.MODULE$.zeros(this.k());
        } else {
            DenseVector gamma;
            Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(document, (DenseMatrix<Object>)expElogbeta, this.docConcentration().asBreeze(), this.gammaShape(), this.k(), gammaSeed);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            DenseVector denseVector = gamma = (DenseVector)tuple3._1();
            DenseVector gamma2 = denseVector;
            vector = Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double()));
        }
        return vector;
    }

    public JavaPairRDD<Long, Vector> topicDistributions(JavaPairRDD<Long, Vector> documents) {
        RDD<Tuple2<Object, Vector>> distributions = this.topicDistributions((RDD<Tuple2<Object, Vector>>)documents.rdd());
        return JavaPairRDD$.MODULE$.fromRDD(distributions, ClassTag$.MODULE$.apply(Long.class), ClassTag$.MODULE$.apply(Vector.class));
    }

    public static final /* synthetic */ double $anonfun$describeTopics$2(Tuple2 x$1) {
        return -x$1._1$mcD$sp();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeTopics$1(int maxTermsPerTopic$1, DenseMatrix brzTopics$1, int topicIndex) {
        DenseVector topic = (DenseVector)normalize$.MODULE$.apply(brzTopics$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)topicIndex), DenseMatrix$.MODULE$.canSliceCol()), (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(topic.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$describeTopics$2(x$1)), (Ordering)Ordering.Double$.MODULE$))).take(maxTermsPerTopic$1))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] termWeights = (double[])tuple2._1();
        int[] terms = (int[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)termWeights, (Object)terms);
        Tuple2 tuple23 = tuple22;
        double[] termWeights2 = (double[])tuple23._1();
        int[] terms2 = (int[])tuple23._2();
        return new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(terms2)).toArray(ClassTag$.MODULE$.Int()), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termWeights2)).toArray(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ double $anonfun$logPerplexity$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector termCounts = (Vector)tuple2._2();
        double d = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termCounts.toArray())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$logLikelihoodBound$1(Tuple2 x$3) {
        return ((Vector)x$3._2()).numNonzeros() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ double $anonfun$logLikelihoodBound$2(double gammaShape$1, int k$1, DenseVector brzAlpha$1, Broadcast ElogbetaBc$1, long gammaSeed$1, Tuple2 x0$2) {
        DenseVector denseVector;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        long id = tuple2._1$mcJ$sp();
        Vector termCounts = (Vector)tuple2._2();
        long l = id;
        if (termCounts == null) throw new MatchError((Object)tuple2);
        Vector vector = termCounts;
        DenseMatrix localElogbeta = (DenseMatrix)ElogbetaBc$1.value();
        DoubleRef docBound = DoubleRef.create((double)0.0);
        Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)package.exp$.MODULE$.apply((Object)localElogbeta, package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), (breeze.linalg.Vector<Object>)brzAlpha$1, gammaShape$1, k$1, gammaSeed$1 + l);
        if (tuple3 == null) throw new MatchError(tuple3);
        DenseVector gammad = (DenseVector)tuple3._1();
        if (gammad == null) throw new MatchError(tuple3);
        DenseVector denseVector2 = denseVector = gammad;
        DenseVector gammad2 = denseVector2;
        DenseVector<Object> Elogthetad = LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)gammad2);
        vector.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$3, x1$1) -> {
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$3, x1$1);
            if (sp2 != null) {
                int idx = sp2._1$mcI$sp();
                double count = sp2._2$mcD$sp();
                docBound$1.elem += count * LDAUtils$.MODULE$.logSumExp((DenseVector<Object>)((DenseVector)Elogthetad.$plus(((ImmutableNumericOps)localElogbeta.apply((Object)BoxesRunTime.boxToInteger((int)idx), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()), DenseVector$.MODULE$.canAddD())));
            } else {
                throw new MatchError((Object)sp2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)brzAlpha$1.$minus((Object)gammad2, DenseVector$.MODULE$.canSubD())).$times$colon$times(Elogthetad, DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply((Object)gammad2, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).$minus(package.lgamma$.MODULE$.apply((Object)brzAlpha$1, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))), DenseVector$.MODULE$.canSubD()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        docBound.elem += package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)brzAlpha$1, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$) - package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)gammad2, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$);
        return docBound.elem;
    }

    public LocalLDAModel(Matrix topics, Vector docConcentration, double topicConcentration, double gammaShape) {
        this.topics = topics;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.gammaShape = gammaShape;
        this.seed = Utils$.MODULE$.random().nextLong();
    }
}

