/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.BitVector$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$;
import breeze.linalg.NumericOps;
import breeze.linalg.all$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.math.Ring$;
import breeze.math.Semiring$;
import breeze.numerics.package;
import breeze.stats.distributions.Gamma;
import breeze.stats.distributions.RandBasis;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Random;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import shapeless.package$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\tug\u0001B\u0001\u0003\u00055\u0011!c\u00148mS:,G\nR!PaRLW.\u001b>fe*\u00111\u0001B\u0001\u000bG2,8\u000f^3sS:<'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!\u0002\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011A\u0002\u0014#B\u001fB$\u0018.\\5{KJ\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!!\b\u000e\u0003\u000f1{wmZ5oO\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\u0012!\t\t\u0003+\u0001Aqa\t\u0001A\u0002\u0013%A%A\u0001l+\u0005)\u0003CA\b'\u0013\t9\u0003CA\u0002J]RDq!\u000b\u0001A\u0002\u0013%!&A\u0003l?\u0012*\u0017\u000f\u0006\u0002,]A\u0011q\u0002L\u0005\u0003[A\u0011A!\u00168ji\"9q\u0006KA\u0001\u0002\u0004)\u0013a\u0001=%c!1\u0011\u0007\u0001Q!\n\u0015\n!a\u001b\u0011\t\u000fM\u0002\u0001\u0019!C\u0005i\u0005Q1m\u001c:qkN\u001c\u0016N_3\u0016\u0003U\u0002\"a\u0004\u001c\n\u0005]\u0002\"\u0001\u0002'p]\u001eDq!\u000f\u0001A\u0002\u0013%!(\u0001\bd_J\u0004Xo]*ju\u0016|F%Z9\u0015\u0005-Z\u0004bB\u00189\u0003\u0003\u0005\r!\u000e\u0005\u0007{\u0001\u0001\u000b\u0015B\u001b\u0002\u0017\r|'\u000f];t'&TX\r\t\u0005\b\u007f\u0001\u0001\r\u0011\"\u0003%\u0003%1xnY1c'&TX\rC\u0004B\u0001\u0001\u0007I\u0011\u0002\"\u0002\u001bY|7-\u00192TSj,w\fJ3r)\tY3\tC\u00040\u0001\u0006\u0005\t\u0019A\u0013\t\r\u0015\u0003\u0001\u0015)\u0003&\u0003)1xnY1c'&TX\r\t\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003I\u0003\u0015\tG\u000e\u001d5b+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0005\u0003\u0019a\u0017N\\1mO&\u0011aj\u0013\u0002\u0007-\u0016\u001cGo\u001c:\t\u000fA\u0003\u0001\u0019!C\u0005#\u0006I\u0011\r\u001c9iC~#S-\u001d\u000b\u0003WICqaL(\u0002\u0002\u0003\u0007\u0011\n\u0003\u0004U\u0001\u0001\u0006K!S\u0001\u0007C2\u0004\b.\u0019\u0011\t\rY\u0003A\u0011\u0001\u0002I\u0003!9W\r^!ma\"\f\u0007b\u0002-\u0001\u0001\u0004%I!W\u0001\u0004KR\fW#\u0001.\u0011\u0005=Y\u0016B\u0001/\u0011\u0005\u0019!u.\u001e2mK\"9a\f\u0001a\u0001\n\u0013y\u0016aB3uC~#S-\u001d\u000b\u0003W\u0001DqaL/\u0002\u0002\u0003\u0007!\f\u0003\u0004c\u0001\u0001\u0006KAW\u0001\u0005KR\f\u0007\u0005\u0003\u0004e\u0001\u0011\u0005!!W\u0001\u0007O\u0016$X\t^1\t\u000f\u0019\u0004\u0001\u0019!C\u0005O\u0006y!/\u00198e_6<UM\\3sCR|'/F\u0001i!\tIg.D\u0001k\u0015\tYG.\u0001\u0003vi&d'\"A7\u0002\t)\fg/Y\u0005\u0003_*\u0014aAU1oI>l\u0007bB9\u0001\u0001\u0004%IA]\u0001\u0014e\u0006tGm\\7HK:,'/\u0019;pe~#S-\u001d\u000b\u0003WMDqa\f9\u0002\u0002\u0003\u0007\u0001\u000e\u0003\u0004v\u0001\u0001\u0006K\u0001[\u0001\u0011e\u0006tGm\\7HK:,'/\u0019;pe\u0002Bqa\u001e\u0001A\u0002\u0013%\u00010A\u000btC6\u0004H.Z,ji\"\u0014V\r\u001d7bG\u0016lWM\u001c;\u0016\u0003e\u0004\"a\u0004>\n\u0005m\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\b{\u0002\u0001\r\u0011\"\u0003\u007f\u0003e\u0019\u0018-\u001c9mK^KG\u000f\u001b*fa2\f7-Z7f]R|F%Z9\u0015\u0005-z\bbB\u0018}\u0003\u0003\u0005\r!\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003z\u0003Y\u0019\u0018-\u001c9mK^KG\u000f\u001b*fa2\f7-Z7f]R\u0004\u0003\u0002CA\u0004\u0001\u0001\u0007I\u0011B-\u0002\tQ\fW\u000f\r\u0005\n\u0003\u0017\u0001\u0001\u0019!C\u0005\u0003\u001b\t\u0001\u0002^1va}#S-\u001d\u000b\u0004W\u0005=\u0001\u0002C\u0018\u0002\n\u0005\u0005\t\u0019\u0001.\t\u000f\u0005M\u0001\u0001)Q\u00055\u0006)A/Y;1A!A\u0011q\u0003\u0001A\u0002\u0013%\u0011,A\u0003lCB\u0004\u0018\rC\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0003\u0002\u001e\u0005I1.\u00199qC~#S-\u001d\u000b\u0004W\u0005}\u0001\u0002C\u0018\u0002\u001a\u0005\u0005\t\u0019\u0001.\t\u000f\u0005\r\u0002\u0001)Q\u00055\u000611.\u00199qC\u0002B\u0001\"a\n\u0001\u0001\u0004%I!W\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\"CA\u0016\u0001\u0001\u0007I\u0011BA\u0017\u0003Ui\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\0%KF$2aKA\u0018\u0011!y\u0013\u0011FA\u0001\u0002\u0004Q\u0006bBA\u001a\u0001\u0001\u0006KAW\u0001\u0013[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0005\u0003\u0005\u00028\u0001\u0001\r\u0011\"\u0003y\u0003ay\u0007\u000f^5nSj,Gi\\2D_:\u001cWM\u001c;sCRLwN\u001c\u0005\n\u0003w\u0001\u0001\u0019!C\u0005\u0003{\tAd\u001c9uS6L'0\u001a#pG\u000e{gnY3oiJ\fG/[8o?\u0012*\u0017\u000fF\u0002,\u0003\u007fA\u0001bLA\u001d\u0003\u0003\u0005\r!\u001f\u0005\b\u0003\u0007\u0002\u0001\u0015)\u0003z\u0003ey\u0007\u000f^5nSj,Gi\\2D_:\u001cWM\u001c;sCRLwN\u001c\u0011\t\u0013\u0005\u001d\u0003\u00011A\u0005\n\u0005%\u0013\u0001\u00023pGN,\"!a\u0013\u0011\r\u00055\u00131KA,\u001b\t\tyEC\u0002\u0002R\u0019\t1A\u001d3e\u0013\u0011\t)&a\u0014\u0003\u0007I#E\tE\u0003\u0010\u00033*\u0014*C\u0002\u0002\\A\u0011a\u0001V;qY\u0016\u0014\u0004\"CA0\u0001\u0001\u0007I\u0011BA1\u0003!!wnY:`I\u0015\fHcA\u0016\u0002d!Iq&!\u0018\u0002\u0002\u0003\u0007\u00111\n\u0005\t\u0003O\u0002\u0001\u0015)\u0003\u0002L\u0005)Am\\2tA!I\u00111\u000e\u0001A\u0002\u0013%\u0011QN\u0001\u0007Y\u0006l'\rZ1\u0016\u0005\u0005=\u0004#BA9\u0003sRVBAA:\u0015\ra\u0015Q\u000f\u0006\u0003\u0003o\naA\u0019:fKj,\u0017\u0002BA>\u0003g\u00121\u0002R3og\u0016l\u0015\r\u001e:jq\"I\u0011q\u0010\u0001A\u0002\u0013%\u0011\u0011Q\u0001\u000bY\u0006l'\rZ1`I\u0015\fHcA\u0016\u0002\u0004\"Iq&! \u0002\u0002\u0003\u0007\u0011q\u000e\u0005\t\u0003\u000f\u0003\u0001\u0015)\u0003\u0002p\u00059A.Y7cI\u0006\u0004\u0003\u0002CAF\u0001\u0011\u0005!!!\u001c\u0002\u0013\u001d,G\u000fT1nE\u0012\f\u0007\u0002CAH\u0001\u0001\u0007I\u0011\u0002\u0013\u0002\u0013%$XM]1uS>t\u0007\"CAJ\u0001\u0001\u0007I\u0011BAK\u00035IG/\u001a:bi&|gn\u0018\u0013fcR\u00191&a&\t\u0011=\n\t*!AA\u0002\u0015Bq!a'\u0001A\u0003&Q%\u0001\u0006ji\u0016\u0014\u0018\r^5p]\u0002B\u0001\"a(\u0001\u0001\u0004%I!W\u0001\u000bO\u0006lW.Y*iCB,\u0007\"CAR\u0001\u0001\u0007I\u0011BAS\u000399\u0017-\\7b'\"\f\u0007/Z0%KF$2aKAT\u0011!y\u0013\u0011UA\u0001\u0002\u0004Q\u0006bBAV\u0001\u0001\u0006KAW\u0001\fO\u0006lW.Y*iCB,\u0007\u0005\u0003\u0004\u00020\u0002!\t!W\u0001\bO\u0016$H+Y;1Q\u0019\ti+a-\u0002@B!\u0011QWA^\u001b\t\t9LC\u0002\u0002:\u001a\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti,a.\u0003\u000bMKgnY3\"\u0005\u0005\u0005\u0017!B\u0019/i9\u0002\u0004bBAc\u0001\u0011\u0005\u0011qY\u0001\bg\u0016$H+Y;1)\u0011\tI-a3\u000e\u0003\u0001Aq!a\u0002\u0002D\u0002\u0007!\f\u000b\u0004\u0002D\u0006M\u0016q\u0018\u0005\u0007\u0003#\u0004A\u0011A-\u0002\u0011\u001d,GoS1qa\u0006Dc!a4\u00024\u0006}\u0006bBAl\u0001\u0011\u0005\u0011\u0011\\\u0001\tg\u0016$8*\u00199qCR!\u0011\u0011ZAn\u0011\u001d\t9\"!6A\u0002iCc!!6\u00024\u0006}\u0006BBAq\u0001\u0011\u0005\u0011,\u0001\u000bhKRl\u0015N\\5CCR\u001c\u0007N\u0012:bGRLwN\u001c\u0015\u0007\u0003?\f\u0019,a0\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\u0006!2/\u001a;NS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:$B!!3\u0002l\"9\u0011qEAs\u0001\u0004Q\u0006FBAs\u0003g\u000by\f\u0003\u0004\u0002r\u0002!\t\u0001_\u0001\u001cO\u0016$x\n\u001d;j[&TX\rR8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8)\r\u0005=\u00181WA{C\t\t90A\u00032]Ur\u0003\u0007C\u0004\u0002|\u0002!\t!!@\u00027M,Go\u00149uS6L'0\u001a#pG\u000e{gnY3oiJ\fG/[8o)\u0011\tI-a@\t\u000f\u0005]\u0012\u0011 a\u0001s\"2\u0011\u0011`AZ\u0003kD\u0001B!\u0002\u0001\t\u0003\u0011!qA\u0001\ng\u0016$H*Y7cI\u0006$B!!3\u0003\n!A\u00111\u000eB\u0002\u0001\u0004\ty\u0007\u0003\u0005\u0003\u000e\u0001!\tA\u0001B\b\u00035\u0019X\r^$b[6\f7\u000b[1qKR!\u0011\u0011\u001aB\t\u0011\u001d\u0011\u0019Ba\u0003A\u0002i\u000bQa\u001d5ba\u0016D\u0001Ba\u0006\u0001\t\u0003\u0011!\u0011D\u0001\u0019g\u0016$8+Y7qY\u0016<\u0016\u000e\u001e5SKBd\u0017mY3nK:$H\u0003BAe\u00057AqA!\b\u0003\u0016\u0001\u0007\u00110A\u0004sKBd\u0017mY3\t\u0011\t\u0005\u0002\u0001\"\u0011\u0003\u0005G\t!\"\u001b8ji&\fG.\u001b>f)\u0015\t#Q\u0005B\u0014\u0011!\t9Ea\bA\u0002\u0005-\u0003\u0002\u0003B\u0015\u0005?\u0001\rAa\u000b\u0002\u00071$\u0017\rE\u0002\u0016\u0005[I1Aa\f\u0003\u0005\raE)\u0011\u0005\b\u0005g\u0001A\u0011\t\u0002!\u0003\u0011qW\r\u001f;\t\u0011\t]\u0002\u0001\"\u0001\u0003\u0005s\tqb];c[&$X*\u001b8j\u0005\u0006$8\r\u001b\u000b\u0004C\tm\u0002\u0002\u0003B\u001f\u0005k\u0001\r!a\u0013\u0002\u000b\t\fGo\u00195\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D\u0005aQ\u000f\u001d3bi\u0016d\u0015-\u001c2eCR)1F!\u0012\u0003J!A!q\tB \u0001\u0004\ty'\u0001\u0003ti\u0006$\bb\u0002B&\u0005\u007f\u0001\r!J\u0001\nE\u0006$8\r[*ju\u0016DqAa\u0014\u0001\t\u0013\u0011\t&A\u0006va\u0012\fG/Z!ma\"\fG#B\u0016\u0003T\tu\u0003\u0002\u0003B+\u0005\u001b\u0002\rAa\u0016\u0002\u000f1|w\r\u001d5biB)\u0011\u0011\u000fB-5&!!1LA:\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u000f\t}#Q\na\u00015\u0006ian\u001c8F[B$\u0018\u0010R8dg:CqAa\u0019\u0001\t\u0013\u0011)'A\u0002sQ>$\u0012A\u0017\u0005\b\u0005S\u0002A\u0011\u0002B6\u000399W\r^$b[6\fW*\u0019;sSb$b!a\u001c\u0003n\tE\u0004b\u0002B8\u0005O\u0002\r!J\u0001\u0004e><\bb\u0002B:\u0005O\u0002\r!J\u0001\u0004G>d\u0007\u0002\u0003B<\u0001\u0011\u0005#A!\u001f\u0002\u0017\u001d,G\u000f\u0014#B\u001b>$W\r\u001c\u000b\u0005\u0005w\u0012\t\tE\u0002\u0016\u0005{J1Aa \u0003\u0005!aE)Q'pI\u0016d\u0007\u0002\u0003BB\u0005k\u0002\rA!\"\u0002\u001d%$XM]1uS>tG+[7fgB!qBa\"[\u0013\r\u0011I\t\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0004\u0001\t5\u0005\u0003BA[\u0005\u001fKAA!%\u00028\naA)\u001a<fY>\u0004XM]!qS\"*\u0001!a-\u0002@\u001eA!q\u0013\u0002\t\u0002\t\u0011I*\u0001\nP]2Lg.\u001a'E\u0003>\u0003H/[7ju\u0016\u0014\bcA\u000b\u0003\u001c\u001a9\u0011A\u0001E\u0001\u0005\tu5c\u0001BN\u001d!9qDa'\u0005\u0002\t\u0005FC\u0001BM\u0011%\u0011)Ka'\u0005\u0002\t\u00119+A\rwCJL\u0017\r^5p]\u0006dGk\u001c9jG&sg-\u001a:f]\u000e,GC\u0004BU\u0005\u000f\u0014YMa4\u0003V\n]'\u0011\u001c\t\n\u001f\t-&qKA8\u0005_K1A!,\u0011\u0005\u0019!V\u000f\u001d7fgA)!\u0011\u0017BaK9!!1\u0017B_\u001d\u0011\u0011)La/\u000e\u0005\t]&b\u0001B]\u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u0005\u007f\u0003\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005\u0007\u0014)M\u0001\u0003MSN$(b\u0001B`!!9!\u0011\u001aBR\u0001\u0004I\u0015A\u0003;fe6\u001cu.\u001e8ug\"A!Q\u001aBR\u0001\u0004\ty'A\u0006fqB,En\\4cKR\f\u0007bB$\u0003$\u0002\u0007!\u0011\u001b\t\u0006\u0003c\u0012\u0019NW\u0005\u0004\u001d\u0006M\u0004bBAP\u0005G\u0003\rA\u0017\u0005\u0007G\t\r\u0006\u0019A\u0013\t\u000f\tm'1\u0015a\u0001k\u0005!1/Z3e\u0001")
public final class OnlineLDAOptimizer
implements LDAOptimizer,
Logging {
    private int k;
    private long corpusSize;
    private int vocabSize;
    private Vector alpha;
    private double eta;
    private Random randomGenerator;
    private boolean sampleWithReplacement;
    private double tau0;
    private double kappa;
    private double miniBatchFraction;
    private boolean optimizeDocConcentration;
    private RDD<Tuple2<Object, Vector>> docs;
    private DenseMatrix<Object> lambda;
    private int iteration;
    private double gammaShape;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private long corpusSize() {
        return this.corpusSize;
    }

    private void corpusSize_$eq(long x$1) {
        this.corpusSize = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    private Vector alpha() {
        return this.alpha;
    }

    private void alpha_$eq(Vector x$1) {
        this.alpha = x$1;
    }

    public Vector getAlpha() {
        return this.alpha();
    }

    private double eta() {
        return this.eta;
    }

    private void eta_$eq(double x$1) {
        this.eta = x$1;
    }

    public double getEta() {
        return this.eta();
    }

    private Random randomGenerator() {
        return this.randomGenerator;
    }

    private void randomGenerator_$eq(Random x$1) {
        this.randomGenerator = x$1;
    }

    private boolean sampleWithReplacement() {
        return this.sampleWithReplacement;
    }

    private void sampleWithReplacement_$eq(boolean x$1) {
        this.sampleWithReplacement = x$1;
    }

    private double tau0() {
        return this.tau0;
    }

    private void tau0_$eq(double x$1) {
        this.tau0 = x$1;
    }

    private double kappa() {
        return this.kappa;
    }

    private void kappa_$eq(double x$1) {
        this.kappa = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private boolean optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    private void optimizeDocConcentration_$eq(boolean x$1) {
        this.optimizeDocConcentration = x$1;
    }

    private RDD<Tuple2<Object, Vector>> docs() {
        return this.docs;
    }

    private void docs_$eq(RDD<Tuple2<Object, Vector>> x$1) {
        this.docs = x$1;
    }

    private DenseMatrix<Object> lambda() {
        return this.lambda;
    }

    private void lambda_$eq(DenseMatrix<Object> x$1) {
        this.lambda = x$1;
    }

    public DenseMatrix<Object> getLambda() {
        return this.lambda();
    }

    private int iteration() {
        return this.iteration;
    }

    private void iteration_$eq(int x$1) {
        this.iteration = x$1;
    }

    private double gammaShape() {
        return this.gammaShape;
    }

    private void gammaShape_$eq(double x$1) {
        this.gammaShape = x$1;
    }

    public double getTau0() {
        return this.tau0();
    }

    public OnlineLDAOptimizer setTau0(double tau0) {
        Predef$.MODULE$.require(tau0 > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("LDA tau0 must be positive, but was set to ").append(tau0).toString());
        this.tau0_$eq(tau0);
        return this;
    }

    public double getKappa() {
        return this.kappa();
    }

    public OnlineLDAOptimizer setKappa(double kappa) {
        Predef$.MODULE$.require(kappa >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Online LDA kappa must be nonnegative, but was set to ").append(kappa).toString());
        this.kappa_$eq(kappa);
        return this;
    }

    public double getMiniBatchFraction() {
        return this.miniBatchFraction();
    }

    public OnlineLDAOptimizer setMiniBatchFraction(double miniBatchFraction) {
        Predef$.MODULE$.require(miniBatchFraction > 0.0 && miniBatchFraction <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Online LDA miniBatchFraction must be in range (0,1], but was set to ").append(miniBatchFraction).toString());
        this.miniBatchFraction_$eq(miniBatchFraction);
        return this;
    }

    public boolean getOptimizeDocConcentration() {
        return this.optimizeDocConcentration();
    }

    public OnlineLDAOptimizer setOptimizeDocConcentration(boolean optimizeDocConcentration) {
        this.optimizeDocConcentration_$eq(optimizeDocConcentration);
        return this;
    }

    public OnlineLDAOptimizer setLambda(DenseMatrix<Object> lambda) {
        this.lambda_$eq(lambda);
        return this;
    }

    public OnlineLDAOptimizer setGammaShape(double shape) {
        this.gammaShape_$eq(shape);
        return this;
    }

    public OnlineLDAOptimizer setSampleWithReplacement(boolean replace) {
        this.sampleWithReplacement_$eq(replace);
        return this;
    }

    @Override
    public OnlineLDAOptimizer initialize(RDD<Tuple2<Object, Vector>> docs, LDA lda) {
        Vector vector;
        this.k_$eq(lda.getK());
        this.corpusSize_$eq(docs.count());
        this.vocabSize_$eq(((Vector)((Tuple2)docs.first())._2()).size());
        if (lda.getAsymmetricDocConcentration().size() == 1) {
            if (lda.getAsymmetricDocConcentration().apply(0) == (double)-1) {
                vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0 / (double)this.k(), ClassTag$.MODULE$.Double()));
            } else {
                Predef$.MODULE$.require(lda.getAsymmetricDocConcentration().apply(0) >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("all entries in alpha must be >=0, got: ").append(this.alpha()).toString());
                vector = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> lda.getAsymmetricDocConcentration().apply(0), ClassTag$.MODULE$.Double()));
            }
        } else {
            Predef$.MODULE$.require(lda.getAsymmetricDocConcentration().size() == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("alpha must have length k, got: ").append(this.alpha()).toString());
            lda.getAsymmetricDocConcentration().foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$4, x1$2) -> {
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$4, x1$2);
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                double x = sp2._2$mcD$sp();
                Predef$.MODULE$.require(x >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("all entries in alpha must be >= 0, got: ").append(this.alpha()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
            vector = lda.getAsymmetricDocConcentration();
        }
        this.alpha_$eq(vector);
        this.eta_$eq(lda.getTopicConcentration() == (double)-1 ? 1.0 / (double)this.k() : lda.getTopicConcentration());
        this.randomGenerator_$eq(new Random(lda.getSeed()));
        this.docs_$eq(docs);
        this.lambda_$eq(this.getGammaMatrix(this.k(), this.vocabSize()));
        this.iteration_$eq(0);
        return this;
    }

    @Override
    public OnlineLDAOptimizer next() {
        RDD batch = this.docs().sample(this.sampleWithReplacement(), this.miniBatchFraction(), this.randomGenerator().nextLong());
        if (batch.isEmpty()) {
            return this;
        }
        return this.submitMiniBatch((RDD<Tuple2<Object, Vector>>)batch);
    }

    public OnlineLDAOptimizer submitMiniBatch(RDD<Tuple2<Object, Vector>> batch) {
        DenseMatrix denseMatrix;
        long nonEmptyDocsN;
        Option logphatOption;
        Broadcast expElogbetaBc;
        DenseMatrix expElogbeta;
        block5: {
            Tuple3 tuple3;
            block4: {
                this.iteration_$eq(this.iteration() + 1);
                int k = this.k();
                int vocabSize = this.vocabSize();
                expElogbeta = (DenseMatrix)((ImmutableNumericOps)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation(this.lambda()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).t(DenseMatrix$.MODULE$.canTranspose());
                expElogbetaBc = batch.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
                breeze.linalg.Vector<Object> alpha = this.alpha().asBreeze();
                double gammaShape = this.gammaShape();
                boolean optimizeDocConcentration = this.optimizeDocConcentration();
                long seed = this.randomGenerator().nextLong();
                Function0 & Serializable & scala.Serializable logphatPartOptionBase = (Function0 & Serializable & scala.Serializable)() -> optimizeDocConcentration ? new Some((Object)DenseVector$.MODULE$.zeros$mDc$sp(k, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$)) : None$.MODULE$;
                RDD stats = batch.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(index, docs) -> OnlineLDAOptimizer.$anonfun$submitMiniBatch$2(k, vocabSize, expElogbetaBc, alpha, gammaShape, seed, logphatPartOptionBase, BoxesRunTime.unboxToInt((Object)index), docs), batch.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple3.class));
                Function2 & Serializable & scala.Serializable elementWiseSum = (Function2 & Serializable & scala.Serializable)(u, v) -> {
                    ((NumericOps)u._1()).$plus$eq(v._1(), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpAdd());
                    ((Option)u._2()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (DenseVector)x$10.$plus$eq(((Option)v._2()).get(), DenseVector$.MODULE$.canAddIntoD()));
                    return new Tuple3(u._1(), u._2(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)u._3()) + BoxesRunTime.unboxToLong((Object)v._3()))));
                };
                Tuple3 x$18 = new Tuple3((Object)DenseMatrix$.MODULE$.zeros$mDc$sp(k, vocabSize, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), logphatPartOptionBase.apply(), (Object)BoxesRunTime.boxToLong((long)0L));
                Function2 & Serializable & scala.Serializable x$19 = elementWiseSum;
                Function2 & Serializable & scala.Serializable x$20 = elementWiseSum;
                int x$21 = stats.treeAggregate$default$4((Object)x$18);
                tuple3 = (Tuple3)stats.treeAggregate((Object)x$18, (Function2)x$19, (Function2)x$20, x$21, ClassTag$.MODULE$.apply(Tuple3.class));
                if (tuple3 == null) break block4;
                DenseMatrix statsSum = (DenseMatrix)tuple3._1();
                logphatOption = (Option)tuple3._2();
                nonEmptyDocsN = BoxesRunTime.unboxToLong((Object)tuple3._3());
                if (statsSum == null) break block4;
                denseMatrix = statsSum;
                if (logphatOption != null) break block5;
            }
            throw new MatchError((Object)tuple3);
        }
        Option option = logphatOption;
        long l = nonEmptyDocsN;
        Tuple3 tuple3 = new Tuple3((Object)denseMatrix, (Object)option, (Object)BoxesRunTime.boxToLong((long)l));
        Tuple3 tuple32 = tuple3;
        DenseMatrix statsSum = (DenseMatrix)tuple32._1();
        Option logphatOption2 = (Option)tuple32._2();
        long nonEmptyDocsN2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
        expElogbetaBc.destroy(false);
        if (nonEmptyDocsN2 == 0L) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No non-empty documents were submitted in the batch.");
            return this;
        }
        DenseMatrix batchResult = (DenseMatrix)statsSum.$times$colon$times(expElogbeta.t(DenseMatrix$.MODULE$.canTranspose()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar());
        int batchSize = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(this.miniBatchFraction() * (double)this.corpusSize()));
        this.updateLambda((DenseMatrix<Object>)batchResult, batchSize);
        logphatOption2.foreach((Function1 & Serializable & scala.Serializable)x$12 -> (DenseVector)x$12.$div$eq((Object)BoxesRunTime.boxToDouble((double)nonEmptyDocsN2), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpDiv()));
        logphatOption2.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            this.updateAlpha((DenseVector<Object>)x$13, nonEmptyDocsN2);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    private void updateLambda(DenseMatrix<Object> stat, int batchSize) {
        double weight = this.rho();
        this.lambda().$colon$eq(((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)(1.0 - weight)))).$times(this.lambda(), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix())).$plus(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times(((NumericOps)stat.$times((Object)BoxesRunTime.boxToDouble((double)((double)this.corpusSize() / (double)batchSize)), DenseMatrix$.MODULE$.op_DM_S_Double_OpMulMatrix())).$plus((Object)BoxesRunTime.boxToDouble((double)this.eta()), DenseMatrix$.MODULE$.op_DM_S_Double_OpAdd()), DenseMatrix$.MODULE$.s_dm_op_Double_OpMulMatrix()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpAdd()), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
    }

    private void updateAlpha(DenseVector<Object> logphat, double nonEmptyDocsN) {
        block0: {
            double weight = this.rho();
            DenseVector alpha = this.alpha().asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
            DenseVector gradf = (DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)nonEmptyDocsN))).$times(((NumericOps)LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)alpha).unary_$minus(DenseVector$.MODULE$.negFromScale(DenseVector$.MODULE$.dv_s_Op_Double_OpMulScalar(), Ring$.MODULE$.ringD()))).$plus(logphat, DenseVector$.MODULE$.canAddD()), DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix());
            double c = nonEmptyDocsN * package.trigamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)alpha, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.trigamma$.trigammaImplDouble$.MODULE$);
            DenseVector q = (DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)(-nonEmptyDocsN)))).$times(package.trigamma$.MODULE$.apply((Object)alpha, package.trigamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.trigamma$.trigammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))), DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix());
            double b = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(gradf.$div((Object)q, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) / (1.0 / c + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)1.0))).$div((Object)q, DenseVector$.MODULE$.s_dv_Op_Double_OpDiv()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))));
            DenseVector dalpha = (DenseVector)((ImmutableNumericOps)((ImmutableNumericOps)gradf.$minus((Object)BoxesRunTime.boxToDouble((double)b), DenseVector$.MODULE$.dv_s_Op_Double_OpSub())).unary_$minus(DenseVector$.MODULE$.negFromScale(DenseVector$.MODULE$.dv_s_Op_Double_OpMulScalar(), Ring$.MODULE$.ringD()))).$div((Object)q, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv());
            if (!BoxesRunTime.unboxToBoolean((Object)all$.MODULE$.apply(((NumericOps)((NumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times((Object)dalpha, DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix())).$plus((Object)alpha, DenseVector$.MODULE$.canAddD())).$greater$colon$greater((Object)BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_CompOp_Double_OpGT()), (UFunc.UImpl)BitVector$.MODULE$.allImpl()))) break block0;
            alpha.$colon$plus$eq(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)weight))).$times((Object)dalpha, DenseVector$.MODULE$.s_dv_Op_Double_OpMulMatrix()), DenseVector$.MODULE$.canAddIntoD());
            this.alpha_$eq(Vectors$.MODULE$.dense(alpha.toArray$mcD$sp(ClassTag$.MODULE$.Double())));
        }
    }

    private double rho() {
        return scala.math.package$.MODULE$.pow(this.getTau0() + (double)this.iteration(), -this.getKappa());
    }

    private DenseMatrix<Object> getGammaMatrix(int row, int col) {
        RandBasis randBasis = new RandBasis((RandomGenerator)new MersenneTwister(this.randomGenerator().nextLong()));
        Gamma gammaRandomGenerator = new Gamma(this.gammaShape(), 1.0 / this.gammaShape(), randBasis);
        double[] temp = (double[])gammaRandomGenerator.sample(row * col).toArray(ClassTag$.MODULE$.Double());
        return (DenseMatrix)new DenseMatrix.mcD.sp(col, row, temp).t(DenseMatrix$.MODULE$.canTranspose());
    }

    @Override
    public LDAModel getLDAModel(double[] iterationTimes) {
        return new LocalLDAModel(Matrices$.MODULE$.fromBreeze((Matrix<Object>)this.lambda()).transpose(), this.alpha(), this.eta(), LocalLDAModel$.MODULE$.$lessinit$greater$default$4()).setSeed(this.randomGenerator().nextLong());
    }

    public static final /* synthetic */ boolean $anonfun$submitMiniBatch$3(Tuple2 x$7) {
        return ((Vector)x$7._2()).numNonzeros() > 0;
    }

    public static final /* synthetic */ void $anonfun$submitMiniBatch$4(int k$2, Broadcast expElogbetaBc$1, breeze.linalg.Vector alpha$2, double gammaShape$1, long seed$1, DenseMatrix stat$1, Option logphatPartOption$1, LongRef nonEmptyDocCount$1, int index$1, Tuple2 x0$5) {
        Tuple3 tuple3;
        Vector termCounts;
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null && (termCounts = (Vector)tuple2._2()) != null) {
            Vector vector = termCounts;
            ++nonEmptyDocCount$1.elem;
            Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple32 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)expElogbetaBc$1.value()), (breeze.linalg.Vector<Object>)alpha$2, gammaShape$1, k$2, seed$1 + (long)index$1);
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            DenseVector gammad = (DenseVector)tuple32._1();
            DenseMatrix sstats = (DenseMatrix)tuple32._2();
            List ids = (List)tuple32._3();
            tuple3 = new Tuple3((Object)gammad, (Object)sstats, (Object)ids);
        } else {
            throw new MatchError((Object)tuple2);
        }
        Tuple3 tuple33 = tuple3;
        DenseVector gammad = (DenseVector)tuple33._1();
        DenseMatrix sstats = (DenseMatrix)tuple33._2();
        List ids = (List)tuple33._3();
        ((NumericOps)stat$1.apply((Object)scala.package$.MODULE$.$colon$colon(), (Object)ids, DenseMatrix$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double()))).$colon$eq(((NumericOps)stat$1.apply((Object)scala.package$.MODULE$.$colon$colon(), (Object)ids, DenseMatrix$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double()))).$plus((Object)sstats, Matrix$.MODULE$.castOps(Predef$.MODULE$.$conforms(), package$.MODULE$.neq(), Predef$.MODULE$.$conforms(), package$.MODULE$.neq(), (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd())), Matrix$.MODULE$.castUpdateOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.InPlaceImpl2)Matrix$.MODULE$.m_m_UpdateOp_Double_OpSet()));
        logphatPartOption$1.foreach((Function1 & Serializable & scala.Serializable)x$9 -> (DenseVector)x$9.$plus$eq(LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)gammad), DenseVector$.MODULE$.canAddIntoD()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Iterator $anonfun$submitMiniBatch$2(int k$2, int vocabSize$1, Broadcast expElogbetaBc$1, breeze.linalg.Vector alpha$2, double gammaShape$1, long seed$1, Function0 logphatPartOptionBase$1, int index, Iterator docs) {
        Iterator nonEmptyDocs = docs.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)OnlineLDAOptimizer.$anonfun$submitMiniBatch$3(x$7)));
        DenseMatrix stat = DenseMatrix$.MODULE$.zeros$mDc$sp(k$2, vocabSize$1, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Option logphatPartOption = (Option)logphatPartOptionBase$1.apply();
        LongRef nonEmptyDocCount = LongRef.create((long)0L);
        nonEmptyDocs.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            OnlineLDAOptimizer.$anonfun$submitMiniBatch$4(k$2, expElogbetaBc$1, alpha$2, gammaShape$1, seed$1, stat, logphatPartOption, nonEmptyDocCount, index, x0$5);
            return BoxedUnit.UNIT;
        });
        return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)stat, (Object)logphatPartOption, (Object)BoxesRunTime.boxToLong((long)nonEmptyDocCount.elem))}));
    }

    public OnlineLDAOptimizer() {
        Logging.$init$((Logging)this);
        this.k = 0;
        this.corpusSize = 0L;
        this.vocabSize = 0;
        this.alpha = Vectors$.MODULE$.dense(0.0, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0]));
        this.eta = 0.0;
        this.randomGenerator = null;
        this.sampleWithReplacement = true;
        this.tau0 = 1024.0;
        this.kappa = 0.51;
        this.miniBatchFraction = 0.05;
        this.optimizeDocConcentration = false;
        this.docs = null;
        this.lambda = null;
        this.iteration = 0;
        this.gammaShape = 100.0;
    }
}

