/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.mllib.clustering.PowerIterationClustering$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u0001\u0003\u00015\u0011\u0001\u0004U8xKJLE/\u001a:bi&|gn\u00117vgR,'/\u001b8h\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0019\u0001\t\u0005\r\u0011\"\u0003\u001a\u0003\u0005YW#\u0001\u000e\u0011\u0005=Y\u0012B\u0001\u000f\u0011\u0005\rIe\u000e\u001e\u0005\t=\u0001\u0011\t\u0019!C\u0005?\u0005)1n\u0018\u0013fcR\u0011\u0001e\t\t\u0003\u001f\u0005J!A\t\t\u0003\tUs\u0017\u000e\u001e\u0005\bIu\t\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\tM\u0001\u0011\t\u0011)Q\u00055\u0005\u00111\u000e\t\u0005\tQ\u0001\u0011\t\u0019!C\u00053\u0005iQ.\u0019=Ji\u0016\u0014\u0018\r^5p]ND\u0001B\u000b\u0001\u0003\u0002\u0004%IaK\u0001\u0012[\u0006D\u0018\n^3sCRLwN\\:`I\u0015\fHC\u0001\u0011-\u0011\u001d!\u0013&!AA\u0002iA\u0001B\f\u0001\u0003\u0002\u0003\u0006KAG\u0001\u000f[\u0006D\u0018\n^3sCRLwN\\:!\u0011!\u0001\u0004A!a\u0001\n\u0013\t\u0014\u0001C5oSRlu\u000eZ3\u0016\u0003I\u0002\"a\r\u001e\u000f\u0005QB\u0004CA\u001b\u0011\u001b\u00051$BA\u001c\r\u0003\u0019a$o\\8u}%\u0011\u0011\bE\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:!!Aa\b\u0001BA\u0002\u0013%q(\u0001\u0007j]&$Xj\u001c3f?\u0012*\u0017\u000f\u0006\u0002!\u0001\"9A%PA\u0001\u0002\u0004\u0011\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u001a\u0002\u0013%t\u0017\u000e^'pI\u0016\u0004\u0003B\u0002#\u0001\t\u0003\u0011Q)\u0001\u0004=S:LGO\u0010\u000b\u0005\r\"K%\n\u0005\u0002H\u00015\t!\u0001C\u0003\u0019\u0007\u0002\u0007!\u0004C\u0003)\u0007\u0002\u0007!\u0004C\u00031\u0007\u0002\u0007!\u0007C\u0003E\u0001\u0011\u0005A\nF\u0001GQ\rYe\n\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u001a\t!\"\u00198o_R\fG/[8o\u0013\t\u0019\u0006KA\u0003TS:\u001cW-I\u0001V\u0003\u0015\tdf\r\u00181\u0011\u00159\u0006\u0001\"\u0001Y\u0003\u0011\u0019X\r^&\u0015\u0005eSV\"\u0001\u0001\t\u000ba1\u0006\u0019\u0001\u000e)\u0007YsE\u000bC\u0003^\u0001\u0011\u0005a,\u0001\ttKRl\u0015\r_%uKJ\fG/[8ogR\u0011\u0011l\u0018\u0005\u0006Qq\u0003\rA\u0007\u0015\u00049:#\u0006\"\u00022\u0001\t\u0003\u0019\u0017!F:fi&s\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u000b\u00033\u0012DQ!Z1A\u0002I\nA!\\8eK\"\u001a\u0011M\u0014+\t\u000b!\u0004A\u0011A5\u0002\u0007I,h\u000e\u0006\u0002k[B\u0011qi[\u0005\u0003Y\n\u0011Q\u0004U8xKJLE/\u001a:bi&|gn\u00117vgR,'/\u001b8h\u001b>$W\r\u001c\u0005\u0006]\u001e\u0004\ra\\\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0005aN,X/D\u0001r\u0015\t\u0011h!\u0001\u0004he\u0006\u0004\b\u000e_\u0005\u0003iF\u0014Qa\u0012:ba\"\u0004\"a\u0004<\n\u0005]\u0004\"A\u0002#pk\ndW\rK\u0002h\u001df\f\u0013A_\u0001\u0006c9*d\u0006\r\u0005\u0006Q\u0002!\t\u0001 \u000b\u0003UvDQA`>A\u0002}\fAb]5nS2\f'/\u001b;jKN\u0004b!!\u0001\u0002\b\u0005-QBAA\u0002\u0015\r\t)AB\u0001\u0004e\u0012$\u0017\u0002BA\u0005\u0003\u0007\u00111A\u0015#E!!y\u0011QBA\t\u0003#)\u0018bAA\b!\t1A+\u001e9mKN\u00022aDA\n\u0013\r\t)\u0002\u0005\u0002\u0005\u0019>tw\rK\u0002|\u001dRCa\u0001\u001b\u0001\u0005\u0002\u0005mAc\u00016\u0002\u001e!9a0!\u0007A\u0002\u0005}\u0001CBA\u0011\u0003W\ty#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0011Q\u0017M^1\u000b\u0007\u0005%b!A\u0002ba&LA!!\f\u0002$\t9!*\u0019<b%\u0012#\u0005#C\b\u0002\u000e\u0005E\u0012\u0011GA\u001f!\u0011\t\u0019$a\u000f\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA\u0001\\1oO*\u0011\u0011QE\u0005\u0005\u0003+\t)\u0004\u0005\u0003\u00024\u0005}\u0012bA<\u00026!\"\u0011\u0011\u0004(U\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000f\n1\u0001]5d)\rQ\u0017\u0011\n\u0005\b\u0003\u0017\n\u0019\u00051\u0001p\u0003\u00059\bf\u0001\u0001O)\u001e9\u0011\u0011\u000b\u0002\t\u0002\u0005M\u0013\u0001\u0007)po\u0016\u0014\u0018\n^3sCRLwN\\\"mkN$XM]5oOB\u0019q)!\u0016\u0007\r\u0005\u0011\u0001\u0012AA,'\u0019\t)FDA-)A!\u00111LA1\u001b\t\tiFC\u0002\u0002`\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003G\niFA\u0004M_\u001e<\u0017N\\4\t\u000f\u0011\u000b)\u0006\"\u0001\u0002hQ\u0011\u00111\u000b\u0004\b\u0003W\n)\u0006QA7\u0005)\t5o]5h]6,g\u000e^\n\u0007\u0003Sr\u0011q\u000e\u000b\u0011\u0007=\t\t(C\u0002\u0002tA\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0006\u0002x\u0005%$Q3A\u0005\u0002\u0005e\u0014AA5e+\t\t\t\u0002C\u0006\u0002~\u0005%$\u0011#Q\u0001\n\u0005E\u0011aA5eA!Q\u0011\u0011QA5\u0005+\u0007I\u0011A\r\u0002\u000f\rdWo\u001d;fe\"Q\u0011QQA5\u0005#\u0005\u000b\u0011\u0002\u000e\u0002\u0011\rdWo\u001d;fe\u0002Bq\u0001RA5\t\u0003\tI\t\u0006\u0004\u0002\f\u0006=\u0015\u0011\u0013\t\u0005\u0003\u001b\u000bI'\u0004\u0002\u0002V!A\u0011qOAD\u0001\u0004\t\t\u0002C\u0004\u0002\u0002\u0006\u001d\u0005\u0019\u0001\u000e\t\u0015\u0005U\u0015\u0011NA\u0001\n\u0003\t9*\u0001\u0003d_BLHCBAF\u00033\u000bY\n\u0003\u0006\u0002x\u0005M\u0005\u0013!a\u0001\u0003#A\u0011\"!!\u0002\u0014B\u0005\t\u0019\u0001\u000e\t\u0015\u0005}\u0015\u0011NI\u0001\n\u0003\t\t+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r&\u0006BA\t\u0003K[#!a*\u0011\t\u0005%\u0016\u0011W\u0007\u0003\u0003WSA!!,\u00020\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003#BIA!a-\u0002,\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005]\u0016\u0011NI\u0001\n\u0003\tI,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m&f\u0001\u000e\u0002&\"Q\u0011qXA5\u0003\u0003%\t%!1\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\r\u0005\u0003\u00024\u0005\u0015\u0017bA\u001e\u00026!I\u0011\u0011ZA5\u0003\u0003%\t!G\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0003\u001b\fI'!A\u0005\u0002\u0005=\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003#\f9\u000eE\u0002\u0010\u0003'L1!!6\u0011\u0005\r\te.\u001f\u0005\tI\u0005-\u0017\u0011!a\u00015!Q\u00111\\A5\u0003\u0003%\t%!8\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a8\u0011\r\u0005\u0005\u0018q]Ai\u001b\t\t\u0019OC\u0002\u0002fB\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI/a9\u0003\u0011%#XM]1u_JD!\"!<\u0002j\u0005\u0005I\u0011AAx\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAy\u0003o\u00042aDAz\u0013\r\t)\u0010\u0005\u0002\b\u0005>|G.Z1o\u0011%!\u00131^A\u0001\u0002\u0004\t\t\u000e\u0003\u0006\u0002|\u0006%\u0014\u0011!C!\u0003{\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u00025!Q!\u0011AA5\u0003\u0003%\tEa\u0001\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a1\t\u0015\t\u001d\u0011\u0011NA\u0001\n\u0003\u0012I!\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003c\u0014Y\u0001C\u0005%\u0005\u000b\t\t\u00111\u0001\u0002R\"\"\u0011\u0011\u000e(U\u000f)\u0011\t\"!\u0016\u0002\u0002#\u0005!1C\u0001\u000b\u0003N\u001c\u0018n\u001a8nK:$\b\u0003BAG\u0005+1!\"a\u001b\u0002V\u0005\u0005\t\u0012\u0001B\f'\u0015\u0011)B!\u0007\u0015!%\u0011YB!\t\u0002\u0012i\tY)\u0004\u0002\u0003\u001e)\u0019!q\u0004\t\u0002\u000fI,h\u000e^5nK&!!1\u0005B\u000f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b\t\nUA\u0011\u0001B\u0014)\t\u0011\u0019\u0002\u0003\u0006\u0003\u0002\tU\u0011\u0011!C#\u0005\u0007A!B!\f\u0003\u0016\u0005\u0005I\u0011\u0011B\u0018\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tYI!\r\u00034!A\u0011q\u000fB\u0016\u0001\u0004\t\t\u0002C\u0004\u0002\u0002\n-\u0002\u0019\u0001\u000e\t\u0015\t]\"QCA\u0001\n\u0003\u0013I$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tm\"q\t\t\u0006\u001f\tu\"\u0011I\u0005\u0004\u0005\u007f\u0001\"AB(qi&|g\u000e\u0005\u0004\u0010\u0005\u0007\n\tBG\u0005\u0004\u0005\u000b\u0002\"A\u0002+va2,'\u0007\u0003\u0006\u0003J\tU\u0012\u0011!a\u0001\u0003\u0017\u000b1\u0001\u001f\u00131\u0011)\u0011iE!\u0006\u0002\u0002\u0013%!qJ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003RA!\u00111\u0007B*\u0013\u0011\u0011)&!\u000e\u0003\r=\u0013'.Z2u\u0011%\u0011I&!\u0016\u0005\u0002\t\u0011Y&A\u0005o_Jl\u0017\r\\5{KR\u0019qN!\u0018\t\r9\u00149\u00061\u0001p\u0011%\u0011I&!\u0016\u0005\u0002\t\u0011\t\u0007F\u0002p\u0005GBaA B0\u0001\u0004y\b\"\u0003B4\u0003+\"\tA\u0001B5\u0003)\u0011\u0018M\u001c3p[&s\u0017\u000e\u001e\u000b\u0004_\n-\u0004b\u0002B7\u0005K\u0002\ra\\\u0001\u0002O\"I!\u0011OA+\t\u0003\u0011!1O\u0001\u0011S:LG\u000fR3he\u0016,g+Z2u_J$2a\u001cB;\u0011\u001d\u0011iGa\u001cA\u0002=D\u0011B!\u001f\u0002V\u0011\u0005!Aa\u001f\u0002\u0013A|w/\u001a:Ji\u0016\u0014HC\u0002B?\u0005\u0007\u0013)\t\u0005\u0003q\u0005\u007f*\u0018b\u0001BAc\nIa+\u001a:uKb\u0014F\t\u0012\u0005\b\u0005[\u00129\b1\u0001p\u0011\u0019A#q\u000fa\u00015!I!\u0011RA+\t\u0003\u0011!1R\u0001\u0007W6+\u0017M\\:\u0015\r\t5%q\u0012BJ!\u0011\u0001(q\u0010\u000e\t\u0011\tE%q\u0011a\u0001\u0005{\n\u0011A\u001e\u0005\u00071\t\u001d\u0005\u0019\u0001\u000e\t\u0015\t5\u0013QKA\u0001\n\u0013\u0011y\u0005\u000b\u0003\u0002V9#\u0006\u0006BA(\u001dR\u0003")
public class PowerIterationClustering
implements scala.Serializable {
    private int k;
    private int maxIterations;
    private String initMode;

    public static void logWarning(Function0<String> function0) {
        PowerIterationClustering$.MODULE$.logWarning(function0);
    }

    public static void logDebug(Function0<String> function0) {
        PowerIterationClustering$.MODULE$.logDebug(function0);
    }

    public static void logInfo(Function0<String> function0) {
        PowerIterationClustering$.MODULE$.logInfo(function0);
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String initMode() {
        return this.initMode;
    }

    private void initMode_$eq(String x$1) {
        this.initMode = x$1;
    }

    public PowerIterationClustering setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public PowerIterationClustering setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public PowerIterationClustering setInitializationMode(String mode) {
        String string = mode;
        boolean bl = "random".equals(string) ? true : "degree".equals(string);
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid initialization mode: ").append(mode).toString());
        }
        String string2 = mode;
        this.initMode_$eq(string2);
        return this;
    }

    public PowerIterationClusteringModel run(Graph<Object, Object> graph) {
        Graph<Object, Object> graph2;
        Graph<Object, Object> w = PowerIterationClustering$.MODULE$.normalize(graph);
        String string = this.initMode();
        if ("random".equals(string)) {
            graph2 = PowerIterationClustering$.MODULE$.randomInit(w);
        } else if ("degree".equals(string)) {
            graph2 = PowerIterationClustering$.MODULE$.initDegreeVector(w);
        } else {
            throw new MatchError((Object)string);
        }
        Graph<Object, Object> w0 = graph2;
        return this.pic(w0);
    }

    public PowerIterationClusteringModel run(RDD<Tuple3<Object, Object, Object>> similarities) {
        Graph<Object, Object> graph;
        Graph<Object, Object> w = PowerIterationClustering$.MODULE$.normalize(similarities);
        String string = this.initMode();
        if ("random".equals(string)) {
            graph = PowerIterationClustering$.MODULE$.randomInit(w);
        } else if ("degree".equals(string)) {
            graph = PowerIterationClustering$.MODULE$.initDegreeVector(w);
        } else {
            throw new MatchError((Object)string);
        }
        Graph<Object, Object> w0 = graph;
        return this.pic(w0);
    }

    public PowerIterationClusteringModel run(JavaRDD<Tuple3<Long, Long, Double>> similarities) {
        return this.run((RDD<Tuple3<Object, Object, Object>>)similarities.rdd());
    }

    private PowerIterationClusteringModel pic(Graph<Object, Object> w) {
        VertexRDD<Object> v = PowerIterationClustering$.MODULE$.powerIter(w, this.maxIterations());
        RDD assignments = PowerIterationClustering$.MODULE$.kMeans(v, this.k()).mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            int cluster = tuple2._2$mcI$sp();
            Assignment assignment = new Assignment(id, cluster);
            return assignment;
        }), true, ClassTag$.MODULE$.apply(Assignment.class));
        return new PowerIterationClusteringModel(this.k(), (RDD<Assignment>)assignments);
    }

    public PowerIterationClustering(int k, int maxIterations, String initMode) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.initMode = initMode;
    }

    public PowerIterationClustering() {
        this(2, 100, "random");
    }

    public static class Assignment
    implements Product,
    scala.Serializable {
        private final long id;
        private final int cluster;

        public long id() {
            return this.id;
        }

        public int cluster() {
            return this.cluster;
        }

        public Assignment copy(long id, int cluster) {
            return new Assignment(id, cluster);
        }

        public long copy$default$1() {
            return this.id();
        }

        public int copy$default$2() {
            return this.cluster();
        }

        public String productPrefix() {
            return "Assignment";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                case 0: {
                    number = BoxesRunTime.boxToLong((long)this.id());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToInteger((int)this.cluster());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Assignment;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.id()));
            n = Statics.mix((int)n, (int)this.cluster());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Assignment)) return false;
            boolean bl = true;
            if (!bl) return false;
            Assignment assignment = (Assignment)x$1;
            if (this.id() != assignment.id()) return false;
            if (this.cluster() != assignment.cluster()) return false;
            if (!assignment.canEqual(this)) return false;
            return true;
        }

        public Assignment(long id, int cluster) {
            this.id = id;
            this.cluster = cluster;
            Product.$init$((Product)this);
        }
    }
}

