/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.StreamingKMeans$;
import org.apache.spark.mllib.clustering.StreamingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStream$;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0001\u0003\u00015\u0011qb\u0015;sK\u0006l\u0017N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00155A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oOB\u0011qbG\u0005\u00039A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0002\u0004%\taH\u0001\u0002WV\t\u0001\u0005\u0005\u0002\u0010C%\u0011!\u0005\u0005\u0002\u0004\u0013:$\bfA\u000f%UA\u0011Q\u0005K\u0007\u0002M)\u0011qEB\u0001\u000bC:tw\u000e^1uS>t\u0017BA\u0015'\u0005\u0015\u0019\u0016N\\2fC\u0005Y\u0013!B\u0019/e9\u0002\u0004\u0002C\u0017\u0001\u0005\u0003\u0007I\u0011\u0001\u0018\u0002\u000b-|F%Z9\u0015\u0005=\u0012\u0004CA\b1\u0013\t\t\u0004C\u0001\u0003V]&$\bbB\u001a-\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004f\u0001\u0017%U!Aa\u0007\u0001B\u0001B\u0003&\u0001%\u0001\u0002lA!\u001aQ\u0007\n\u0016\t\u0011e\u0002!\u00111A\u0005\u0002i\n1\u0002Z3dCf4\u0015m\u0019;peV\t1\b\u0005\u0002\u0010y%\u0011Q\b\u0005\u0002\u0007\t>,(\r\\3)\u0007a\"#\u0006\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0001B\u0003=!WmY1z\r\u0006\u001cGo\u001c:`I\u0015\fHCA\u0018C\u0011\u001d\u0019t(!AA\u0002mB3a\u0010\u0013+\u0011!)\u0005A!A!B\u0013Y\u0014\u0001\u00043fG\u0006Lh)Y2u_J\u0004\u0003f\u0001#%U!A\u0001\n\u0001BA\u0002\u0013\u0005\u0011*\u0001\u0005uS6,WK\\5u+\u0005Q\u0005CA&S\u001d\ta\u0005\u000b\u0005\u0002N!5\taJ\u0003\u0002P\u0019\u00051AH]8pizJ!!\u0015\t\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#BA3a\u0012\u0013+\u0011!9\u0006A!a\u0001\n\u0003A\u0016\u0001\u0004;j[\u0016,f.\u001b;`I\u0015\fHCA\u0018Z\u0011\u001d\u0019d+!AA\u0002)C3A\u0016\u0013+\u0011!a\u0006A!A!B\u0013Q\u0015!\u0003;j[\u0016,f.\u001b;!Q\rYFE\u000b\u0005\u0006?\u0002!\t\u0001Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\u001cWm\u001a\t\u0003E\u0002i\u0011A\u0001\u0005\u0006=y\u0003\r\u0001\t\u0015\u0004G\u0012R\u0003\"B\u001d_\u0001\u0004Y\u0004fA3%U!)\u0001J\u0018a\u0001\u0015\"\u001aq\r\n\u0016)\u0007y##\u0006C\u0003`\u0001\u0011\u00051\u000eF\u0001bQ\rQGE\u000b\u0005\b]\u0002\u0001\r\u0011\"\u0005p\u0003\u0015iw\u000eZ3m+\u0005\u0001\bC\u00012r\u0013\t\u0011(A\u0001\u000bTiJ,\u0017-\\5oO.kU-\u00198t\u001b>$W\r\u001c\u0005\bi\u0002\u0001\r\u0011\"\u0005v\u0003%iw\u000eZ3m?\u0012*\u0017\u000f\u0006\u00020m\"91g]A\u0001\u0002\u0004\u0001\bB\u0002=\u0001A\u0003&\u0001/\u0001\u0004n_\u0012,G\u000e\t\u0005\u0006u\u0002!\ta_\u0001\u0005g\u0016$8\n\u0006\u0002}{6\t\u0001\u0001C\u0003\u001fs\u0002\u0007\u0001\u0005K\u0002zI)Bq!!\u0001\u0001\t\u0003\t\u0019!\u0001\btKR$UmY1z\r\u0006\u001cGo\u001c:\u0015\u0007q\f)\u0001\u0003\u0004\u0002\b}\u0004\raO\u0001\u0002C\"\u001aq\u0010\n\u0016\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\u0005Y1/\u001a;IC24G*\u001b4f)\u0015a\u0018\u0011CA\u000b\u0011\u001d\t\u0019\"a\u0003A\u0002m\n\u0001\u0002[1mM2Kg-\u001a\u0005\u0007\u0011\u0006-\u0001\u0019\u0001&)\t\u0005-AE\u000b\u0005\b\u00037\u0001A\u0011AA\u000f\u0003E\u0019X\r^%oSRL\u0017\r\\\"f]R,'o\u001d\u000b\u0006y\u0006}\u0011Q\u0007\u0005\t\u0003C\tI\u00021\u0001\u0002$\u000591-\u001a8uKJ\u001c\b#B\b\u0002&\u0005%\u0012bAA\u0014!\t)\u0011I\u001d:bsB!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020\u0011\ta\u0001\\5oC2<\u0017\u0002BA\u001a\u0003[\u0011aAV3di>\u0014\b\u0002CA\u001c\u00033\u0001\r!!\u000f\u0002\u000f],\u0017n\u001a5ugB!q\"!\n<Q\u0011\tI\u0002\n\u0016\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B\u0005\u00012/\u001a;SC:$w.\\\"f]R,'o\u001d\u000b\by\u0006\r\u0013qIA&\u0011\u001d\t)%!\u0010A\u0002\u0001\n1\u0001Z5n\u0011\u001d\tI%!\u0010A\u0002m\naa^3jO\"$\bBCA'\u0003{\u0001\n\u00111\u0001\u0002P\u0005!1/Z3e!\ry\u0011\u0011K\u0005\u0004\u0003'\u0002\"\u0001\u0002'p]\u001eDC!!\u0010%U!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013a\u00037bi\u0016\u001cH/T8eK2$\u0012\u0001\u001d\u0015\u0005\u0003/\"#\u0006C\u0004\u0002b\u0001!\t!a\u0019\u0002\u000fQ\u0014\u0018-\u001b8P]R\u0019q&!\u001a\t\u0011\u0005\u001d\u0014q\fa\u0001\u0003S\nA\u0001Z1uCB1\u00111NA;\u0003Si!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\bIN$(/Z1n\u0015\r\t\u0019HB\u0001\ngR\u0014X-Y7j]\u001eLA!a\u001e\u0002n\t9Ai\u0015;sK\u0006l\u0007\u0006BA0I)Bq!!\u0019\u0001\t\u0003\ti\bF\u00020\u0003\u007fB\u0001\"a\u001a\u0002|\u0001\u0007\u0011\u0011\u0011\t\u0007\u0003\u0007\u000bi)!\u000b\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000bAA[1wC*!\u00111RA9\u0003\r\t\u0007/[\u0005\u0005\u0003\u001f\u000b)IA\u0006KCZ\fGi\u0015;sK\u0006l\u0007&BA>I\u0005M\u0015EAAK\u0003\u0015\td\u0006\u000e\u00181\u0011\u001d\tI\n\u0001C\u0001\u00037\u000b\u0011\u0002\u001d:fI&\u001cGo\u00148\u0015\t\u0005u\u0015q\u0014\t\u0006\u0003W\n)\b\t\u0005\t\u0003O\n9\n1\u0001\u0002j!\"\u0011q\u0013\u0013+\u0011\u001d\tI\n\u0001C\u0001\u0003K#B!a*\u00028B1\u00111QAG\u0003S\u0003B!a+\u000246\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,\u0001\u0003mC:<'BAAD\u0013\u0011\t),!,\u0003\u000f%sG/Z4fe\"A\u0011qMAR\u0001\u0004\t\t\tK\u0003\u0002$\u0012\n\u0019\nC\u0004\u0002>\u0002!\t!a0\u0002\u001fA\u0014X\rZ5di>sg+\u00197vKN,B!!1\u0002RR!\u00111YAz)\u0011\t)-a9\u0011\r\u0005-\u0014QOAd!\u0019y\u0011\u0011ZAgA%\u0019\u00111\u001a\t\u0003\rQ+\b\u000f\\33!\u0011\ty-!5\r\u0001\u0011A\u00111[A^\u0005\u0004\t)NA\u0001L#\u0011\t9.!8\u0011\u0007=\tI.C\u0002\u0002\\B\u0011qAT8uQ&tw\rE\u0002\u0010\u0003?L1!!9\u0011\u0005\r\te.\u001f\u0005\u000b\u0003K\fY,!AA\u0004\u0005\u001d\u0018AC3wS\u0012,gnY3%cA1\u0011\u0011^Ax\u0003\u001bl!!a;\u000b\u0007\u00055\b#A\u0004sK\u001adWm\u0019;\n\t\u0005E\u00181\u001e\u0002\t\u00072\f7o\u001d+bO\"A\u0011qMA^\u0001\u0004\t)\u0010\u0005\u0004\u0002l\u0005U\u0014q\u001f\t\b\u001f\u0005%\u0017QZA\u0015Q\u0011\tY\f\n\u0016\t\u000f\u0005u\u0006\u0001\"\u0001\u0002~V!\u0011q B\u0005)\u0011\u0011\tAa\u0003\u0011\u0011\u0005\r%1\u0001B\u0004\u0003SKAA!\u0002\u0002\u0006\ny!*\u0019<b!\u0006L'\u000fR*ue\u0016\fW\u000e\u0005\u0003\u0002P\n%A\u0001CAj\u0003w\u0014\r!!6\t\u0011\u0005\u001d\u00141 a\u0001\u0005\u001b\u0001\u0002\"a!\u0003\u0004\t\u001d\u0011\u0011\u0006\u0015\u0006\u0003w$\u00131\u0013\u0005\t\u0005'\u0001\u0001\u0015\"\u0003\u0003\u0016\u0005\t\u0012m]:feRLe.\u001b;jC2L'0\u001a3\u0015\u0003=B\u0011B!\u0007\u0001#\u0003%\tAa\u0007\u00025M,GOU1oI>l7)\u001a8uKJ\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu!\u0006BA(\u0005?Y#A!\t\u0011\t\t\r\"1F\u0007\u0003\u0005KQAAa\n\u0003*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003OAIAA!\f\u0003&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3)\u0007\u0001!#f\u0002\u0005\u00034\tA\tA\u0001B\u001b\u0003=\u0019FO]3b[&twmS'fC:\u001c\bc\u00012\u00038\u00199\u0011A\u0001E\u0001\u0005\te2\u0003\u0002B\u001c\u001diAqa\u0018B\u001c\t\u0003\u0011i\u0004\u0006\u0002\u00036!Q!\u0011\tB\u001c\u0005\u0004%)Aa\u0011\u0002\u000f\t\u000bEk\u0011%F'V\u0011!QI\b\u0003\u0005\u000f\n#A!\u0013\u0002\u000f\t\fGo\u00195fg\"I!Q\nB\u001cA\u00035!QI\u0001\t\u0005\u0006#6\tS#TA!Q!\u0011\u000bB\u001c\u0005\u0004%)Aa\u0015\u0002\rA{\u0015J\u0014+T+\t\u0011)f\u0004\u0002\u0003X\u0005\u0012!\u0011L\u0001\u0007a>Lg\u000e^:\t\u0013\tu#q\u0007Q\u0001\u000e\tU\u0013a\u0002)P\u0013:#6\u000b\t\u0005\u000b\u0005C\u00129$!A\u0005\n\t\r\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u001a\u0011\t\u0005-&qM\u0005\u0005\u0005S\niK\u0001\u0004PE*,7\r\u001e")
public class StreamingKMeans
implements Logging,
scala.Serializable {
    private int k;
    private double decayFactor;
    private String timeUnit;
    private StreamingKMeansModel model;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String POINTS() {
        return StreamingKMeans$.MODULE$.POINTS();
    }

    public static String BATCHES() {
        return StreamingKMeans$.MODULE$.BATCHES();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int k() {
        return this.k;
    }

    public void k_$eq(int x$1) {
        this.k = x$1;
    }

    public double decayFactor() {
        return this.decayFactor;
    }

    public void decayFactor_$eq(double x$1) {
        this.decayFactor = x$1;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public void timeUnit_$eq(String x$1) {
        this.timeUnit = x$1;
    }

    public StreamingKMeansModel model() {
        return this.model;
    }

    public void model_$eq(StreamingKMeansModel x$1) {
        this.model = x$1;
    }

    public StreamingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public StreamingKMeans setDecayFactor(double a) {
        Predef$.MODULE$.require(a >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Decay factor must be nonnegative but got ").append(a).toString());
        this.decayFactor_$eq(a);
        return this;
    }

    public StreamingKMeans setHalfLife(double halfLife, String timeUnit) {
        Predef$.MODULE$.require(halfLife > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Half life must be positive but got ").append(halfLife).toString());
        String string = timeUnit;
        String string2 = "batches";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = timeUnit;
            String string4 = "points";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw new IllegalArgumentException(new StringBuilder(29).append("Invalid time unit for decay: ").append(timeUnit).toString());
            }
        }
        this.decayFactor_$eq(package$.MODULE$.exp(package$.MODULE$.log(0.5) / halfLife));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Setting decay factor to: %g ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.decayFactor())})));
        this.timeUnit_$eq(timeUnit);
        return this;
    }

    public StreamingKMeans setInitialCenters(Vector[] centers, double[] weights) {
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).size(), (Function0 & Serializable & scala.Serializable)() -> "Number of initial centers must be equal to number of weights");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).size() == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Number of initial centers must be ").append(this.k()).append(" but got ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers)).size()).toString());
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 >= 0.0), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Weight for each initial center must be nonnegative but got [").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).mkString(" ")).append("]").toString());
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public StreamingKMeans setRandomCenters(int dim, double weight, long seed) {
        Predef$.MODULE$.require(dim > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Number of dimensions must be positive but got ").append(dim).toString());
        Predef$.MODULE$.require(weight >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Weight for each center must be nonnegative but got ").append(weight).toString());
        XORShiftRandom random = new XORShiftRandom(seed);
        Vector[] centers = (Vector[])Array$.MODULE$.fill(this.k(), (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random.nextGaussian(), ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Vector.class));
        double[] weights = (double[])Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> weight, ClassTag$.MODULE$.Double());
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public long setRandomCenters$default$3() {
        return Utils$.MODULE$.random().nextLong();
    }

    public StreamingKMeansModel latestModel() {
        return this.model();
    }

    public void trainOn(DStream<Vector> data) {
        this.assertInitialized();
        data.foreachRDD((Function2 & Serializable & scala.Serializable)(rdd, time) -> {
            this.model_$eq(this.model().update((RDD<Vector>)rdd, this.decayFactor(), this.timeUnit()));
            return BoxedUnit.UNIT;
        });
    }

    public void trainOn(JavaDStream<Vector> data) {
        this.trainOn((DStream<Vector>)data.dstream());
    }

    public DStream<Object> predictOn(DStream<Vector> data) {
        this.assertInitialized();
        StreamingKMeansModel streamingKMeansModel = this.model();
        return data.map((Function1 & Serializable & scala.Serializable)point -> BoxesRunTime.boxToInteger((int)streamingKMeansModel.predict(point)), ClassTag$.MODULE$.Int());
    }

    public JavaDStream<Integer> predictOn(JavaDStream<Vector> data) {
        return JavaDStream$.MODULE$.fromDStream(this.predictOn((DStream<Vector>)data.dstream()), ClassTag$.MODULE$.apply(Integer.class));
    }

    public <K> DStream<Tuple2<K, Object>> predictOnValues(DStream<Tuple2<K, Vector>> data, ClassTag<K> evidence$1) {
        this.assertInitialized();
        DStream<Tuple2<K, Vector>> x$6 = data;
        ClassTag<K> x$7 = evidence$1;
        ClassTag x$8 = ClassTag$.MODULE$.apply(Vector.class);
        Null$ x$9 = DStream$.MODULE$.toPairDStreamFunctions$default$4(x$6);
        StreamingKMeansModel streamingKMeansModel = this.model();
        return DStream$.MODULE$.toPairDStreamFunctions(x$6, x$7, x$8, null).mapValues((Function1 & Serializable & scala.Serializable)point -> BoxesRunTime.boxToInteger((int)streamingKMeansModel.predict(point)), ClassTag$.MODULE$.Int());
    }

    public <K> JavaPairDStream<K, Integer> predictOnValues(JavaPairDStream<K, Vector> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return JavaPairDStream$.MODULE$.fromPairDStream(this.predictOnValues(data.dstream(), tag), tag, ClassTag$.MODULE$.apply(Integer.class));
    }

    private void assertInitialized() {
        if (this.model().clusterCenters() == null) {
            throw new IllegalStateException("Initial cluster centers must be set before starting predictions");
        }
    }

    public StreamingKMeans(int k, double decayFactor, String timeUnit) {
        this.k = k;
        this.decayFactor = decayFactor;
        this.timeUnit = timeUnit;
        Logging.$init$((Logging)this);
        this.model = new StreamingKMeansModel(null, null);
    }

    public StreamingKMeans() {
        this(2, 1.0, "batches");
    }
}

