/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqView;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001b\t!2\u000b\u001e:fC6LgnZ&NK\u0006t7/T8eK2T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tY1*T3b]Nlu\u000eZ3m!\t\u0019b#D\u0001\u0015\u0015\t)b!\u0001\u0005j]R,'O\\1m\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0001!Q1A\u0005Bi\tab\u00197vgR,'oQ3oi\u0016\u00148/F\u0001\u001c!\rar$I\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t)\u0011I\u001d:bsB\u0011!%J\u0007\u0002G)\u0011A\u0005B\u0001\u0007Y&t\u0017\r\\4\n\u0005\u0019\u001a#A\u0002,fGR|'\u000fK\u0002\u0019Q9\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002.U\t)1+\u001b8dK\u0006\nq&A\u00032]Ir\u0003\u0007\u0003\u00052\u0001\t\u0005\t\u0015!\u0003\u001c\u0003=\u0019G.^:uKJ\u001cUM\u001c;feN\u0004\u0003f\u0001\u0019)]!AA\u0007\u0001BC\u0002\u0013\u0005Q'\u0001\bdYV\u001cH/\u001a:XK&<\u0007\u000e^:\u0016\u0003Y\u00022\u0001H\u00108!\ta\u0002(\u0003\u0002:;\t1Ai\\;cY\u0016D3a\r\u0015/\u0011!a\u0004A!A!\u0002\u00131\u0014aD2mkN$XM],fS\u001eDGo\u001d\u0011)\u0007mBc\u0006C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0004\u0003\n#\u0005CA\b\u0001\u0011\u0015Ib\b1\u0001\u001cQ\r\u0011\u0005F\f\u0005\u0006iy\u0002\rA\u000e\u0015\u0004\t\"r\u0003f\u0001 )]!)\u0001\n\u0001C\u0001\u0013\u00061Q\u000f\u001d3bi\u0016$B!\u0011&S)\")1j\u0012a\u0001\u0019\u0006!A-\u0019;b!\ri\u0005+I\u0007\u0002\u001d*\u0011qJB\u0001\u0004e\u0012$\u0017BA)O\u0005\r\u0011F\t\u0012\u0005\u0006'\u001e\u0003\raN\u0001\fI\u0016\u001c\u0017-\u001f$bGR|'\u000fC\u0003V\u000f\u0002\u0007a+\u0001\u0005uS6,WK\\5u!\t9fL\u0004\u0002Y9B\u0011\u0011,H\u0007\u00025*\u00111\fD\u0001\u0007yI|w\u000e\u001e \n\u0005uk\u0012A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X\u000f)\u0007\u001dCc\u0006K\u0002\u0001Q9\u0002")
public class StreamingKMeansModel
extends KMeansModel
implements Logging {
    private final Vector[] clusterCenters;
    private final double[] clusterWeights;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public Vector[] clusterCenters() {
        return this.clusterCenters;
    }

    public double[] clusterWeights() {
        return this.clusterWeights;
    }

    public StreamingKMeansModel update(RDD<Vector> data, double decayFactor, String timeUnit) {
        double d;
        RDD closest = data.map((Function1 & Serializable & scala.Serializable)point -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.predict((Vector)point)), (Object)new Tuple2(point, (Object)BoxesRunTime.boxToLong((long)1L))), ClassTag$.MODULE$.apply(Tuple2.class));
        Function2 & Serializable & scala.Serializable mergeContribs = (Function2 & Serializable & scala.Serializable)(p1, p2) -> {
            BLAS$.MODULE$.axpy(1.0, (Vector)p2._1(), (Vector)p1._1());
            return new Tuple2(p1._1(), (Object)BoxesRunTime.boxToLong((long)(p1._2$mcJ$sp() + p2._2$mcJ$sp())));
        };
        int dim = this.clusterCenters()[0].size();
        Tuple2[] pointStats = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(closest, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).aggregateByKey((Object)new Tuple2((Object)Vectors$.MODULE$.zeros(dim), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)mergeContribs, (Function2)mergeContribs, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        String string = timeUnit;
        if ("batches".equals(string)) {
            d = decayFactor;
        } else if ("points".equals(string)) {
            long numNewPoints = BoxesRunTime.unboxToLong((Object)((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pointStats)).view().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)StreamingKMeansModel.$anonfun$update$3(x0$1)), IndexedSeqView$.MODULE$.arrCanBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            d = package$.MODULE$.pow(decayFactor, (double)numNewPoints);
        } else {
            throw new MatchError((Object)string);
        }
        double discount = d;
        BLAS$.MODULE$.scal(discount, Vectors$.MODULE$.dense(this.clusterWeights()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pointStats)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            StreamingKMeansModel.$anonfun$update$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
        SeqView weightsWithIndex = (SeqView)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.clusterWeights())).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom());
        Tuple2 tuple2 = (Tuple2)weightsWithIndex.maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double maxWeight = tuple2._1$mcD$sp();
        int largest = tuple2._2$mcI$sp();
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(maxWeight, largest);
        Tuple2.mcDI.sp sp3 = sp2;
        double maxWeight2 = sp3._1$mcD$sp();
        int largest2 = sp3._2$mcI$sp();
        Tuple2 tuple22 = (Tuple2)weightsWithIndex.minBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        double minWeight = tuple22._1$mcD$sp();
        int smallest = tuple22._2$mcI$sp();
        Tuple2.mcDI.sp sp4 = new Tuple2.mcDI.sp(minWeight, smallest);
        Tuple2.mcDI.sp sp5 = sp4;
        double minWeight2 = sp5._1$mcD$sp();
        int smallest2 = sp5._2$mcI$sp();
        if (minWeight2 < 1.0E-8 * maxWeight2) {
            double weight;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Cluster ").append(smallest2).append(" is dying. Split the largest cluster ").append(largest2).append(" into two.").toString());
            this.clusterWeights()[largest2] = weight = (maxWeight2 + minWeight2) / 2.0;
            this.clusterWeights()[smallest2] = weight;
            Vector largestClusterCenter = this.clusterCenters()[largest2];
            Vector smallestClusterCenter = this.clusterCenters()[smallest2];
            for (int j = 0; j < dim; ++j) {
                double x = largestClusterCenter.apply(j);
                double p = 1.0E-14 * package$.MODULE$.max(package$.MODULE$.abs(x), 1.0);
                largestClusterCenter.asBreeze().update$mcID$sp(j, x + p);
                smallestClusterCenter.asBreeze().update$mcID$sp(j, x - p);
            }
        }
        return new StreamingKMeansModel(this.clusterCenters(), this.clusterWeights());
    }

    public static final /* synthetic */ long $anonfun$update$3(Tuple2 x0$1) {
        long n;
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$1;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        long l = n = tuple2._2$mcJ$sp();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$update$4(StreamingKMeansModel $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int label = tuple2._1$mcI$sp();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Vector sum = (Vector)tuple22._1();
        long count = tuple22._2$mcJ$sp();
        Vector centroid = $this.clusterCenters()[label];
        double updatedWeight = $this.clusterWeights()[label] + (double)count;
        double lambda = (double)count / package$.MODULE$.max(updatedWeight, 1.0E-16);
        $this.clusterWeights()[label] = updatedWeight;
        BLAS$.MODULE$.scal(1.0 - lambda, centroid);
        BLAS$.MODULE$.axpy(lambda / (double)count, sum, centroid);
        int n = $this.clusterCenters()[label].size();
        switch (n) {
            default: 
        }
        String display = n > 100 ? new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(centroid.toArray())).take(100))).mkString("[", ",", "...") : new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(centroid.toArray())).mkString("[", ",", "]");
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Cluster ").append(label).append(" updated with weight ").append(updatedWeight).append(" and centroid: ").append(display).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StreamingKMeansModel(Vector[] clusterCenters, double[] clusterWeights) {
        this.clusterCenters = clusterCenters;
        this.clusterWeights = clusterWeights;
        super(clusterCenters);
        Logging.$init$((Logging)this);
    }
}

