/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u00015\u0011\u0011#T;mi&\u001cG.Y:t\u001b\u0016$(/[2t\u0015\t\u0019A!\u0001\u0006fm\u0006dW/\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0014aJ,G-[2uS>t\u0017I\u001c3MC\n,Gn\u001d\t\u0004/iaR\"\u0001\r\u000b\u0005e1\u0011a\u0001:eI&\u00111\u0004\u0007\u0002\u0004%\u0012#\u0005\u0003B\b\u001e?}I!A\b\t\u0003\rQ+\b\u000f\\33!\ty\u0001%\u0003\u0002\"!\t1Ai\\;cY\u0016DQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtDCA\u0013(!\t1\u0003!D\u0001\u0003\u0011\u0015)\"\u00051\u0001\u0017Q\r\u0011\u0013f\f\t\u0003U5j\u0011a\u000b\u0006\u0003Y\u0019\t!\"\u00198o_R\fG/[8o\u0013\tq3FA\u0003TS:\u001cW-I\u00011\u0003\u0015\td&\r\u00181\u0011\u0019\u0019\u0003\u0001\"\u0001\u0005eQ\u0011Qe\r\u0005\u0006+E\u0002\r\u0001\u000e\t\u0003k\u0015s!A\u000e\"\u000f\u0005]\u0002eB\u0001\u001d@\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00053\u0011aA:rY&\u00111\tR\u0001\ba\u0006\u001c7.Y4f\u0015\t\te!\u0003\u0002G\u000f\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003\u0007\u0012C\u0001\"\u0013\u0001\t\u0006\u0004%IAS\u0001\u0012Y\u0006\u0014W\r\\\"pk:$()_\"mCN\u001cX#A&\u0011\t1{u$U\u0007\u0002\u001b*\u0011a\nE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001)N\u0005\ri\u0015\r\u001d\t\u0003\u001fIK!a\u0015\t\u0003\t1{gn\u001a\u0005\t+\u0002A)\u0019!C\u0005-\u0006QA.\u00192fY\u000e{WO\u001c;\u0016\u0003EC\u0001\u0002\u0017\u0001\t\u0006\u0004%I!W\u0001\niB\u0014\u0015p\u00117bgN,\u0012A\u0017\t\u0005\u0019>{2\f\u0005\u0002\u00109&\u0011Q\f\u0005\u0002\u0004\u0013:$\b\u0002C0\u0001\u0011\u000b\u0007I\u0011B-\u0002\u0013\u0019\u0004()_\"mCN\u001c\b\u0002C1\u0001\u0011\u000b\u0007I\u0011\u00022\u0002\u0015\r|gNZ;tS>t7/F\u0001d!\u0011au\nH.\t\u000b\u0015\u0004A\u0011\u00014\u0002\u001f\r|gNZ;tS>tW*\u0019;sSb,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u0012\ta\u0001\\5oC2<\u0017B\u00017j\u0005\u0019i\u0015\r\u001e:jq\"\u001aA-K\u0018\t\u000b=\u0004A\u0011\u00019\u0002!Q\u0014X/\u001a)pg&$\u0018N^3SCR,GCA\u0010r\u0011\u0015\u0011h\u000e1\u0001 \u0003\u0015a\u0017MY3mQ\rq\u0017f\f\u0005\u0006k\u0002!\tA^\u0001\u0012M\u0006d7/\u001a)pg&$\u0018N^3SCR,GCA\u0010x\u0011\u0015\u0011H\u000f1\u0001 Q\r!\u0018f\f\u0005\u0006u\u0002!\ta_\u0001\naJ,7-[:j_:$\"a\b?\t\u000bIL\b\u0019A\u0010)\u0007eLs\u0006\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0007e\u0016\u001c\u0017\r\u001c7\u0015\u0007}\t\u0019\u0001C\u0003s}\u0002\u0007q\u0004K\u0002\u007fS=Bq!!\u0003\u0001\t\u0003\tY!\u0001\u0005g\u001b\u0016\f7/\u001e:f)\u0015y\u0012QBA\b\u0011\u0019\u0011\u0018q\u0001a\u0001?!9\u0011\u0011CA\u0004\u0001\u0004y\u0012\u0001\u00022fi\u0006DC!a\u0002*_!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005]AcA\u0010\u0002\u001a!1!/!\u0006A\u0002}AC!!\u0006*_!I!\u0010\u0001EC\u0002\u0013\u0005\u0011qD\u000b\u0002?!B\u0011QDA\u0012\u0003S\ti\u0003E\u0002\u0010\u0003KI1!a\n\u0011\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003W\tQ\"V:fA\u0005\u001c7-\u001e:bGft\u0013EAA\u0018\u0003\u0015\u0011d\u0006\r\u00181Q\u0011\ti\"K\u0018\t\u0013}\u0004\u0001R1A\u0005\u0002\u0005}\u0001\u0006CA\u001a\u0003G\tI#!\f)\t\u0005M\u0012f\f\u0005\u000b\u0003\u0013\u0001\u0001R1A\u0005\u0002\u0005}\u0001\u0006CA\u001d\u0003G\tI#!\f)\t\u0005e\u0012f\f\u0005\u000b\u0003\u0003\u0002\u0001R1A\u0005\u0002\u0005}\u0011\u0001C1dGV\u0014\u0018mY=)\u000b\u0005}\u0012&!\f\t\u0015\u0005\u001d\u0003\u0001#b\u0001\n\u0003\ty\"\u0001\rxK&<\u0007\u000e^3e)J,X\rU8tSRLg/\u001a*bi\u0016DC!!\u0012*_!Q\u0011Q\n\u0001\t\u0006\u0004%\t!a\b\u00023],\u0017n\u001a5uK\u00124\u0015\r\\:f!>\u001c\u0018\u000e^5wKJ\u000bG/\u001a\u0015\u0005\u0003\u0017Js\u0006\u0003\u0006\u0002T\u0001A)\u0019!C\u0001\u0003?\tab^3jO\"$X\r\u001a*fG\u0006dG\u000e\u000b\u0003\u0002R%z\u0003BCA-\u0001!\u0015\r\u0011\"\u0001\u0002 \u0005\tr/Z5hQR,G\r\u0015:fG&\u001c\u0018n\u001c8)\t\u0005]\u0013f\f\u0005\b\u0003?\u0002A\u0011AA1\u0003A9X-[4ii\u0016$g)T3bgV\u0014X\rF\u0002 \u0003GBq!!\u0005\u0002^\u0001\u0007q\u0004\u000b\u0003\u0002^%z\u0003BCA0\u0001!\u0015\r\u0011\"\u0001\u0002 !\"\u0011qM\u00150\u0011)\ti\u0007\u0001EC\u0002\u0013\u0005\u0011qN\u0001\u0007Y\u0006\u0014W\r\\:\u0016\u0005\u0005E\u0004\u0003B\b\u0002t}I1!!\u001e\u0011\u0005\u0015\t%O]1zQ\u0011\tY'K\u0018)\u0007\u0001Is\u0006")
public class MulticlassMetrics {
    private Map<Object, Object> labelCountByClass;
    private long labelCount;
    private Map<Object, Object> tpByClass;
    private Map<Object, Object> fpByClass;
    private Map<Tuple2<Object, Object>, Object> confusions;
    private double precision;
    private double recall;
    private double fMeasure;
    private double accuracy;
    private double weightedTruePositiveRate;
    private double weightedFalsePositiveRate;
    private double weightedRecall;
    private double weightedPrecision;
    private double weightedFMeasure;
    private double[] labels;
    private final RDD<Tuple2<Object, Object>> predictionAndLabels;
    private volatile int bitmap$0;

    private Map<Object, Object> labelCountByClass$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 1) == 0) {
                this.labelCountByClass = RDD$.MODULE$.rddToPairRDDFunctions(this.predictionAndLabels, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).values().countByValue((Ordering)Ordering.Double$.MODULE$);
                this.bitmap$0 |= 1;
            }
        }
        return this.labelCountByClass;
    }

    private Map<Object, Object> labelCountByClass() {
        return (this.bitmap$0 & 1) == 0 ? this.labelCountByClass$lzycompute() : this.labelCountByClass;
    }

    private long labelCount$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 2) == 0) {
                this.labelCount = BoxesRunTime.unboxToLong((Object)this.labelCountByClass().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                this.bitmap$0 |= 2;
            }
        }
        return this.labelCount;
    }

    private long labelCount() {
        return (this.bitmap$0 & 2) == 0 ? this.labelCount$lzycompute() : this.labelCount;
    }

    private Map<Object, Object> tpByClass$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tpByClass = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    double label;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double prediction = tuple2._1$mcD$sp();
                    Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(label, (label = tuple2._2$mcD$sp()) == prediction ? 1 : 0);
                    return sp2;
                }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Double$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Double$.MODULE$).collectAsMap();
                this.bitmap$0 |= 4;
            }
        }
        return this.tpByClass;
    }

    private Map<Object, Object> tpByClass() {
        return (this.bitmap$0 & 4) == 0 ? this.tpByClass$lzycompute() : this.tpByClass;
    }

    private Map<Object, Object> fpByClass$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 8) == 0) {
                this.fpByClass = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    double label;
                    double prediction;
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(prediction, (prediction = tuple2._1$mcD$sp()) != (label = tuple2._2$mcD$sp()) ? 1 : 0);
                    return sp2;
                }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Double$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 + x$4), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Double$.MODULE$).collectAsMap();
                this.bitmap$0 |= 8;
            }
        }
        return this.fpByClass;
    }

    private Map<Object, Object> fpByClass() {
        return (this.bitmap$0 & 8) == 0 ? this.fpByClass$lzycompute() : this.fpByClass;
    }

    private Map<Tuple2<Object, Object>, Object> confusions$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.confusions = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double prediction = tuple2._1$mcD$sp();
                    double label = tuple2._2$mcD$sp();
                    Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcDD.sp(label, prediction), (Object)BoxesRunTime.boxToInteger((int)1));
                    return tuple22;
                }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Int(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$)).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Int(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$)).collectAsMap();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.confusions;
    }

    private Map<Tuple2<Object, Object>, Object> confusions() {
        return (this.bitmap$0 & 0x10) == 0 ? this.confusions$lzycompute() : this.confusions;
    }

    public Matrix confusionMatrix() {
        int n = this.labels().length;
        double[] values = (double[])Array$.MODULE$.ofDim(n * n, ClassTag$.MODULE$.Double());
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                values[i + j * n] = BoxesRunTime.unboxToInt((Object)this.confusions().getOrElse((Object)new Tuple2.mcDD.sp(this.labels()[i], this.labels()[j]), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            }
        }
        return Matrices$.MODULE$.dense(n, n, values);
    }

    public double truePositiveRate(double label) {
        return this.recall(label);
    }

    public double falsePositiveRate(double label) {
        int fp = BoxesRunTime.unboxToInt((Object)this.fpByClass().getOrElse((Object)BoxesRunTime.boxToDouble((double)label), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        return (double)fp / (double)(this.labelCount() - BoxesRunTime.unboxToLong((Object)this.labelCountByClass().apply((Object)BoxesRunTime.boxToDouble((double)label))));
    }

    public double precision(double label) {
        int fp;
        int tp = BoxesRunTime.unboxToInt((Object)this.tpByClass().apply((Object)BoxesRunTime.boxToDouble((double)label)));
        return tp + (fp = BoxesRunTime.unboxToInt((Object)this.fpByClass().getOrElse((Object)BoxesRunTime.boxToDouble((double)label), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))) == 0 ? 0.0 : (double)tp / (double)(tp + fp);
    }

    public double recall(double label) {
        return (double)BoxesRunTime.unboxToInt((Object)this.tpByClass().apply((Object)BoxesRunTime.boxToDouble((double)label))) / (double)BoxesRunTime.unboxToLong((Object)this.labelCountByClass().apply((Object)BoxesRunTime.boxToDouble((double)label)));
    }

    public double fMeasure(double label, double beta) {
        double p = this.precision(label);
        double r = this.recall(label);
        double betaSqrd = beta * beta;
        return p + r == 0.0 ? 0.0 : (1.0 + betaSqrd) * p * r / (betaSqrd * p + r);
    }

    public double fMeasure(double label) {
        return this.fMeasure(label, 1.0);
    }

    private double precision$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.precision = this.accuracy();
                this.bitmap$0 |= 0x20;
            }
        }
        return this.precision;
    }

    public double precision() {
        return (this.bitmap$0 & 0x20) == 0 ? this.precision$lzycompute() : this.precision;
    }

    private double recall$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.recall = this.accuracy();
                this.bitmap$0 |= 0x40;
            }
        }
        return this.recall;
    }

    public double recall() {
        return (this.bitmap$0 & 0x40) == 0 ? this.recall$lzycompute() : this.recall;
    }

    private double fMeasure$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.fMeasure = this.accuracy();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.fMeasure;
    }

    public double fMeasure() {
        return (this.bitmap$0 & 0x80) == 0 ? this.fMeasure$lzycompute() : this.fMeasure;
    }

    private double accuracy$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.accuracy = (double)BoxesRunTime.unboxToInt((Object)this.tpByClass().values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (double)this.labelCount();
                this.bitmap$0 |= 0x100;
            }
        }
        return this.accuracy;
    }

    public double accuracy() {
        return (this.bitmap$0 & 0x100) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    private double weightedTruePositiveRate$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.weightedTruePositiveRate = this.weightedRecall();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.weightedTruePositiveRate;
    }

    public double weightedTruePositiveRate() {
        return (this.bitmap$0 & 0x200) == 0 ? this.weightedTruePositiveRate$lzycompute() : this.weightedTruePositiveRate;
    }

    private double weightedFalsePositiveRate$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.weightedFalsePositiveRate = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)this.labelCountByClass().map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToDouble((double)MulticlassMetrics.$anonfun$weightedFalsePositiveRate$1(this, x0$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.bitmap$0 |= 0x400;
            }
        }
        return this.weightedFalsePositiveRate;
    }

    public double weightedFalsePositiveRate() {
        return (this.bitmap$0 & 0x400) == 0 ? this.weightedFalsePositiveRate$lzycompute() : this.weightedFalsePositiveRate;
    }

    private double weightedRecall$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.weightedRecall = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)this.labelCountByClass().map((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToDouble((double)MulticlassMetrics.$anonfun$weightedRecall$1(this, x0$5)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.bitmap$0 |= 0x800;
            }
        }
        return this.weightedRecall;
    }

    public double weightedRecall() {
        return (this.bitmap$0 & 0x800) == 0 ? this.weightedRecall$lzycompute() : this.weightedRecall;
    }

    private double weightedPrecision$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.weightedPrecision = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)this.labelCountByClass().map((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToDouble((double)MulticlassMetrics.$anonfun$weightedPrecision$1(this, x0$6)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.weightedPrecision;
    }

    public double weightedPrecision() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.weightedPrecision$lzycompute() : this.weightedPrecision;
    }

    public double weightedFMeasure(double beta) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)this.labelCountByClass().map((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToDouble((double)MulticlassMetrics.$anonfun$weightedFMeasure$1(this, beta, x0$7)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private double weightedFMeasure$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.weightedFMeasure = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)this.labelCountByClass().map((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToDouble((double)MulticlassMetrics.$anonfun$weightedFMeasure$2(this, x0$8)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.weightedFMeasure;
    }

    public double weightedFMeasure() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.weightedFMeasure$lzycompute() : this.weightedFMeasure;
    }

    private double[] labels$lzycompute() {
        MulticlassMetrics multiclassMetrics = this;
        synchronized (multiclassMetrics) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.labels = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])this.tpByClass().keys().toArray(ClassTag$.MODULE$.Double()))).sorted((Ordering)Ordering.Double$.MODULE$);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.labels;
    }

    public double[] labels() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.labels$lzycompute() : this.labels;
    }

    public static final /* synthetic */ double $anonfun$weightedFalsePositiveRate$1(MulticlassMetrics $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double category = tuple2._1$mcD$sp();
        long count = tuple2._2$mcJ$sp();
        double d = $this.falsePositiveRate(category) * (double)count / (double)$this.labelCount();
        return d;
    }

    public static final /* synthetic */ double $anonfun$weightedRecall$1(MulticlassMetrics $this, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double category = tuple2._1$mcD$sp();
        long count = tuple2._2$mcJ$sp();
        double d = $this.recall(category) * (double)count / (double)$this.labelCount();
        return d;
    }

    public static final /* synthetic */ double $anonfun$weightedPrecision$1(MulticlassMetrics $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double category = tuple2._1$mcD$sp();
        long count = tuple2._2$mcJ$sp();
        double d = $this.precision(category) * (double)count / (double)$this.labelCount();
        return d;
    }

    public static final /* synthetic */ double $anonfun$weightedFMeasure$1(MulticlassMetrics $this, double beta$1, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double category = tuple2._1$mcD$sp();
        long count = tuple2._2$mcJ$sp();
        double d = $this.fMeasure(category, beta$1) * (double)count / (double)$this.labelCount();
        return d;
    }

    public static final /* synthetic */ double $anonfun$weightedFMeasure$2(MulticlassMetrics $this, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double category = tuple2._1$mcD$sp();
        long count = tuple2._2$mcJ$sp();
        double d = $this.fMeasure(category, 1.0) * (double)count / (double)$this.labelCount();
        return d;
    }

    public MulticlassMetrics(RDD<Tuple2<Object, Object>> predictionAndLabels) {
        this.predictionAndLabels = predictionAndLabels;
    }

    public MulticlassMetrics(Dataset<Row> predictionAndLabels) {
        this((RDD<Tuple2<Object, Object>>)predictionAndLabels.rdd().map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row r) {
                return new Tuple2.mcDD.sp(r.getDouble(0), r.getDouble(1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

