/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.RankingMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u00015\u0011aBU1oW&tw-T3ue&\u001c7O\u0003\u0002\u0004\t\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0011aBL\n\u0005\u0001=)2\u0004\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-ei\u0011a\u0006\u0006\u00031\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00035]\u0011q\u0001T8hO&tw\r\u0005\u0002\u00119%\u0011Q$\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005\u0019\u0002O]3eS\u000e$\u0018n\u001c8B]\u0012d\u0015MY3mgB\u0019\u0011\u0005\n\u0014\u000e\u0003\tR!a\t\u0004\u0002\u0007I$G-\u0003\u0002&E\t\u0019!\u000b\u0012#\u0011\tA9\u0013&K\u0005\u0003QE\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\t+Y%\u00111&\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003[9b\u0001\u0001B\u00030\u0001\t\u0007\u0001GA\u0001U#\t\tD\u0007\u0005\u0002\u0011e%\u00111'\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001R'\u0003\u00027#\t\u0019\u0011I\\=\t\u0011a\u0002!1!Q\u0001\fe\n!\"\u001a<jI\u0016t7-\u001a\u00132!\rQT\bL\u0007\u0002w)\u0011A(E\u0001\be\u00164G.Z2u\u0013\tq4H\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q\u0011!I\u0012\u000b\u0003\u0007\u0016\u00032\u0001\u0012\u0001-\u001b\u0005\u0011\u0001\"\u0002\u001d@\u0001\bI\u0004\"B\u0010@\u0001\u0004\u0001\u0003\"\u0002%\u0001\t\u0003I\u0015a\u00039sK\u000eL7/[8o\u0003R$\"AS'\u0011\u0005AY\u0015B\u0001'\u0012\u0005\u0019!u.\u001e2mK\")aj\u0012a\u0001\u001f\u0006\t1\u000e\u0005\u0002\u0011!&\u0011\u0011+\u0005\u0002\u0004\u0013:$\bfA$T3B\u0011AkV\u0007\u0002+*\u0011aKB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001-V\u0005\u0015\u0019\u0016N\\2fC\u0005Q\u0016!B\u0019/e9\u0002\u0004\u0002\u0003/\u0001\u0011\u000b\u0007I\u0011A/\u0002)5,\u0017M\\!wKJ\fw-\u001a)sK\u000eL7/[8o+\u0005Q\u0005\"B0\u0001\t\u0003\u0001\u0017A\u00028eG\u001e\fE\u000f\u0006\u0002KC\")aJ\u0018a\u0001\u001f\"\u001aalU-)\u0007\u0001\u0019\u0016lB\u0003f\u0005!\u0005a-\u0001\bSC:\\\u0017N\\4NKR\u0014\u0018nY:\u0011\u0005\u0011;g!B\u0001\u0003\u0011\u0003A7cA4\u00107!)\u0001i\u001aC\u0001UR\ta\rC\u0003mO\u0012\u0005Q.\u0001\u0002pMV\u0019a.\u001d@\u0015\u0005=\u001c\bc\u0001#\u0001aB\u0011Q&\u001d\u0003\u0006e.\u0014\r\u0001\r\u0002\u0002\u000b\")qd\u001ba\u0001iB\u0019QO\u001f?\u000e\u0003YT!a\u001e=\u0002\t)\fg/\u0019\u0006\u0003s\u001a\t1!\u00199j\u0013\tYhOA\u0004KCZ\f'\u000b\u0012#\u0011\tA9S0 \t\u0003[y$QaL6C\u0002}\f2!MA\u0001!\u0015\t\u0019!a\u0003q\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011\u0001\u00027b]\u001eT\u0011a^\u0005\u0005\u0003\u001b\t)A\u0001\u0005Ji\u0016\u0014\u0018M\u00197fQ\u0011Y7+!\u0005\"\u0005\u0005M\u0011!B\u0019/i9\u0002\u0004\"CA\fO\u0006\u0005I\u0011BA\r\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0001\u0003BA\u0002\u0003;IA!a\b\u0002\u0006\t1qJ\u00196fGR\u0004")
public class RankingMetrics<T>
implements Logging,
scala.Serializable {
    private double meanAveragePrecision;
    private final RDD<Tuple2<Object, Object>> predictionAndLabels;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static <E, T extends Iterable<E>> RankingMetrics<E> of(JavaRDD<Tuple2<T, T>> javaRDD) {
        return RankingMetrics$.MODULE$.of(javaRDD);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public double precisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$precisionAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    private double meanAveragePrecision$lzycompute() {
        RankingMetrics rankingMetrics = this;
        synchronized (rankingMetrics) {
            if (!this.bitmap$0) {
                this.meanAveragePrecision = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$meanAveragePrecision$1(this, x0$2)), ClassTag$.MODULE$.Double())).mean();
                this.bitmap$0 = true;
            }
        }
        return this.meanAveragePrecision;
    }

    public double meanAveragePrecision() {
        return !this.bitmap$0 ? this.meanAveragePrecision$lzycompute() : this.meanAveragePrecision;
    }

    public double ndcgAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$ndcgAt$2(this, k, x0$3)), ClassTag$.MODULE$.Double())).mean();
    }

    public static final /* synthetic */ double $anonfun$precisionAt$2(RankingMetrics $this, int k$1, Tuple2 x0$1) {
        double d;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            if (labSet.nonEmpty()) {
                int n = package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length(pred), k$1);
                int cnt = 0;
                for (int i = 0; i < n; ++i) {
                    if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                    ++cnt;
                }
                d = (double)cnt / (double)k$1;
            } else {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
                d = 0.0;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        double d2 = d;
        return d2;
    }

    public static final /* synthetic */ double $anonfun$meanAveragePrecision$1(RankingMetrics $this, Tuple2 x0$2) {
        double d;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            if (labSet.nonEmpty()) {
                int cnt = 0;
                double precSum = 0.0;
                int n = ScalaRunTime$.MODULE$.array_length(pred);
                for (int i = 0; i < n; ++i) {
                    if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                    precSum += (double)(++cnt) / (double)(i + 1);
                }
                d = precSum / (double)labSet.size();
            } else {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
                d = 0.0;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        double d2 = d;
        return d2;
    }

    public static final /* synthetic */ double $anonfun$ndcgAt$2(RankingMetrics $this, int k$2, Tuple2 x0$3) {
        double d;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            if (labSet.nonEmpty()) {
                int labSetSize = labSet.size();
                int n = package$.MODULE$.min(package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSetSize), k$2);
                double maxDcg = 0.0;
                double dcg = 0.0;
                for (int i = 0; i < n; ++i) {
                    double gain = 1.0 / package$.MODULE$.log((double)(i + 2));
                    if (i < ScalaRunTime$.MODULE$.array_length(pred) && labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) {
                        dcg += gain;
                    }
                    if (i >= labSetSize) continue;
                    maxDcg += gain;
                }
                d = dcg / maxDcg;
            } else {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
                d = 0.0;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        double d2 = d;
        return d2;
    }

    public RankingMetrics(RDD<Tuple2<Object, Object>> predictionAndLabels, ClassTag<T> evidence$1) {
        this.predictionAndLabels = predictionAndLabels;
        Logging.$init$((Logging)this);
    }
}

