/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\t\t\"+Z4sKN\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u000b\u0005\r!\u0011AC3wC2,\u0018\r^5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oO\"A1\u0004\u0001B\u0001B\u0003%A$A\rqe\u0016$\u0017n\u0019;j_:\fe\u000eZ(cg\u0016\u0014h/\u0019;j_:\u001c\bcA\u000f!E5\taD\u0003\u0002 \r\u0005\u0019!\u000f\u001a3\n\u0005\u0005r\"a\u0001*E\tB!qbI\u0013&\u0013\t!\u0003C\u0001\u0004UkBdWM\r\t\u0003\u001f\u0019J!a\n\t\u0003\r\u0011{WO\u00197f\u0011!I\u0003A!A!\u0002\u0013Q\u0013!\u0004;ie>,x\r[(sS\u001eLg\u000e\u0005\u0002\u0010W%\u0011A\u0006\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015q\u0003\u0001\"\u00010\u0003\u0019a\u0014N\\5u}Q\u0019\u0001GM\u001a\u0011\u0005E\u0002Q\"\u0001\u0002\t\u000bmi\u0003\u0019\u0001\u000f\t\u000b%j\u0003\u0019\u0001\u0016)\u00075*4\b\u0005\u00027s5\tqG\u0003\u00029\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i:$!B*j]\u000e,\u0017%\u0001\u001f\u0002\u000bIr\u0003G\f\u0019\t\u000b9\u0002A\u0011\u0001 \u0015\u0005Az\u0004\"B\u000e>\u0001\u0004a\u0002fA\u001f6\u0003\u0006\n!)A\u00032]Ir\u0003\u0007\u0003\u0004/\u0001\u0011\u0005A\u0001\u0012\u000b\u0003a\u0015CQaG\"A\u0002\u0019\u0003\"aR,\u000f\u0005!#fBA%S\u001d\tQ\u0015K\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011a\nD\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA*\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003+Z\u000bq\u0001]1dW\u0006<WM\u0003\u0002T\r%\u0011\u0001,\u0017\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!\u0016,\t\u0011m\u0003\u0001R1A\u0005\nq\u000bqa];n[\u0006\u0014\u00180F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001G!\u0001\u0003ti\u0006$\u0018B\u00012`\u0005yiU\u000f\u001c;jm\u0006\u0014\u0018.\u0019;f'R\fG/[:uS\u000e\fGnU;n[\u0006\u0014\u0018\u0010\u0003\u0005e\u0001!\u0015\r\u0011\"\u0003f\u0003\r\u00196+_\u000b\u0002K!Aq\r\u0001EC\u0002\u0013%Q-A\u0003T'\u0016\u0014(\u000f\u0003\u0005j\u0001!\u0015\r\u0011\"\u0003f\u0003\u0015\u00196\u000b^8u\u0011!Y\u0007\u0001#b\u0001\n\u0013)\u0017!B*Te\u0016<\u0007\"B7\u0001\t\u0003)\u0017!E3ya2\f\u0017N\\3e-\u0006\u0014\u0018.\u00198dK\"\u001aA.N!\t\u000bA\u0004A\u0011A3\u0002#5,\u0017M\\!cg>dW\u000f^3FeJ|'\u000fK\u0002pk\u0005CQa\u001d\u0001\u0005\u0002\u0015\f\u0001#\\3b]N\u000bX/\u0019:fI\u0016\u0013(o\u001c:)\u0007I,\u0014\tC\u0003w\u0001\u0011\u0005Q-\u0001\u000bs_>$X*Z1o'F,\u0018M]3e\u000bJ\u0014xN\u001d\u0015\u0004kV\n\u0005\"B=\u0001\t\u0003)\u0017A\u0001:3Q\rAX'\u0011\u0015\u0004\u0001U\n\u0005")
public class RegressionMetrics
implements Logging {
    private MultivariateStatisticalSummary summary;
    private double SSy;
    private double SSerr;
    private double SStot;
    private double SSreg;
    private final RDD<Tuple2<Object, Object>> predictionAndObservations;
    private final boolean throughOrigin;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private MultivariateStatisticalSummary summary$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_7;
                RDD qual$1 = this.predictionAndObservations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double prediction = tuple2._1$mcD$sp();
                    double observation = tuple2._2$mcD$sp();
                    Vector vector = Vectors$.MODULE$.dense(observation, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{observation - prediction}));
                    return vector;
                }, ClassTag$.MODULE$.apply(Vector.class));
                MultivariateOnlineSummarizer x$1 = new MultivariateOnlineSummarizer();
                Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(summary, v) -> summary.add((Vector)v);
                Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(sum1, sum2) -> sum1.merge((MultivariateOnlineSummarizer)sum2);
                int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
                MultivariateStatisticalSummary summary2 = (MultivariateStatisticalSummary)qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
                this.summary = var2_7;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.summary;
    }

    private MultivariateStatisticalSummary summary() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.summary$lzycompute() : this.summary;
    }

    private double SSy$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.SSy = package$.MODULE$.pow(this.summary().normL2().apply(0), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.SSy;
    }

    private double SSy() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.SSy$lzycompute() : this.SSy;
    }

    private double SSerr$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SSerr = package$.MODULE$.pow(this.summary().normL2().apply(1), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.SSerr;
    }

    private double SSerr() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SSerr$lzycompute() : this.SSerr;
    }

    private double SStot$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SStot = this.summary().variance().apply(0) * (double)(this.summary().count() - 1L);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.SStot;
    }

    private double SStot() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SStot$lzycompute() : this.SStot;
    }

    private double SSreg$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                double yMean = this.summary().mean().apply(0);
                this.SSreg = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndObservations.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)RegressionMetrics.$anonfun$SSreg$1(yMean, x0$2)), ClassTag$.MODULE$.Double())).sum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.SSreg;
    }

    private double SSreg() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.SSreg$lzycompute() : this.SSreg;
    }

    public double explainedVariance() {
        return this.SSreg() / (double)this.summary().count();
    }

    public double meanAbsoluteError() {
        return this.summary().normL1().apply(1) / (double)this.summary().count();
    }

    public double meanSquaredError() {
        return this.SSerr() / (double)this.summary().count();
    }

    public double rootMeanSquaredError() {
        return package$.MODULE$.sqrt(this.meanSquaredError());
    }

    public double r2() {
        return this.throughOrigin ? 1.0 - this.SSerr() / this.SSy() : 1.0 - this.SSerr() / this.SStot();
    }

    public static final /* synthetic */ double $anonfun$SSreg$1(double yMean$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        double d = package$.MODULE$.pow(prediction - yMean$1, 2.0);
        return d;
    }

    public RegressionMetrics(RDD<Tuple2<Object, Object>> predictionAndObservations, boolean throughOrigin) {
        this.predictionAndObservations = predictionAndObservations;
        this.throughOrigin = throughOrigin;
        Logging.$init$((Logging)this);
    }

    public RegressionMetrics(RDD<Tuple2<Object, Object>> predictionAndObservations) {
        this(predictionAndObservations, false);
    }

    public RegressionMetrics(Dataset<Row> predictionAndObservations) {
        this((RDD<Tuple2<Object, Object>>)predictionAndObservations.rdd().map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row r) {
                return new Tuple2.mcDD.sp(r.getDouble(0), r.getDouble(1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

