/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.mllib.feature.ChiSqSelector$;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u00015\u0011Qb\u00115j'F\u001cV\r\\3di>\u0014(BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u0019\u0001\u0011\u0005\u0011$\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\u0005!\u001aq#H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0005\u00012\u0011AC1o]>$\u0018\r^5p]&\u0011!e\b\u0002\u0006'&t7-Z\u0011\u0002I\u0005)!GL\u0019/a!9a\u0005\u0001a\u0001\n\u00039\u0013A\u00048v[R{\u0007OR3biV\u0014Xm]\u000b\u0002QA\u0011q\"K\u0005\u0003UA\u00111!\u00138u\u0011\u001da\u0003\u00011A\u0005\u00025\n!C\\;n)>\u0004h)Z1ukJ,7o\u0018\u0013fcR\u0011a&\r\t\u0003\u001f=J!\u0001\r\t\u0003\tUs\u0017\u000e\u001e\u0005\be-\n\t\u00111\u0001)\u0003\rAH%\r\u0005\u0007i\u0001\u0001\u000b\u0015\u0002\u0015\u0002\u001f9,X\u000eV8q\r\u0016\fG/\u001e:fg\u0002BqA\u000e\u0001A\u0002\u0013\u0005q'\u0001\u0006qKJ\u001cWM\u001c;jY\u0016,\u0012\u0001\u000f\t\u0003\u001feJ!A\u000f\t\u0003\r\u0011{WO\u00197f\u0011\u001da\u0004\u00011A\u0005\u0002u\na\u0002]3sG\u0016tG/\u001b7f?\u0012*\u0017\u000f\u0006\u0002/}!9!gOA\u0001\u0002\u0004A\u0004B\u0002!\u0001A\u0003&\u0001(A\u0006qKJ\u001cWM\u001c;jY\u0016\u0004\u0003b\u0002\"\u0001\u0001\u0004%\taN\u0001\u0004MB\u0014\bb\u0002#\u0001\u0001\u0004%\t!R\u0001\bMB\u0014x\fJ3r)\tqc\tC\u00043\u0007\u0006\u0005\t\u0019\u0001\u001d\t\r!\u0003\u0001\u0015)\u00039\u0003\u00111\u0007O\u001d\u0011\t\u000f)\u0003\u0001\u0019!C\u0001o\u0005\u0019a\r\u001a:\t\u000f1\u0003\u0001\u0019!C\u0001\u001b\u00069a\r\u001a:`I\u0015\fHC\u0001\u0018O\u0011\u001d\u00114*!AA\u0002aBa\u0001\u0015\u0001!B\u0013A\u0014\u0001\u00024ee\u0002BqA\u0015\u0001A\u0002\u0013\u0005q'A\u0002go\u0016Dq\u0001\u0016\u0001A\u0002\u0013\u0005Q+A\u0004go\u0016|F%Z9\u0015\u000592\u0006b\u0002\u001aT\u0003\u0003\u0005\r\u0001\u000f\u0005\u00071\u0002\u0001\u000b\u0015\u0002\u001d\u0002\t\u0019<X\r\t\u0005\b5\u0002\u0001\r\u0011\"\u0001\\\u00031\u0019X\r\\3di>\u0014H+\u001f9f+\u0005a\u0006CA/e\u001d\tq&\r\u0005\u0002`!5\t\u0001M\u0003\u0002b\u0019\u00051AH]8pizJ!a\u0019\t\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GBAq\u0001\u001b\u0001A\u0002\u0013\u0005\u0011.\u0001\ttK2,7\r^8s)f\u0004Xm\u0018\u0013fcR\u0011aF\u001b\u0005\be\u001d\f\t\u00111\u0001]\u0011\u0019a\u0007\u0001)Q\u00059\u0006i1/\u001a7fGR|'\u000fV=qK\u0002BQ\u0001\u0007\u0001\u0005\u00029$\"AG8\t\u000b\u0019j\u0007\u0019\u0001\u0015)\u00075l\u0012/I\u0001s\u0003\u0015\tdf\r\u00181\u0011\u0015!\b\u0001\"\u0001v\u0003E\u0019X\r\u001e(v[R{\u0007OR3biV\u0014Xm\u001d\u000b\u0003m^l\u0011\u0001\u0001\u0005\u0006qN\u0004\r\u0001K\u0001\u0006m\u0006dW/\u001a\u0015\u0004gvQ\u0018%A>\u0002\u000bErcG\f\u0019\t\u000bu\u0004A\u0011\u0001@\u0002\u001bM,G\u000fU3sG\u0016tG/\u001b7f)\t1x\u0010C\u0003yy\u0002\u0007\u0001\bK\u0002};\rBq!!\u0002\u0001\t\u0003\t9!\u0001\u0004tKR4\u0005O\u001d\u000b\u0004m\u0006%\u0001B\u0002=\u0002\u0004\u0001\u0007\u0001\b\u000b\u0003\u0002\u0004u\u0019\u0003bBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\u0007g\u0016$h\t\u001a:\u0015\u0007Y\f\u0019\u0002\u0003\u0004y\u0003\u001b\u0001\r\u0001\u000f\u0015\u0006\u0003\u001bi\u0012qC\u0011\u0003\u00033\tQA\r\u00183]ABq!!\b\u0001\t\u0003\ty\"\u0001\u0004tKR4u/\u001a\u000b\u0004m\u0006\u0005\u0002B\u0002=\u0002\u001c\u0001\u0007\u0001\bK\u0003\u0002\u001cu\t9\u0002C\u0004\u0002(\u0001!\t!!\u000b\u0002\u001fM,GoU3mK\u000e$xN\u001d+za\u0016$2A^A\u0016\u0011\u0019A\u0018Q\u0005a\u00019\"\"\u0011QE\u000f$\u0011\u001d\t\t\u0004\u0001C\u0001\u0003g\t1AZ5u)\u0011\t)$a\u000f\u0011\u0007m\t9$C\u0002\u0002:\t\u0011!c\u00115j'F\u001cV\r\\3di>\u0014Xj\u001c3fY\"A\u0011QHA\u0018\u0001\u0004\ty$\u0001\u0003eCR\f\u0007CBA!\u0003\u000f\nY%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0004\u0002\u0007I$G-\u0003\u0003\u0002J\u0005\r#a\u0001*E\tB!\u0011QJA*\u001b\t\tyEC\u0002\u0002R\u0011\t!B]3he\u0016\u001c8/[8o\u0013\u0011\t)&a\u0014\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;)\t\u0005=R$\u001d\u0015\u0004\u0001u\tx\u0001CA/\u0005!\u0005a!a\u0018\u0002\u001b\rC\u0017nU9TK2,7\r^8s!\rY\u0012\u0011\r\u0004\b\u0003\tA\tABA2'\u0011\t\tG\u0004\u000b\t\u000fa\t\t\u0007\"\u0001\u0002hQ\u0011\u0011q\f\u0005\u000b\u0003W\n\tG1A\u0005\u0002\u0019Y\u0016A\u0004(v[R{\u0007OR3biV\u0014Xm\u001d\u0005\t\u0003_\n\t\u0007)A\u00059\u0006ya*^7U_B4U-\u0019;ve\u0016\u001c\b\u0005\u0003\u0006\u0002t\u0005\u0005$\u0019!C\u0001\rm\u000b!\u0002U3sG\u0016tG/\u001b7f\u0011!\t9(!\u0019!\u0002\u0013a\u0016a\u0003)fe\u000e,g\u000e^5mK\u0002B!\"a\u001f\u0002b\t\u0007I\u0011\u0001\u0004\\\u0003\r1\u0005K\u0015\u0005\t\u0003\u007f\n\t\u0007)A\u00059\u0006!a\t\u0015*!\u0011)\t\u0019)!\u0019C\u0002\u0013\u0005aaW\u0001\u0004\r\u0012\u0013\u0006\u0002CAD\u0003C\u0002\u000b\u0011\u0002/\u0002\t\u0019#%\u000b\t\u0005\u000b\u0003\u0017\u000b\tG1A\u0005\u0002\u0019Y\u0016a\u0001$X\u000b\"A\u0011qRA1A\u0003%A,\u0001\u0003G/\u0016\u0003\u0003BCAJ\u0003C\u0012\r\u0011\"\u0001\u0002\u0016\u000612/\u001e9q_J$X\rZ*fY\u0016\u001cGo\u001c:UsB,7/\u0006\u0002\u0002\u0018B!q\"!']\u0013\r\tY\n\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0003?\u000b\t\u0007)A\u0005\u0003/\u000bqc];qa>\u0014H/\u001a3TK2,7\r^8s)f\u0004Xm\u001d\u0011\t\u0015\u0005\r\u0016\u0011MA\u0001\n\u0013\t)+A\u0006sK\u0006$'+Z:pYZ,GCAAT!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000bA\u0001\\1oO*\u0011\u0011\u0011W\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u0006-&AB(cU\u0016\u001cG\u000f")
public class ChiSqSelector
implements scala.Serializable {
    private int numTopFeatures = 50;
    private double percentile = 0.1;
    private double fpr = 0.05;
    private double fdr = 0.05;
    private double fwe = 0.05;
    private String selectorType = ChiSqSelector$.MODULE$.NumTopFeatures();

    public static String[] supportedSelectorTypes() {
        return ChiSqSelector$.MODULE$.supportedSelectorTypes();
    }

    public int numTopFeatures() {
        return this.numTopFeatures;
    }

    public void numTopFeatures_$eq(int x$1) {
        this.numTopFeatures = x$1;
    }

    public double percentile() {
        return this.percentile;
    }

    public void percentile_$eq(double x$1) {
        this.percentile = x$1;
    }

    public double fpr() {
        return this.fpr;
    }

    public void fpr_$eq(double x$1) {
        this.fpr = x$1;
    }

    public double fdr() {
        return this.fdr;
    }

    public void fdr_$eq(double x$1) {
        this.fdr = x$1;
    }

    public double fwe() {
        return this.fwe;
    }

    public void fwe_$eq(double x$1) {
        this.fwe = x$1;
    }

    public String selectorType() {
        return this.selectorType;
    }

    public void selectorType_$eq(String x$1) {
        this.selectorType = x$1;
    }

    public ChiSqSelector setNumTopFeatures(int value) {
        this.numTopFeatures_$eq(value);
        return this;
    }

    public ChiSqSelector setPercentile(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "Percentile must be in [0,1]");
        this.percentile_$eq(value);
        return this;
    }

    public ChiSqSelector setFpr(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "FPR must be in [0,1]");
        this.fpr_$eq(value);
        return this;
    }

    public ChiSqSelector setFdr(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "FDR must be in [0,1]");
        this.fdr_$eq(value);
        return this;
    }

    public ChiSqSelector setFwe(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable & scala.Serializable)() -> "FWE must be in [0,1]");
        this.fwe_$eq(value);
        return this;
    }

    public ChiSqSelector setSelectorType(String value) {
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ChiSqSelector$.MODULE$.supportedSelectorTypes())).contains((Object)value), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("ChiSqSelector Type: ").append(value).append(" was not supported.").toString());
        this.selectorType_$eq(value);
        return this;
    }

    public ChiSqSelectorModel fit(RDD<LabeledPoint> data) {
        Tuple2[] tuple2Array;
        Tuple2[] chiSqTestResult = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Statistics$.MODULE$.chiSqTest(data))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        String string = this.selectorType();
        String string2 = ChiSqSelector$.MODULE$.NumTopFeatures();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).sortBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$1(x0$2)), (Ordering)Ordering.Double$.MODULE$))).take(this.numTopFeatures());
        } else {
            String string4 = ChiSqSelector$.MODULE$.Percentile();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$2(x0$3)), (Ordering)Ordering.Double$.MODULE$))).take((int)((double)chiSqTestResult.length * this.percentile()));
            } else {
                String string6 = ChiSqSelector$.MODULE$.FPR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$3(this, x0$4)));
                } else {
                    String string8 = ChiSqSelector$.MODULE$.FDR();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        Tuple2[] tuple2Array2;
                        Tuple2[] tempRes = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).sortBy((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$4(x0$5)), (Ordering)Ordering.Double$.MODULE$);
                        Tuple2[] selected = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tempRes)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$5(this, chiSqTestResult, x0$6)));
                        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selected)).isEmpty()) {
                            tuple2Array2 = (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
                        } else {
                            int maxIndex = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selected)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
                            tuple2Array2 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tempRes)).take(maxIndex + 1);
                        }
                        tuple2Array = tuple2Array2;
                    } else {
                        String string10 = ChiSqSelector$.MODULE$.FWE();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            tuple2Array = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult)).filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$7(this, chiSqTestResult, x0$7)));
                        } else {
                            throw new IllegalStateException(new StringBuilder(28).append("Unknown ChiSqSelector Type: ").append(string).toString());
                        }
                    }
                }
            }
        }
        Tuple2[] features = tuple2Array;
        int[] indices = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])features)).map((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToInteger((int)ChiSqSelector.$anonfun$fit$8(x0$8)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return new ChiSqSelectorModel(indices);
    }

    public static final /* synthetic */ double $anonfun$fit$1(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
        double d = res.pValue();
        return d;
    }

    public static final /* synthetic */ double $anonfun$fit$2(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
        double d = res.pValue();
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$fit$3(ChiSqSelector $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
        boolean bl = res.pValue() < $this.fpr();
        return bl;
    }

    public static final /* synthetic */ double $anonfun$fit$4(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
        double d = res.pValue();
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$fit$5(ChiSqSelector $this, Tuple2[] chiSqTestResult$1, Tuple2 x0$6) {
        int index;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$6;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                index = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
        boolean bl = res.pValue() <= $this.fdr() * (double)(index + 1) / (double)chiSqTestResult$1.length;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$fit$7(ChiSqSelector $this, Tuple2[] chiSqTestResult$1, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
        boolean bl = res.pValue() < $this.fwe() / (double)chiSqTestResult$1.length;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$fit$8(Tuple2 x0$8) {
        int index;
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = index = tuple2._2$mcI$sp();
        return n;
    }

    public ChiSqSelector() {
    }

    public ChiSqSelector(int numTopFeatures) {
        this();
        this.numTopFeatures_$eq(numTopFeatures);
    }
}

