/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function2;
import scala.Option;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u00015\u00111!\u0013#G\u0015\t\u0019A!A\u0004gK\u0006$XO]3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!Q1A\u0005\u0002Y\t!\"\\5o\t>\u001cgI]3r+\u00059\u0002CA\b\u0019\u0013\tI\u0002CA\u0002J]RD3\u0001F\u000e\"!\tar$D\u0001\u001e\u0015\tqb!\u0001\u0006b]:|G/\u0019;j_:L!\u0001I\u000f\u0003\u000bMKgnY3\"\u0003\t\nQ!\r\u00183]AB\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IaF\u0001\f[&tGi\\2Ge\u0016\f\b\u0005K\u0002$7\u0005BQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u0015)b\u00051\u0001\u0018Q\rY3$\t\u0015\u0004Mm\t\u0003\"B\u0014\u0001\t\u0003yC#A\u0015)\u00079Z\u0012'I\u00013\u0003\u0015\td&\r\u00181\u0011\u0015!\u0004\u0001\"\u00016\u0003\r1\u0017\u000e\u001e\u000b\u0003me\u0002\"AK\u001c\n\u0005a\u0012!\u0001C%E\r6{G-\u001a7\t\u000bi\u001a\u0004\u0019A\u001e\u0002\u000f\u0011\fG/Y:fiB\u0019AhP!\u000e\u0003uR!A\u0010\u0004\u0002\u0007I$G-\u0003\u0002A{\t\u0019!\u000b\u0012#\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0011A\u00027j]\u0006dw-\u0003\u0002G\u0007\n1a+Z2u_JD3aM\u000e2\u0011\u0015!\u0004\u0001\"\u0001J)\t1$\nC\u0003;\u0011\u0002\u00071\nE\u0002M#\u0006k\u0011!\u0014\u0006\u0003\u001d>\u000bAA[1wC*\u0011\u0001KB\u0001\u0004CBL\u0017B\u0001*N\u0005\u001dQ\u0015M^1S\t\u0012C3\u0001S\u000e2Q\r\u00011$M\u0004\u0006-\nAIaV\u0001\u0004\u0013\u00123\u0005C\u0001\u0016Y\r\u0015\t!\u0001#\u0003Z'\tAf\u0002C\u0003(1\u0012\u00051\fF\u0001X\r\u0011i\u0006\f\u00010\u00037\u0011{7-^7f]R4%/Z9vK:\u001c\u00170Q4he\u0016<\u0017\r^8s'\rafb\u0018\t\u0003\u001f\u0001L!!\u0019\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011Ua&Q1A\u0005\u0002YA\u0001\u0002\n/\u0003\u0002\u0003\u0006Ia\u0006\u0005\u0006Oq#\t!\u001a\u000b\u0003M\"\u0004\"a\u001a/\u000e\u0003aCQ!\u00063A\u0002]AqA\u001b/A\u0002\u0013%1.A\u0001n+\u0005a\u0007CA\bn\u0013\tq\u0007C\u0001\u0003M_:<\u0007b\u00029]\u0001\u0004%I!]\u0001\u0006[~#S-\u001d\u000b\u0003eV\u0004\"aD:\n\u0005Q\u0004\"\u0001B+oSRDqA^8\u0002\u0002\u0003\u0007A.A\u0002yIEBa\u0001\u001f/!B\u0013a\u0017AA7!\u0011%QH\f1AA\u0002\u0013%10\u0001\u0002eMV\tA\u0010\u0005\u0003~\u0003\u0007aW\"\u0001@\u000b\u0005\u0011{(BAA\u0001\u0003\u0019\u0011'/Z3{K&\u0019\u0011Q\u0001@\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\u0005\f\u0003\u0013a\u0006\u0019!a\u0001\n\u0013\tY!\u0001\u0004eM~#S-\u001d\u000b\u0004e\u00065\u0001\u0002\u0003<\u0002\b\u0005\u0005\t\u0019\u0001?\t\u0015\u0005EA\f1A\u0001B\u0003&A0A\u0002eM\u0002Baa\n/\u0005\u0002\u0005UA#\u00014\t\u000f\u0005eA\f\"\u0001\u0002\u001c\u0005\u0019\u0011\r\u001a3\u0015\t\u0005u\u0011qD\u0007\u00029\"9\u0011\u0011EA\f\u0001\u0004\t\u0015a\u00013pG\"9\u0011Q\u0005/\u0005\u0002\u0005\u001d\u0012!B7fe\u001e,G\u0003BA\u000f\u0003SAq!a\u000b\u0002$\u0001\u0007a-A\u0003pi\",'\u000fC\u0004\u00020q#I!!\r\u0002\u000f%\u001cX)\u001c9usV\u0011\u00111\u0007\t\u0004\u001f\u0005U\u0012bAA\u001c!\t9!i\\8mK\u0006t\u0007bBA\u001e9\u0012\u0005\u0011QH\u0001\u0004S\u00124G#A!")
public class IDF {
    private final int minDocFreq;

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public IDFModel fit(RDD<Vector> dataset) {
        DocumentFrequencyAggregator x$1 = new DocumentFrequencyAggregator(this.minDocFreq());
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(df, v) -> df.add((Vector)v);
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(df1, df2) -> df1.merge((DocumentFrequencyAggregator)df2);
        int x$4 = dataset.treeAggregate$default$4((Object)x$1);
        Vector idf = ((DocumentFrequencyAggregator)dataset.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(DocumentFrequencyAggregator.class))).idf();
        return new IDFModel(idf);
    }

    public IDFModel fit(JavaRDD<Vector> dataset) {
        return this.fit((RDD<Vector>)dataset.rdd());
    }

    public IDF(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public IDF() {
        this(0);
    }

    public static class DocumentFrequencyAggregator
    implements scala.Serializable {
        private final int minDocFreq;
        private long m;
        private breeze.linalg.DenseVector<Object> df;

        public int minDocFreq() {
            return this.minDocFreq;
        }

        private long m() {
            return this.m;
        }

        private void m_$eq(long x$1) {
            this.m = x$1;
        }

        private breeze.linalg.DenseVector<Object> df() {
            return this.df;
        }

        private void df_$eq(breeze.linalg.DenseVector<Object> x$1) {
            this.df = x$1;
        }

        public DocumentFrequencyAggregator add(Vector doc) {
            DenseVector denseVector;
            Option<double[]> option;
            SparseVector sparseVector;
            Option<Tuple3<Object, int[], double[]>> option2;
            Vector vector;
            if (this.isEmpty()) {
                this.df_$eq((breeze.linalg.DenseVector<Object>)breeze.linalg.DenseVector$.MODULE$.zeros$mJc$sp(doc.size(), ClassTag$.MODULE$.Long(), (Zero)Zero.LongZero$.MODULE$));
            }
            if ((vector = doc) instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] values = (double[])((Tuple3)option2.get())._3();
                int nnz = indices.length;
                for (int k = 0; k < nnz; ++k) {
                    if (!(values[k] > 0.0)) continue;
                    breeze.linalg.DenseVector<Object> denseVector2 = this.df();
                    int n = indices[k];
                    denseVector2.update$mcJ$sp(n, denseVector2.apply$mcJ$sp(n) + 1L);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                double[] values = (double[])option.get();
                int n = values.length;
                for (int j = 0; j < n; ++j) {
                    if (!(values[j] > 0.0)) continue;
                    breeze.linalg.DenseVector<Object> denseVector3 = this.df();
                    int n2 = j;
                    denseVector3.update$mcJ$sp(n2, denseVector3.apply$mcJ$sp(n2) + 1L);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(53).append("Only sparse and dense vectors are supported but got ").append(vector.getClass()).append(".").toString());
            }
            this.m_$eq(this.m() + 1L);
            return this;
        }

        public DocumentFrequencyAggregator merge(DocumentFrequencyAggregator other) {
            Object object;
            if (!other.isEmpty()) {
                this.m_$eq(this.m() + other.m());
                if (this.df() == null) {
                    this.df_$eq((breeze.linalg.DenseVector<Object>)other.df().copy$mcJ$sp());
                    object = BoxedUnit.UNIT;
                } else {
                    object = this.df().$plus$eq(other.df(), breeze.linalg.DenseVector$.MODULE$.dv_dv_UpdateOp_Long_OpAdd());
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            return this;
        }

        private boolean isEmpty() {
            return this.m() == 0L;
        }

        public Vector idf() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Haven't seen any document yet.");
            }
            int n = this.df().length();
            double[] inv = new double[n];
            for (int j = 0; j < n; ++j) {
                if (this.df().apply$mcJ$sp(j) < (long)this.minDocFreq()) continue;
                inv[j] = package$.MODULE$.log(((double)this.m() + 1.0) / ((double)this.df().apply$mcJ$sp(j) + 1.0));
            }
            return Vectors$.MODULE$.dense(inv);
        }

        public DocumentFrequencyAggregator(int minDocFreq) {
            this.minDocFreq = minDocFreq;
            this.m = 0L;
        }

        public DocumentFrequencyAggregator() {
            this(0);
        }
    }
}

