/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Option;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001b\tA\u0001kQ!N_\u0012,GN\u0003\u0002\u0004\t\u00059a-Z1ukJ,'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t\tb+Z2u_J$&/\u00198tM>\u0014X.\u001a:\t\u0011e\u0001!Q1A\u0005\u0002i\t\u0011a[\u000b\u00027A\u0011q\u0002H\u0005\u0003;A\u00111!\u00138uQ\rAr$\n\t\u0003A\rj\u0011!\t\u0006\u0003E\u0019\t!\"\u00198o_R\fG/[8o\u0013\t!\u0013EA\u0003TS:\u001cW-I\u0001'\u0003\u0015\td\u0006\u000e\u00181\u0011!A\u0003A!A!\u0002\u0013Y\u0012AA6!Q\r9s$\n\u0005\tW\u0001\u0011)\u0019!C\u0001Y\u0005\u0011\u0001oY\u000b\u0002[A\u0011a&M\u0007\u0002_)\u0011\u0001\u0007B\u0001\u0007Y&t\u0017\r\\4\n\u0005Iz#a\u0003#f]N,W*\u0019;sSbD3AK\u0010&\u0011!)\u0004A!A!\u0002\u0013i\u0013a\u00019dA!\u001aAgH\u0013\t\u0011a\u0002!Q1A\u0005\u0002e\n\u0011#\u001a=qY\u0006Lg.\u001a3WCJL\u0017M\\2f+\u0005Q\u0004C\u0001\u0018<\u0013\tatFA\u0006EK:\u001cXMV3di>\u0014\bfA\u001c }\u0005\nq(A\u00032]Yr\u0003\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003;\u0003I)\u0007\u0010\u001d7bS:,GMV1sS\u0006t7-\u001a\u0011)\u0007\u0001{b\b\u0003\u0004E\u0001\u0011\u0005a!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0019;\u0015j\u0013\t\u0003+\u0001AQ!G\"A\u0002mA3aR\u0010&\u0011\u0015Y3\t1\u0001.Q\rIu$\n\u0005\u0006q\r\u0003\rA\u000f\u0015\u0004\u0017~q\u0004\"\u0002(\u0001\t\u0003z\u0015!\u0003;sC:\u001chm\u001c:n)\t\u00016\u000b\u0005\u0002/#&\u0011!k\f\u0002\u0007-\u0016\u001cGo\u001c:\t\u000bQk\u0005\u0019\u0001)\u0002\rY,7\r^8sQ\riu$\n\u0015\u0004\u0001})\u0003")
public class PCAModel
implements VectorTransformer {
    private final int k;
    private final DenseMatrix pc;
    private final DenseVector explainedVariance;

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer.transform$((VectorTransformer)this, data);
    }

    @Override
    public JavaRDD<Vector> transform(JavaRDD<Vector> data) {
        return VectorTransformer.transform$((VectorTransformer)this, data);
    }

    public int k() {
        return this.k;
    }

    public DenseMatrix pc() {
        return this.pc;
    }

    public DenseVector explainedVariance() {
        return this.explainedVariance;
    }

    @Override
    public Vector transform(Vector vector) {
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option;
        Vector vector2;
        Vector vector3 = vector;
        if (vector3 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector3;
            vector2 = this.pc().transpose().multiply(denseVector);
        } else if (vector3 instanceof SparseVector && !(option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector3)).isEmpty()) {
            int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._1());
            int[] indices = (int[])((Tuple3)option.get())._2();
            double[] values = (double[])((Tuple3)option.get())._3();
            Matrix sm = Matrices$.MODULE$.sparse(size, 1, new int[]{0, indices.length}, indices, values).transpose();
            DenseMatrix projection = sm.multiply(this.pc());
            vector2 = Vectors$.MODULE$.dense(projection.values());
        } else {
            throw new IllegalArgumentException(new StringBuilder(36).append("Unsupported vector format. Expected ").append(new StringBuilder(42).append("SparseVector or DenseVector. Instead got: ").append(vector.getClass()).toString()).toString());
        }
        return vector2;
    }

    public PCAModel(int k, DenseMatrix pc, DenseVector explainedVariance) {
        this.k = k;
        this.pc = pc;
        this.explainedVariance = explainedVariance;
        VectorTransformer.$init$(this);
    }
}

