/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.feature.VocabWord;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0001\u0003\u00015\u0011\u0001bV8sIJ2Vm\u0019\u0006\u0003\u0007\u0011\tqAZ3biV\u0014XM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qAc\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f!\tA2$D\u0001\u001a\u0015\tQb!\u0001\u0005j]R,'O\\1m\u0013\ta\u0012DA\u0004M_\u001e<\u0017N\\4\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011\u0001bB\u0012\u0001\u0001\u0004%I\u0001J\u0001\u000bm\u0016\u001cGo\u001c:TSj,W#A\u0013\u0011\u0005=1\u0013BA\u0014\u0011\u0005\rIe\u000e\u001e\u0005\bS\u0001\u0001\r\u0011\"\u0003+\u000391Xm\u0019;peNK'0Z0%KF$\"a\u000b\u0018\u0011\u0005=a\u0013BA\u0017\u0011\u0005\u0011)f.\u001b;\t\u000f=B\u0013\u0011!a\u0001K\u0005\u0019\u0001\u0010J\u0019\t\rE\u0002\u0001\u0015)\u0003&\u0003-1Xm\u0019;peNK'0\u001a\u0011\t\u000fM\u0002\u0001\u0019!C\u0005i\u0005aA.Z1s]&twMU1uKV\tQ\u0007\u0005\u0002\u0010m%\u0011q\u0007\u0005\u0002\u0007\t>,(\r\\3\t\u000fe\u0002\u0001\u0019!C\u0005u\u0005\u0001B.Z1s]&twMU1uK~#S-\u001d\u000b\u0003WmBqa\f\u001d\u0002\u0002\u0003\u0007Q\u0007\u0003\u0004>\u0001\u0001\u0006K!N\u0001\u000eY\u0016\f'O\\5oOJ\u000bG/\u001a\u0011\t\u000f}\u0002\u0001\u0019!C\u0005I\u0005ia.^7QCJ$\u0018\u000e^5p]NDq!\u0011\u0001A\u0002\u0013%!)A\tok6\u0004\u0016M\u001d;ji&|gn]0%KF$\"aK\"\t\u000f=\u0002\u0015\u0011!a\u0001K!1Q\t\u0001Q!\n\u0015\naB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004H\u0001\u0001\u0007I\u0011\u0002\u0013\u0002\u001b9,X.\u0013;fe\u0006$\u0018n\u001c8t\u0011\u001dI\u0005\u00011A\u0005\n)\u000b\u0011C\\;n\u0013R,'/\u0019;j_:\u001cx\fJ3r)\tY3\nC\u00040\u0011\u0006\u0005\t\u0019A\u0013\t\r5\u0003\u0001\u0015)\u0003&\u00039qW/\\%uKJ\fG/[8og\u0002Bqa\u0014\u0001A\u0002\u0013%\u0001+\u0001\u0003tK\u0016$W#A)\u0011\u0005=\u0011\u0016BA*\u0011\u0005\u0011auN\\4\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006A1/Z3e?\u0012*\u0017\u000f\u0006\u0002,/\"9q\u0006VA\u0001\u0002\u0004\t\u0006BB-\u0001A\u0003&\u0011+A\u0003tK\u0016$\u0007\u0005C\u0004\\\u0001\u0001\u0007I\u0011\u0002\u0013\u0002\u00115LgnQ8v]RDq!\u0018\u0001A\u0002\u0013%a,\u0001\u0007nS:\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002,?\"9q\u0006XA\u0001\u0002\u0004)\u0003BB1\u0001A\u0003&Q%A\u0005nS:\u001cu.\u001e8uA!91\r\u0001a\u0001\n\u0013!\u0013!E7bqN+g\u000e^3oG\u0016dUM\\4uQ\"9Q\r\u0001a\u0001\n\u00131\u0017!F7bqN+g\u000e^3oG\u0016dUM\\4uQ~#S-\u001d\u000b\u0003W\u001dDqa\f3\u0002\u0002\u0003\u0007Q\u0005\u0003\u0004j\u0001\u0001\u0006K!J\u0001\u0013[\u0006D8+\u001a8uK:\u001cW\rT3oORD\u0007\u0005C\u0003l\u0001\u0011\u0005A.\u0001\u000btKRl\u0015\r_*f]R,gnY3MK:<G\u000f\u001b\u000b\u0003[:l\u0011\u0001\u0001\u0005\u0006G*\u0004\r!\n\u0015\u0004UB4\bCA9u\u001b\u0005\u0011(BA:\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003kJ\u0014QaU5oG\u0016\f\u0013a^\u0001\u0006e9\u0002d\u0006\r\u0005\u0006s\u0002!\tA_\u0001\u000eg\u0016$h+Z2u_J\u001c\u0016N_3\u0015\u00055\\\b\"B\u0012y\u0001\u0004)\u0003f\u0001=q{\u0006\na0A\u00032]Er\u0003\u0007C\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u001fM,G\u000fT3be:Lgn\u001a*bi\u0016$2!\\A\u0003\u0011\u0015\u0019t\u00101\u00016Q\ry\b/ \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003A\u0019X\r\u001e(v[B\u000b'\u000f^5uS>t7\u000fF\u0002n\u0003\u001fAaaPA\u0005\u0001\u0004)\u0003\u0006BA\u0005avDq!!\u0006\u0001\t\u0003\t9\"\u0001\ttKRtU/\\%uKJ\fG/[8ogR\u0019Q.!\u0007\t\r\u001d\u000b\u0019\u00021\u0001&Q\u0011\t\u0019\u0002]?\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u000591/\u001a;TK\u0016$GcA7\u0002$!1q*!\bA\u0002ECC!!\bq{\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012!D:fi^Kg\u000eZ8x'&TX\rF\u0002n\u0003[Aq!a\f\u0002(\u0001\u0007Q%\u0001\u0004xS:$wn\u001e\u0015\u0006\u0003O\u0001\u00181G\u0011\u0003\u0003k\tQ!\r\u00187]ABq!!\u000f\u0001\t\u0003\tY$A\u0006tKRl\u0015N\\\"pk:$HcA7\u0002>!11,a\u000eA\u0002\u0015BS!a\u000eq\u0003\u0003\n#!a\u0011\u0002\u000bEr3G\f\u0019\t\u0011\u0005\u001d\u0003A1A\u0005\n\u0011\na\"\u0012-Q?R\u000b%\tT#`'&SV\tC\u0004\u0002L\u0001\u0001\u000b\u0011B\u0013\u0002\u001f\u0015C\u0006k\u0018+B\u00052+ulU%[\u000b\u0002B\u0001\"a\u0014\u0001\u0005\u0004%I\u0001J\u0001\b\u001b\u0006Cv,\u0012-Q\u0011\u001d\t\u0019\u0006\u0001Q\u0001\n\u0015\n\u0001\"T!Y?\u0016C\u0006\u000b\t\u0005\t\u0003/\u0002!\u0019!C\u0005I\u0005yQ*\u0011-`\u0007>#Ui\u0018'F\u001d\u001e#\u0006\nC\u0004\u0002\\\u0001\u0001\u000b\u0011B\u0013\u0002!5\u000b\u0005lX\"P\t\u0016{F*\u0012(H)\"\u0003\u0003\u0002CA\u0018\u0001\u0001\u0007I\u0011\u0002\u0013\t\u0013\u0005\u0005\u0004\u00011A\u0005\n\u0005\r\u0014AC<j]\u0012|wo\u0018\u0013fcR\u00191&!\u001a\t\u0011=\ny&!AA\u0002\u0015Bq!!\u001b\u0001A\u0003&Q%A\u0004xS:$wn\u001e\u0011\t\u0011\u00055\u0004\u00011A\u0005\nA\u000bq\u0002\u001e:bS:<vN\u001d3t\u0007>,h\u000e\u001e\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003g\n1\u0003\u001e:bS:<vN\u001d3t\u0007>,h\u000e^0%KF$2aKA;\u0011!y\u0013qNA\u0001\u0002\u0004\t\u0006bBA=\u0001\u0001\u0006K!U\u0001\u0011iJ\f\u0017N\\,pe\u0012\u001c8i\\;oi\u0002B\u0001\"! \u0001\u0001\u0004%I\u0001J\u0001\nm>\u001c\u0017MY*ju\u0016D\u0011\"!!\u0001\u0001\u0004%I!a!\u0002\u001bY|7-\u00192TSj,w\fJ3r)\rY\u0013Q\u0011\u0005\t_\u0005}\u0014\u0011!a\u0001K!9\u0011\u0011\u0012\u0001!B\u0013)\u0013A\u0003<pG\u0006\u00147+\u001b>fA!I\u0011Q\u0012\u0001A\u0002\u0013%\u0011qR\u0001\u0006m>\u001c\u0017MY\u000b\u0003\u0003#\u0003RaDAJ\u0003/K1!!&\u0011\u0005\u0015\t%O]1z!\r\t\u0013\u0011T\u0005\u0004\u00037\u0013!!\u0003,pG\u0006\u0014wk\u001c:e\u0011%\ty\n\u0001a\u0001\n\u0013\t\t+A\u0005w_\u000e\f'm\u0018\u0013fcR\u00191&a)\t\u0013=\ni*!AA\u0002\u0005E\u0005\u0002CAT\u0001\u0001\u0006K!!%\u0002\rY|7-\u00192!Q\u0011\t)+a+\u0011\u0007=\ti+C\u0002\u00020B\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013\u0005M\u0006\u00011A\u0005\n\u0005U\u0016!\u0003<pG\u0006\u0014\u0007*Y:i+\t\t9\fE\u0004\u0002:\u0006\r\u0017qY\u0013\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000bq!\\;uC\ndWMC\u0002\u0002BB\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)-a/\u0003\u000f!\u000b7\u000f['baB!\u0011\u0011ZAl\u001d\u0011\tY-a5\u0011\u0007\u00055\u0007#\u0004\u0002\u0002P*\u0019\u0011\u0011\u001b\u0007\u0002\rq\u0012xn\u001c;?\u0013\r\t)\u000eE\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00171\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U\u0007\u0003C\u0005\u0002`\u0002\u0001\r\u0011\"\u0003\u0002b\u0006iao\\2bE\"\u000b7\u000f[0%KF$2aKAr\u0011%y\u0013Q\\A\u0001\u0002\u0004\t9\f\u0003\u0005\u0002h\u0002\u0001\u000b\u0015BA\\\u0003)1xnY1c\u0011\u0006\u001c\b\u000e\t\u0015\u0005\u0003K\fY\u000bC\u0004\u0002n\u0002!I!a<\u0002\u00151,\u0017M\u001d8W_\u000e\f'-\u0006\u0003\u0002r\n\u001dAcA\u0016\u0002t\"A\u0011Q_Av\u0001\u0004\t90A\u0004eCR\f7/\u001a;\u0011\r\u0005e\u0018q B\u0002\u001b\t\tYPC\u0002\u0002~\u001a\t1A\u001d3e\u0013\u0011\u0011\t!a?\u0003\u0007I#E\t\u0005\u0003\u0003\u0006\t\u001dA\u0002\u0001\u0003\t\u0005\u0013\tYO1\u0001\u0003\f\t\t1+\u0005\u0003\u0003\u000e\tM\u0001cA\b\u0003\u0010%\u0019!\u0011\u0003\t\u0003\u000f9{G\u000f[5oOB1!Q\u0003B\u0010\u0003\u000ftAAa\u0006\u0003\u001c9!\u0011Q\u001aB\r\u0013\u0005\t\u0012b\u0001B\u000f!\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0011\u0005G\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005;\u0001\u0002b\u0002B\u0014\u0001\u0011%!\u0011F\u0001\u000fGJ,\u0017\r^3FqB$\u0016M\u00197f)\t\u0011Y\u0003E\u0003\u0010\u0003'\u0013i\u0003E\u0002\u0010\u0005_I1A!\r\u0011\u0005\u00151En\\1u\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005o\t\u0001c\u0019:fCR,')\u001b8bef$&/Z3\u0015\u0003-BqAa\u000f\u0001\t\u0003\u0011i$A\u0002gSR,BAa\u0010\u0003NQ!!\u0011\tB$!\r\t#1I\u0005\u0004\u0005\u000b\u0012!!D,pe\u0012\u0014d+Z2N_\u0012,G\u000e\u0003\u0005\u0002v\ne\u0002\u0019\u0001B%!\u0019\tI0a@\u0003LA!!Q\u0001B'\t!\u0011IA!\u000fC\u0002\t-\u0001\u0006\u0002B\u001davDqAa\u0015\u0001\t\u0013\u0011)&A\u0003e_\u001aKG/\u0006\u0003\u0003X\t}C\u0003\u0004B!\u00053\u0012\tG!\u001c\u0003~\t\r\u0005\u0002CA{\u0005#\u0002\rAa\u0017\u0011\r\u0005e\u0018q B/!\u0011\u0011)Aa\u0018\u0005\u0011\t%!\u0011\u000bb\u0001\u0005\u0017A\u0001Ba\u0019\u0003R\u0001\u0007!QM\u0001\u0003g\u000e\u0004BAa\u001a\u0003j5\ta!C\u0002\u0003l\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001Ba\u001c\u0003R\u0001\u0007!\u0011O\u0001\tKb\u0004H+\u00192mKB1!1\u000fB=\u0005Wi!A!\u001e\u000b\u0007\t]d!A\u0005ce>\fGmY1ti&!!1\u0010B;\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0003\u0005\u0003\u0000\tE\u0003\u0019\u0001BA\u0003\u001d\u00117MV8dC\n\u0004bAa\u001d\u0003z\u0005E\u0005\u0002\u0003BC\u0005#\u0002\rAa\"\u0002\u0017\t\u001cgk\\2bE\"\u000b7\u000f\u001b\t\u0007\u0005g\u0012I(a.\t\u000f\tm\u0002\u0001\"\u0001\u0003\fV!!Q\u0012BR)\u0011\u0011\tEa$\t\u0011\u0005U(\u0011\u0012a\u0001\u0005#\u0003bAa%\u0003\u001e\n\u0005VB\u0001BK\u0015\u0011\u00119J!'\u0002\t)\fg/\u0019\u0006\u0004\u000573\u0011aA1qS&!!q\u0014BK\u0005\u001dQ\u0015M^1S\t\u0012\u0003BA!\u0002\u0003$\u0012A!\u0011\u0002BE\u0005\u0004\u0011)+\u0005\u0003\u0003\u000e\t\u001d\u0006C\u0002BU\u0005c\u000b9-\u0004\u0002\u0003,*!!Q\u0016BX\u0003\u0011a\u0017M\\4\u000b\u0005\t]\u0015\u0002\u0002B\u0011\u0005WCCA!#q{\"\u001a\u0001\u0001]?")
public class Word2Vec
implements scala.Serializable,
Logging {
    private int vectorSize;
    private double learningRate;
    private int numPartitions;
    private int numIterations;
    private long seed;
    private int minCount;
    private int maxSentenceLength;
    private final int EXP_TABLE_SIZE;
    private final int MAX_EXP;
    private final int MAX_CODE_LENGTH;
    private int window;
    private long trainWordsCount;
    private int vocabSize;
    private transient VocabWord[] vocab;
    private transient HashMap<String, Object> vocabHash;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private void vectorSize_$eq(int x$1) {
        this.vectorSize = x$1;
    }

    private double learningRate() {
        return this.learningRate;
    }

    private void learningRate_$eq(double x$1) {
        this.learningRate = x$1;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(int x$1) {
        this.numPartitions = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int minCount() {
        return this.minCount;
    }

    private void minCount_$eq(int x$1) {
        this.minCount = x$1;
    }

    private int maxSentenceLength() {
        return this.maxSentenceLength;
    }

    private void maxSentenceLength_$eq(int x$1) {
        this.maxSentenceLength = x$1;
    }

    public Word2Vec setMaxSentenceLength(int maxSentenceLength) {
        Predef$.MODULE$.require(maxSentenceLength > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Maximum length of sentences must be positive but got ").append(maxSentenceLength).toString());
        this.maxSentenceLength_$eq(maxSentenceLength);
        return this;
    }

    public Word2Vec setVectorSize(int vectorSize) {
        Predef$.MODULE$.require(vectorSize > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("vector size must be positive but got ").append(vectorSize).toString());
        this.vectorSize_$eq(vectorSize);
        return this;
    }

    public Word2Vec setLearningRate(double learningRate) {
        Predef$.MODULE$.require(learningRate > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Initial learning rate must be positive but got ").append(learningRate).toString());
        this.learningRate_$eq(learningRate);
        return this;
    }

    public Word2Vec setNumPartitions(int numPartitions) {
        Predef$.MODULE$.require(numPartitions > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Number of partitions must be positive but got ").append(numPartitions).toString());
        this.numPartitions_$eq(numPartitions);
        return this;
    }

    public Word2Vec setNumIterations(int numIterations) {
        Predef$.MODULE$.require(numIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Number of iterations must be nonnegative but got ").append(numIterations).toString());
        this.numIterations_$eq(numIterations);
        return this;
    }

    public Word2Vec setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public Word2Vec setWindowSize(int window) {
        Predef$.MODULE$.require(window > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Window of words must be positive but got ").append(window).toString());
        this.window_$eq(window);
        return this;
    }

    public Word2Vec setMinCount(int minCount) {
        Predef$.MODULE$.require(minCount >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Minimum number of times must be nonnegative but got ").append(minCount).toString());
        this.minCount_$eq(minCount);
        return this;
    }

    private int EXP_TABLE_SIZE() {
        return this.EXP_TABLE_SIZE;
    }

    private int MAX_EXP() {
        return this.MAX_EXP;
    }

    private int MAX_CODE_LENGTH() {
        return this.MAX_CODE_LENGTH;
    }

    private int window() {
        return this.window;
    }

    private void window_$eq(int x$1) {
        this.window = x$1;
    }

    private long trainWordsCount() {
        return this.trainWordsCount;
    }

    private void trainWordsCount_$eq(long x$1) {
        this.trainWordsCount = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    private VocabWord[] vocab() {
        return this.vocab;
    }

    private void vocab_$eq(VocabWord[] x$1) {
        this.vocab = x$1;
    }

    private HashMap<String, Object> vocabHash() {
        return this.vocabHash;
    }

    private void vocabHash_$eq(HashMap<String, Object> x$1) {
        this.vocabHash = x$1;
    }

    private <S extends Iterable<String>> void learnVocab(RDD<S> dataset) {
        RDD words = dataset.flatMap((Function1 & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.apply(String.class));
        this.vocab_$eq((VocabWord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(words.map((Function1 & Serializable & scala.Serializable)w -> new Tuple2(w, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Word2Vec.$anonfun$learnVocab$4(this, x$3))).map((Function1 & Serializable & scala.Serializable)x -> new VocabWord((String)x._1(), x._2$mcI$sp(), new int[this.MAX_CODE_LENGTH()], new int[this.MAX_CODE_LENGTH()], 0), ClassTag$.MODULE$.apply(VocabWord.class)).collect())).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)Word2Vec.$anonfun$learnVocab$6(a, b))));
        this.vocabSize_$eq(this.vocab().length);
        Predef$.MODULE$.require(this.vocabSize() > 0, (Function0 & Serializable & scala.Serializable)() -> "The vocabulary size should be > 0. You may need to check the setting of minCount, which could be large enough to remove all your words in sentences.");
        for (int a2 = 0; a2 < this.vocabSize(); ++a2) {
            this.vocabHash().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.vocab()[a2].word()), (Object)BoxesRunTime.boxToInteger((int)a2)));
            this.trainWordsCount_$eq(this.trainWordsCount() + (long)this.vocab()[a2].cn());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("vocabSize = ").append(this.vocabSize()).append(", trainWordsCount = ").append(this.trainWordsCount()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private float[] createExpTable() {
        void var1_1;
        float[] expTable = new float[this.EXP_TABLE_SIZE()];
        for (int i = 0; i < this.EXP_TABLE_SIZE(); ++i) {
            double tmp = scala.math.package$.MODULE$.exp((2.0 * (double)i / (double)this.EXP_TABLE_SIZE() - 1.0) * (double)this.MAX_EXP());
            expTable[i] = (float)(tmp / (tmp + 1.0));
        }
        return var1_1;
    }

    private void createBinaryTree() {
        int a;
        long[] count = new long[this.vocabSize() * 2 + 1];
        int[] binary = new int[this.vocabSize() * 2 + 1];
        int[] parentNode = new int[this.vocabSize() * 2 + 1];
        int[] code = new int[this.MAX_CODE_LENGTH()];
        int[] point = new int[this.MAX_CODE_LENGTH()];
        for (a = 0; a < this.vocabSize(); ++a) {
            count[a] = this.vocab()[a].cn();
        }
        while (a < 2 * this.vocabSize()) {
            count[a] = (int)1.0E9;
            ++a;
        }
        int pos1 = this.vocabSize() - 1;
        int pos2 = this.vocabSize();
        int min1i = 0;
        int min2i = 0;
        for (a = 0; a < this.vocabSize() - 1; ++a) {
            min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            count[this.vocabSize() + a] = count[min1i] + count[min2i];
            parentNode[min1i] = this.vocabSize() + a;
            parentNode[min2i] = this.vocabSize() + a;
            binary[min2i] = 1;
        }
        int i = 0;
        for (a = 0; a < this.vocabSize(); ++a) {
            int b = a;
            i = 0;
            while (b != this.vocabSize() * 2 - 2) {
                code[i] = binary[b];
                point[i] = b;
                ++i;
                b = parentNode[b];
            }
            this.vocab()[a].codeLen_$eq(i);
            this.vocab()[a].point()[0] = this.vocabSize() - 2;
            for (b = 0; b < i; ++b) {
                this.vocab()[a].code()[i - b - 1] = code[b];
                this.vocab()[a].point()[i - b] = point[b] - this.vocabSize();
            }
        }
    }

    public <S extends Iterable<String>> Word2VecModel fit(RDD<S> dataset) {
        Word2VecModel word2VecModel;
        this.learnVocab(dataset);
        this.createBinaryTree();
        SparkContext sc = dataset.context();
        Broadcast expTable = sc.broadcast((Object)this.createExpTable(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        Broadcast bcVocab = sc.broadcast((Object)this.vocab(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VocabWord.class)));
        Broadcast bcVocabHash = sc.broadcast(this.vocabHash(), ClassTag$.MODULE$.apply(HashMap.class));
        try {
            word2VecModel = this.doFit(dataset, sc, (Broadcast<float[]>)expTable, (Broadcast<VocabWord[]>)bcVocab, (Broadcast<HashMap<String, Object>>)bcVocabHash);
        }
        finally {
            expTable.destroy(false);
            bcVocab.destroy(false);
            bcVocabHash.destroy(false);
        }
        return word2VecModel;
    }

    private <S extends Iterable<String>> Word2VecModel doFit(RDD<S> dataset, SparkContext sc, Broadcast<float[]> expTable, Broadcast<VocabWord[]> bcVocab, Broadcast<HashMap<String, Object>> bcVocabHash) {
        RDD sentences = dataset.mapPartitions((Function1 & Serializable & scala.Serializable)sentenceIter -> sentenceIter.flatMap((Function1 & Serializable & scala.Serializable)sentence -> {
            HashMap hashMap = (HashMap)bcVocabHash.value();
            Iterable wordIndexes = (Iterable)sentence.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(hashMap.get(key)), Iterable$.MODULE$.canBuildFrom());
            return wordIndexes.grouped(this.maxSentenceLength()).map((Function1 & Serializable & scala.Serializable)x$4 -> (int[])x$4.toArray(ClassTag$.MODULE$.Int()));
        }), dataset.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        int x$14 = this.numPartitions();
        Ordering x$15 = sentences.repartition$default$2(x$14);
        RDD newSentences = sentences.repartition(x$14, x$15).cache();
        XORShiftRandom initRandom = new XORShiftRandom(this.seed());
        if ((long)this.vocabSize() * (long)this.vectorSize() >= Integer.MAX_VALUE) {
            throw new RuntimeException(new StringBuilder(184).append("Please increase minCount or decrease vectorSize in Word2Vec to avoid an OOM. You are highly recommended to make your vocabSize*vectorSize, which is ").append(this.vocabSize()).append("*").append(this.vectorSize()).append(" for now, less than `Int.MaxValue`.").toString());
        }
        float[] syn0Global = (float[])Array$.MODULE$.fill(this.vocabSize() * this.vectorSize(), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> (initRandom.nextFloat() - 0.5f) / (float)this.vectorSize(), ClassTag$.MODULE$.Float());
        float[] syn1Global = new float[this.vocabSize() * this.vectorSize()];
        long totalWordsCounts = (long)this.numIterations() * this.trainWordsCount() + 1L;
        DoubleRef alpha = DoubleRef.create((double)this.learningRate());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numIterations()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            Broadcast bcSyn0Global = sc.broadcast((Object)syn0Global, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
            Broadcast bcSyn1Global = sc.broadcast((Object)syn1Global, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
            long numWordsProcessedInPreviousIterations = (long)(k - 1) * this.trainWordsCount();
            RDD partial = newSentences.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> Word2Vec.$anonfun$doFit$7(this, expTable, bcVocab, totalWordsCounts, alpha, bcSyn0Global, bcSyn1Global, numWordsProcessedInPreviousIterations, k, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), newSentences.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Tuple2[] synAgg = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(partial, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                Tuple2 tuple2 = new Tuple2(x0$3, x1$3);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                float[] v1 = (float[])tuple2._1();
                float[] v2 = (float[])tuple2._2();
                BLAS.getInstance().saxpy(this.vectorSize(), 1.0f, v2, 1, v1, 1);
                float[] fArray = v1;
                return fArray;
            }).collect();
            for (int i = 0; i < synAgg.length; ++i) {
                int index = synAgg[i]._1$mcI$sp();
                if (index < this.vocabSize()) {
                    Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)syn0Global, index * this.vectorSize(), this.vectorSize());
                    continue;
                }
                Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)syn1Global, (index - this.vocabSize()) * this.vectorSize(), this.vectorSize());
            }
            bcSyn0Global.destroy(false);
            bcSyn1Global.destroy(false);
        });
        newSentences.unpersist(newSentences.unpersist$default$1());
        String[] wordArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.vocab())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.word(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new Word2VecModel((Map<String, Object>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])wordArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()), syn0Global);
    }

    public <S extends java.lang.Iterable<String>> Word2VecModel fit(JavaRDD<S> dataset) {
        return this.fit(dataset.rdd().map((Function1 & Serializable & scala.Serializable)x$6 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$6).asScala(), ClassTag$.MODULE$.apply(Iterable.class)));
    }

    public static final /* synthetic */ boolean $anonfun$learnVocab$4(Word2Vec $this, Tuple2 x$3) {
        return x$3._2$mcI$sp() >= $this.minCount();
    }

    public static final /* synthetic */ boolean $anonfun$learnVocab$6(VocabWord a, VocabWord b) {
        return a.cn() > b.cn();
    }

    public static final /* synthetic */ Option $anonfun$doFit$10(Word2Vec $this, int[] syn0Modify$1, float[] syn0Local$1, int index) {
        return syn0Modify$1[index] > 0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(syn0Local$1)).slice(index * $this.vectorSize(), (index + 1) * $this.vectorSize()))) : None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$doFit$13(Word2Vec $this, int[] syn1Modify$1, float[] syn1Local$1, int index) {
        return syn1Modify$1[index] > 0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(index + $this.vocabSize())), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(syn1Local$1)).slice(index * $this.vectorSize(), (index + 1) * $this.vectorSize()))) : None$.MODULE$;
    }

    public static final /* synthetic */ Iterator $anonfun$doFit$7(Word2Vec $this, Broadcast expTable$1, Broadcast bcVocab$1, long totalWordsCounts$1, DoubleRef alpha$1, Broadcast bcSyn0Global$1, Broadcast bcSyn1Global$1, long numWordsProcessedInPreviousIterations$1, int k$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int idx = tuple2._1$mcI$sp();
        Iterator iter = (Iterator)tuple2._2();
        XORShiftRandom random = new XORShiftRandom($this.seed() ^ (long)(idx + 1 << 16) ^ (long)(-k$1 - 1 << 8));
        int[] syn0Modify = new int[$this.vocabSize()];
        int[] syn1Modify = new int[$this.vocabSize()];
        Tuple4 model = (Tuple4)iter.foldLeft((Object)new Tuple4(bcSyn0Global$1.value(), bcSyn1Global$1.value(), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple4 tuple4 = (Tuple4)tuple2._1();
            int[] sentence = (int[])tuple2._2();
            if (tuple4 == null) throw new MatchError((Object)tuple2);
            float[] syn0 = (float[])tuple4._1();
            float[] syn1 = (float[])tuple4._2();
            long lastWordCount = BoxesRunTime.unboxToLong((Object)tuple4._3());
            long wordCount = BoxesRunTime.unboxToLong((Object)tuple4._4());
            long lwc = lastWordCount;
            long wc = wordCount;
            if (wordCount - lastWordCount > 10000L) {
                lwc = wordCount;
                alpha$1.elem = $this.learningRate() * (1.0 - ((double)$this.numPartitions() * (double)wordCount + (double)numWordsProcessedInPreviousIterations$1) / (double)totalWordsCounts$1);
                if (alpha$1.elem < $this.learningRate() * 1.0E-4) {
                    alpha$1.elem = $this.learningRate() * 1.0E-4;
                }
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("wordCount = ").append(wordCount + numWordsProcessedInPreviousIterations$1).append(", ").append(new StringBuilder(8).append("alpha = ").append(alpha$1.elem).toString()).toString());
            }
            wc += (long)sentence.length;
            int pos = 0;
            while (pos < sentence.length) {
                int b;
                int word = sentence[pos];
                for (int a = b = random.nextInt($this.window()); a < $this.window() * 2 + 1 - b; ++a) {
                    int c;
                    if (a == $this.window() || (c = pos - $this.window() + a) < 0 || c >= sentence.length) continue;
                    int lastWord = sentence[c];
                    int l1 = lastWord * $this.vectorSize();
                    float[] neu1e = new float[$this.vectorSize()];
                    for (int d = 0; d < ((VocabWord[])bcVocab$1.value())[word].codeLen(); ++d) {
                        int inner = ((VocabWord[])bcVocab$1.value())[word].point()[d];
                        int l2 = inner * $this.vectorSize();
                        float f = BLAS.getInstance().sdot($this.vectorSize(), syn0, l1, 1, syn1, l2, 1);
                        if (!(f > (float)(-$this.MAX_EXP())) || !(f < (float)$this.MAX_EXP())) continue;
                        int ind = (int)((double)(f + (float)$this.MAX_EXP()) * ((double)($this.EXP_TABLE_SIZE() / $this.MAX_EXP()) / 2.0));
                        f = ((float[])expTable$1.value())[ind];
                        float g = (float)((double)((float)(1 - ((VocabWord[])bcVocab$1.value())[word].code()[d]) - f) * alpha$1.elem);
                        BLAS.getInstance().saxpy($this.vectorSize(), g, syn1, l2, 1, neu1e, 0, 1);
                        BLAS.getInstance().saxpy($this.vectorSize(), g, syn0, l1, 1, syn1, l2, 1);
                        syn1Modify$1[inner] = syn1Modify[inner] + 1;
                    }
                    BLAS.getInstance().saxpy($this.vectorSize(), 1.0f, neu1e, 0, 1, syn0, l1, 1);
                    syn0Modify$1[lastWord] = syn0Modify[lastWord] + 1;
                }
                ++pos;
            }
            return new Tuple4((Object)syn0, (Object)syn1, (Object)BoxesRunTime.boxToLong((long)lwc), (Object)BoxesRunTime.boxToLong((long)wc));
        });
        float[] syn0Local = (float[])model._1();
        float[] syn1Local = (float[])model._2();
        Iterator iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().tabulate($this.vocabSize(), (Function1 & Serializable & scala.Serializable)index -> Word2Vec.$anonfun$doFit$10($this, syn0Modify, syn0Local, BoxesRunTime.unboxToInt((Object)index))), (Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten().$plus$plus((Function0 & Serializable & scala.Serializable)() -> TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().tabulate($this.vocabSize(), (Function1 & Serializable & scala.Serializable)index -> Word2Vec.$anonfun$doFit$13($this, syn1Modify, syn1Local, BoxesRunTime.unboxToInt((Object)index))), (Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten());
        return iterator;
    }

    public Word2Vec() {
        Logging.$init$((Logging)this);
        this.vectorSize = 100;
        this.learningRate = 0.025;
        this.numPartitions = 1;
        this.numIterations = 1;
        this.seed = Utils$.MODULE$.random().nextLong();
        this.minCount = 5;
        this.maxSentenceLength = 1000;
        this.EXP_TABLE_SIZE = 1000;
        this.MAX_EXP = 6;
        this.MAX_CODE_LENGTH = 40;
        this.window = 5;
        this.trainWordsCount = 0L;
        this.vocabSize = 0;
        this.vocab = null;
        this.vocabHash = HashMap$.MODULE$.empty();
    }
}

