/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.util.BoundedPriorityQueue;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\u0001\u0003\u00015\u0011QbV8sIJ2VmY'pI\u0016d'BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tA!\u001e;jY&\u0011A$\u0007\u0002\t'\u00064X-\u00192mK\"Ia\u0004\u0001BC\u0002\u0013\u0005aaH\u0001\no>\u0014H-\u00138eKb,\u0012\u0001\t\t\u0005C!ZcF\u0004\u0002#MA\u00111\u0005E\u0007\u0002I)\u0011Q\u0005D\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002*U\t\u0019Q*\u00199\u000b\u0005\u001d\u0002\u0002CA\u0011-\u0013\ti#F\u0001\u0004TiJLgn\u001a\t\u0003\u001f=J!\u0001\r\t\u0003\u0007%sG\u000f\u0003\u00053\u0001\t\u0005\t\u0015!\u0003!\u0003)9xN\u001d3J]\u0012,\u0007\u0010\t\u0005\ni\u0001\u0011)\u0019!C\u0001\rU\n1b^8sIZ+7\r^8sgV\ta\u0007E\u0002\u0010oeJ!\u0001\u000f\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=Q\u0014BA\u001e\u0011\u0005\u00151En\\1u\u0011!i\u0004A!A!\u0002\u00131\u0014\u0001D<pe\u00124Vm\u0019;peN\u0004\u0003BB \u0001\t\u00031\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0004\u0003\u000e#\u0005C\u0001\"\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010?\u0001\u0004\u0001\u0003\"\u0002\u001b?\u0001\u00041\u0004b\u0002$\u0001\u0005\u0004%IaR\u0001\t]Vlwk\u001c:egV\ta\u0006\u0003\u0004J\u0001\u0001\u0006IAL\u0001\n]Vlwk\u001c:eg\u0002Bqa\u0013\u0001C\u0002\u0013%q)\u0001\u0006wK\u000e$xN]*ju\u0016Da!\u0014\u0001!\u0002\u0013q\u0013a\u0003<fGR|'oU5{K\u0002Bqa\u0014\u0001C\u0002\u0013%\u0001+\u0001\u0005x_J$G*[:u+\u0005\t\u0006cA\b8W!11\u000b\u0001Q\u0001\nE\u000b\u0011b^8sI2K7\u000f\u001e\u0011\t\u000fU\u0003!\u0019!C\u0005k\u0005aqo\u001c:e-\u0016\u001cgj\u001c:ng\"1q\u000b\u0001Q\u0001\nY\nQb^8sIZ+7MT8s[N\u0004\u0003\"B \u0001\t\u0003IFCA![\u0011\u0015Y\u0006\f1\u0001]\u0003\u0015iw\u000eZ3m!\u0011\t\u0003f\u000b\u001c)\u0007asF\r\u0005\u0002`E6\t\u0001M\u0003\u0002b\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\r\u0004'!B*j]\u000e,\u0017%A3\u0002\u000bErSG\f\u0019\t\u000b\u001d\u0004A\u0011\u000b5\u0002\u001b\u0019|'/\\1u-\u0016\u00148/[8o+\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u0011a\u0017M\\4\u000b\u00039\fAA[1wC&\u0011Qf\u001b\u0005\u0006c\u0002!\tA]\u0001\u0005g\u00064X\rF\u0002tmr\u0004\"a\u0004;\n\u0005U\u0004\"\u0001B+oSRDQa\u001e9A\u0002a\f!a]2\u0011\u0005eTX\"\u0001\u0004\n\u0005m4!\u0001D*qCJ\\7i\u001c8uKb$\b\"B?q\u0001\u0004Y\u0013\u0001\u00029bi\"D3\u0001\u001d0\u0000C\t\t\t!A\u00032]Qr\u0003\u0007C\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA\u0005\u0003+\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f!\u0011A\u00027j]\u0006dw-\u0003\u0003\u0002\u0014\u00055!A\u0002,fGR|'\u000fC\u0004\u0002\u0018\u0005\r\u0001\u0019A\u0016\u0002\t]|'\u000f\u001a\u0015\u0006\u0003\u0007q\u00161D\u0011\u0003\u0003;\tQ!\r\u00182]ABq!!\t\u0001\t\u0003\t\u0019#\u0001\u0007gS:$7+\u001f8p]fl7\u000f\u0006\u0004\u0002&\u0005M\u0012Q\u0007\t\u0005\u001f]\n9\u0003\u0005\u0004\u0010\u0003SY\u0013QF\u0005\u0004\u0003W\u0001\"A\u0002+va2,'\u0007E\u0002\u0010\u0003_I1!!\r\u0011\u0005\u0019!u.\u001e2mK\"9\u0011qCA\u0010\u0001\u0004Y\u0003bBA\u001c\u0003?\u0001\rAL\u0001\u0004]Vl\u0007&BA\u0010=\u0006m\u0001bBA\u0011\u0001\u0011\u0005\u0011Q\b\u000b\u0007\u0003K\ty$a\u0011\t\u0011\u0005\u0005\u00131\ba\u0001\u0003\u0013\taA^3di>\u0014\bbBA\u001c\u0003w\u0001\rA\f\u0015\u0006\u0003wq\u00161\u0004\u0005\b\u0003C\u0001A\u0011BA%)!\t)#a\u0013\u0002N\u0005=\u0003\u0002CA!\u0003\u000f\u0002\r!!\u0003\t\u000f\u0005]\u0012q\ta\u0001]!A\u0011\u0011KA$\u0001\u0004\t\u0019&A\u0004x_J$w\n\u001d;\u0011\t=\t)fK\u0005\u0004\u0003/\u0002\"AB(qi&|g\u000eC\u0004\u0002\\\u0001!\t!!\u0018\u0002\u0015\u001d,GOV3di>\u00148/F\u0001]Q\u0015\tIFXA1C\t\t\u0019'A\u00032]Ir\u0003\u0007\u000b\u0003\u0001=\u0006mqaBA5\u0005!\u0005\u00111N\u0001\u000e/>\u0014HM\r,fG6{G-\u001a7\u0011\u0007\t\u000biG\u0002\u0004\u0002\u0005!\u0005\u0011qN\n\u0007\u0003[r\u0011\u0011\u000f\u000b\u0011\ta\t\u0019(Q\u0005\u0004\u0003kJ\"A\u0002'pC\u0012,'\u000fC\u0004@\u0003[\"\t!!\u001f\u0015\u0005\u0005-\u0004\u0002CA?\u0003[\"I!a \u0002\u001d\t,\u0018\u000e\u001c3X_J$\u0017J\u001c3fqR\u0019\u0001%!!\t\rm\u000bY\b1\u0001]\u0011!\t))!\u001c\u0005\n\u0005\u001d\u0015\u0001\u00052vS2$wk\u001c:e-\u0016\u001cGo\u001c:t)\r1\u0014\u0011\u0012\u0005\u00077\u0006\r\u0005\u0019\u0001/\b\u0011\u00055\u0015Q\u000eE\u0005\u0003\u001f\u000bAbU1wK2{\u0017\r\u001a,2?B\u0002B!!%\u0002\u00146\u0011\u0011Q\u000e\u0004\t\u0003+\u000bi\u0007#\u0003\u0002\u0018\na1+\u0019<f\u0019>\fGMV\u0019`aM\u0019\u00111\u0013\b\t\u000f}\n\u0019\n\"\u0001\u0002\u001cR\u0011\u0011q\u0012\u0005\n\u0003?\u000b\u0019J1A\u0005\u0002!\f\u0011CZ8s[\u0006$h+\u001a:tS>tg+M01\u0011!\t\u0019+a%!\u0002\u0013I\u0017A\u00054pe6\fGOV3sg&|gNV\u0019`a\u0001B\u0011\"a*\u0002\u0014\n\u0007I\u0011\u00015\u0002\u001b\rd\u0017m]:OC6,g+M01\u0011!\tY+a%!\u0002\u0013I\u0017AD2mCN\u001ch*Y7f-Fz\u0006\u0007\t\u0004\b\u0003_\u000b\u0019\nQAY\u0005\u0011!\u0015\r^1\u0014\r\u00055f\"a-\u0015!\ry\u0011QW\u0005\u0004\u0003o\u0003\"a\u0002)s_\u0012,8\r\u001e\u0005\f\u0003/\tiK!f\u0001\n\u0003\tY,F\u0001,\u0011)\ty,!,\u0003\u0012\u0003\u0006IaK\u0001\u0006o>\u0014H\r\t\u0005\u000b\u0003\u0003\niK!f\u0001\n\u0003)\u0004BCAc\u0003[\u0013\t\u0012)A\u0005m\u00059a/Z2u_J\u0004\u0003bB \u0002.\u0012\u0005\u0011\u0011\u001a\u000b\u0007\u0003\u0017\fy-!5\u0011\t\u00055\u0017QV\u0007\u0003\u0003'Cq!a\u0006\u0002H\u0002\u00071\u0006C\u0004\u0002B\u0005\u001d\u0007\u0019\u0001\u001c\t\u0015\u0005U\u0017QVA\u0001\n\u0003\t9.\u0001\u0003d_BLHCBAf\u00033\fY\u000eC\u0005\u0002\u0018\u0005M\u0007\u0013!a\u0001W!I\u0011\u0011IAj!\u0003\u0005\rA\u000e\u0005\u000b\u0003?\fi+%A\u0005\u0002\u0005\u0005\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003GT3aKAsW\t\t9\u000f\u0005\u0003\u0002j\u0006EXBAAv\u0015\u0011\ti/a<\u0002\u0013Ut7\r[3dW\u0016$'BA1\u0011\u0013\u0011\t\u00190a;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002x\u00065\u0016\u0013!C\u0001\u0003s\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002|*\u001aa'!:\t\u0013\u0005}\u0018QVA\u0001\n\u0003B\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010C\u0005\u0003\u0004\u00055\u0016\u0011!C\u0001\u000f\u0006a\u0001O]8ek\u000e$\u0018I]5us\"Q!qAAW\u0003\u0003%\tA!\u0003\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0002B\t!\ry!QB\u0005\u0004\u0005\u001f\u0001\"aA!os\"I!1\u0003B\u0003\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\n\u0004B\u0003B\f\u0003[\u000b\t\u0011\"\u0011\u0003\u001a\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u001cA1!Q\u0004B\u0012\u0005\u0017i!Aa\b\u000b\u0007\t\u0005\u0002#\u0001\u0006d_2dWm\u0019;j_:LAA!\n\u0003 \tA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003*\u00055\u0016\u0011!C\u0001\u0005W\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005[\u0011\u0019\u0004E\u0002\u0010\u0005_I1A!\r\u0011\u0005\u001d\u0011un\u001c7fC:D!Ba\u0005\u0003(\u0005\u0005\t\u0019\u0001B\u0006\u0011)\u00119$!,\u0002\u0002\u0013\u0005#\u0011H\u0001\tQ\u0006\u001c\bnQ8eKR\ta\u0006\u0003\u0006\u0003>\u00055\u0016\u0011!C!\u0005\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002S\"Q!1IAW\u0003\u0003%\tE!\u0012\u0002\r\u0015\fX/\u00197t)\u0011\u0011iCa\u0012\t\u0015\tM!\u0011IA\u0001\u0002\u0004\u0011Ya\u0002\u0006\u0003L\u0005M\u0015\u0011!E\u0001\u0005\u001b\nA\u0001R1uCB!\u0011Q\u001aB(\r)\ty+a%\u0002\u0002#\u0005!\u0011K\n\u0006\u0005\u001f\u0012\u0019\u0006\u0006\t\t\u0005+\u0012Yf\u000b\u001c\u0002L6\u0011!q\u000b\u0006\u0004\u00053\u0002\u0012a\u0002:v]RLW.Z\u0005\u0005\u0005;\u00129FA\tBEN$(/Y2u\rVt7\r^5p]JBqa\u0010B(\t\u0003\u0011\t\u0007\u0006\u0002\u0003N!Q!Q\bB(\u0003\u0003%)Ea\u0010\t\u0015\t\u001d$qJA\u0001\n\u0003\u0013I'A\u0003baBd\u0017\u0010\u0006\u0004\u0002L\n-$Q\u000e\u0005\b\u0003/\u0011)\u00071\u0001,\u0011\u001d\t\tE!\u001aA\u0002YB!B!\u001d\u0003P\u0005\u0005I\u0011\u0011B:\u0003\u001d)h.\u00199qYf$BA!\u001e\u0003zA)q\"!\u0016\u0003xA)q\"!\u000b,m!Q!1\u0010B8\u0003\u0003\u0005\r!a3\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u0000\t=\u0013\u0011!C\u0005\u0005\u0003\u000b1B]3bIJ+7o\u001c7wKR\u0011!1\u0011\t\u0004U\n\u0015\u0015b\u0001BDW\n1qJ\u00196fGRD\u0001Ba#\u0002\u0014\u0012\u0005!QR\u0001\u0005Y>\fG\rF\u0003B\u0005\u001f\u0013\t\n\u0003\u0004x\u0005\u0013\u0003\r\u0001\u001f\u0005\u0007{\n%\u0005\u0019A\u0016\t\u000fE\f\u0019\n\"\u0001\u0003\u0016R91Oa&\u0003\u001a\nm\u0005BB<\u0003\u0014\u0002\u0007\u0001\u0010\u0003\u0004~\u0005'\u0003\ra\u000b\u0005\u00077\nM\u0005\u0019\u0001/\t\u0011\t-\u0015Q\u000eC!\u0005?#R!\u0011BQ\u0005GCaa\u001eBO\u0001\u0004A\bBB?\u0003\u001e\u0002\u00071\u0006\u000b\u0003\u0003\u001ez{\bB\u0003B@\u0003[\n\t\u0011\"\u0003\u0003\u0002\"\"\u0011Q\u000e0\u0000Q\u0011\t9GX@")
public class Word2VecModel
implements scala.Serializable,
Saveable {
    private final Map<String, Object> wordIndex;
    private final float[] wordVectors;
    private final int numWords;
    private final int vectorSize;
    private final String[] wordList;
    private final float[] wordVecNorms;

    public static /* bridge */ Saveable load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    public static Word2VecModel load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    public Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public float[] wordVectors() {
        return this.wordVectors;
    }

    private int numWords() {
        return this.numWords;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private String[] wordList() {
        return this.wordList;
    }

    private float[] wordVecNorms() {
        return this.wordVecNorms;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        Option option = this.wordIndex().get((Object)word);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(18).append(word).append(" not in vocabulary").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        int ind = BoxesRunTime.unboxToInt((Object)some.value());
        float[] vec = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.wordVectors())).slice(ind * this.vectorSize(), ind * this.vectorSize() + this.vectorSize());
        Vector vector = Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vec)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$8 -> x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        return vector;
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector, num, (Option<String>)new Some((Object)word));
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        return this.findSynonyms(vector, num, (Option<String>)None$.MODULE$);
    }

    private Tuple2<String, Object>[] findSynonyms(Vector vector, int num, Option<String> wordOpt) {
        Seq seq;
        Predef$.MODULE$.require(num > 0, (Function0 & Serializable & scala.Serializable)() -> "Number of similar words should > 0");
        float[] fVector = (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector.toArray())).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$9 -> (float)x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        float[] cosineVec = new float[this.numWords()];
        float alpha = 1.0f;
        float beta = 0.0f;
        float vecNorm = BLAS.getInstance().snrm2(this.vectorSize(), fVector, 1);
        if (vecNorm != 0.0f) {
            BLAS.getInstance().sscal(this.vectorSize(), 1.0f / vecNorm, fVector, 0, 1);
        }
        BLAS.getInstance().sgemv("T", this.vectorSize(), this.numWords(), alpha, this.wordVectors(), this.vectorSize(), fVector, 1, beta, cosineVec, 1);
        for (int i = 0; i < this.numWords(); ++i) {
            float norm = this.wordVecNorms()[i];
            if (norm == 0.0f) {
                cosineVec[i] = 0.0f;
                continue;
            }
            int n = i;
            cosineVec[n] = cosineVec[n] / norm;
        }
        BoundedPriorityQueue pq = new BoundedPriorityQueue(num + 1, package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToFloat((float)Word2VecModel.$anonfun$findSynonyms$3(x$10)), (Ordering)Ordering.Float$.MODULE$));
        for (int j = 0; j < this.numWords(); ++j) {
            pq.$plus$eq((Object)new Tuple2((Object)this.wordList()[j], (Object)BoxesRunTime.boxToFloat((float)cosineVec[j])));
        }
        Seq scored = (Seq)pq.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToFloat((float)Word2VecModel.$anonfun$findSynonyms$4(x$11)), (Ordering)Ordering.Float$.MODULE$);
        Option<String> option = wordOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String w = (String)some.value();
            seq = (Seq)scored.filter((Function1 & Serializable & scala.Serializable)tup -> BoxesRunTime.boxToBoolean((boolean)Word2VecModel.$anonfun$findSynonyms$5(w, tup)));
        } else if (None$.MODULE$.equals(option)) {
            seq = scored;
        } else {
            throw new MatchError(option);
        }
        Seq filtered = seq;
        return (Tuple2[])((TraversableOnce)((TraversableLike)filtered.take(num)).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String word = (String)tuple2._1();
            float score = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2((Object)word, (Object)BoxesRunTime.boxToDouble((double)score));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String word = (String)tuple2._1();
            int ind = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)word, new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.wordVectors())).slice(this.vectorSize() * ind, this.vectorSize() * ind + this.vectorSize()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ float $anonfun$findSynonyms$3(Tuple2 x$10) {
        return BoxesRunTime.unboxToFloat((Object)x$10._2());
    }

    public static final /* synthetic */ float $anonfun$findSynonyms$4(Tuple2 x$11) {
        return -BoxesRunTime.unboxToFloat((Object)x$11._2());
    }

    public static final /* synthetic */ boolean $anonfun$findSynonyms$5(String w$1, Tuple2 tup) {
        String string = w$1;
        Object object = tup._1();
        return string == null ? object != null : !string.equals(object);
    }

    public Word2VecModel(Map<String, Object> wordIndex, float[] wordVectors) {
        Seq wl;
        this.wordIndex = wordIndex;
        this.wordVectors = wordVectors;
        this.numWords = wordIndex.size();
        this.vectorSize = wordVectors.length / this.numWords();
        Tuple2 tuple2 = ((GenericTraversableTemplate)wordIndex.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq seq = wl = (Seq)tuple2._1();
        Seq wl2 = seq;
        this.wordList = (String[])wl2.toArray(ClassTag$.MODULE$.apply(String.class));
        float[] wordVecNorms = new float[this.numWords()];
        for (int i = 0; i < this.numWords(); ++i) {
            float[] vec = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(wordVectors)).slice(i * this.vectorSize(), i * this.vectorSize() + this.vectorSize());
            wordVecNorms[i] = BLAS.getInstance().snrm2(this.vectorSize(), vec, 1);
        }
        this.wordVecNorms = wordVecNorms;
    }

    public Word2VecModel(Map<String, float[]> model) {
        this(Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(model), Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(model));
    }
}

