/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.fpm.PrefixSpan$;
import org.apache.spark.mllib.fpm.PrefixSpan$Prefix$;
import org.apache.spark.mllib.fpm.PrefixSpanModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}c\u0001B\u0001\u0003\u00015\u0011!\u0002\u0015:fM&D8\u000b]1o\u0015\t\u0019A!A\u0002ga6T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQQ\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001a-\t9Aj\\4hS:<\u0007CA\b\u001c\u0013\ta\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001f\u0001\t\u0005\r\u0011\"\u0003 \u0003)i\u0017N\\*vaB|'\u000f^\u000b\u0002AA\u0011q\"I\u0005\u0003EA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0007I\u0011B\u0013\u0002\u001d5LgnU;qa>\u0014Ho\u0018\u0013fcR\u0011a%\u000b\t\u0003\u001f\u001dJ!\u0001\u000b\t\u0003\tUs\u0017\u000e\u001e\u0005\bU\r\n\t\u00111\u0001!\u0003\rAH%\r\u0005\tY\u0001\u0011\t\u0011)Q\u0005A\u0005YQ.\u001b8TkB\u0004xN\u001d;!\u0011!q\u0003A!a\u0001\n\u0013y\u0013\u0001E7bqB\u000bG\u000f^3s]2+gn\u001a;i+\u0005\u0001\u0004CA\b2\u0013\t\u0011\u0004CA\u0002J]RD\u0001\u0002\u000e\u0001\u0003\u0002\u0004%I!N\u0001\u0015[\u0006D\b+\u0019;uKJtG*\u001a8hi\"|F%Z9\u0015\u0005\u00192\u0004b\u0002\u00164\u0003\u0003\u0005\r\u0001\r\u0005\tq\u0001\u0011\t\u0011)Q\u0005a\u0005\tR.\u0019=QCR$XM\u001d8MK:<G\u000f\u001b\u0011\t\u0011i\u0002!\u00111A\u0005\nm\n!#\\1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{KV\tA\b\u0005\u0002\u0010{%\u0011a\b\u0005\u0002\u0005\u0019>tw\r\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0003B\u0003Yi\u0017\r\u001f'pG\u0006d\u0007K]8k\t\n\u001b\u0016N_3`I\u0015\fHC\u0001\u0014C\u0011\u001dQs(!AA\u0002qB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006K\u0001P\u0001\u0014[\u0006DHj\\2bYB\u0013xN\u001b#C'&TX\r\t\u0005\u0006\r\u0002!IaR\u0001\u0007y%t\u0017\u000e\u001e \u0015\t!S5\n\u0014\t\u0003\u0013\u0002i\u0011A\u0001\u0005\u0006=\u0015\u0003\r\u0001\t\u0005\u0006]\u0015\u0003\r\u0001\r\u0005\u0006u\u0015\u0003\r\u0001\u0010\u0005\u0006\r\u0002!\tA\u0014\u000b\u0002\u0011\"\u001aQ\n\u0015,\u0011\u0005E#V\"\u0001*\u000b\u0005M3\u0011AC1o]>$\u0018\r^5p]&\u0011QK\u0015\u0002\u0006'&t7-Z\u0011\u0002/\u0006)\u0011GL\u001b/a!)\u0011\f\u0001C\u0001?\u0005iq-\u001a;NS:\u001cV\u000f\u001d9peRD3\u0001\u0017)W\u0011\u0015a\u0006\u0001\"\u0001^\u00035\u0019X\r^'j]N+\b\u000f]8siR\u0011alX\u0007\u0002\u0001!)ad\u0017a\u0001A!\u001a1\f\u0015,\t\u000b\t\u0004A\u0011A\u0018\u0002'\u001d,G/T1y!\u0006$H/\u001a:o\u0019\u0016tw\r\u001e5)\u0007\u0005\u0004f\u000bC\u0003f\u0001\u0011\u0005a-A\ntKRl\u0015\r\u001f)biR,'O\u001c'f]\u001e$\b\u000e\u0006\u0002_O\")a\u0006\u001aa\u0001a!\u001aA\r\u0015,\t\u000b)\u0004A\u0011A\u001e\u0002+\u001d,G/T1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{K\"\u001a\u0011\u000e\u0015,\t\u000b5\u0004A\u0011\u00018\u0002+M,G/T1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{KR\u0011al\u001c\u0005\u0006u1\u0004\r\u0001\u0010\u0015\u0004YB3\u0006\"\u0002:\u0001\t\u0003\u0019\u0018a\u0001:v]V\u0011Ao\u001f\u000b\u0004k\u0006eAc\u0001<\u0002\nA\u0019\u0011j^=\n\u0005a\u0014!a\u0004)sK\u001aL\u0007p\u00159b]6{G-\u001a7\u0011\u0005i\\H\u0002\u0001\u0003\u0006yF\u0014\r! \u0002\u0005\u0013R,W.E\u0002\u007f\u0003\u0007\u0001\"aD@\n\u0007\u0005\u0005\u0001CA\u0004O_RD\u0017N\\4\u0011\u0007=\t)!C\u0002\u0002\bA\u00111!\u00118z\u0011%\tY!]A\u0001\u0002\b\ti!\u0001\u0006fm&$WM\\2fIE\u0002R!a\u0004\u0002\u0016el!!!\u0005\u000b\u0007\u0005M\u0001#A\u0004sK\u001adWm\u0019;\n\t\u0005]\u0011\u0011\u0003\u0002\t\u00072\f7o\u001d+bO\"9\u00111D9A\u0002\u0005u\u0011\u0001\u00023bi\u0006\u0004b!a\b\u0002&\u0005%RBAA\u0011\u0015\r\t\u0019CB\u0001\u0004e\u0012$\u0017\u0002BA\u0014\u0003C\u00111A\u0015#E!\u0015y\u00111FA\u0018\u0013\r\ti\u0003\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u001f\u0005-\u0012\u0010K\u0002r!ZCaA\u001d\u0001\u0005\u0002\u0005UR\u0003CA\u001c\u0003{\tI'a\u0015\u0015\t\u0005e\u0012q\b\t\u0005\u0013^\fY\u0004E\u0002{\u0003{!a\u0001`A\u001a\u0005\u0004i\b\u0002CA\u000e\u0003g\u0001\r!!\u0011\u0011\r\u0005\r\u0013QJA)\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00026bm\u0006T1!a\u0013\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003\u001f\n)EA\u0004KCZ\f'\u000b\u0012#\u0011\u0007i\f\u0019\u0006\u0002\u0005\u0002V\u0005M\"\u0019AA,\u0005!\u0019V-];f]\u000e,\u0017c\u0001@\u0002ZA1\u00111LA2\u0003Oj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0005Y\u0006twM\u0003\u0002\u0002H%!\u0011QMA/\u0005!IE/\u001a:bE2,\u0007c\u0001>\u0002j\u0011A\u00111NA\u001a\u0005\u0004\tiGA\u0004Ji\u0016l7/\u001a;\u0012\u0007y\fy\u0007\u0005\u0004\u0002\\\u0005\r\u00141\b\u0015\u0005\u0003g\u0001f\u000bK\u0002\u0001!Z;q!a\u001e\u0003\u0011\u0003\tI(\u0001\u0006Qe\u00164\u0017\u000e_*qC:\u00042!SA>\r\u0019\t!\u0001#\u0001\u0002~M)\u00111\u0010\b\u00155!9a)a\u001f\u0005\u0002\u0005\u0005ECAA=\u0011%\t))a\u001f\u0005\u0002\t\t9)A\tgS:$gI]3rk\u0016tG/\u0013;f[N,B!!#\u0002\u0012R1\u00111RAM\u0003?#B!!$\u0002\u0014B)q\"a\u000b\u0002\u0010B\u0019!0!%\u0005\rq\f\u0019I1\u0001~\u0011)\t)*a!\u0002\u0002\u0003\u000f\u0011qS\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004CBA\b\u0003+\ty\t\u0003\u0005\u0002\u001c\u0005\r\u0005\u0019AAN!\u0019\ty\"!\n\u0002\u001eB)q\"a\u000b\u0002\u000e\"9\u0011\u0011UAB\u0001\u0004a\u0014\u0001C7j]\u000e{WO\u001c;\t\u0013\u0005\u0015\u00161\u0010C\u0001\u0005\u0005\u001d\u0016A\u0006;p\t\u0006$\u0018MY1tK&sG/\u001a:oC2\u0014V\r\u001d:\u0016\t\u0005%\u0016\u0011\u0018\u000b\u0007\u0003W\u000bY,a1\u0015\t\u00055\u0016\u0011\u0017\t\u0007\u0003?\t)#a,\u0011\t=\tY\u0003\r\u0005\u000b\u0003g\u000b\u0019+!AA\u0004\u0005U\u0016AC3wS\u0012,gnY3%gA1\u0011qBA\u000b\u0003o\u00032A_A]\t\u0019a\u00181\u0015b\u0001{\"A\u00111DAR\u0001\u0004\ti\f\u0005\u0004\u0002 \u0005\u0015\u0012q\u0018\t\u0006\u001f\u0005-\u0012\u0011\u0019\t\u0006\u001f\u0005-\u0012q\u0017\u0005\t\u0003\u000b\f\u0019\u000b1\u0001\u0002H\u0006I\u0011\u000e^3n)>Le\u000e\u001e\t\b\u0003\u0013\f9.a.1\u001d\u0011\tY-a5\u0011\u0007\u00055\u0007#\u0004\u0002\u0002P*\u0019\u0011\u0011\u001b\u0007\u0002\rq\u0012xn\u001c;?\u0013\r\t)\u000eE\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00171\u001c\u0002\u0004\u001b\u0006\u0004(bAAk!!I\u0011q\\A>\t\u0003\u0011\u0011\u0011]\u0001\u0010O\u0016tgI]3r!\u0006$H/\u001a:ogRQ\u00111]Av\u0003[\fy/!=\u0011\r\u0005}\u0011QEAs!\u0019y\u0011q]AXy%\u0019\u0011\u0011\u001e\t\u0003\rQ+\b\u000f\\33\u0011!\tY\"!8A\u0002\u00055\u0006bBAQ\u0003;\u0004\r\u0001\u0010\u0005\u0007]\u0005u\u0007\u0019\u0001\u0019\t\ri\ni\u000e1\u0001=\r!\t)0a\u001f\u0001\u0005\u0005](A\u0002)sK\u001aL\u0007p\u0005\u0003\u0002t:Q\u0002bCA~\u0003g\u0014)\u0019!C\u0001\u0003{\fQ!\u001b;f[N,\"!a,\t\u0017\t\u0005\u00111\u001fB\u0001B\u0003%\u0011qV\u0001\u0007SR,Wn\u001d\u0011\t\u0015\t\u0015\u00111\u001fBC\u0002\u0013\u0005q&\u0001\u0004mK:<G\u000f\u001b\u0005\u000b\u0005\u0013\t\u0019P!A!\u0002\u0013\u0001\u0014a\u00027f]\u001e$\b\u000e\t\u0005\b\r\u0006MH\u0011\u0002B\u0007)\u0019\u0011yAa\u0005\u0003\u0016A!!\u0011CAz\u001b\t\tY\b\u0003\u0005\u0002|\n-\u0001\u0019AAX\u0011\u001d\u0011)Aa\u0003A\u0002AB\u0011B!\u0007\u0002t\n\u0007I\u0011A\u0018\u0002\u0005%$\u0007\u0002\u0003B\u000f\u0003g\u0004\u000b\u0011\u0002\u0019\u0002\u0007%$\u0007\u0005\u0003\u0005\u0003\"\u0005MH\u0011\u0001B\u0012\u0003-!3m\u001c7p]\u0012\u0002H.^:\u0015\t\t=!Q\u0005\u0005\b\u0005O\u0011y\u00021\u00011\u0003\u0011IG/Z7\b\u0013\t-\u00121\u0010E\u0001\u0005\t5\u0012A\u0002)sK\u001aL\u0007\u0010\u0005\u0003\u0003\u0012\t=b!CA{\u0003wB\tA\u0001B\u0019'\u0011\u0011yC\u0004\u000e\t\u000f\u0019\u0013y\u0003\"\u0001\u00036Q\u0011!Q\u0006\u0005\u000b\u0005s\u0011yC1A\u0005\n\tm\u0012aB2pk:$XM]\u000b\u0003\u0005{\u0001BAa\u0010\u0003N5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0005\u000f\u0012I%\u0001\u0006d_:\u001cWO\u001d:f]RTAAa\u0013\u0002b\u0005!Q\u000f^5m\u0013\u0011\u0011yE!\u0011\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011%\u0011\u0019Fa\f!\u0002\u0013\u0011i$\u0001\u0005d_VtG/\u001a:!\u0011\u001d\u00119Fa\f\u0005\n=\naA\\3yi&#\u0007B\u0003B.\u0005_\u0011\r\u0011\"\u0001\u0003^\u0005)Q-\u001c9usV\u0011!q\u0002\u0005\n\u0005C\u0012y\u0003)A\u0005\u0005\u001f\ta!Z7qif\u0004\u0003B\u0003B3\u0005_\t\t\u0011\"\u0003\u0003h\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011I\u0007\u0005\u0003\u0002\\\t-\u0014\u0002\u0002B7\u0003;\u0012aa\u00142kK\u000e$h\u0001\u0003B9\u0003w\u0002!Aa\u001d\u0003\u000fA{7\u000f\u001e4jqN!!q\u000e\b\u001b\u0011-\tYPa\u001c\u0003\u0006\u0004%\t!!@\t\u0017\t\u0005!q\u000eB\u0001B\u0003%\u0011q\u0016\u0005\u000b\u0005w\u0012yG!b\u0001\n\u0003y\u0013!B:uCJ$\bB\u0003B@\u0005_\u0012\t\u0011)A\u0005a\u000511\u000f^1si\u0002B1Ba!\u0003p\t\u0015\r\u0011\"\u0001\u0002~\u0006i\u0001/\u0019:uS\u0006d7\u000b^1siND1Ba\"\u0003p\t\u0005\t\u0015!\u0003\u00020\u0006q\u0001/\u0019:uS\u0006d7\u000b^1siN\u0004\u0003b\u0002$\u0003p\u0011\u0005!1\u0012\u000b\t\u0005\u001b\u0013yI!%\u0003\u0014B!!\u0011\u0003B8\u0011!\tYP!#A\u0002\u0005=\u0006\"\u0003B>\u0005\u0013\u0003\n\u00111\u00011\u0011)\u0011\u0019I!#\u0011\u0002\u0003\u0007\u0011q\u0016\u0005\t\u0005/\u0013y\u0007)C\u0005_\u0005Ia-\u001e7m'R\f'\u000f\u001e\u0005\t\u00057\u0013y\u0007\"\u0001\u0003\u001e\u0006qq-\u001a8Qe\u00164\u0017\u000e_%uK6\u001cXC\u0001BP!\u0019\u0011\tKa+\u00032:!!1\u0015BT\u001d\u0011\tiM!*\n\u0003EI1A!+\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LAA!,\u00030\nA\u0011\n^3sCR|'OC\u0002\u0003*B\u0001RaDAtaqB\u0001B!.\u0003p\u0011\u0005!qW\u0001\t]>tW)\u001c9usV\u0011!\u0011\u0018\t\u0004\u001f\tm\u0016b\u0001B_!\t9!i\\8mK\u0006t\u0007\u0002\u0003Ba\u0005_\"\tAa1\u0002\u000fA\u0014xN[3diR!!Q\u0012Bc\u0011\u001d\u00119Ma0A\u0002A\na\u0001\u001d:fM&D\b\u0002\u0003Ba\u0005_\"IAa3\u0015\t\t5%Q\u001a\u0005\t\u0005\u000f\u0014I\r1\u0001\u00020\"A!\u0011\u0019B8\t\u0003\u0011\t\u000e\u0006\u0003\u0003\u000e\nM\u0007\u0002\u0003Bd\u0005\u001f\u0004\rAa\u0004\t\u0011\t]'q\u000eC\u0001\u00053\f!bY8naJ,7o]3e+\t\u0011iiB\u0006\u0003^\u0006m\u0014\u0011!E\u0001\u0005\t}\u0017a\u0002)pgR4\u0017\u000e\u001f\t\u0005\u0005#\u0011\tOB\u0006\u0003r\u0005m\u0014\u0011!E\u0001\u0005\t\r8\u0003\u0002Bq\u001diAqA\u0012Bq\t\u0003\u00119\u000f\u0006\u0002\u0003`\"Q!1\u001eBq#\u0003%\tA!<\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yOK\u00021\u0005c\\#Aa=\u0011\t\tU(Q`\u0007\u0003\u0005oTAA!?\u0003|\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003'BIAAa@\u0003x\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\r\r!\u0011]I\u0001\n\u0003\u0019)!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0007\u000fQC!a,\u0003r\"Q!Q\rBq\u0003\u0003%IAa\u001a\u0007\u000f\r5\u00111\u0010\u0001\u0004\u0010\taaI]3r'\u0016\fX/\u001a8dKV!1\u0011CB\u0010'\u0011\u0019YA\u0004\u000e\t\u0017\rU11\u0002BC\u0002\u0013\u00051qC\u0001\tg\u0016\fX/\u001a8dKV\u00111\u0011\u0004\t\u0006\u001f\u0005-21\u0004\t\u0006\u001f\u0005-2Q\u0004\t\u0004u\u000e}AA\u0002?\u0004\f\t\u0007Q\u0010\u000b\u0003\u0004\u0014A3\u0006bCB\u0013\u0007\u0017\u0011\t\u0011)A\u0005\u00073\t\u0011b]3rk\u0016t7-\u001a\u0011)\t\r\r\u0002K\u0016\u0005\u000b\u0007W\u0019YA!b\u0001\n\u0003Y\u0014\u0001\u00024sKFDCa!\u000bQ-\"Q1\u0011GB\u0006\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u000b\u0019\u0014X-\u001d\u0011)\t\r=\u0002K\u0016\u0005\b\r\u000e-A\u0011AB\u001c)\u0019\u0019Ida\u000f\u0004@A1!\u0011CB\u0006\u0007;A\u0001b!\u0006\u00046\u0001\u00071\u0011\u0004\u0015\u0005\u0007w\u0001f\u000bC\u0004\u0004,\rU\u0002\u0019\u0001\u001f)\t\r}\u0002K\u0016\u0015\u0005\u0007k\u0001f\u000b\u0003\u0005\u0004H\r-A\u0011AB%\u00031Q\u0017M^1TKF,XM\\2f+\t\u0019Y\u0005\u0005\u0004\u0004N\r=31K\u0007\u0003\u0005\u0013JAa!\u0015\u0003J\t!A*[:u!\u0019\u0019iea\u0014\u0004\u001e!\"1Q\t)WQ\u0011\u0019Y\u0001\u0015,\t\u0015\t\u0015\u00141PA\u0001\n\u0013\u00119\u0007\u000b\u0003\u0002|A3\u0006\u0006BA;!Z\u0003")
public class PrefixSpan
implements Logging,
scala.Serializable {
    private double minSupport;
    private int maxPatternLength;
    private long maxLocalProjDBSize;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private double minSupport() {
        return this.minSupport;
    }

    private void minSupport_$eq(double x$1) {
        this.minSupport = x$1;
    }

    private int maxPatternLength() {
        return this.maxPatternLength;
    }

    private void maxPatternLength_$eq(int x$1) {
        this.maxPatternLength = x$1;
    }

    private long maxLocalProjDBSize() {
        return this.maxLocalProjDBSize;
    }

    private void maxLocalProjDBSize_$eq(long x$1) {
        this.maxLocalProjDBSize = x$1;
    }

    public double getMinSupport() {
        return this.minSupport();
    }

    public PrefixSpan setMinSupport(double minSupport) {
        Predef$.MODULE$.require(minSupport >= 0.0 && minSupport <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("The minimum support value must be in [0, 1], but got ").append(minSupport).append(".").toString());
        this.minSupport_$eq(minSupport);
        return this;
    }

    public int getMaxPatternLength() {
        return this.maxPatternLength();
    }

    public PrefixSpan setMaxPatternLength(int maxPatternLength) {
        Predef$.MODULE$.require(maxPatternLength >= 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("The maximum pattern length value must be greater than 0, but got ").append(maxPatternLength).append(".").toString());
        this.maxPatternLength_$eq(maxPatternLength);
        return this;
    }

    public long getMaxLocalProjDBSize() {
        return this.maxLocalProjDBSize();
    }

    public PrefixSpan setMaxLocalProjDBSize(long maxLocalProjDBSize) {
        Predef$.MODULE$.require(maxLocalProjDBSize >= 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("The maximum local projected database size must be nonnegative, but got ").append(maxLocalProjDBSize).toString());
        this.maxLocalProjDBSize_$eq(maxLocalProjDBSize);
        return this;
    }

    public <Item> PrefixSpanModel<Item> run(RDD<Object[]> data, ClassTag<Item> evidence$1) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Input data is not cached.");
        }
        long totalCount = data.count();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("number of sequences: ").append(totalCount).toString());
        long minCount = (long)package$.MODULE$.ceil(this.minSupport() * (double)totalCount);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("minimum count for a frequent pattern: ").append(minCount).toString());
        Object freqItems = PrefixSpan$.MODULE$.findFrequentItems(data, minCount, evidence$1);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("number of frequent items: ").append(ScalaRunTime$.MODULE$.array_length(freqItems)).toString());
        Map itemToInt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(freqItems).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        RDD dataInternalRepr = PrefixSpan$.MODULE$.toDatabaseInternalRepr(data, itemToInt, evidence$1).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD<Tuple2<int[], Object>> results = PrefixSpan$.MODULE$.genFreqPatterns((RDD<int[]>)dataInternalRepr, minCount, this.maxPatternLength(), this.maxLocalProjDBSize());
        RDD freqSequences = results.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            long count;
            int[] seq;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    seq = (int[])tuple2._1();
                    count = tuple2._2$mcJ$sp();
                    if (seq != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            int[] nArray = seq;
            long l = count;
            FreqSequence freqSequence = new FreqSequence(PrefixSpan.toPublicRepr$1(nArray, evidence$1, freqItems), l);
            return freqSequence;
        }, ClassTag$.MODULE$.apply(FreqSequence.class));
        return new PrefixSpanModel(freqSequences);
    }

    public <Item, Itemset extends Iterable<Item>, Sequence extends Iterable<Itemset>> PrefixSpanModel<Item> run(JavaRDD<Sequence> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return this.run((RDD<Object[]>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$1 -> (Object[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$2).asScala()).toArray(tag), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass()))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass())))), tag);
    }

    private static final Object[] toPublicRepr$1(int[] pattern, ClassTag evidence$1$1, Object freqItems$1) {
        ArrayBuilder sequenceBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1$1.runtimeClass())));
        ArrayBuilder itemsetBuilder = ArrayBuilder$.MODULE$.make(evidence$1$1);
        int n = pattern.length;
        for (int i = 1; i < n; ++i) {
            BoxedUnit boxedUnit;
            int x = pattern[i];
            if (x == 0) {
                sequenceBuilder.$plus$eq(itemsetBuilder.result());
                itemsetBuilder.clear();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = itemsetBuilder.$plus$eq(ScalaRunTime$.MODULE$.array_apply(freqItems$1, x - 1));
        }
        return (Object[])sequenceBuilder.result();
    }

    private PrefixSpan(double minSupport, int maxPatternLength, long maxLocalProjDBSize) {
        this.minSupport = minSupport;
        this.maxPatternLength = maxPatternLength;
        this.maxLocalProjDBSize = maxLocalProjDBSize;
        Logging.$init$((Logging)this);
    }

    public PrefixSpan() {
        this(0.1, 10, 32000000L);
    }

    public static class FreqSequence<Item>
    implements scala.Serializable {
        private final Object[] sequence;
        private final long freq;

        public Object[] sequence() {
            return this.sequence;
        }

        public long freq() {
            return this.freq;
        }

        public List<List<Item>> javaSequence() {
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(this.sequence())).map((Function1 & Serializable & scala.Serializable)x$10 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps(x$10).toList()).asJava(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class))))).toList()).asJava();
        }

        public FreqSequence(Object[] sequence, long freq) {
            this.sequence = sequence;
            this.freq = freq;
        }
    }

    public static class Postfix
    implements scala.Serializable {
        private final int[] items;
        private final int start;
        private final int[] partialStarts;

        public int[] items() {
            return this.items;
        }

        public int start() {
            return this.start;
        }

        public int[] partialStarts() {
            return this.partialStarts;
        }

        /*
         * WARNING - void declaration
         */
        private int fullStart() {
            void var1_1;
            int i = this.start();
            while (this.items()[i] != 0) {
                ++i;
            }
            return (int)var1_1;
        }

        public Iterator<Tuple2<Object, Object>> genPrefixItems() {
            int n1 = this.items().length - 1;
            scala.collection.mutable.Map prefixes = Map$.MODULE$.empty();
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.partialStarts())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)start -> {
                int i = start;
                int x = -this.items()[i];
                while (x != 0) {
                    if (!prefixes.contains((Object)BoxesRunTime.boxToInteger((int)x))) {
                        prefixes.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(n1 - i)));
                    }
                    x = -this.items()[++i];
                }
            });
            for (int i = this.fullStart(); i < n1; ++i) {
                int x = this.items()[i];
                if (x == 0 || prefixes.contains((Object)BoxesRunTime.boxToInteger((int)x))) continue;
                prefixes.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(n1 - i)));
            }
            return prefixes.toIterator();
        }

        public boolean nonEmpty() {
            return this.items().length > this.start() + 1;
        }

        public Postfix project(int prefix) {
            Predef$.MODULE$.require(prefix != 0);
            int n1 = this.items().length - 1;
            BooleanRef matched = BooleanRef.create((boolean)false);
            IntRef newStart = IntRef.create((int)n1);
            ArrayBuilder newPartialStarts = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
            if (prefix < 0) {
                int target = -prefix;
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.partialStarts())).foreach((Function1 & Serializable & scala.Serializable)start -> Postfix.$anonfun$project$1(this, matched, newStart, newPartialStarts, target, BoxesRunTime.unboxToInt((Object)start)));
            } else {
                int target = prefix;
                for (int i = this.fullStart(); i < n1; ++i) {
                    BoxedUnit boxedUnit;
                    int x = this.items()[i];
                    if (x == target) {
                        if (!matched.elem) {
                            newStart.elem = i;
                            matched.elem = true;
                        }
                        if (this.items()[i + 1] != 0) {
                            boxedUnit = newPartialStarts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
                            continue;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return new Postfix(this.items(), newStart.elem, (int[])newPartialStarts.result());
        }

        /*
         * WARNING - void declaration
         */
        private Postfix project(int[] prefix) {
            void var3_3;
            boolean partial = true;
            Postfix cur = this;
            int np = prefix.length;
            for (int i = 0; i < np && cur.nonEmpty(); ++i) {
                int x = prefix[i];
                if (x == 0) {
                    partial = false;
                    continue;
                }
                if (partial) {
                    cur = cur.project(-x);
                    continue;
                }
                cur = cur.project(x);
                partial = true;
            }
            return var3_3;
        }

        public Postfix project(Prefix prefix) {
            return this.project(prefix.items());
        }

        public Postfix compressed() {
            return this.start() > 0 ? new Postfix((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.items())).slice(this.start(), this.items().length), 0, (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.partialStarts())).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$9 -> x$9 - this.start(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))) : this;
        }

        public static final /* synthetic */ Object $anonfun$project$1(Postfix $this, BooleanRef matched$1, IntRef newStart$1, ArrayBuilder newPartialStarts$1, int target$1, int start) {
            Object object;
            int i = start;
            int x = $this.items()[i];
            while (x != target$1 && x != 0) {
                x = $this.items()[++i];
            }
            if (x == target$1) {
                ++i;
                if (!matched$1.elem) {
                    newStart$1.elem = i;
                    matched$1.elem = true;
                }
                object = $this.items()[i] != 0 ? newPartialStarts$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        }

        public Postfix(int[] items, int start, int[] partialStarts) {
            block0: {
                this.items = items;
                this.start = start;
                this.partialStarts = partialStarts;
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(items)).last()) == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("The last item in a postfix must be zero, but got ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.items())).last()).append(".").toString());
                if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partialStarts)).nonEmpty()) break block0;
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partialStarts)).head()) >= start, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("The first partial start cannot be smaller than the start index,").append(new StringBuilder(41).append("but got partialStarts.head = ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.partialStarts())).head()).append(" < start = ").append(this.start()).append(".").toString()).toString());
            }
        }
    }

    public static class Prefix
    implements scala.Serializable {
        private final int[] items;
        private final int length;
        private final int id;

        public int[] items() {
            return this.items;
        }

        public int length() {
            return this.length;
        }

        public int id() {
            return this.id;
        }

        public Prefix $colon$plus(int item) {
            Predef$.MODULE$.require(item != 0);
            return item < 0 ? new Prefix((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.items())).$colon$plus((Object)BoxesRunTime.boxToInteger((int)(-item)), ClassTag$.MODULE$.Int()), this.length() + 1) : new Prefix((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.items())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, item})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), this.length() + 1);
        }

        public Prefix(int[] items, int length) {
            this.items = items;
            this.length = length;
            this.id = PrefixSpan$Prefix$.MODULE$.org$apache$spark$mllib$fpm$PrefixSpan$Prefix$$nextId();
        }
    }
}

