/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import java.io.Serializable;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054Q!\u0001\u0002\u0001\r1\u0011\u0011\"T1ue&DX\u000b\u0012+\u000b\u0005\r!\u0011A\u00027j]\u0006dwM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0002\u0001\u001bA\u0019abE\u000b\u000e\u0003=Q!\u0001E\t\u0002\u000bQL\b/Z:\u000b\u0005I1\u0011aA:rY&\u0011Ac\u0004\u0002\u0010+N,'\u000fR3gS:,G\rV=qKB\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0007\u001b\u0006$(/\u001b=\t\u000bi\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\b\t\u0003-\u0001AQa\b\u0001\u0005B\u0001\nqa]9m)f\u0004X-F\u0001\"!\tq!%\u0003\u0002$\u001f\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\u0015\u0002A\u0011\t\u0014\u0002\u0013M,'/[1mSj,GCA\u0014.!\tA3&D\u0001*\u0015\tQ\u0013#\u0001\u0005dCR\fG._:u\u0013\ta\u0013FA\u0006J]R,'O\\1m%><\b\"\u0002\u0018%\u0001\u0004)\u0012aA8cU\")\u0001\u0007\u0001C!c\u0005YA-Z:fe&\fG.\u001b>f)\t)\"\u0007C\u00034_\u0001\u0007A'A\u0003eCR,X\u000e\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0002B]fDQa\u000f\u0001\u0005Bq\n\u0011\"^:fe\u000ec\u0017m]:\u0016\u0003u\u00022AP#\u0016\u001d\ty4\t\u0005\u0002Am5\t\u0011I\u0003\u0002C7\u00051AH]8pizJ!\u0001\u0012\u001c\u0002\rA\u0013X\rZ3g\u0013\t1uIA\u0003DY\u0006\u001c8O\u0003\u0002Em!)\u0011\n\u0001C!\u0015\u00061Q-];bYN$\"a\u0013(\u0011\u0005Ub\u0015BA'7\u0005\u001d\u0011un\u001c7fC:DQa\u0014%A\u0002Q\n\u0011a\u001c\u0005\u0006#\u0002!\tEU\u0001\tQ\u0006\u001c\bnQ8eKR\t1\u000b\u0005\u00026)&\u0011QK\u000e\u0002\u0004\u0013:$\b\"B,\u0001\t\u0003B\u0016\u0001\u0003;za\u0016t\u0015-\\3\u0016\u0003e\u0003\"A\u0010.\n\u0005m;%AB*ue&tw\rC\u0003^\u0001\u0011\u0005\u0003,A\u0003qsV#E\u000b\u0003\u0004`\u0001\u0011\u0005c\u0001Y\u0001\u000bCNtU\u000f\u001c7bE2,W#A\u000f")
public class MatrixUDT
extends UserDefinedType<Matrix> {
    public StructType sqlType() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("type", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("numRows", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("numCols", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("colPtrs", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("rowIndices", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("values", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("isTransposed", (DataType)BooleanType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
    }

    /*
     * WARNING - void declaration
     */
    public InternalRow serialize(Matrix obj) {
        void var3_2;
        GenericInternalRow row = new GenericInternalRow(7);
        Matrix matrix = obj;
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            row.setByte(0, (byte)0);
            row.setInt(1, sparseMatrix.numRows());
            row.setInt(2, sparseMatrix.numCols());
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((int[])sparseMatrix.colPtrs()));
            row.update(4, (Object)UnsafeArrayData.fromPrimitiveArray((int[])sparseMatrix.rowIndices()));
            row.update(5, (Object)UnsafeArrayData.fromPrimitiveArray((double[])sparseMatrix.values()));
            row.setBoolean(6, sparseMatrix.isTransposed());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (matrix instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix;
            row.setByte(0, (byte)1);
            row.setInt(1, denseMatrix.numRows());
            row.setInt(2, denseMatrix.numCols());
            row.setNullAt(3);
            row.setNullAt(4);
            row.update(5, (Object)UnsafeArrayData.fromPrimitiveArray((double[])denseMatrix.values()));
            row.setBoolean(6, denseMatrix.isTransposed());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)matrix);
        }
        return var3_2;
    }

    public Matrix deserialize(Object datum) {
        Matrix matrix;
        Object object = datum;
        if (object instanceof InternalRow) {
            InternalRow internalRow = (InternalRow)object;
            Predef$.MODULE$.require(internalRow.numFields() == 7, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("MatrixUDT.deserialize given row with length ").append(internalRow.numFields()).append(" but requires length == 7").toString());
            byte tpe = internalRow.getByte(0);
            int numRows = internalRow.getInt(1);
            int numCols = internalRow.getInt(2);
            double[] values = internalRow.getArray(5).toDoubleArray();
            boolean isTransposed = internalRow.getBoolean(6);
            byte by = tpe;
            switch (by) {
                case 0: {
                    int[] colPtrs = internalRow.getArray(3).toIntArray();
                    int[] rowIndices = internalRow.getArray(4).toIntArray();
                    matrix = new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values, isTransposed);
                    break;
                }
                case 1: {
                    matrix = new DenseMatrix(numRows, numCols, values, isTransposed);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
            }
        } else {
            throw new MatchError(object);
        }
        DenseMatrix denseMatrix = matrix;
        return denseMatrix;
    }

    public Class<Matrix> userClass() {
        return Matrix.class;
    }

    public boolean equals(Object o) {
        Object object = o;
        boolean bl = object instanceof MatrixUDT;
        return bl;
    }

    public int hashCode() {
        return MatrixUDT.class.getName().hashCode();
    }

    public String typeName() {
        return "matrix";
    }

    public String pyUDT() {
        return "pyspark.mllib.linalg.MatrixUDT";
    }

    public MatrixUDT asNullable() {
        return this;
    }
}

