/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SparseMatrix$
implements scala.Serializable {
    public static SparseMatrix$ MODULE$;

    static {
        new SparseMatrix$();
    }

    public SparseMatrix fromCOO(int numRows, int numCols, Iterable<Tuple3<Object, Object, Object>> entries) {
        Seq sortedEntries = (Seq)entries.toSeq().sortBy((Function1 & Serializable & scala.Serializable)v -> new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)v._2()), BoxesRunTime.unboxToInt((Object)v._1())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        int numEntries = sortedEntries.size();
        if (sortedEntries.nonEmpty()) {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)((Tuple3)sortedEntries.head())._2()), BoxesRunTime.unboxToInt((Object)((Tuple3)sortedEntries.last())._2())}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)col -> Predef$.MODULE$.require(col >= 0 && col < numCols, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Column index out of range [0, ").append(numCols).append("): ").append(col).append(".").toString()));
        }
        int[] colPtrs = new int[numCols + 1];
        ArrayBuilder rowIndices = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        rowIndices.sizeHint(numEntries);
        ArrayBuilder values = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        values.sizeHint(numEntries);
        IntRef nnz = IntRef.create((int)0);
        IntRef prevCol = IntRef.create((int)0);
        IntRef prevRow = IntRef.create((int)-1);
        DoubleRef prevVal = DoubleRef.create((double)0.0);
        ((IterableLike)sortedEntries.view().$colon$plus((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)numRows), (Object)BoxesRunTime.boxToInteger((int)numCols), (Object)BoxesRunTime.boxToDouble((double)1.0)), SeqView$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparseMatrix$.$anonfun$fromCOO$4(numRows, colPtrs, rowIndices, values, nnz, prevCol, prevRow, prevVal, x0$1);
            return BoxedUnit.UNIT;
        });
        return new SparseMatrix(numRows, numCols, colPtrs, (int[])rowIndices.result(), (double[])values.result());
    }

    public SparseMatrix speye(int n) {
        return new SparseMatrix(n, n, (int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), n).toArray(ClassTag$.MODULE$.Int()), (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).toArray(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
    }

    private SparseMatrix genRandMatrix(int numRows, int numCols, double density, Random rng) {
        SparseMatrix sparseMatrix;
        Predef$.MODULE$.require(numRows > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("numRows must be greater than 0 but got ").append(numRows).toString());
        Predef$.MODULE$.require(numCols > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("numCols must be greater than 0 but got ").append(numCols).toString());
        Predef$.MODULE$.require(density >= 0.0 && density <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("density must be a double in the range 0.0 <= d <= 1.0. Currently, density: ").append(density).toString());
        long size = (long)numRows * (long)numCols;
        double expected = (double)size * density;
        Predef$.MODULE$.assert(expected < (double)Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> "The expected number of nonzeros cannot be greater than Int.MaxValue.");
        int nnz = (int)package$.MODULE$.ceil(expected);
        if (density == 0.0) {
            sparseMatrix = new SparseMatrix(numRows, numCols, new int[numCols + 1], (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
        } else if (density == 1.0) {
            int[] colPtrs = (int[])Array$.MODULE$.tabulate(numCols + 1, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)j -> j * numRows, ClassTag$.MODULE$.Int());
            int[] rowIndices = (int[])Array$.MODULE$.tabulate((int)size, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)idx -> idx % numRows, ClassTag$.MODULE$.Int());
            sparseMatrix = new SparseMatrix(numRows, numCols, colPtrs, rowIndices, new double[numRows * numCols]);
        } else if (density < 0.34) {
            HashSet entries = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (entries.size() < nnz) {
                entries.$plus$eq((Object)new Tuple2.mcII.sp(rng.nextInt(numRows), rng.nextInt(numCols)));
            }
            sparseMatrix = this.fromCOO(numRows, numCols, (Iterable<Tuple3<Object, Object, Object>>)((Iterable)entries.map((Function1 & Serializable & scala.Serializable)v -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)1.0)), HashSet$.MODULE$.canBuildFrom())));
        } else {
            long idx2 = 0L;
            int numSelected = 0;
            int[] colPtrs = new int[numCols + 1];
            int[] rowIndices = new int[nnz];
            for (int j2 = 0; j2 < numCols && numSelected < nnz; ++j2) {
                int i = 0;
                while (i < numRows && numSelected < nnz) {
                    if (rng.nextDouble() < 1.0 * (double)(nnz - numSelected) / (double)(size - idx2)) {
                        rowIndices[numSelected] = i;
                        ++numSelected;
                    }
                    ++i;
                    ++idx2;
                }
                colPtrs[j2 + 1] = numSelected;
            }
            sparseMatrix = new SparseMatrix(numRows, numCols, colPtrs, rowIndices, new double[nnz]);
        }
        return sparseMatrix;
    }

    public SparseMatrix sprand(int numRows, int numCols, double density, Random rng) {
        SparseMatrix mat = this.genRandMatrix(numRows, numCols, density, rng);
        return mat.update((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)i -> rng.nextDouble());
    }

    public SparseMatrix sprandn(int numRows, int numCols, double density, Random rng) {
        SparseMatrix mat = this.genRandMatrix(numRows, numCols, density, rng);
        return mat.update((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)i -> rng.nextGaussian());
    }

    public SparseMatrix spdiag(Vector vector) {
        SparseMatrix sparseMatrix;
        int n = vector.size();
        Vector vector2 = vector;
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            sparseMatrix = this.fromCOO(n, n, (Iterable<Tuple3<Object, Object, Object>>)((Iterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sparseVector.indices())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(sparseVector.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)v -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)v._2$mcD$sp())), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        } else if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            Tuple2[] entries = (Tuple2[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseVector.values())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Tuple2[] nnzVals = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])entries)).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)SparseMatrix$.$anonfun$spdiag$2(v)));
            sparseMatrix = this.fromCOO(n, n, (Iterable<Tuple3<Object, Object, Object>>)((Iterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nnzVals)).map((Function1 & Serializable & scala.Serializable)v -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)v._1$mcD$sp())), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        } else {
            throw new MatchError((Object)vector2);
        }
        return sparseMatrix;
    }

    public SparseMatrix fromML(org.apache.spark.ml.linalg.SparseMatrix m) {
        return new SparseMatrix(m.numRows(), m.numCols(), m.colPtrs(), m.rowIndices(), m.values(), m.isTransposed());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$fromCOO$4(int numRows$5, int[] colPtrs$1, ArrayBuilder rowIndices$1, ArrayBuilder values$1, IntRef nnz$1, IntRef prevCol$1, IntRef prevRow$1, DoubleRef prevVal$1, Tuple3 x0$1) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            if (v != 0.0) {
                if (i == prevRow$1.elem && j == prevCol$1.elem) {
                    prevVal$1.elem += v;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit2;
                    if (prevVal$1.elem != 0.0) {
                        Predef$.MODULE$.require(prevRow$1.elem >= 0 && prevRow$1.elem < numRows$5, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Row index out of range [0, ").append(numRows$5).append("): ").append(prevRow$1.elem).append(".").toString());
                        ++nnz$1.elem;
                        rowIndices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)prevRow$1.elem));
                        boxedUnit2 = values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)prevVal$1.elem));
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    prevRow$1.elem = i;
                    prevVal$1.elem = v;
                    while (prevCol$1.elem < j) {
                        colPtrs$1[prevCol$1.elem + 1] = nnz$1.elem;
                        ++prevCol$1.elem;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$spdiag$2(Tuple2 v) {
        return v._1$mcD$sp() != 0.0;
    }

    private SparseMatrix$() {
        MODULE$ = this;
    }
}

