/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.CSCMatrix;
import breeze.linalg.CSCMatrix$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@SQLUserDefinedType(udt=MatrixUDT.class)
@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,W*\u0019;sSbT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0007\u001b\u0006$(/\u001b=\t\u0011e\u0001!Q1A\u0005\u0002i\tqA\\;n%><8/F\u0001\u001c!\tyA$\u0003\u0002\u001e!\t\u0019\u0011J\u001c;)\u0007ayR\u0005\u0005\u0002!G5\t\u0011E\u0003\u0002#\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0011\n#!B*j]\u000e,\u0017%\u0001\u0014\u0002\u000bEr#G\f\u0019\t\u0011!\u0002!\u0011!Q\u0001\nm\t\u0001B\\;n%><8\u000f\t\u0015\u0004O})\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u000f9,XnQ8mg\"\u001a!fH\u0013\t\u00119\u0002!\u0011!Q\u0001\nm\t\u0001B\\;n\u0007>d7\u000f\t\u0015\u0004[})\u0003\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u001a\u0002\u000f\r|G\u000e\u0015;sgV\t1\u0007E\u0002\u0010imI!!\u000e\t\u0003\u000b\u0005\u0013(/Y=)\u0007AzR\u0005\u0003\u00059\u0001\t\u0005\t\u0015!\u00034\u0003!\u0019w\u000e\u001c)ueN\u0004\u0003fA\u001c K!A1\b\u0001BC\u0002\u0013\u0005!'\u0001\u0006s_^Le\u000eZ5dKND3AO\u0010&\u0011!q\u0004A!A!\u0002\u0013\u0019\u0014a\u0003:po&sG-[2fg\u0002B3!P\u0010&\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015A\u0002<bYV,7/F\u0001D!\ryA\u0007\u0012\t\u0003\u001f\u0015K!A\u0012\t\u0003\r\u0011{WO\u00197fQ\r\u0001u$\n\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0007\u00069a/\u00197vKN\u0004\u0003f\u0001% K!AA\n\u0001BC\u0002\u0013\u0005S*\u0001\u0007jgR\u0013\u0018M\\:q_N,G-F\u0001O!\tyq*\u0003\u0002Q!\t9!i\\8mK\u0006t\u0007fA& %\u0006\n1+A\u00032]Mr\u0003\u0007\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003O\u00035I7\u000f\u0016:b]N\u0004xn]3eA!\u001aAk\b*\t\u000ba\u0003A\u0011A-\u0002\rqJg.\u001b;?)\u001dQ6,X0bG\u0016\u0004\"!\u0006\u0001\t\u000be9\u0006\u0019A\u000e)\u0007m{R\u0005C\u0003,/\u0002\u00071\u0004K\u0002^?\u0015BQ!M,A\u0002MB3aX\u0010&\u0011\u0015Yt\u000b1\u00014Q\r\tw$\n\u0005\u0006\u0003^\u0003\ra\u0011\u0015\u0004G~)\u0003\"\u0002'X\u0001\u0004q\u0005fA3 %\"\u001aqk\b*\t\u000ba\u0003A\u0011A5\u0015\riS7\u000e\\7o\u0011\u0015I\u0002\u000e1\u0001\u001c\u0011\u0015Y\u0003\u000e1\u0001\u001c\u0011\u0015\t\u0004\u000e1\u00014\u0011\u0015Y\u0004\u000e1\u00014\u0011\u0015\t\u0005\u000e1\u0001DQ\rAw$\n\u0005\u0006c\u0002!\tE]\u0001\u0007KF,\u0018\r\\:\u0015\u00059\u001b\b\"\u0002;q\u0001\u0004)\u0018!A8\u0011\u0005=1\u0018BA<\u0011\u0005\r\te.\u001f\u0005\u0006s\u0002!\tE_\u0001\tQ\u0006\u001c\bnQ8eKR\t1\u0004\u0003\u0004}\u0001\u0011\u0005A!`\u0001\tCN\u0014%/Z3{KV\ta\u0010\u0005\u0003\u0000\u0003\u000f!UBAA\u0001\u0015\r\u0019\u00111\u0001\u0006\u0003\u0003\u000b\taA\u0019:fKj,\u0017bA\f\u0002\u0002!9\u00111\u0002\u0001\u0005B\u00055\u0011!B1qa2LH#\u0002#\u0002\u0010\u0005M\u0001bBA\t\u0003\u0013\u0001\raG\u0001\u0002S\"9\u0011QCA\u0005\u0001\u0004Y\u0012!\u00016)\t\u0005%qD\u0015\u0005\t\u00037\u0001A\u0011\u0001\u0003\u0002\u001e\u0005)\u0011N\u001c3fqR)1$a\b\u0002\"!9\u0011\u0011CA\r\u0001\u0004Y\u0002bBA\u000b\u00033\u0001\ra\u0007\u0005\t\u0003K\u0001A\u0011\u0001\u0003\u0002(\u00051Q\u000f\u001d3bi\u0016$\u0002\"!\u000b\u00020\u0005E\u00121\u0007\t\u0004\u001f\u0005-\u0012bAA\u0017!\t!QK\\5u\u0011\u001d\t\t\"a\tA\u0002mAq!!\u0006\u0002$\u0001\u00071\u0004C\u0004\u00026\u0005\r\u0002\u0019\u0001#\u0002\u0003YDq!!\u000f\u0001\t\u0003\nY$\u0001\u0003d_BLX#\u0001.)\u000b\u0005]r$a\u0010\"\u0005\u0005\u0005\u0013!B\u0019/i9\u0002\u0004\u0002CA#\u0001\u0011\u0005a!a\u0012\u0002\u00075\f\u0007\u000fF\u0002[\u0003\u0013B\u0001\"a\u0013\u0002D\u0001\u0007\u0011QJ\u0001\u0002MB)q\"a\u0014E\t&\u0019\u0011\u0011\u000b\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0002CA\u0013\u0001\u0011\u0005A!!\u0016\u0015\u0007i\u000b9\u0006\u0003\u0005\u0002L\u0005M\u0003\u0019AA'\u0011\u001d\tY\u0006\u0001C!\u0003w\t\u0011\u0002\u001e:b]N\u0004xn]3)\t\u0005esD\u0015\u0005\t\u0003C\u0002A\u0011\t\u0004\u0002d\u0005iam\u001c:fC\u000eD\u0017i\u0019;jm\u0016$B!!\u000b\u0002f!A\u00111JA0\u0001\u0004\t9\u0007\u0005\u0005\u0010\u0003SZ2\u0004RA\u0015\u0013\r\tY\u0007\u0005\u0002\n\rVt7\r^5p]NBq!a\u001c\u0001\t\u0003\t\t(A\u0004u_\u0012+gn]3\u0016\u0005\u0005M\u0004cA\u000b\u0002v%\u0019\u0011q\u000f\u0002\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\u0015\u0005\u0003[z\"\u000b\u0003\u0004\u0002~\u0001!\tEG\u0001\f]Vlgj\u001c8{KJ|7\u000fK\u0003\u0002|}\t\t)\t\u0002\u0002\u0004\u0006)\u0011GL\u001b/a!1\u0011q\u0011\u0001\u0005Bi\t!B\\;n\u0003\u000e$\u0018N^3tQ\u0015\t)iHAA\u0011\u001d\ti\t\u0001C!\u0003\u001f\u000bqaY8m\u0013R,'/\u0006\u0002\u0002\u0012B1\u00111SAR\u0003SsA!!&\u0002 :!\u0011qSAO\u001b\t\tIJC\u0002\u0002\u001c2\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0007\u0005\u0005\u0006#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0016q\u0015\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011\u0011\u0015\t\u0011\u0007U\tY+C\u0002\u0002.\n\u0011aAV3di>\u0014\b&BAF?\u0005E\u0016EAAZ\u0003\u0015\u0011d\u0006\r\u00181\u0011\u001d\t9\f\u0001C!\u0003s\u000bA!Y:N\u0019V\u0011\u00111\u0018\t\u0005\u0003{\u000b)-\u0004\u0002\u0002@*\u00191!!1\u000b\u0007\u0005\rg!\u0001\u0002nY&\u0019\u0011!a0)\u000b\u0005Uv$!-)\u000f\u0001\tY-a7\u0002^B!\u0011QZAl\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017!\u0002;za\u0016\u001c(bAAk\r\u0005\u00191/\u001d7\n\t\u0005e\u0017q\u001a\u0002\u0013'FcUk]3s\t\u00164\u0017N\\3e)f\u0004X-A\u0002vIR\u001c#!a8\u0011\u0007U\t\t/C\u0002\u0002d\n\u0011\u0011\"T1ue&DX\u000b\u0012+)\u0007\u0001yReB\u0004\u0002j\nA\t!a;\u0002\u0019M\u0003\u0018M]:f\u001b\u0006$(/\u001b=\u0011\u0007U\tiO\u0002\u0004\u0002\u0005!\u0005\u0011q^\n\u0006\u0003[t\u0011\u0011\u001f\t\u0004\u001f\u0005M\u0018bAA{!\ta1+\u001a:jC2L'0\u00192mK\"9\u0001,!<\u0005\u0002\u0005eHCAAv\u0011!\ti0!<\u0005\u0002\u0005}\u0018a\u00024s_6\u001cuj\u0014\u000b\b5\n\u0005!1\u0001B\u0003\u0011\u0019I\u00121 a\u00017!11&a?A\u0002mA\u0001Ba\u0002\u0002|\u0002\u0007!\u0011B\u0001\bK:$(/[3t!\u0019\t\u0019Ja\u0003\u0003\u0010%!!QBAT\u0005!IE/\u001a:bE2,\u0007CB\b\u0003\u0012mYB)C\u0002\u0003\u0014A\u0011a\u0001V;qY\u0016\u001c\u0004\u0006BA~?IC\u0001B!\u0007\u0002n\u0012\u0005!1D\u0001\u0006gB,\u00170\u001a\u000b\u00045\nu\u0001b\u0002B\u0010\u0005/\u0001\raG\u0001\u0002]\"\"!qC\u0010S\u0011!\u0011)#!<\u0005\n\t\u001d\u0012!D4f]J\u000bg\u000eZ'biJL\u0007\u0010F\u0005[\u0005S\u0011YC!\f\u00032!1\u0011Da\tA\u0002mAaa\u000bB\u0012\u0001\u0004Y\u0002b\u0002B\u0018\u0005G\u0001\r\u0001R\u0001\bI\u0016t7/\u001b;z\u0011!\u0011\u0019Da\tA\u0002\tU\u0012a\u0001:oOB!!q\u0007B!\u001b\t\u0011ID\u0003\u0003\u0003<\tu\u0012\u0001B;uS2T!Aa\u0010\u0002\t)\fg/Y\u0005\u0005\u0005\u0007\u0012ID\u0001\u0004SC:$w.\u001c\u0005\t\u0005\u000f\ni\u000f\"\u0001\u0003J\u000511\u000f\u001d:b]\u0012$\u0012B\u0017B&\u0005\u001b\u0012yE!\u0015\t\re\u0011)\u00051\u0001\u001c\u0011\u0019Y#Q\ta\u00017!9!q\u0006B#\u0001\u0004!\u0005\u0002\u0003B\u001a\u0005\u000b\u0002\rA!\u000e)\t\t\u0015sD\u0015\u0005\t\u0005/\ni\u000f\"\u0001\u0003Z\u000591\u000f\u001d:b]\u0012tG#\u0003.\u0003\\\tu#q\fB1\u0011\u0019I\"Q\u000ba\u00017!11F!\u0016A\u0002mAqAa\f\u0003V\u0001\u0007A\t\u0003\u0005\u00034\tU\u0003\u0019\u0001B\u001bQ\u0011\u0011)f\b*\t\u0011\t\u001d\u0014Q\u001eC\u0001\u0005S\naa\u001d9eS\u0006<Gc\u0001.\u0003l!A!Q\u000eB3\u0001\u0004\tI+\u0001\u0004wK\u000e$xN\u001d\u0015\u0005\u0005Kz\"\u000b\u0003\u0005\u0003t\u00055H\u0011\u0001B;\u0003\u00191'o\\7N\u0019R\u0019!La\u001e\t\u0011\te$\u0011\u000fa\u0001\u0003w\u000b\u0011!\u001c\u0015\u0006\u0005cz\u0012\u0011\u0017\u0005\u000b\u0005\u007f\ni/!A\u0005\n\t\u0005\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa!\u0011\t\t\u0015%1R\u0007\u0003\u0005\u000fSAA!#\u0003>\u0005!A.\u00198h\u0013\u0011\u0011iIa\"\u0003\r=\u0013'.Z2uQ\u0011\tio\b*)\t\u0005\u001dxD\u0015")
public class SparseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    private final int[] colPtrs;
    private final int[] rowIndices;
    private final double[] values;
    private final boolean isTransposed;

    public static SparseMatrix fromML(org.apache.spark.ml.linalg.SparseMatrix sparseMatrix) {
        return SparseMatrix$.MODULE$.fromML(sparseMatrix);
    }

    public static SparseMatrix spdiag(Vector vector) {
        return SparseMatrix$.MODULE$.spdiag(vector);
    }

    public static SparseMatrix sprandn(int n, int n2, double d, Random random) {
        return SparseMatrix$.MODULE$.sprandn(n, n2, d, random);
    }

    public static SparseMatrix sprand(int n, int n2, double d, Random random) {
        return SparseMatrix$.MODULE$.sprand(n, n2, d, random);
    }

    public static SparseMatrix speye(int n) {
        return SparseMatrix$.MODULE$.speye(n);
    }

    public static SparseMatrix fromCOO(int n, int n2, Iterable<Tuple3<Object, Object, Object>> iterable) {
        return SparseMatrix$.MODULE$.fromCOO(n, n2, iterable);
    }

    @Override
    public double[] toArray() {
        return Matrix.toArray$(this);
    }

    @Override
    public Iterator<Vector> rowIter() {
        return Matrix.rowIter$(this);
    }

    @Override
    public DenseMatrix multiply(DenseMatrix y) {
        return Matrix.multiply$((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(DenseVector y) {
        return Matrix.multiply$((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(Vector y) {
        return Matrix.multiply$((Matrix)this, y);
    }

    @Override
    public String toString() {
        return Matrix.toString$(this);
    }

    @Override
    public String toString(int maxLines, int maxLineWidth) {
        return Matrix.toString$(this, maxLines, maxLineWidth);
    }

    @Override
    public void org$apache$spark$mllib$linalg$Matrix$_setter_$isTransposed_$eq(boolean x$1) {
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public int[] colPtrs() {
        return this.colPtrs;
    }

    public int[] rowIndices() {
        return this.rowIndices;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public boolean isTransposed() {
        return this.isTransposed;
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            breeze.linalg.Matrix<Object> matrix2 = this.asBreeze();
            breeze.linalg.Matrix<Object> matrix3 = matrix.asBreeze();
            bl = !(matrix2 != null ? !matrix2.equals(matrix3) : matrix3 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.asBreeze().hashCode();
    }

    @Override
    public breeze.linalg.Matrix<Object> asBreeze() {
        CSCMatrix.mcD.sp sp2;
        if (!this.isTransposed()) {
            sp2 = new CSCMatrix.mcD.sp(this.values(), this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (Zero)Zero.DoubleZero$.MODULE$);
        } else {
            CSCMatrix.mcD.sp breezeMatrix = new CSCMatrix.mcD.sp(this.values(), this.numCols(), this.numRows(), this.colPtrs(), this.rowIndices(), (Zero)Zero.DoubleZero$.MODULE$);
            sp2 = (breeze.linalg.Matrix)breezeMatrix.t(CSCMatrix$.MODULE$.canTranspose(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()));
        }
        return sp2;
    }

    @Override
    public double apply(int i, int j) {
        int ind = this.index(i, j);
        return ind < 0 ? 0.0 : this.values()[ind];
    }

    @Override
    public int index(int i, int j) {
        Predef$.MODULE$.require(i >= 0 && i < this.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Expected 0 <= i < ").append(this.numRows()).append(", got i = ").append(i).append(".").toString());
        Predef$.MODULE$.require(j >= 0 && j < this.numCols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Expected 0 <= j < ").append(this.numCols()).append(", got j = ").append(j).append(".").toString());
        return !this.isTransposed() ? Arrays.binarySearch(this.rowIndices(), this.colPtrs()[j], this.colPtrs()[j + 1], i) : Arrays.binarySearch(this.rowIndices(), this.colPtrs()[i], this.colPtrs()[i + 1], j);
    }

    @Override
    public void update(int i, int j, double v) {
        int ind = this.index(i, j);
        if (ind < 0) {
            throw new NoSuchElementException("The given row and column indices correspond to a zero value. Only non-zero elements in Sparse Matrices can be updated.");
        }
        this.values()[ind] = v;
    }

    @Override
    public SparseMatrix copy() {
        return new SparseMatrix(this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (double[])this.values().clone());
    }

    @Override
    public SparseMatrix map(Function1<Object, Object> f) {
        return new SparseMatrix(this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).map(f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), this.isTransposed());
    }

    @Override
    public SparseMatrix update(Function1<Object, Object> f) {
        int len = this.values().length;
        for (int i = 0; i < len; ++i) {
            this.values()[i] = f.apply$mcDD$sp(this.values()[i]);
        }
        return this;
    }

    @Override
    public SparseMatrix transpose() {
        return new SparseMatrix(this.numCols(), this.numRows(), this.colPtrs(), this.rowIndices(), this.values(), !this.isTransposed());
    }

    @Override
    public void foreachActive(Function3<Object, Object, Object, BoxedUnit> f) {
        if (!this.isTransposed()) {
            for (int j = 0; j < this.numCols(); ++j) {
                int idxEnd = this.colPtrs()[j + 1];
                for (int idx = this.colPtrs()[j]; idx < idxEnd; ++idx) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)this.rowIndices()[idx]), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[idx]));
                }
            }
        } else {
            for (int i = 0; i < this.numRows(); ++i) {
                int idxEnd = this.colPtrs()[i + 1];
                for (int idx = this.colPtrs()[i]; idx < idxEnd; ++idx) {
                    int j = this.rowIndices()[idx];
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[idx]));
                }
            }
        }
    }

    public DenseMatrix toDense() {
        return new DenseMatrix(this.numRows(), this.numCols(), this.toArray());
    }

    @Override
    public int numNonzeros() {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 != 0.0);
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public Iterator<Vector> colIter() {
        Iterator iterator;
        if (this.isTransposed()) {
            ArrayBuilder[] indicesArray = (ArrayBuilder[])Array$.MODULE$.fill(this.numCols(), (Function0 & Serializable & scala.Serializable)() -> ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ArrayBuilder.class));
            ArrayBuilder[] valuesArray = (ArrayBuilder[])Array$.MODULE$.fill(this.numCols(), (Function0 & Serializable & scala.Serializable)() -> ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ArrayBuilder.class));
            for (int i = 0; i < this.numRows(); ++i) {
                int rowEnd = this.colPtrs()[i + 1];
                for (int k = this.colPtrs()[i]; k < rowEnd; ++k) {
                    int j2 = this.rowIndices()[k];
                    indicesArray[j2].$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                    valuesArray[j2].$plus$eq((Object)BoxesRunTime.boxToDouble((double)this.values()[k]));
                }
            }
            iterator = package$.MODULE$.Iterator().tabulate(this.numCols(), (Function1 & Serializable & scala.Serializable)j -> SparseMatrix.$anonfun$colIter$5(this, indicesArray, valuesArray, BoxesRunTime.unboxToInt((Object)j)));
        } else {
            iterator = package$.MODULE$.Iterator().tabulate(this.numCols(), (Function1 & Serializable & scala.Serializable)j -> SparseMatrix.$anonfun$colIter$6(this, BoxesRunTime.unboxToInt((Object)j)));
        }
        return iterator;
    }

    public org.apache.spark.ml.linalg.SparseMatrix asML() {
        return new org.apache.spark.ml.linalg.SparseMatrix(this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), this.values(), this.isTransposed());
    }

    public static final /* synthetic */ SparseVector $anonfun$colIter$5(SparseMatrix $this, ArrayBuilder[] indicesArray$1, ArrayBuilder[] valuesArray$1, int j) {
        int[] ii = (int[])indicesArray$1[j].result();
        double[] vv = (double[])valuesArray$1[j].result();
        return new SparseVector($this.numRows(), ii, vv);
    }

    public static final /* synthetic */ SparseVector $anonfun$colIter$6(SparseMatrix $this, int j) {
        int colStart = $this.colPtrs()[j];
        int colEnd = $this.colPtrs()[j + 1];
        int[] ii = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps($this.rowIndices())).slice(colStart, colEnd);
        double[] vv = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps($this.values())).slice(colStart, colEnd);
        return new SparseVector($this.numRows(), ii, vv);
    }

    public SparseMatrix(int numRows, int numCols, int[] colPtrs, int[] rowIndices, double[] values, boolean isTransposed) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.colPtrs = colPtrs;
        this.rowIndices = rowIndices;
        this.values = values;
        this.isTransposed = isTransposed;
        Matrix.$init$(this);
        Predef$.MODULE$.require(values.length == rowIndices.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("The number of row indices and values don't match! ").append(new StringBuilder(36).append("values.length: ").append(this.values().length).append(", rowIndices.length: ").append(this.rowIndices().length).toString()).toString());
        if (isTransposed) {
            Predef$.MODULE$.require(colPtrs.length == numRows + 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Expecting ").append(this.numRows() + 1).append(" colPtrs when numRows = ").append(this.numRows()).append(" but got ").append(this.colPtrs().length).toString());
        } else {
            Predef$.MODULE$.require(colPtrs.length == numCols + 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Expecting ").append(this.numCols() + 1).append(" colPtrs when numCols = ").append(this.numCols()).append(" but got ").append(this.colPtrs().length).toString());
        }
        Predef$.MODULE$.require(values.length == BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colPtrs)).last()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("The last value of colPtrs must equal the number of ").append(new StringBuilder(41).append("elements. values.length: ").append(this.values().length).append(", colPtrs.last: ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.colPtrs())).last()).toString()).toString());
    }

    public SparseMatrix(int numRows, int numCols, int[] colPtrs, int[] rowIndices, double[] values) {
        this(numRows, numCols, colPtrs, rowIndices, values, false);
    }
}

