/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,g+Z2u_JT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0007-\u0016\u001cGo\u001c:\t\u0011e\u0001!Q1A\u0005Bi\tAa]5{KV\t1\u0004\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0004\u0013:$\bf\u0001\r KA\u0011\u0001eI\u0007\u0002C)\u0011!EB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u0013\"\u0005\u0015\u0019\u0016N\\2fC\u00051\u0013!B\u0019/a9\u0002\u0004\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000bML'0\u001a\u0011)\u0007\u001dzR\u0005\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0001-\u0003\u001dIg\u000eZ5dKN,\u0012!\f\t\u0004\u001f9Z\u0012BA\u0018\u0011\u0005\u0015\t%O]1zQ\rQs$\n\u0005\te\u0001\u0011\t\u0011)A\u0005[\u0005A\u0011N\u001c3jG\u0016\u001c\b\u0005K\u00022?\u0015B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\u0007m\u0006dW/Z:\u0016\u0003]\u00022a\u0004\u00189!\ty\u0011(\u0003\u0002;!\t1Ai\\;cY\u0016D3\u0001N\u0010&\u0011!i\u0004A!A!\u0002\u00139\u0014a\u0002<bYV,7\u000f\t\u0015\u0004y})\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0016;\u0005CA\u000b\u0001\u0011\u0015Ir\b1\u0001\u001cQ\r\u0019u$\n\u0005\u0006W}\u0002\r!\f\u0015\u0004\u000b~)\u0003\"B\u001b@\u0001\u00049\u0004fA$ K!\u001aqhH\u0013\t\u000b-\u0003A\u0011\t'\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u0014\t\u0003\u001dVs!aT*\u0011\u0005A\u0003R\"A)\u000b\u0005Ic\u0011A\u0002\u001fs_>$h(\u0003\u0002U!\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!\u0006\u0003C\u0003Z\u0001\u0011\u0005c'A\u0004u_\u0006\u0013(/Y=)\u0007a{R\u0005C\u0003]\u0001\u0011\u0005S,\u0001\u0003d_BLX#\u0001\")\u0007m{r,I\u0001a\u0003\u0015\td&\r\u00181\u0011\u0019\u0011\u0007\u0001\"\u0011\u0007G\u0006A\u0011m\u001d\"sK\u0016TX-F\u0001e!\r)\u0017\u000eO\u0007\u0002M*\u00111a\u001a\u0006\u0002Q\u00061!M]3fu\u0016L!a\u00064\t\u000b-\u0004A\u0011\t7\u0002\u001b\u0019|'/Z1dQ\u0006\u001bG/\u001b<f)\ti\u0007\u000f\u0005\u0002\u0010]&\u0011q\u000e\u0005\u0002\u0005+:LG\u000fC\u0003rU\u0002\u0007!/A\u0001g!\u0015y1o\u0007\u001dn\u0013\t!\bCA\u0005Gk:\u001cG/[8oe!\u001a!n\b<\"\u0003]\fQ!\r\u00187]ABQ!\u001f\u0001\u0005Bi\fa!Z9vC2\u001cHCA>\u007f!\tyA0\u0003\u0002~!\t9!i\\8mK\u0006t\u0007BB@y\u0001\u0004\t\t!A\u0003pi\",'\u000fE\u0002\u0010\u0003\u0007I1!!\u0002\u0011\u0005\r\te.\u001f\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0003!A\u0017m\u001d5D_\u0012,G#A\u000e\t\r\u0005=\u0001\u0001\"\u0011\u001b\u0003)qW/\\!di&4Xm\u001d\u0015\u0006\u0003\u001by\u00121C\u0011\u0003\u0003+\tQ!\r\u00185]ABa!!\u0007\u0001\t\u0003R\u0012a\u00038v[:{gN_3s_NDS!a\u0006 \u0003'A\u0001\"a\b\u0001\t\u0003\u0012\u0011\u0011E\u0001\u0011i>\u001c\u0006/\u0019:tK^KG\u000f[*ju\u0016$2AQA\u0012\u0011\u001d\t)#!\bA\u0002m\t1A\u001c8{\u0011\u0019\tI\u0003\u0001C!5\u00051\u0011M]4nCbDS!a\n \u0003[\t#!a\f\u0002\u000bErSG\f\u0019\t\u0011\u0005M\u0002\u0001\"\u0001\u0007\u0003k\tQa\u001d7jG\u0016$2AQA\u001c\u0011\u001d\tI$!\rA\u00025\nqb]3mK\u000e$X\rZ%oI&\u001cWm\u001d\u0005\b\u0003{\u0001A\u0011IA \u0003\u0019!xNS:p]V\tQ\n\u000b\u0003\u0002<}1\bbBA#\u0001\u0011\u0005\u0013qI\u0001\u0005CNlE*\u0006\u0002\u0002JA!\u00111JA*\u001b\t\tiEC\u0002\u0004\u0003\u001fR1!!\u0015\u0007\u0003\tiG.C\u0002\u0002\u0003\u001bBS!a\u0011 \u0003/\n#!!\u0017\u0002\u000bIr\u0003G\f\u0019)\u000f\u0001\ti&!\u001c\u0002pA!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014!\u0002;za\u0016\u001c(bAA4\r\u0005\u00191/\u001d7\n\t\u0005-\u0014\u0011\r\u0002\u0013'FcUk]3s\t\u00164\u0017N\\3e)f\u0004X-A\u0002vIR\u001c#!!\u001d\u0011\u0007U\t\u0019(C\u0002\u0002v\t\u0011\u0011BV3di>\u0014X\u000b\u0012+)\u0007\u0001yReB\u0004\u0002|\tA\t!! \u0002\u0019M\u0003\u0018M]:f-\u0016\u001cGo\u001c:\u0011\u0007U\tyH\u0002\u0004\u0002\u0005!\u0005\u0011\u0011Q\n\u0006\u0003\u007fr\u00111\u0011\t\u0004\u001f\u0005\u0015\u0015bAAD!\ta1+\u001a:jC2L'0\u00192mK\"9\u0001)a \u0005\u0002\u0005-ECAA?\u0011!\ty)a \u0005\u0002\u0005E\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003'\u000by\nE\u0003\u0010\u0003+\u000bI*C\u0002\u0002\u0018B\u0011aa\u00149uS>t\u0007CB\b\u0002\u001cnis'C\u0002\u0002\u001eB\u0011a\u0001V;qY\u0016\u001c\u0004bBAQ\u0003\u001b\u0003\rAQ\u0001\u0003gZDS!!$ \u0003K\u000b#!a*\u0002\u000bEr3G\f\u0019\t\u0011\u0005-\u0016q\u0010C\u0001\u0003[\u000baA\u001a:p[6cEc\u0001\"\u00020\"A\u0011\u0011WAU\u0001\u0004\tI%A\u0001wQ\u0015\tIkHA,\u0011)\t9,a \u0002\u0002\u0013%\u0011\u0011X\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002<B!\u0011QXAd\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017\u0001\u00027b]\u001eT!!!2\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\fyL\u0001\u0004PE*,7\r\u001e\u0015\u0006\u0003\u007fz\u0012Q\u0015\u0015\u0006\u0003sz\u0012Q\u0015")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static SparseVector fromML(org.apache.spark.ml.linalg.SparseVector sparseVector) {
        return SparseVector$.MODULE$.fromML(sparseVector);
    }

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public double apply(int i) {
        return Vector.apply$(this, i);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringBuilder(4).append("(").append(this.size()).append(",").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).mkString("[", ",", "]")).append(",").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).mkString("[", ",", "]")).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> {
            block0: {
                if (v == 0.0) break block0;
                ++nnz$3.elem;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, v) -> {
                block0: {
                    if (v == 0.0) break block0;
                    ii$2[k$2.elem] = i;
                    vv$2[k$2.elem] = v;
                    ++k$2.elem;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedIndices)).flatMap((Function1 & Serializable & scala.Serializable)origIdx -> SparseVector.$anonfun$slice$1(this, currentIdx, BoxesRunTime.unboxToInt((Object)origIdx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] sliceInds = (int[])tuple2._1();
        double[] sliceVals = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
        Tuple2 tuple23 = tuple22;
        int[] sliceInds2 = (int[])tuple23._1();
        double[] sliceVals2 = (double[])tuple23._2();
        return new SparseVector(selectedIndices.length, (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sliceInds2)).toArray(ClassTag$.MODULE$.Int()), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sliceVals2)).toArray(ClassTag$.MODULE$.Double()));
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue;
        JsonAST.JObject x$8 = jValue = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToInteger((int)this.size())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indices"), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))));
        Formats x$9 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$8);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$8, x$9));
    }

    public org.apache.spark.ml.linalg.SparseVector asML() {
        return new org.apache.spark.ml.linalg.SparseVector(this.size(), this.indices(), this.values());
    }

    public static final /* synthetic */ Iterator $anonfun$slice$1(SparseVector $this, IntRef currentIdx$1, int origIdx) {
        int iIdx = Arrays.binarySearch($this.indices(), origIdx);
        Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(currentIdx$1.elem, $this.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        ++currentIdx$1.elem;
        return i_v;
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0 & Serializable & scala.Serializable)() -> "The size of the requested sparse vector must be no less than 0.");
        Predef$.MODULE$.require(indices.length == values.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Sparse vectors require that the dimension of the").append(new StringBuilder(70).append(" indices match the dimension of the values. You provided ").append(this.indices().length).append(" indices and ").toString()).append(new StringBuilder(9).append(" ").append(this.values().length).append(" values.").toString()).toString());
        Predef$.MODULE$.require(indices.length <= size, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("You provided ").append(this.indices().length).append(" indices and values, ").append(new StringBuilder(41).append("which exceeds the specified vector size ").append(this.size()).append(".").toString()).toString());
    }
}

