/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import java.io.Serializable;
import org.apache.spark.annotation.AlphaComponent;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@AlphaComponent
@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u001b\tIa+Z2u_J,F\t\u0016\u0006\u0003\u0007\u0011\ta\u0001\\5oC2<'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u00012a\u0004\u000b\u0017\u001b\u0005\u0001\"BA\t\u0013\u0003\u0015!\u0018\u0010]3t\u0015\t\u0019b!A\u0002tc2L!!\u0006\t\u0003\u001fU\u001bXM\u001d#fM&tW\r\u001a+za\u0016\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\rY+7\r^8s\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0018\u0001!)q\u0004\u0001C!A\u000591/\u001d7UsB,W#A\u0011\u0011\u0005=\u0011\u0013BA\u0012\u0011\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006K\u0001!\tEJ\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$\"aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0005)\u0012\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u00051J#aC%oi\u0016\u0014h.\u00197S_^DQA\f\u0013A\u0002Y\t1a\u001c2k\u0011\u0015\u0001\u0004\u0001\"\u00112\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0005Y\u0011\u0004\"B\u001a0\u0001\u0004!\u0014!\u00023biVl\u0007CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$aA!os\")1\b\u0001C!y\u0005)\u0001/_+E)V\tQ\b\u0005\u0002?\u000b:\u0011qh\u0011\t\u0003\u0001Zj\u0011!\u0011\u0006\u0003\u00052\ta\u0001\u0010:p_Rt\u0014B\u0001#7\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u00113\u0004\"B%\u0001\t\u0003R\u0015!C;tKJ\u001cE.Y:t+\u0005Y\u0005c\u0001 M-%\u0011Qj\u0012\u0002\u0006\u00072\f7o\u001d\u0005\u0006\u001f\u0002!\t\u0005U\u0001\u0007KF,\u0018\r\\:\u0015\u0005E#\u0006CA\u001bS\u0013\t\u0019fGA\u0004C_>dW-\u00198\t\u000bUs\u0005\u0019\u0001\u001b\u0002\u0003=DQa\u0016\u0001\u0005Ba\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u00023B\u0011QGW\u0005\u00037Z\u00121!\u00138u\u0011\u0015i\u0006\u0001\"\u0011=\u0003!!\u0018\u0010]3OC6,\u0007BB0\u0001\t\u00032\u0001-\u0001\u0006bg:+H\u000e\\1cY\u0016,\u0012!\b\u0015\u0003\u0001\t\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002hI\nq\u0011\t\u001c9iC\u000e{W\u000e]8oK:$\b")
public class VectorUDT
extends UserDefinedType<Vector> {
    public StructType sqlType() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("type", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("size", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("indices", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("values", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())})));
    }

    public InternalRow serialize(Vector obj) {
        DenseVector denseVector;
        Option<double[]> option;
        GenericInternalRow genericInternalRow;
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option2;
        Vector vector = obj;
        if (vector instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
            int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
            int[] indices = (int[])((Tuple3)option2.get())._2();
            double[] values = (double[])((Tuple3)option2.get())._3();
            GenericInternalRow row = new GenericInternalRow(4);
            row.setByte(0, (byte)0);
            row.setInt(1, size);
            row.update(2, (Object)UnsafeArrayData.fromPrimitiveArray((int[])indices));
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((double[])values));
            genericInternalRow = row;
        } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
            double[] values = (double[])option.get();
            GenericInternalRow row = new GenericInternalRow(4);
            row.setByte(0, (byte)1);
            row.setNullAt(1);
            row.setNullAt(2);
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((double[])values));
            genericInternalRow = row;
        } else {
            throw new MatchError((Object)vector);
        }
        return genericInternalRow;
    }

    public Vector deserialize(Object datum) {
        Vector vector;
        Object object = datum;
        if (object instanceof InternalRow) {
            byte tpe;
            InternalRow internalRow = (InternalRow)object;
            Predef$.MODULE$.require(internalRow.numFields() == 4, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("VectorUDT.deserialize given row with length ").append(internalRow.numFields()).append(" but requires length == 4").toString());
            byte by = tpe = internalRow.getByte(0);
            switch (by) {
                case 0: {
                    int size = internalRow.getInt(1);
                    int[] indices = internalRow.getArray(2).toIntArray();
                    double[] values = internalRow.getArray(3).toDoubleArray();
                    vector = new SparseVector(size, indices, values);
                    break;
                }
                case 1: {
                    double[] values = internalRow.getArray(3).toDoubleArray();
                    vector = new DenseVector(values);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
            }
        } else {
            throw new MatchError(object);
        }
        DenseVector denseVector = vector;
        return denseVector;
    }

    public String pyUDT() {
        return "pyspark.mllib.linalg.VectorUDT";
    }

    public Class<Vector> userClass() {
        return Vector.class;
    }

    public boolean equals(Object o) {
        Object object = o;
        boolean bl = object instanceof VectorUDT;
        return bl;
    }

    public int hashCode() {
        return VectorUDT.class.getName().hashCode();
    }

    public String typeName() {
        return "vector";
    }

    public VectorUDT asNullable() {
        return this;
    }
}

