/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.NumericParser$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

public final class Vectors$ {
    public static Vectors$ MODULE$;
    private final int MAX_HASH_NNZ;

    static {
        new Vectors$();
    }

    public Vector dense(double firstValue, double ... otherValues) {
        return this.dense(firstValue, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(otherValues));
    }

    public Vector dense(double firstValue, Seq<Object> otherValues) {
        double d = firstValue;
        return new DenseVector((double[])((TraversableOnce)otherValues.$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
    }

    public Vector dense(double[] values) {
        return new DenseVector(values);
    }

    public Vector sparse(int size, int[] indices, double[] values) {
        return new SparseVector(size, indices, values);
    }

    public Vector sparse(int size, Seq<Tuple2<Object, Object>> elements) {
        Tuple2 tuple2 = ((GenericTraversableTemplate)elements.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq indices = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
        Tuple2 tuple23 = tuple22;
        Seq indices2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        IntRef prev = IntRef.create((int)-1);
        indices2.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Predef$.MODULE$.require(prev$1.elem < i, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Found duplicate indices: ").append(i).append(".").toString());
            prev$1.elem = i;
        });
        Predef$.MODULE$.require(prev.elem < size, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("You may not write an element to index ").append(prev$1.elem).append(" because the declared ").append(new StringBuilder(23).append("size of your vector is ").append(size).toString()).toString());
        return new SparseVector(size, (int[])indices2.toArray(ClassTag$.MODULE$.Int()), (double[])values2.toArray(ClassTag$.MODULE$.Double()));
    }

    public Vector sparse(int size, Iterable<Tuple2<Integer, Double>> elements) {
        return this.sparse(size, (Seq<Tuple2<Object, Object>>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(elements).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer i = (Integer)tuple2._1();
            Double x = (Double)tuple2._2();
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(i.intValue(), x.doubleValue());
            return sp2;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public Vector zeros(int size) {
        return new DenseVector(new double[size]);
    }

    public Vector parse(String s) {
        return this.parseNumeric(NumericParser$.MODULE$.parse(s));
    }

    public Vector fromJson(String json) {
        Vector vector;
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JsonAST.JValue jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        int n = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("type")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        switch (n) {
            case 0: {
                int size = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("size")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                int[] indices = (int[])((TraversableOnce)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("indices")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).toArray(ClassTag$.MODULE$.Int());
                double[] values = (double[])((TraversableOnce)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("values")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).toArray(ClassTag$.MODULE$.Double());
                vector = this.sparse(size, indices, values);
                break;
            }
            case 1: {
                double[] values = (double[])((TraversableOnce)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(jValue).$bslash("values")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).toArray(ClassTag$.MODULE$.Double());
                vector = this.dense(values);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("Cannot parse ").append(json).append(" into a vector.").toString());
            }
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector parseNumeric(Object any) {
        Object object = any;
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            return this.dense(dArray);
        }
        if (!(object instanceof Seq)) throw new SparkException(new StringBuilder(14).append("Cannot parse ").append(object).append(".").toString());
        Seq seq = (Seq)object;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty()) throw new SparkException(new StringBuilder(14).append("Cannot parse ").append(object).append(".").toString());
        if (some.get() == null) throw new SparkException(new StringBuilder(14).append("Cannot parse ").append(object).append(".").toString());
        if (((SeqLike)some.get()).lengthCompare(3) != 0) throw new SparkException(new StringBuilder(14).append("Cannot parse ").append(object).append(".").toString());
        Object size = ((SeqLike)some.get()).apply(0);
        Object indices = ((SeqLike)some.get()).apply(1);
        Object values = ((SeqLike)some.get()).apply(2);
        if (!(size instanceof Double)) throw new SparkException(new StringBuilder(14).append("Cannot parse ").append(object).append(".").toString());
        double d = BoxesRunTime.unboxToDouble((Object)size);
        if (!(indices instanceof double[])) throw new SparkException(new StringBuilder(14).append("Cannot parse ").append(object).append(".").toString());
        double[] dArray = (double[])indices;
        if (!(values instanceof double[])) throw new SparkException(new StringBuilder(14).append("Cannot parse ").append(object).append(".").toString());
        double[] dArray2 = (double[])values;
        return this.sparse((int)d, (int[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(dArray)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$4 -> (int)x$4, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), dArray2);
    }

    public Vector fromBreeze(breeze.linalg.Vector<Object> breezeVector) {
        Vector vector;
        breeze.linalg.Vector<Object> vector2 = breezeVector;
        if (vector2 instanceof breeze.linalg.DenseVector) {
            breeze.linalg.DenseVector denseVector = (breeze.linalg.DenseVector)vector2;
            vector = denseVector.offset() == 0 && denseVector.stride() == 1 && denseVector.length() == denseVector.data$mcD$sp().length ? new DenseVector(denseVector.data$mcD$sp()) : new DenseVector(denseVector.toArray$mcD$sp(ClassTag$.MODULE$.Double()));
        } else if (vector2 instanceof breeze.linalg.SparseVector) {
            breeze.linalg.SparseVector sparseVector = (breeze.linalg.SparseVector)vector2;
            vector = sparseVector.index().length == sparseVector.used() ? new SparseVector(sparseVector.length(), sparseVector.index(), sparseVector.data$mcD$sp()) : new SparseVector(sparseVector.length(), (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sparseVector.index())).slice(0, sparseVector.used()), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sparseVector.data$mcD$sp())).slice(0, sparseVector.used()));
        } else {
            if (vector2 != null) {
                breeze.linalg.Vector<Object> vector3 = vector2;
                throw scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Unsupported Breeze vector type: ").append(vector3.getClass().getName()).toString());
            }
            throw new MatchError(vector2);
        }
        return vector;
    }

    public double norm(Vector vector, double p) {
        double d;
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option;
        double[] dArray;
        DenseVector denseVector;
        Option<double[]> option2;
        Predef$.MODULE$.require(p >= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("To compute the p-norm of the vector, we require that you specify a p>=1. ").append(new StringBuilder(17).append("You specified p=").append(p).append(".").toString()).toString());
        Vector vector2 = vector;
        if (vector2 instanceof DenseVector && !(option2 = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector2)).isEmpty()) {
            double[] vs;
            dArray = vs = (double[])option2.get();
        } else if (vector2 instanceof SparseVector && !(option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector2)).isEmpty()) {
            double[] vs;
            dArray = vs = (double[])((Tuple3)option.get())._3();
        } else {
            throw new IllegalArgumentException(new StringBuilder(27).append("Do not support vector type ").append(vector2.getClass()).toString());
        }
        double[] values = dArray;
        int size = values.length;
        if (p == 1.0) {
            double sum = 0.0;
            for (int i = 0; i < size; ++i) {
                sum += scala.math.package$.MODULE$.abs(values[i]);
            }
            d = sum;
        } else if (p == (double)2) {
            double sum = 0.0;
            for (int i = 0; i < size; ++i) {
                sum += values[i] * values[i];
            }
            d = scala.math.package$.MODULE$.sqrt(sum);
        } else if (p == Double.POSITIVE_INFINITY) {
            double max = 0.0;
            for (int i = 0; i < size; ++i) {
                double value = scala.math.package$.MODULE$.abs(values[i]);
                if (!(value > max)) continue;
                max = value;
            }
            d = max;
        } else {
            double sum = 0.0;
            for (int i = 0; i < size; ++i) {
                sum += scala.math.package$.MODULE$.pow(scala.math.package$.MODULE$.abs(values[i]), p);
            }
            d = scala.math.package$.MODULE$.pow(sum, 1.0 / p);
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     */
    public double sqdist(Vector v1, Vector v2) {
        SparseVector sparseVector;
        Vector v22;
        double squaredDistance;
        block18: {
            Tuple2 tuple2;
            block17: {
                Predef$.MODULE$.require(v1.size() == v2.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Vector dimensions do not match: Dim(v1)=").append(v1.size()).append(" and Dim(v2)").append(new StringBuilder(2).append("=").append(v2.size()).append(".").toString()).toString());
                squaredDistance = 0.0;
                tuple2 = new Tuple2((Object)v1, (Object)v2);
                if (tuple2 == null) break block17;
                Vector v12 = (Vector)tuple2._1();
                v22 = (Vector)tuple2._2();
                if (!(v12 instanceof SparseVector)) break block17;
                sparseVector = (SparseVector)v12;
                if (v22 instanceof SparseVector) break block18;
            }
            if (tuple2 != null) {
                Vector v13 = (Vector)tuple2._1();
                Vector v23 = (Vector)tuple2._2();
                if (v13 instanceof SparseVector) {
                    SparseVector sparseVector2 = (SparseVector)v13;
                    if (v23 instanceof DenseVector) {
                        DenseVector denseVector = (DenseVector)v23;
                        squaredDistance = this.sqdist(sparseVector2, denseVector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return squaredDistance;
                    }
                }
            }
            if (tuple2 != null) {
                Vector v14 = (Vector)tuple2._1();
                Vector v24 = (Vector)tuple2._2();
                if (v14 instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)v14;
                    if (v24 instanceof SparseVector) {
                        SparseVector sparseVector3 = (SparseVector)v24;
                        squaredDistance = this.sqdist(sparseVector3, denseVector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return squaredDistance;
                    }
                }
            }
            if (tuple2 == null) throw new IllegalArgumentException(new StringBuilder(32).append("Do not support vector type ").append(v1.getClass()).append(" and ").append(v2.getClass()).toString());
            Vector vector = (Vector)tuple2._1();
            Vector vector2 = (Vector)tuple2._2();
            if (!(vector instanceof DenseVector)) throw new IllegalArgumentException(new StringBuilder(32).append("Do not support vector type ").append(v1.getClass()).append(" and ").append(v2.getClass()).toString());
            DenseVector denseVector = (DenseVector)vector;
            Option<double[]> option = DenseVector$.MODULE$.unapply(denseVector);
            if (option.isEmpty()) throw new IllegalArgumentException(new StringBuilder(32).append("Do not support vector type ").append(v1.getClass()).append(" and ").append(v2.getClass()).toString());
            double[] vv1 = (double[])option.get();
            if (!(vector2 instanceof DenseVector)) throw new IllegalArgumentException(new StringBuilder(32).append("Do not support vector type ").append(v1.getClass()).append(" and ").append(v2.getClass()).toString());
            DenseVector denseVector2 = (DenseVector)vector2;
            Option<double[]> option2 = DenseVector$.MODULE$.unapply(denseVector2);
            if (option2.isEmpty()) throw new IllegalArgumentException(new StringBuilder(32).append("Do not support vector type ").append(v1.getClass()).append(" and ").append(v2.getClass()).toString());
            double[] vv2 = (double[])option2.get();
            int kv = 0;
            int sz = vv1.length;
            while (true) {
                if (kv >= sz) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return squaredDistance;
                }
                double score = vv1[kv] - vv2[kv];
                squaredDistance += score * score;
                ++kv;
            }
        }
        SparseVector sparseVector4 = (SparseVector)v22;
        double[] v1Values = sparseVector.values();
        int[] v1Indices = sparseVector.indices();
        double[] v2Values = sparseVector4.values();
        int[] v2Indices = sparseVector4.indices();
        int nnzv1 = v1Indices.length;
        int nnzv2 = v2Indices.length;
        int kv1 = 0;
        int kv2 = 0;
        while (true) {
            if (kv1 >= nnzv1 && kv2 >= nnzv2) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return squaredDistance;
            }
            double score = 0.0;
            if (kv2 >= nnzv2 || kv1 < nnzv1 && v1Indices[kv1] < v2Indices[kv2]) {
                score = v1Values[kv1];
                ++kv1;
            } else if (kv1 >= nnzv1 || kv2 < nnzv2 && v2Indices[kv2] < v1Indices[kv1]) {
                score = v2Values[kv2];
                ++kv2;
            } else {
                score = v1Values[kv1] - v2Values[kv2];
                ++kv1;
                ++kv2;
            }
            squaredDistance += score * score;
        }
    }

    public double sqdist(SparseVector v1, DenseVector v2) {
        int iv1;
        int kv1 = 0;
        int[] indices = v1.indices();
        double squaredDistance = 0.0;
        int nnzv1 = indices.length;
        int nnzv2 = v2.size();
        int n = iv1 = nnzv1 > 0 ? indices[kv1] : -1;
        for (int kv2 = 0; kv2 < nnzv2; ++kv2) {
            double score = 0.0;
            if (kv2 != iv1) {
                score = v2.apply(kv2);
            } else {
                score = v1.values()[kv1] - v2.apply(kv2);
                if (kv1 < nnzv1 - 1) {
                    iv1 = indices[++kv1];
                }
            }
            squaredDistance += score * score;
        }
        return squaredDistance;
    }

    public boolean equals(IndexedSeq<Object> v1Indices, double[] v1Values, IndexedSeq<Object> v2Indices, double[] v2Values) {
        int v1Size = v1Values.length;
        int v2Size = v2Values.length;
        int k1 = 0;
        int k2 = 0;
        boolean allEqual = true;
        while (allEqual) {
            while (k1 < v1Size && v1Values[k1] == 0.0) {
                ++k1;
            }
            while (k2 < v2Size && v2Values[k2] == 0.0) {
                ++k2;
            }
            if (k1 >= v1Size || k2 >= v2Size) {
                return k1 >= v1Size && k2 >= v2Size;
            }
            allEqual = BoxesRunTime.unboxToInt((Object)v1Indices.apply(k1)) == BoxesRunTime.unboxToInt((Object)v2Indices.apply(k2)) && v1Values[k1] == v2Values[k2];
            ++k1;
            ++k2;
        }
        return allEqual;
    }

    public int MAX_HASH_NNZ() {
        return this.MAX_HASH_NNZ;
    }

    public Vector fromML(org.apache.spark.ml.linalg.Vector v) {
        Vector vector;
        org.apache.spark.ml.linalg.Vector vector2 = v;
        if (vector2 instanceof org.apache.spark.ml.linalg.DenseVector) {
            org.apache.spark.ml.linalg.DenseVector denseVector = (org.apache.spark.ml.linalg.DenseVector)vector2;
            vector = DenseVector$.MODULE$.fromML(denseVector);
        } else if (vector2 instanceof org.apache.spark.ml.linalg.SparseVector) {
            org.apache.spark.ml.linalg.SparseVector sparseVector = (org.apache.spark.ml.linalg.SparseVector)vector2;
            vector = SparseVector$.MODULE$.fromML(sparseVector);
        } else {
            throw new MatchError((Object)vector2);
        }
        return vector;
    }

    private Vectors$() {
        MODULE$ = this;
        this.MAX_HASH_NNZ = 128;
    }
}

