/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix$;
import breeze.linalg.NumericOps;
import breeze.linalg.SliceVector;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.StorageVector;
import breeze.linalg.Tensor$;
import breeze.linalg.TensorLike;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0001\u0003\u0001=\u00111B\u00117pG.l\u0015\r\u001e:jq*\u00111\u0001B\u0001\fI&\u001cHO]5ckR,GM\u0003\u0002\u0006\r\u00051A.\u001b8bY\u001eT!a\u0002\u0005\u0002\u000b5dG.\u001b2\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!YQ\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t\tB)[:ue&\u0014W\u000f^3e\u001b\u0006$(/\u001b=\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011)\u0019!C\u0001E\u00051!\r\\8dWN,\u0012a\t\t\u0004I\u001dJS\"A\u0013\u000b\u0005\u0019B\u0011a\u0001:eI&\u0011\u0001&\n\u0002\u0004%\u0012#\u0005\u0003B\t+YAJ!a\u000b\n\u0003\rQ+\b\u000f\\33!\u0011\t\"&L\u0017\u0011\u0005Eq\u0013BA\u0018\u0013\u0005\rIe\u000e\u001e\t\u0003cIj\u0011\u0001B\u0005\u0003g\u0011\u0011a!T1ue&D\bf\u0001\u00116wA\u0011a'O\u0007\u0002o)\u0011\u0001\bC\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u001e8\u0005\u0015\u0019\u0016N\\2fC\u0005a\u0014!B\u0019/g9\u0002\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000f\tdwnY6tA!\u001aQ(N\u001e\t\u0011\u0005\u0003!Q1A\u0005\u0002\t\u000bAB]8xgB+'O\u00117pG.,\u0012!\f\u0015\u0004\u0001VZ\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001bI|wo\u001d)fe\ncwnY6!Q\r!Ug\u000f\u0005\t\u0011\u0002\u0011)\u0019!C\u0001\u0005\u0006a1m\u001c7t!\u0016\u0014(\t\\8dW\"\u001aq)N\u001e\t\u0011-\u0003!\u0011!Q\u0001\n5\nQbY8mgB+'O\u00117pG.\u0004\u0003f\u0001&6w!Aa\n\u0001BA\u0002\u0013%q*A\u0003o%><8/F\u0001Q!\t\t\u0012+\u0003\u0002S%\t!Aj\u001c8h\u0011!!\u0006A!a\u0001\n\u0013)\u0016!\u00038S_^\u001cx\fJ3r)\t1\u0016\f\u0005\u0002\u0012/&\u0011\u0001L\u0005\u0002\u0005+:LG\u000fC\u0004['\u0006\u0005\t\u0019\u0001)\u0002\u0007a$\u0013\u0007\u0003\u0005]\u0001\t\u0005\t\u0015)\u0003Q\u0003\u0019q'k\\<tA!Aa\f\u0001BA\u0002\u0013%q*A\u0003o\u0007>d7\u000f\u0003\u0005a\u0001\t\u0005\r\u0011\"\u0003b\u0003%q7i\u001c7t?\u0012*\u0017\u000f\u0006\u0002WE\"9!lXA\u0001\u0002\u0004\u0001\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0015\u0002)\u0002\r9\u001cu\u000e\\:!\u0011\u00151\u0007\u0001\"\u0001h\u0003\u0019a\u0014N\\5u}Q1\u0001.[6n_B\u0004\"a\u0006\u0001\t\u000b\u0005*\u0007\u0019A\u0012)\u0007%,4\bC\u0003BK\u0002\u0007Q\u0006K\u0002lkmBQ\u0001S3A\u00025B3!\\\u001b<\u0011\u0015qU\r1\u0001Q\u0011\u0015qV\r1\u0001QQ\r)WgO\u0003\u0005g\u0002!\u0011FA\u0006NCR\u0014\u0018\u000e\u001f\"m_\u000e\\\u0007\"\u00024\u0001\t\u0003)H\u0003\u00025wobDQ!\t;A\u0002\rBQ!\u0011;A\u00025BQ\u0001\u0013;A\u00025B3\u0001^\u001b<\u0011\u0015Y\b\u0001\"\u0011}\u0003\u001dqW/\u001c*poN$\u0012\u0001\u0015\u0015\u0004uVZ\u0004\"B@\u0001\t\u0003b\u0018a\u00028v[\u000e{Gn\u001d\u0015\u0004}VZ\u0004\u0002CA\u0003\u0001\t\u0007I\u0011\u0001\"\u0002\u00199,XNU8x\u00052|7m[:)\t\u0005\rQg\u000f\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003.\u00035qW/\u001c*po\ncwnY6tA!\"\u0011\u0011B\u001b<\u0011!\t\t\u0002\u0001b\u0001\n\u0003\u0011\u0015\u0001\u00048v[\u000e{GN\u00117pG.\u001c\b\u0006BA\bkmBq!a\u0006\u0001A\u0003%Q&A\u0007ok6\u001cu\u000e\u001c\"m_\u000e\\7\u000f\t\u0015\u0005\u0003+)4\b\u0003\u0005\u0002\u001e\u0001!\tABA\u0010\u0003E\u0019'/Z1uKB\u000b'\u000f^5uS>tWM\u001d\u000b\u0003\u0003C\u00012aFA\u0012\u0013\r\t)C\u0001\u0002\u0010\u000fJLG\rU1si&$\u0018n\u001c8fe\"Q\u0011\u0011\u0006\u0001\t\u0006\u0004%I!a\u000b\u0002\u0013\tdwnY6J]\u001a|WCAA\u0017!\u0011!s%a\f\u0011\tEQC\u0006\f\u0005\b\u0003g\u0001A\u0011BA\u001b\u0003-)7\u000f^5nCR,G)[7\u0015\u0003YCq!!\u000f\u0001\t\u0003\t)$\u0001\u0005wC2LG-\u0019;fQ\u0011\t9$N\u001e\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B\u0005)1-Y2iKR\u0011\u00111I\u0007\u0002\u0001!\"\u0011QH\u001b<\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\nq\u0001]3sg&\u001cH\u000f\u0006\u0003\u0002D\u00055\u0003\u0002CA(\u0003\u000f\u0002\r!!\u0015\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\t\u0005M\u0013\u0011L\u0007\u0003\u0003+R1!a\u0016\t\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a\u0017\u0002V\ta1\u000b^8sC\u001e,G*\u001a<fY\"\"\u0011qI\u001b<\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\n!\u0003^8D_>\u0014H-\u001b8bi\u0016l\u0015\r\u001e:jqR\u0011\u0011Q\r\t\u0004/\u0005\u001d\u0014bAA5\u0005\t\u00012i\\8sI&t\u0017\r^3NCR\u0014\u0018\u000e\u001f\u0015\u0005\u0003?*4\bC\u0004\u0002p\u0001!\t!!\u001d\u0002%Q|\u0017J\u001c3fq\u0016$'k\\<NCR\u0014\u0018\u000e\u001f\u000b\u0003\u0003g\u00022aFA;\u0013\r\t9H\u0001\u0002\u0011\u0013:$W\r_3e%><X*\u0019;sSbDC!!\u001c6w!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0014!\u0004;p\u0019>\u001c\u0017\r\\'biJL\u0007\u0010F\u00011Q\u0011\tY(N\u001e\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u0006IAO]1ogB|7/Z\u000b\u0002Q\"\"\u00111Q\u001b<\u0011!\ti\t\u0001C\u0001\r\u0005=\u0015\u0001\u0003;p\u0005J,WM_3\u0015\u0005\u0005E\u0005CBAJ\u00037\u000by*\u0004\u0002\u0002\u0016*\u0019Q!a&\u000b\u0005\u0005e\u0015A\u00022sK\u0016TX-\u0003\u0003\u0002\u001e\u0006U%a\u0003#f]N,W*\u0019;sSb\u00042!EAQ\u0013\r\t\u0019K\u0005\u0002\u0007\t>,(\r\\3\t\u0011\u0005\u001d\u0006\u0001\"\u0001\u0007\u0003S\u000b\u0001B\u00197pG.l\u0015\r\u001d\u000b\u0006Q\u0006-\u0016q\u0016\u0005\b\u0003[\u000b)\u000b1\u0001i\u0003\u0015yG\u000f[3s\u0011!\t\t,!*A\u0002\u0005M\u0016A\u00022j]6\u000b\u0007\u000fE\u0005\u0012\u0003k\u000bI,!/\u0002:&\u0019\u0011q\u0017\n\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004CBAJ\u0003w\u000by*C\u00024\u0003+Cq!a0\u0001\t\u0003\t\t-A\u0002bI\u0012$2\u0001[Ab\u0011\u001d\ti+!0A\u0002!DC!!06w!9\u0011\u0011\u001a\u0001\u0005\u0002\u0005-\u0017\u0001C:vER\u0014\u0018m\u0019;\u0015\u0007!\fi\rC\u0004\u0002.\u0006\u001d\u0007\u0019\u00015)\u000b\u0005\u001dW'!5\"\u0005\u0005M\u0017!\u0002\u001a/a9\u0002TABAl\u0001\u0011\tINA\tCY>\u001c7\u000eR3ti&t\u0017\r^5p]N\u0004r!a7\u0002j2\nyO\u0004\u0003\u0002^\u0006\u0015\bcAAp%5\u0011\u0011\u0011\u001d\u0006\u0004\u0003Gt\u0011A\u0002\u001fs_>$h(C\u0002\u0002hJ\ta\u0001\u0015:fI\u00164\u0017\u0002BAv\u0003[\u00141!T1q\u0015\r\t9O\u0005\t\u0006\u00037\f\t0L\u0005\u0005\u0003g\fiOA\u0002TKRD\u0001\"a>\u0001\t\u0003\u0011\u0011\u0011`\u0001\u0011g&lW\u000f\\1uK6+H\u000e^5qYf$\u0002\"a?\u0002\u0000\n\u0005!Q\u0001\t\u0007#)\ni0!@\u0011\t\u0005\r\u0013Q\u001b\u0005\b\u0003[\u000b)\u00101\u0001i\u0011!\u0011\u0019!!>A\u0002\u0005\u0005\u0012a\u00039beRLG/[8oKJDqAa\u0002\u0002v\u0002\u0007Q&\u0001\bnS\u0012$\u0015.\\*qY&$h*^7\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u0005AQ.\u001e7uSBd\u0017\u0010F\u0002i\u0005\u001fAq!!,\u0003\n\u0001\u0007\u0001\u000e\u000b\u0003\u0003\nUZ\u0004b\u0002B\u0006\u0001\u0011\u0005!Q\u0003\u000b\u0006Q\n]!\u0011\u0004\u0005\b\u0003[\u0013\u0019\u00021\u0001i\u0011\u001d\u0011YBa\u0005A\u00025\nqB\\;n\u001b&$G)[7Ta2LGo\u001d\u0015\u0006\u0005')$qD\u0011\u0003\u0005C\tQA\r\u00183]AB3\u0001A\u001b<\u0001")
public class BlockMatrix
implements DistributedMatrix,
Logging {
    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo;
    private final RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks;
    private final int rowsPerBlock;
    private final int colsPerBlock;
    private long nRows;
    private long nCols;
    private final int numRowBlocks;
    private final int numColBlocks;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks() {
        return this.blocks;
    }

    public int rowsPerBlock() {
        return this.rowsPerBlock;
    }

    public int colsPerBlock() {
        return this.colsPerBlock;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private long nCols() {
        return this.nCols;
    }

    private void nCols_$eq(long x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numRows() {
        block0: {
            if (this.nRows() > 0L) break block0;
            this.estimateDim();
        }
        return this.nRows();
    }

    @Override
    public long numCols() {
        block0: {
            if (this.nCols() > 0L) break block0;
            this.estimateDim();
        }
        return this.nCols();
    }

    public int numRowBlocks() {
        return this.numRowBlocks;
    }

    public int numColBlocks() {
        return this.numColBlocks;
    }

    public GridPartitioner createPartitioner() {
        return GridPartitioner$.MODULE$.apply(this.numRowBlocks(), this.numColBlocks(), this.blocks().partitions().length);
    }

    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo$lzycompute() {
        BlockMatrix blockMatrix = this;
        synchronized (blockMatrix) {
            if (!this.bitmap$0) {
                this.blockInfo = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1 & Serializable & scala.Serializable)block -> new Tuple2.mcII.sp(block.numRows(), block.numCols())).cache();
                this.bitmap$0 = true;
            }
        }
        return this.blockInfo;
    }

    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo() {
        return !this.bitmap$0 ? this.blockInfo$lzycompute() : this.blockInfo;
    }

    private void estimateDim() {
        Tuple2 tuple2 = (Tuple2)this.blockInfo().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int blockColIndex;
            int blockRowIndex;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    blockRowIndex = tuple23._1$mcI$sp();
                    blockColIndex = tuple23._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int m = tuple2._1$mcI$sp();
            int n = tuple2._2$mcI$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)blockRowIndex * (long)this.rowsPerBlock() + (long)m, (long)blockColIndex * (long)this.colsPerBlock() + (long)n);
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2 & Serializable & scala.Serializable)(x0, x1) -> new Tuple2.mcJJ.sp(package$.MODULE$.max(x0._1$mcJ$sp(), x1._1$mcJ$sp()), package$.MODULE$.max(x0._2$mcJ$sp(), x1._2$mcJ$sp())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long rows = tuple2._1$mcJ$sp();
        long cols = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(rows, cols);
        Tuple2.mcJJ.sp sp3 = sp2;
        long rows2 = sp3._1$mcJ$sp();
        long cols2 = sp3._2$mcJ$sp();
        if (this.nRows() <= 0L) {
            this.nRows_$eq(rows2);
        }
        Predef$.MODULE$.assert(rows2 <= this.nRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("The number of rows ").append(rows2).append(" is more than claimed ").append(this.nRows()).append(".").toString());
        if (this.nCols() <= 0L) {
            this.nCols_$eq(cols2);
        }
        Predef$.MODULE$.assert(cols2 <= this.nCols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("The number of columns ").append(cols2).append(" is more than claimed ").append(this.nCols()).append(".").toString());
    }

    public void validate() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Validating BlockMatrix...");
        this.estimateDim();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockMatrix dimensions are okay...");
        RDD$.MODULE$.rddToPairRDDFunctions(this.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).countByKey().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            BlockMatrix.$anonfun$validate$3(x0$2);
            return BoxedUnit.UNIT;
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "MatrixBlock indices are okay...");
        String dimensionMsg = new StringBuilder(111).append("dimensions different than rowsPerBlock: ").append(this.rowsPerBlock()).append(", and ").append(new StringBuilder(70).append("colsPerBlock: ").append(this.colsPerBlock()).append(". Blocks on the right and bottom edges can have smaller ").toString()).append("dimensions. You may use the repartition method to fix this issue.").toString();
        this.blockInfo().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            BlockMatrix.$anonfun$validate$5(this, dimensionMsg, x0$3);
            return BoxedUnit.UNIT;
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "MatrixBlock dimensions are okay...");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockMatrix is valid!");
    }

    public BlockMatrix cache() {
        this.blocks().cache();
        return this;
    }

    public BlockMatrix persist(StorageLevel storageLevel) {
        this.blocks().persist(storageLevel);
        return this;
    }

    public CoordinateMatrix toCoordinateMatrix() {
        RDD entryRDD = this.blocks().flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Matrix mat;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$4;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    mat = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIndex = tuple2._1$mcI$sp();
            int blockColIndex = tuple2._2$mcI$sp();
            long rowStart = (long)blockRowIndex * (long)this.rowsPerBlock();
            long colStart = (long)blockColIndex * (long)this.colsPerBlock();
            ArrayBuffer entryValues = new ArrayBuffer();
            mat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(i, j, v) -> {
                BlockMatrix.$anonfun$toCoordinateMatrix$2(rowStart, colStart, entryValues, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
                return BoxedUnit.UNIT;
            });
            ArrayBuffer arrayBuffer = entryValues;
            return arrayBuffer;
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)entryRDD, this.numRows(), this.numCols());
    }

    public IndexedRowMatrix toIndexedRowMatrix() {
        int cols = (int)this.numCols();
        Predef$.MODULE$.require(cols < Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("The number of columns should be less than Int.MaxValue (").append(cols).append(").").toString());
        RDD rows = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks().flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Matrix mat;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$5;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    mat = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIdx = tuple2._1$mcI$sp();
            int blockColIdx = tuple2._2$mcI$sp();
            Iterator iterator = mat.rowIter().zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector vector = (Vector)tuple2._1();
                int rowIdx = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(blockRowIdx * this.rowsPerBlock() + rowIdx))), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)blockColIdx), vector.asBreeze()));
                return tuple22;
            });
            return iterator;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int rowIdx = tuple2._1$mcI$sp();
            Iterable vectors = (Iterable)tuple2._2();
            double numberNonZeroPerRow = (double)BoxesRunTime.unboxToInt((Object)((TraversableOnce)vectors.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)BlockMatrix.$anonfun$toIndexedRowMatrix$5(x$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (double)cols;
            SparseVector wholeVector = numberNonZeroPerRow <= 0.1 ? SparseVector$.MODULE$.zeros$mDc$sp(cols, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$) : DenseVector$.MODULE$.zeros$mDc$sp(cols, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            vectors.foreach(arg_0 -> BlockMatrix.$anonfun$toIndexedRowMatrix$6(this, cols, (StorageVector)wholeVector, arg_0));
            IndexedRow indexedRow = new IndexedRow(rowIdx, Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)wholeVector));
            return indexedRow;
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        return new IndexedRowMatrix((RDD<IndexedRow>)rows);
    }

    public Matrix toLocalMatrix() {
        Predef$.MODULE$.require(this.numRows() < Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("The number of rows of this matrix should be less than ").append(new StringBuilder(33).append("Int.MaxValue. Currently numRows: ").append(this.numRows()).toString()).toString());
        Predef$.MODULE$.require(this.numCols() < Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("The number of columns of this matrix should be less than ").append(new StringBuilder(33).append("Int.MaxValue. Currently numCols: ").append(this.numCols()).toString()).toString());
        Predef$.MODULE$.require(this.numRows() * this.numCols() < Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("The length of the values array must be ").append(new StringBuilder(53).append("less than Int.MaxValue. Currently numRows * numCols: ").append(this.numRows() * this.numCols()).toString()).toString());
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        int mem = m * n / 125000;
        if (mem > 500) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Storing this matrix will require ").append(mem).append(" MB of memory!").toString());
        }
        Tuple2[] localBlocks = (Tuple2[])this.blocks().collect();
        double[] values = new double[m * n];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localBlocks)).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
            BlockMatrix.$anonfun$toLocalMatrix$5(this, m, values, x0$9);
            return BoxedUnit.UNIT;
        });
        return new DenseMatrix(m, n, values);
    }

    public BlockMatrix transpose() {
        RDD transposedBlocks = this.blocks().map((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Matrix mat;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$10;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    mat = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIndex = tuple2._1$mcI$sp();
            int blockColIndex = tuple2._2$mcI$sp();
            Tuple2 tuple23 = new Tuple2((Object)new Tuple2.mcII.sp(blockColIndex, blockRowIndex), (Object)mat.transpose());
            return tuple23;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)transposedBlocks, this.colsPerBlock(), this.rowsPerBlock(), this.nCols(), this.nRows());
    }

    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        Matrix localMat = this.toLocalMatrix();
        return new DenseMatrix.mcD.sp(localMat.numRows(), localMat.numCols(), localMat.toArray());
    }

    public BlockMatrix blockMap(BlockMatrix other, Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>> binMap) {
        Predef$.MODULE$.require(this.numRows() == other.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Both matrices must have the same number of rows. ").append(new StringBuilder(24).append("A.numRows: ").append(this.numRows()).append(", B.numRows: ").append(other.numRows()).toString()).toString());
        Predef$.MODULE$.require(this.numCols() == other.numCols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Both matrices must have the same number of columns. ").append(new StringBuilder(24).append("A.numCols: ").append(this.numCols()).append(", B.numCols: ").append(other.numCols()).toString()).toString());
        if (this.rowsPerBlock() != other.rowsPerBlock() || this.colsPerBlock() != other.colsPerBlock()) {
            throw new SparkException("Cannot perform on matrices with different block dimensions");
        }
        RDD newBlocks = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).cogroup(other.blocks(), (Partitioner)this.createPartitioner()).map((Function1 & Serializable & scala.Serializable)x0$11 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$11;
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            Tuple2 tuple24 = (Tuple2)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            int blockRowIndex = tuple23._1$mcI$sp();
            int blockColIndex = tuple23._2$mcI$sp();
            if (tuple24 == null) throw new MatchError((Object)tuple22);
            Iterable a = (Iterable)tuple24._1();
            Iterable b = (Iterable)tuple24._2();
            if (a.size() > 1) throw new SparkException(new StringBuilder(46).append("There are multiple MatrixBlocks with indices: ").append(new StringBuilder(25).append("(").append(blockRowIndex).append(", ").append(blockColIndex).append("). Please remove them.").toString()).toString());
            if (b.size() > 1) {
                throw new SparkException(new StringBuilder(46).append("There are multiple MatrixBlocks with indices: ").append(new StringBuilder(25).append("(").append(blockRowIndex).append(", ").append(blockColIndex).append("). Please remove them.").toString()).toString());
            }
            if (a.isEmpty()) {
                breeze.linalg.Matrix zeroBlock = Matrix$.MODULE$.zeros$mDc$sp(((Matrix)b.head()).numRows(), ((Matrix)b.head()).numCols(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                breeze.linalg.Matrix result = (breeze.linalg.Matrix)binMap.apply((Object)zeroBlock, ((Matrix)b.head()).asBreeze());
                tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)result));
                return tuple2;
            } else if (b.isEmpty()) {
                tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), a.head());
                return tuple2;
            } else {
                breeze.linalg.Matrix result = (breeze.linalg.Matrix)binMap.apply(((Matrix)a.head()).asBreeze(), ((Matrix)b.head()).asBreeze());
                tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)result));
            }
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)newBlocks, this.rowsPerBlock(), this.colsPerBlock(), this.numRows(), this.numCols());
    }

    public BlockMatrix add(BlockMatrix other) {
        return this.blockMap(other, (Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>>)(Function2 & Serializable & scala.Serializable)(x, y) -> (breeze.linalg.Matrix)x.$plus(y, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd()));
    }

    public BlockMatrix subtract(BlockMatrix other) {
        return this.blockMap(other, (Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>>)(Function2 & Serializable & scala.Serializable)(x, y) -> (breeze.linalg.Matrix)x.$minus(y, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpSub()));
    }

    public Tuple2<Map<Tuple2<Object, Object>, Set<Object>>, Map<Tuple2<Object, Object>, Set<Object>>> simulateMultiply(BlockMatrix other, GridPartitioner partitioner, int midDimSplitNum) {
        Tuple2[] leftMatrix = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(this.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).keys().collect();
        Tuple2[] rightMatrix = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(other.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).keys().collect();
        Map rightCounterpartsHelper = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightMatrix)).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp())).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5._2$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        Map leftDestinations = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftMatrix)).map((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Tuple2 tuple2 = x0$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int rowIndex = tuple2._1$mcI$sp();
            int colIndex = tuple2._2$mcI$sp();
            int[] rightCounterparts = (int[])rightCounterpartsHelper.getOrElse((Object)BoxesRunTime.boxToInteger((int)colIndex), (Function0 & Serializable & scala.Serializable)() -> (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()));
            int[] partitions = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(rightCounterparts)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)b -> partitioner.getPartition(new Tuple2.mcII.sp(rowIndex, b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            int midDimSplitIndex = colIndex % midDimSplitNum;
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(rowIndex, colIndex), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitions)).toSet().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)pid -> pid * midDimSplitNum + midDimSplitIndex, Set$.MODULE$.canBuildFrom()));
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Map leftCounterpartsHelper = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftMatrix)).groupBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6._2$mcI$sp())).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._1$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        Map rightDestinations = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightMatrix)).map((Function1 & Serializable & scala.Serializable)x0$13 -> {
            Tuple2 tuple2 = x0$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int rowIndex = tuple2._1$mcI$sp();
            int colIndex = tuple2._2$mcI$sp();
            int[] leftCounterparts = (int[])leftCounterpartsHelper.getOrElse((Object)BoxesRunTime.boxToInteger((int)rowIndex), (Function0 & Serializable & scala.Serializable)() -> (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()));
            int[] partitions = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(leftCounterparts)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)b -> partitioner.getPartition(new Tuple2.mcII.sp(b, colIndex)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            int midDimSplitIndex = rowIndex % midDimSplitNum;
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(rowIndex, colIndex), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partitions)).toSet().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)pid -> pid * midDimSplitNum + midDimSplitIndex, Set$.MODULE$.canBuildFrom()));
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)leftDestinations, (Object)rightDestinations);
    }

    public BlockMatrix multiply(BlockMatrix other) {
        return this.multiply(other, 1);
    }

    public BlockMatrix multiply(BlockMatrix other, int numMidDimSplits) {
        Tuple2 tuple2;
        GridPartitioner resultPartitioner;
        Predef$.MODULE$.require(this.numCols() == other.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(151).append("The number of columns of A and the number of rows ").append(new StringBuilder(53).append("of B must be equal. A.numCols: ").append(this.numCols()).append(", B.numRows: ").append(other.numRows()).append(". If you ").toString()).append("think they should be equal, try setting the dimensions of A and B explicitly while ").append("initializing them.").toString());
        Predef$.MODULE$.require(numMidDimSplits > 0, (Function0 & Serializable & scala.Serializable)() -> "numMidDimSplits should be a positive integer.");
        if (this.colsPerBlock() == other.rowsPerBlock()) {
            resultPartitioner = GridPartitioner$.MODULE$.apply(this.numRowBlocks(), other.numColBlocks(), package$.MODULE$.max(this.blocks().partitions().length, other.blocks().partitions().length));
            Tuple2<Map<Tuple2<Object, Object>, Set<Object>>, Map<Tuple2<Object, Object>, Set<Object>>> tuple22 = this.simulateMultiply(other, resultPartitioner, numMidDimSplits);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Map leftDestinations = (Map)tuple22._1();
            Map rightDestinations = (Map)tuple22._2();
            tuple2 = new Tuple2((Object)leftDestinations, (Object)rightDestinations);
        } else {
            throw new SparkException(new StringBuilder(51).append("colsPerBlock of A doesn't match rowsPerBlock of B. ").append(new StringBuilder(34).append("A.colsPerBlock: ").append(this.colsPerBlock()).append(", B.rowsPerBlock: ").append(other.rowsPerBlock()).toString()).toString());
        }
        Tuple2 tuple23 = tuple2;
        Map leftDestinations = (Map)tuple23._1();
        Map rightDestinations = (Map)tuple23._2();
        RDD flatA = this.blocks().flatMap((Function1 & Serializable & scala.Serializable)x0$14 -> {
            Matrix block;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$14;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    block = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIndex = tuple2._1$mcI$sp();
            int blockColIndex = tuple2._2$mcI$sp();
            Set destinations = (Set)leftDestinations.getOrElse((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
            Set set = (Set)destinations.map((Function1 & Serializable & scala.Serializable)j -> BlockMatrix.$anonfun$multiply$5(blockRowIndex, blockColIndex, block, BoxesRunTime.unboxToInt((Object)j)), Set$.MODULE$.canBuildFrom());
            return set;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD flatB = other.blocks().flatMap((Function1 & Serializable & scala.Serializable)x0$15 -> {
            Matrix block;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$15;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    block = (Matrix)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int blockRowIndex = tuple2._1$mcI$sp();
            int blockColIndex = tuple2._2$mcI$sp();
            Set destinations = (Set)rightDestinations.getOrElse((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
            Set set = (Set)destinations.map((Function1 & Serializable & scala.Serializable)j -> BlockMatrix.$anonfun$multiply$8(blockRowIndex, blockColIndex, block, BoxesRunTime.unboxToInt((Object)j)), Set$.MODULE$.canBuildFrom());
            return set;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Partitioner intermediatePartitioner = new Partitioner(null, numMidDimSplits, resultPartitioner){
            private final int numMidDimSplits$1;
            private final GridPartitioner resultPartitioner$1;

            public int numPartitions() {
                return this.resultPartitioner$1.numPartitions() * this.numMidDimSplits$1;
            }

            public int getPartition(Object key) {
                return BoxesRunTime.unboxToInt((Object)key);
            }
            {
                this.numMidDimSplits$1 = numMidDimSplits$1;
                this.resultPartitioner$1 = resultPartitioner$1;
            }
        };
        RDD newBlocks = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(flatA, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.Int$.MODULE$).cogroup(flatB, intermediatePartitioner).flatMap((Function1 & Serializable & scala.Serializable)x0$16 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$16;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            Iterable a = (Iterable)tuple2._1();
            Iterable b = (Iterable)tuple2._2();
            Iterable iterable = (Iterable)a.flatMap((Function1 & Serializable & scala.Serializable)x0$17 -> {
                Tuple3 tuple3 = x0$17;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                int leftRowIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int leftColIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
                Matrix leftBlock = (Matrix)tuple3._3();
                Iterable iterable = (Iterable)((TraversableLike)b.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)BlockMatrix.$anonfun$multiply$11(leftColIndex, x$10)))).map((Function1 & Serializable & scala.Serializable)x0$18 -> {
                    DenseMatrix denseMatrix;
                    Tuple3 tuple3 = x0$18;
                    if (tuple3 == null) throw new MatchError((Object)tuple3);
                    int rightColIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    Matrix rightBlock = (Matrix)tuple3._3();
                    Matrix matrix = rightBlock;
                    if (matrix instanceof DenseMatrix) {
                        DenseMatrix denseMatrix2 = (DenseMatrix)matrix;
                        denseMatrix = leftBlock.multiply(denseMatrix2);
                    } else {
                        if (!(matrix instanceof SparseMatrix)) throw new SparkException(new StringBuilder(26).append("Unrecognized matrix type ").append(rightBlock.getClass()).append(".").toString());
                        SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                        denseMatrix = leftBlock.multiply(sparseMatrix.toDense());
                    }
                    DenseMatrix C = denseMatrix;
                    return new Tuple2((Object)new Tuple2.mcII.sp(leftRowIndex, rightColIndex), C.asBreeze());
                }, Iterable$.MODULE$.canBuildFrom());
                return iterable;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(breeze.linalg.Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Partitioner)resultPartitioner, (Function2 & Serializable & scala.Serializable)(a, b) -> (breeze.linalg.Matrix)a.$plus(b, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd())), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(breeze.linalg.Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1 & Serializable & scala.Serializable)breeze -> Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)breeze));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)newBlocks, this.rowsPerBlock(), other.colsPerBlock(), this.numRows(), other.numCols());
    }

    public static final /* synthetic */ void $anonfun$validate$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Tuple2 key = (Tuple2)tuple2._1();
            long cnt = tuple2._2$mcJ$sp();
            if (cnt > 1L) {
                throw new SparkException(new StringBuilder(91).append("Found multiple MatrixBlocks with the indices ").append(key).append(". Please ").append("remove blocks with duplicate indices.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$validate$5(BlockMatrix $this, String dimensionMsg$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        Tuple2 tuple23 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        int blockRowIndex = tuple22._1$mcI$sp();
        int blockColIndex = tuple22._2$mcI$sp();
        if (tuple23 == null) throw new MatchError((Object)tuple2);
        int m = tuple23._1$mcI$sp();
        int n = tuple23._2$mcI$sp();
        if (blockRowIndex < $this.numRowBlocks() - 1 && m != $this.rowsPerBlock() || blockRowIndex == $this.numRowBlocks() - 1 && (m <= 0 || m > $this.rowsPerBlock())) {
            throw new SparkException(new StringBuilder(28).append("The MatrixBlock at (").append(blockRowIndex).append(", ").append(blockColIndex).append(") has ").append(dimensionMsg$1).toString());
        }
        if (blockColIndex < $this.numColBlocks() - 1 && n != $this.colsPerBlock() || blockColIndex == $this.numColBlocks() - 1 && (n <= 0 || n > $this.colsPerBlock())) {
            throw new SparkException(new StringBuilder(28).append("The MatrixBlock at (").append(blockRowIndex).append(", ").append(blockColIndex).append(") has ").append(dimensionMsg$1).toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$toCoordinateMatrix$2(long rowStart$1, long colStart$1, ArrayBuffer entryValues$1, int i, int j, double v) {
        block0: {
            if (v == 0.0) break block0;
            entryValues$1.$plus$eq((Object)new MatrixEntry(rowStart$1 + (long)i, colStart$1 + (long)j, v));
        }
    }

    public static final /* synthetic */ int $anonfun$toIndexedRowMatrix$5(Tuple2 x$2) {
        return ((TensorLike)x$2._2()).activeSize();
    }

    public static final /* synthetic */ SliceVector $anonfun$toIndexedRowMatrix$6(BlockMatrix $this, int cols$2, StorageVector wholeVector$1, Tuple2 x0$8) {
        int n;
        breeze.linalg.Vector vec;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$8;
                if (tuple2 == null) break block2;
                int blockColIdx = tuple2._1$mcI$sp();
                vec = (breeze.linalg.Vector)tuple2._2();
                n = blockColIdx;
                if (vec != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        breeze.linalg.Vector vector = vec;
        int offset = $this.colsPerBlock() * n;
        SliceVector sliceVector = (SliceVector)((NumericOps)wholeVector$1.apply((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), Math.min(cols$2, offset + $this.colsPerBlock())), Tensor$.MODULE$.canSliceTensor(ClassTag$.MODULE$.Double()))).$colon$eq((Object)vector, Vector$.MODULE$.castUpdateOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.InPlaceImpl2)Vector$.MODULE$.v_v_UpdateOp_Double_OpSet()));
        return sliceVector;
    }

    public static final /* synthetic */ void $anonfun$toLocalMatrix$6(int m$1, double[] values$1, int rowOffset$1, int colOffset$1, int i, int j, double v) {
        int indexOffset = (j + colOffset$1) * m$1 + rowOffset$1 + i;
        values$1[indexOffset] = v;
    }

    public static final /* synthetic */ void $anonfun$toLocalMatrix$5(BlockMatrix $this, int m$1, double[] values$1, Tuple2 x0$9) {
        Matrix submat;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$9;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                submat = (Matrix)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int blockRowIndex = tuple2._1$mcI$sp();
        int blockColIndex = tuple2._2$mcI$sp();
        int rowOffset = blockRowIndex * $this.rowsPerBlock();
        int colOffset = blockColIndex * $this.colsPerBlock();
        submat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(i, j, v) -> {
            BlockMatrix.$anonfun$toLocalMatrix$6(m$1, values$1, rowOffset, colOffset, BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j), BoxesRunTime.unboxToDouble((Object)v));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$multiply$5(int blockRowIndex$1, int blockColIndex$1, Matrix block$1, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)blockRowIndex$1), (Object)BoxesRunTime.boxToInteger((int)blockColIndex$1), (Object)block$1));
    }

    public static final /* synthetic */ Tuple2 $anonfun$multiply$8(int blockRowIndex$2, int blockColIndex$2, Matrix block$2, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)blockRowIndex$2), (Object)BoxesRunTime.boxToInteger((int)blockColIndex$2), (Object)block$2));
    }

    public static final /* synthetic */ boolean $anonfun$multiply$11(int leftColIndex$1, Tuple3 x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10._1()) == leftColIndex$1;
    }

    public BlockMatrix(RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks, int rowsPerBlock, int colsPerBlock, long nRows, long nCols) {
        this.blocks = blocks;
        this.rowsPerBlock = rowsPerBlock;
        this.colsPerBlock = colsPerBlock;
        this.nRows = nRows;
        this.nCols = nCols;
        Logging.$init$((Logging)this);
        this.numRowBlocks = (int)package$.MODULE$.ceil((double)this.numRows() * 1.0 / (double)rowsPerBlock);
        this.numColBlocks = (int)package$.MODULE$.ceil((double)this.numCols() * 1.0 / (double)colsPerBlock);
    }

    public BlockMatrix(RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks, int rowsPerBlock, int colsPerBlock) {
        this(blocks, rowsPerBlock, colsPerBlock, 0L, 0L);
    }
}

