/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.LU;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.inv$;
import breeze.linalg.qr;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.EigenValueDecomposition$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.QRDecomposition;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$SVDMode$2$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u0001\u0003\u0001=\u0011\u0011BU8x\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003#\u0011K7\u000f\u001e:jEV$X\rZ'biJL\u0007\u0010\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002 9\t9Aj\\4hS:<\u0007\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\tI|wo]\u000b\u0002GA\u0019AeJ\u0015\u000e\u0003\u0015R!A\n\u0005\u0002\u0007I$G-\u0003\u0002)K\t\u0019!\u000b\u0012#\u0011\u0005)ZS\"\u0001\u0003\n\u00051\"!A\u0002,fGR|'\u000fK\u0002!]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00024a\t)1+\u001b8dK\u0006\nQ'A\u00032]Ar\u0003\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u0003$\u0003\u0015\u0011xn^:!Q\r1d\u0006\u000e\u0005\tu\u0001\u0011\t\u0019!C\u0005w\u0005)aNU8xgV\tA\b\u0005\u0002\u0012{%\u0011aH\u0005\u0002\u0005\u0019>tw\r\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0003B\u0003%q'k\\<t?\u0012*\u0017\u000f\u0006\u0002C\u000bB\u0011\u0011cQ\u0005\u0003\tJ\u0011A!\u00168ji\"9aiPA\u0001\u0002\u0004a\u0014a\u0001=%c!A\u0001\n\u0001B\u0001B\u0003&A(\u0001\u0004o%><8\u000f\t\u0005\t\u0015\u0002\u0011\t\u0019!C\u0005\u0017\u0006)anQ8mgV\tA\n\u0005\u0002\u0012\u001b&\u0011aJ\u0005\u0002\u0004\u0013:$\b\u0002\u0003)\u0001\u0005\u0003\u0007I\u0011B)\u0002\u00139\u001cu\u000e\\:`I\u0015\fHC\u0001\"S\u0011\u001d1u*!AA\u00021C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006K\u0001T\u0001\u0007]\u000e{Gn\u001d\u0011\t\u000bY\u0003A\u0011A,\u0002\rqJg.\u001b;?)\u0011A\u0016l\u0017/\u0011\u0005]\u0001\u0001\"B\u0011V\u0001\u0004\u0019\u0003fA-/i!)!(\u0016a\u0001y!)!*\u0016a\u0001\u0019\"\u001aQK\f\u001b\t\u000bY\u0003A\u0011A0\u0015\u0005a\u0003\u0007\"B\u0011_\u0001\u0004\u0019\u0003f\u00010/i!)1\r\u0001C!I\u00069a.^7D_2\u001cH#\u0001\u001f)\u0007\ttC\u0007C\u0003h\u0001\u0011\u0005C-A\u0004ok6\u0014vn^:)\u0007\u0019tC\u0007\u0003\u0004k\u0001\u0011\u0005aa[\u0001\u0018[VdG/\u001b9ms\u001e\u0013\u0018-\\5b]6\u000bGO]5y\u0005f$\"\u0001\u001c<\u0011\u00075\f8/D\u0001o\u0015\t)qNC\u0001q\u0003\u0019\u0011'/Z3{K&\u0011!O\u001c\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0005\u0002\u0012i&\u0011QO\u0005\u0002\u0007\t>,(\r\\3\t\u000b]L\u0007\u0019\u00017\u0002\u0003YDQ!\u001f\u0001\u0005\u0002i\fAcY8naV$Xm\u0012:b[&\fg.T1ue&DH#A>\u0011\u0005)b\u0018BA?\u0005\u0005\u0019i\u0015\r\u001e:jq\"\u001a\u0001P\f\u001b\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\u0005y1\r[3dW:+XnQ8mk6t7\u000fF\u0002C\u0003\u000bAa!a\u0002\u0000\u0001\u0004a\u0015\u0001B2pYNDq!a\u0003\u0001\t\u0003\ti!\u0001\u0006d_6\u0004X\u000f^3T-\u0012#\u0002\"a\u0004\u0002\u0016\u0005e\u00111\u0005\t\u0006U\u0005E\u0001l_\u0005\u0004\u0003'!!AG*j]\u001e,H.\u0019:WC2,X\rR3d_6\u0004xn]5uS>t\u0007bBA\f\u0003\u0013\u0001\r\u0001T\u0001\u0002W\"Q\u00111DA\u0005!\u0003\u0005\r!!\b\u0002\u0011\r|W\u000e];uKV\u00032!EA\u0010\u0013\r\t\tC\u0005\u0002\b\u0005>|G.Z1o\u0011%\t)#!\u0003\u0011\u0002\u0003\u00071/A\u0003s\u0007>tG\r\u000b\u0003\u0002\n9\"\u0004\u0002CA\u0006\u0001\u0011\u0005a!a\u000b\u0015\u001d\u0005=\u0011QFA\u0018\u0003c\t\u0019$a\u000e\u0002<!9\u0011qCA\u0015\u0001\u0004a\u0005\u0002CA\u000e\u0003S\u0001\r!!\b\t\u000f\u0005\u0015\u0012\u0011\u0006a\u0001g\"9\u0011QGA\u0015\u0001\u0004a\u0015aB7bq&#XM\u001d\u0005\b\u0003s\tI\u00031\u0001t\u0003\r!x\u000e\u001c\u0005\t\u0003{\tI\u00031\u0001\u0002@\u0005!Qn\u001c3f!\u0011\t\t%a\u0014\u000f\t\u0005\r\u00131\n\t\u0004\u0003\u000b\u0012RBAA$\u0015\r\tIED\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055##\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\n\u0019F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b\u0012\u0002BBA,\u0001\u0011\u0005!0A\td_6\u0004X\u000f^3D_Z\f'/[1oG\u0016DC!!\u0016/i!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013AL2p[B,H/\u001a)sS:\u001c\u0017\u000e]1m\u0007>l\u0007o\u001c8f]R\u001c\u0018I\u001c3FqBd\u0017-\u001b8fIZ\u000b'/[1oG\u0016$B!!\u0019\u0002hA)\u0011#a\u0019|S%\u0019\u0011Q\r\n\u0003\rQ+\b\u000f\\33\u0011\u001d\t9\"a\u0017A\u00021CS!a\u0017/\u0003W\n#!!\u001c\u0002\u000bErcG\f\u0019\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005Q2m\\7qkR,\u0007K]5oG&\u0004\u0018\r\\\"p[B|g.\u001a8ugR\u001910!\u001e\t\u000f\u0005]\u0011q\u000ea\u0001\u0019\"\"\u0011q\u000e\u00185\u0011\u001d\tY\b\u0001C\u0001\u0003{\nadY8naV$XmQ8mk6t7+^7nCJL8\u000b^1uSN$\u0018nY:\u0015\u0005\u0005}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015e!\u0001\u0003ti\u0006$\u0018\u0002BAE\u0003\u0007\u0013a$T;mi&4\u0018M]5bi\u0016\u001cF/\u0019;jgRL7-\u00197Tk6l\u0017M]=)\t\u0005ed\u0006\u000e\u0005\b\u0003\u001f\u0003A\u0011AAI\u0003!iW\u000f\u001c;ja2LHc\u0001-\u0002\u0014\"9\u0011QSAG\u0001\u0004Y\u0018!\u0001\")\t\u00055e\u0006\u000e\u0005\b\u00037\u0003A\u0011AAO\u0003I\u0019w\u000e\\;n]NKW.\u001b7be&$\u0018.Z:\u0015\u0005\u0005}\u0005cA\f\u0002\"&\u0019\u00111\u0015\u0002\u0003!\r{wN\u001d3j]\u0006$X-T1ue&D\b&BAM]\u0005\u001d\u0016EAAU\u0003\u0015\tdF\r\u00181\u0011\u001d\tY\n\u0001C\u0001\u0003[#B!a(\u00020\"9\u0011\u0011WAV\u0001\u0004\u0019\u0018!\u0003;ie\u0016\u001c\bn\u001c7eQ\u0015\tYKLAT\u0011\u001d\t9\f\u0001C\u0001\u0003s\u000bA\u0002^1mYN[\u0017N\u001c8z#J#B!a/\u0002BB)!&!0Yw&\u0019\u0011q\u0018\u0003\u0003\u001fE\u0013F)Z2p[B|7/\u001b;j_:D!\"a1\u00026B\u0005\t\u0019AA\u000f\u0003!\u0019w.\u001c9vi\u0016\f\u0006&BA[]\u0005\u001d\u0017EAAe\u0003\u0015\td&\u000e\u00181\u0011!\ti\r\u0001C\u0001\r\u0005=\u0017\u0001G2pYVlgnU5nS2\f'/\u001b;jKN$\u0015*T*V\u001bR1\u0011qTAi\u00037D\u0001\"a5\u0002L\u0002\u0007\u0011Q[\u0001\bG>dW*Y4t!\u0011\t\u0012q[:\n\u0007\u0005e'CA\u0003BeJ\f\u0017\u0010C\u0004\u0002^\u0006-\u0007\u0019A:\u0002\u000b\u001d\fW.\\1\t\u0011\u0005\u0005\b\u0001\"\u0011\u0007\u0003G\f\u0001\u0002^8Ce\u0016,'0\u001a\u000b\u0003\u0003K\u0004B!\\Atg&\u0019\u0011\u0011\u001e8\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\u0005\b\u0003[\u0004A\u0011BAx\u00035)\b\u000fZ1uK:+XNU8xgR\u0019!)!=\t\u000f\u0005M\u00181\u001ea\u0001y\u0005\tQ\u000eC\u0005\u0002x\u0002\t\n\u0011\"\u0001\u0002z\u0006!2m\\7qkR,7K\u0016#%I\u00164\u0017-\u001e7uII*\"!a?+\t\u0005u\u0011Q`\u0016\u0003\u0003\u007f\u0004BA!\u0001\u0003\n5\u0011!1\u0001\u0006\u0005\u0005\u000b\u00119!A\u0005v]\u000eDWmY6fI*\u0011\u0011GE\u0005\u0005\u0005\u0017\u0011\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba\u0004\u0001#\u0003%\tA!\u0005\u0002)\r|W\u000e];uKN3F\t\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019BK\u0002t\u0003{D\u0011Ba\u0006\u0001#\u0003%\t!!?\u0002-Q\fG\u000e\\*lS:t\u00170\u0015*%I\u00164\u0017-\u001e7uIEB3\u0001\u0001\u00185\u000f\u001d\u0011iB\u0001E\u0001\u0005?\t\u0011BU8x\u001b\u0006$(/\u001b=\u0011\u0007]\u0011\tC\u0002\u0004\u0002\u0005!\u0005!1E\n\u0006\u0005C\u0001\"Q\u0005\t\u0004#\t\u001d\u0012b\u0001B\u0015%\ta1+\u001a:jC2L'0\u00192mK\"9aK!\t\u0005\u0002\t5BC\u0001B\u0010\u0011!\u0011\tD!\t\u0005\n\tM\u0012A\u0003;sSV$vNR;mYR)1P!\u000e\u0003:!9!q\u0007B\u0018\u0001\u0004a\u0015!\u00018\t\u0011\tm\"q\u0006a\u0001\u0003+\f\u0011!\u0016\u0005\u000b\u0005\u007f\u0011\t#!A\u0005\n\t\u0005\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0011\u0011\t\t\u0015#qJ\u0007\u0003\u0005\u000fRAA!\u0013\u0003L\u0005!A.\u00198h\u0015\t\u0011i%\u0001\u0003kCZ\f\u0017\u0002\u0002B)\u0005\u000f\u0012aa\u00142kK\u000e$\b\u0006\u0002B\u0011]QBCAa\u0007/i\u0001")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long nRows;
    private int nCols;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0) {
            try {
                this.nCols_$eq(((Vector)this.rows().first()).size());
            }
            catch (UnsupportedOperationException err) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of cols because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(this.rows().count());
            if (this.nRows() == 0L) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.nRows();
    }

    public breeze.linalg.DenseVector<Object> multiplyGramianMatrixBy(breeze.linalg.DenseVector<Object> v) {
        int n = (int)this.numCols();
        Broadcast vbr = this.rows().context().broadcast(v, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        breeze.linalg.DenseVector x$8 = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Function2 & Serializable & scala.Serializable x$9 = (Function2 & Serializable & scala.Serializable)(U, r) -> {
            breeze.linalg.Vector<Object> rBrz = r.asBreeze();
            double a = BoxesRunTime.unboxToDouble((Object)rBrz.dot(vbr.value(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
            breeze.linalg.Vector<Object> vector = rBrz;
            if (vector instanceof breeze.linalg.DenseVector) {
                breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.DenseVector)rBrz), U, (UFunc.InPlaceImpl3)DenseVector.canDaxpy$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (vector instanceof breeze.linalg.SparseVector) {
                breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.SparseVector)rBrz), U, breeze.linalg.SparseVector$.MODULE$.implScaleAdd_DVT_T_SVT_InPlace_Double());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(43).append("Do not support vector operation from type ").append(rBrz.getClass().getName()).append(".").toString());
            }
            return U;
        };
        Function2 & Serializable & scala.Serializable x$10 = (Function2 & Serializable & scala.Serializable)(U1, U2) -> (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
        int x$11 = this.rows().treeAggregate$default$4((Object)x$8);
        return (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$8, (Function2)x$9, (Function2)x$10, x$11, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        DenseVector.mcD.sp x$12 = new DenseVector.mcD.sp(nt, ClassTag$.MODULE$.Double());
        Function2 & Serializable & scala.Serializable x$13 = (Function2 & Serializable & scala.Serializable)(U, v) -> {
            BLAS$.MODULE$.spr(1.0, (Vector)v, U.data$mcD$sp());
            return U;
        };
        Function2 & Serializable & scala.Serializable x$14 = (Function2 & Serializable & scala.Serializable)(U1, U2) -> (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
        int x$15 = this.rows().treeAggregate$default$4((Object)x$12);
        breeze.linalg.DenseVector GU = (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$12, (Function2)x$13, (Function2)x$14, x$15, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    private void checkNumColumns(int cols) {
        block1: {
            if (cols > 65535) {
                throw new IllegalArgumentException(new StringBuilder(36).append("Argument with more than 65535 cols: ").append(cols).toString());
            }
            if (cols <= 10000) break block1;
            long memMB = (long)cols * (long)cols / 125000L;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append(cols).append(" columns will require at least ").append(memMB).append(" megabytes of memory!").toString());
        }
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int maxIter = package$.MODULE$.max(300, k * 3);
        double tol = 1.0E-10;
        return this.computeSVD(k, computeU, rCond, maxIter, tol, "auto");
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond, int maxIter, double tol, String mode) {
        SingularValueDecomposition<RowMatrix, Matrix> singularValueDecomposition;
        breeze.linalg.DenseVector denseVector;
        breeze.linalg.DenseMatrix u;
        Enumeration.Value computeMode;
        int n;
        LazyRef SVDMode$module;
        block33: {
            Tuple2 tuple2;
            block32: {
                Tuple2 tuple22;
                block28: {
                    Enumeration.Value value;
                    block29: {
                        breeze.linalg.DenseMatrix denseMatrix;
                        breeze.linalg.DenseVector sigmaSquaresFull;
                        block31: {
                            svd.SVD sVD;
                            block30: {
                                block27: {
                                    Enumeration.Value value2;
                                    SVDMode$module = new LazyRef();
                                    n = (int)this.numCols();
                                    Predef$.MODULE$.require(k > 0 && k <= n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Requested k singular values but got k=").append(k).append(" and numCols=").append(n).append(".").toString());
                                    String string = mode;
                                    if ("auto".equals(string)) {
                                        if (k > 5000) {
                                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("computing svd with k=").append(k).append(" and n=").append(n).append(", please check necessity").toString());
                                        }
                                        value2 = n < 100 || k > n / 2 && n <= 15000 ? (k < n / 3 ? this.SVDMode$1(SVDMode$module).LocalARPACK() : this.SVDMode$1(SVDMode$module).LocalLAPACK()) : this.SVDMode$1(SVDMode$module).DistARPACK();
                                    } else if ("local-svd".equals(string)) {
                                        value2 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                                    } else if ("local-eigs".equals(string)) {
                                        value2 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                    } else if ("dist-eigs".equals(string)) {
                                        value2 = this.SVDMode$1(SVDMode$module).DistARPACK();
                                    } else {
                                        throw new IllegalArgumentException(new StringBuilder(21).append("Do not support mode ").append(mode).append(".").toString());
                                    }
                                    value = computeMode = value2;
                                    Enumeration.Value value3 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                    Enumeration.Value value4 = value;
                                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block27;
                                    Predef$.MODULE$.require(k < n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("k must be smaller than n in local-eigs mode but got k=").append(k).append(" and n=").append(n).append(".").toString());
                                    breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                    tuple22 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)(Function1 & Serializable & scala.Serializable)v -> (breeze.linalg.DenseVector)G.$times(v, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), n, k, tol, maxIter);
                                    break block28;
                                }
                                Enumeration.Value value5 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                                Enumeration.Value value6 = value;
                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block29;
                                Predef$.MODULE$.require(n < 17515, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append(n).append(" exceeds the breeze svd capability").toString());
                                breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                sVD = (svd.SVD)svd$.MODULE$.apply((Object)G, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                                if (sVD == null) break block30;
                                breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                                sigmaSquaresFull = (breeze.linalg.DenseVector)sVD.singularValues();
                                if (uFull == null) break block30;
                                denseMatrix = uFull;
                                if (sigmaSquaresFull != null) break block31;
                            }
                            throw new MatchError((Object)sVD);
                        }
                        breeze.linalg.DenseVector denseVector2 = sigmaSquaresFull;
                        Tuple2 tuple23 = new Tuple2((Object)denseMatrix, (Object)denseVector2);
                        Tuple2 tuple24 = tuple23;
                        breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)tuple24._1();
                        breeze.linalg.DenseVector sigmaSquaresFull2 = (breeze.linalg.DenseVector)tuple24._2();
                        tuple22 = new Tuple2((Object)sigmaSquaresFull2, (Object)uFull);
                        break block28;
                    }
                    Enumeration.Value value7 = this.SVDMode$1(SVDMode$module).DistARPACK();
                    Enumeration.Value value8 = value;
                    if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                        StorageLevel storageLevel = this.rows().getStorageLevel();
                        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.");
                        }
                        Predef$.MODULE$.require(k < n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("k must be smaller than n in dist-eigs mode but got k=").append(k).append(" and n=").append(n).append(".").toString());
                        tuple22 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)(Function1 & Serializable & scala.Serializable)v -> this.multiplyGramianMatrixBy((breeze.linalg.DenseVector<Object>)v), n, k, tol, maxIter);
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block32;
                breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple2._1();
                u = (breeze.linalg.DenseMatrix)tuple2._2();
                if (sigmaSquares == null) break block32;
                denseVector = sigmaSquares;
                if (u != null) break block33;
            }
            throw new MatchError(tuple2);
        }
        breeze.linalg.DenseMatrix denseMatrix = u;
        Tuple2 tuple2 = new Tuple2((Object)denseVector, (Object)denseMatrix);
        Tuple2 tuple25 = tuple2;
        breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple25._1();
        breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple25._2();
        breeze.linalg.DenseVector sigmas = (breeze.linalg.DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares, package.sqrt$.MODULE$.fromLowOrderCanMapValues(breeze.linalg.DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, breeze.linalg.DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        double sigma0 = sigmas.apply$mcD$sp(0);
        double threshold = rCond * sigma0;
        int i = 0;
        if (sigmas.length() < k) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Requested ").append(k).append(" singular values but only found ").append(sigmas.length()).append(" converged.").toString());
        }
        while (i < package$.MODULE$.min(k, sigmas.length()) && sigmas.apply$mcD$sp(i) >= threshold) {
            ++i;
        }
        int sk = i;
        if (sk < k) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Requested ").append(k).append(" singular values but only found ").append(sk).append(" nonzeros.").toString());
        }
        Enumeration.Value value = computeMode;
        Enumeration.Value value9 = this.SVDMode$1(SVDMode$module).DistARPACK();
        if (!(value != null ? !value.equals(value9) : value9 != null)) {
            StorageLevel storageLevel = this.rows().getStorageLevel();
            StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
            if (!(storageLevel != null ? !storageLevel.equals(storageLevel3) : storageLevel3 != null)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.");
            }
        }
        Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
        Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
        if (computeU) {
            DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
            int i2 = 0;
            for (int j = 0; j < sk; ++j) {
                i2 = 0;
                double sigma = sigmas.apply$mcD$sp(j);
                while (i2 < n) {
                    int n2 = i2++;
                    int n3 = j;
                    N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                }
            }
            RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
            singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
        } else {
            singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(null, s, V);
        }
        return singularValueDecomposition;
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public Matrix computeCovariance() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        MultivariateStatisticalSummary summary = this.computeColumnSummaryStatistics();
        long m = summary.count();
        Predef$.MODULE$.require(m > 1L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("RowMatrix.computeCovariance called on matrix with only ").append(m).append(" rows.").append("  Cannot compute the covariance of a RowMatrix with <= 1 row.").toString());
        Vector mean = summary.mean();
        breeze.linalg.Matrix<Object> G = this.computeGramianMatrix().asBreeze();
        int j = 0;
        double m1 = (double)m - 1.0;
        double alpha = 0.0;
        for (int i = 0; i < n; ++i) {
            alpha = (double)m / m1 * mean.apply(i);
            for (j = i; j < n; ++j) {
                double Gij = G.apply$mcD$sp(i, j) / m1 - alpha * mean.apply(j);
                G.update$mcD$sp(i, j, Gij);
                G.update$mcD$sp(j, i, Gij);
            }
        }
        return Matrices$.MODULE$.fromBreeze(G);
    }

    public Tuple2<Matrix, Vector> computePrincipalComponentsAndExplainedVariance(int k) {
        breeze.linalg.DenseMatrix denseMatrix;
        breeze.linalg.DenseVector s;
        int n;
        block3: {
            svd.SVD sVD;
            block2: {
                n = (int)this.numCols();
                Predef$.MODULE$.require(k > 0 && k <= n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("k = ").append(k).append(" out of range (0, n = ").append(n).append("]").toString());
                breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().asBreeze();
                sVD = (svd.SVD)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                if (sVD == null) break block2;
                breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                s = (breeze.linalg.DenseVector)sVD.singularValues();
                if (u == null) break block2;
                denseMatrix = u;
                if (s != null) break block3;
            }
            throw new MatchError((Object)sVD);
        }
        breeze.linalg.DenseVector denseVector = s;
        Tuple2 tuple2 = new Tuple2((Object)denseMatrix, (Object)denseVector);
        Tuple2 tuple22 = tuple2;
        breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple22._1();
        breeze.linalg.DenseVector s2 = (breeze.linalg.DenseVector)tuple22._2();
        double eigenSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s2.data$mcD$sp())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double[] explainedVariance = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s2.data$mcD$sp())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / eigenSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return k == n ? new Tuple2((Object)Matrices$.MODULE$.dense(n, k, u.data$mcD$sp()), (Object)Vectors$.MODULE$.dense(explainedVariance)) : new Tuple2((Object)Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u.data$mcD$sp(), 0, n * k)), (Object)Vectors$.MODULE$.dense(Arrays.copyOfRange(explainedVariance, 0, k)));
    }

    public Matrix computePrincipalComponents(int k) {
        return (Matrix)this.computePrincipalComponentsAndExplainedVariance(k)._1();
    }

    /*
     * WARNING - void declaration
     */
    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        void var1_5;
        MultivariateOnlineSummarizer x$16 = new MultivariateOnlineSummarizer();
        Function2 & Serializable & scala.Serializable x$17 = (Function2 & Serializable & scala.Serializable)(aggregator, data) -> aggregator.add((Vector)data);
        Function2 & Serializable & scala.Serializable x$18 = (Function2 & Serializable & scala.Serializable)(aggregator1, aggregator2) -> aggregator1.merge((MultivariateOnlineSummarizer)aggregator2);
        int x$19 = this.rows().treeAggregate$default$4((Object)x$16);
        MultivariateOnlineSummarizer summary = (MultivariateOnlineSummarizer)this.rows().treeAggregate((Object)x$16, (Function2)x$17, (Function2)x$18, x$19, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        this.updateNumRows(summary.count());
        return var1_5;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        int k = B.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Dimension mismatch: ").append(n).append(" vs ").append(B.numRows()).toString());
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Only support dense matrix at this time but found ").append(B.getClass().getName()).append(".").toString());
        Broadcast Bb = this.rows().context().broadcast((Object)((breeze.linalg.DenseMatrix)B.asBreeze()).toDenseVector$mcD$sp().toArray$mcD$sp(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD AB = this.rows().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            double[] Bi = (double[])Bb.value();
            return iter.map((Function1 & Serializable & scala.Serializable)row -> {
                breeze.linalg.DenseVector v = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(k, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                for (int i = 0; i < k; ++i) {
                    v.update$mcD$sp(i, BoxesRunTime.unboxToDouble((Object)row.asBreeze().dot((Object)new DenseVector.mcD.sp(Bi, i * n, 1, n), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()))));
                }
                return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)v);
            });
        }, this.rows().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.nRows(), B.numCols());
    }

    public CoordinateMatrix columnSimilarities() {
        return this.columnSimilarities(0.0);
    }

    public CoordinateMatrix columnSimilarities(double threshold) {
        Predef$.MODULE$.require(threshold >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Threshold cannot be negative: ").append(threshold).toString());
        if (threshold > 1.0) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(132).append("Threshold is greater than 1: ").append(threshold).append(" ").append("Computation will be more efficient with promoted sparsity, ").append(" however there is no correctness guarantee.").toString());
        }
        double gamma = threshold < 1.0E-6 ? Double.POSITIVE_INFINITY : (double)10 * package$.MODULE$.log((double)this.numCols()) / threshold;
        return this.columnSimilaritiesDIMSUM(this.computeColumnSummaryStatistics().normL2().toArray(), gamma);
    }

    public QRDecomposition<RowMatrix, Matrix> tallSkinnyQR(boolean computeQ) {
        RowMatrix rowMatrix;
        int col = (int)this.numCols();
        RDD blockQRs = this.rows().retag(Vector.class).glom().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RowMatrix.$anonfun$tallSkinnyQR$1(x$5))).map((Function1 & Serializable & scala.Serializable)partRows -> {
            breeze.linalg.DenseMatrix bdm = DenseMatrix$.MODULE$.zeros$mDc$sp(((Vector[])partRows).length, col, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            IntRef i = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partRows)).foreach((Function1 & Serializable & scala.Serializable)row -> {
                RowMatrix.$anonfun$tallSkinnyQR$3(bdm, i, row);
                return BoxedUnit.UNIT;
            });
            return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)bdm, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
        }, ClassTag$.MODULE$.apply(breeze.linalg.DenseMatrix.class));
        breeze.linalg.DenseMatrix combinedR = (breeze.linalg.DenseMatrix)blockQRs.treeReduce((Function2 & Serializable & scala.Serializable)(r1, r2) -> {
            breeze.linalg.DenseMatrix stackedR = DenseMatrix$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new breeze.linalg.DenseMatrix[]{r1, r2}), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)stackedR, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
        }, blockQRs.treeReduce$default$2());
        Matrix finalR = Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)combinedR.toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
        if (computeQ) {
            try {
                breeze.linalg.DenseMatrix invR = (breeze.linalg.DenseMatrix)inv$.MODULE$.apply((Object)combinedR, inv$.MODULE$.canInvUsingLU_Double((UFunc.UImpl)LU.LU_DM_Impl_Double$.MODULE$));
                rowMatrix = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)invR));
            }
            catch (MatrixSingularException err) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "R is not invertible and return Q as null");
                rowMatrix = null;
            }
        } else {
            rowMatrix = null;
        }
        RowMatrix finalQ = rowMatrix;
        return new QRDecomposition<Object, Matrix>(finalQ, finalR);
    }

    public boolean tallSkinnyQR$default$1() {
        return false;
    }

    public CoordinateMatrix columnSimilaritiesDIMSUM(double[] colMags, double gamma) {
        Predef$.MODULE$.require(gamma > 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Oversampling should be greater than 1: ").append(gamma).toString());
        Predef$.MODULE$.require((long)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMags)).size() == this.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Number of magnitudes didn't match column dimension");
        double sg = package$.MODULE$.sqrt(gamma);
        double[] colMagsCorrected = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMags)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x == 0.0 ? 1.0 : x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        SparkContext sc = this.rows().context();
        Broadcast pBV = sc.broadcast(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMagsCorrected)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)c -> sg / c, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast qBV = sc.broadcast(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMagsCorrected)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)c -> package$.MODULE$.min(sg, c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD sims = RDD$.MODULE$.rddToPairRDDFunctions(this.rows().mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(indx, iter) -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$6(pBV, qBV, BoxesRunTime.unboxToInt((Object)indx), iter), this.rows().mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$6, x$7) -> x$6 + x$7).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double sim;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    sim = tuple22._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int i = tuple2._1$mcI$sp();
            int j = tuple2._2$mcI$sp();
            MatrixEntry matrixEntry = new MatrixEntry(i, j, sim);
            return matrixEntry;
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)sims, this.numCols(), this.numCols());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        IntRef i = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rows().collect())).foreach((Function1 & Serializable & scala.Serializable)vector -> {
            RowMatrix.$anonfun$toBreeze$1(mat, i, vector);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private void updateNumRows(long m) {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(m);
        } else {
            Predef$.MODULE$.require(this.nRows() == m, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("The number of rows ").append(m).append(" is different from what specified or previously computed: ").append(this.nRows()).append(".").toString());
        }
    }

    private static final /* synthetic */ RowMatrix$SVDMode$2$ SVDMode$lzycompute$1(LazyRef SVDMode$module$1) {
        RowMatrix$SVDMode$2$ rowMatrix$SVDMode$2$;
        LazyRef lazyRef = SVDMode$module$1;
        synchronized (lazyRef) {
            rowMatrix$SVDMode$2$ = SVDMode$module$1.initialized() ? (RowMatrix$SVDMode$2$)((Object)SVDMode$module$1.value()) : (RowMatrix$SVDMode$2$)((Object)SVDMode$module$1.initialize((Object)new RowMatrix$SVDMode$2$(null)));
        }
        return rowMatrix$SVDMode$2$;
    }

    private final RowMatrix$SVDMode$2$ SVDMode$1(LazyRef SVDMode$module$1) {
        return SVDMode$module$1.initialized() ? (RowMatrix$SVDMode$2$)((Object)SVDMode$module$1.value()) : RowMatrix.SVDMode$lzycompute$1(SVDMode$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$tallSkinnyQR$1(Vector[] x$5) {
        return x$5.length != 0;
    }

    public static final /* synthetic */ void $anonfun$tallSkinnyQR$3(breeze.linalg.DenseMatrix bdm$1, IntRef i$1, Vector row) {
        ((NumericOps)bdm$1.apply((Object)BoxesRunTime.boxToInteger((int)i$1.elem), (Object)scala.package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).$colon$eq(row.asBreeze().t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms())), Transpose$.MODULE$.liftInPlaceOps((UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_InPlaceOp_Double_OpSet()));
        ++i$1.elem;
    }

    public static final /* synthetic */ ListBuffer $anonfun$columnSimilaritiesDIMSUM$8(double[] p$1, XORShiftRandom rand$1, double[] scaled$1, int[] indices$1, int nnz$1, int k) {
        ListBuffer buf = new ListBuffer();
        int i = indices$1[k];
        double iVal = scaled$1[k];
        if (iVal != 0.0 && rand$1.nextDouble() < p$1[i]) {
            for (int l = k + 1; l < nnz$1; ++l) {
                int j = indices$1[l];
                double jVal = scaled$1[l];
                Object object = jVal != 0.0 && rand$1.nextDouble() < p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
            }
        }
        return buf;
    }

    public static final /* synthetic */ ListBuffer $anonfun$columnSimilaritiesDIMSUM$9(double[] p$1, XORShiftRandom rand$1, double[] scaled$1, int n$4, int i) {
        ListBuffer buf = new ListBuffer();
        double iVal = scaled$1[i];
        if (iVal != 0.0 && rand$1.nextDouble() < p$1[i]) {
            for (int j = i + 1; j < n$4; ++j) {
                double jVal = scaled$1[j];
                Object object = jVal != 0.0 && rand$1.nextDouble() < p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
            }
        }
        return buf;
    }

    public static final /* synthetic */ Iterator $anonfun$columnSimilaritiesDIMSUM$6(Broadcast pBV$1, Broadcast qBV$1, int indx, Iterator iter) {
        double[] p = (double[])pBV$1.value();
        double[] q = (double[])qBV$1.value();
        XORShiftRandom rand = new XORShiftRandom((long)indx);
        double[] scaled = new double[new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).size()];
        return iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
            DenseVector denseVector;
            Option<double[]> option;
            Iterator iterator;
            SparseVector sparseVector;
            Option<Tuple3<Object, int[], double[]>> option2;
            Vector vector = row;
            if (vector instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] values = (double[])((Tuple3)option2.get())._3();
                int nnz = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).size();
                for (int k2 = 0; k2 < nnz; ++k2) {
                    scaled$1[k2] = values[k2] / q[indices[k2]];
                }
                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(nnz, (Function1 & Serializable & scala.Serializable)k -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$8(p, rand, scaled, indices, nnz, BoxesRunTime.unboxToInt((Object)k))), (Function1)Predef$.MODULE$.$conforms()).flatten();
            } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                double[] values = (double[])option.get();
                int n = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).size();
                for (int i2 = 0; i2 < n; ++i2) {
                    scaled$1[i2] = values[i2] / q[i2];
                }
                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(n, (Function1 & Serializable & scala.Serializable)i -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$9(p, rand, scaled, n, BoxesRunTime.unboxToInt((Object)i))), (Function1)Predef$.MODULE$.$conforms()).flatten();
            } else {
                throw new MatchError((Object)vector);
            }
            return iterator;
        });
    }

    public static final /* synthetic */ void $anonfun$toBreeze$1(breeze.linalg.DenseMatrix mat$1, IntRef i$2, Vector vector) {
        vector.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int j = sp2._1$mcI$sp();
            double v = sp2._2$mcD$sp();
            mat$1.update$mcD$sp(i$2.elem, j, v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        ++i$2.elem;
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.nRows = nRows;
        this.nCols = nCols;
        Logging.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

