/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.pmml.export;

import java.io.Serializable;
import org.apache.spark.mllib.pmml.export.PMMLModelExport;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.spark_project.dmg.pmml.DataDictionary;
import org.spark_project.dmg.pmml.DataField;
import org.spark_project.dmg.pmml.DataType;
import org.spark_project.dmg.pmml.FieldName;
import org.spark_project.dmg.pmml.FieldUsageType;
import org.spark_project.dmg.pmml.MiningField;
import org.spark_project.dmg.pmml.MiningFunctionType;
import org.spark_project.dmg.pmml.MiningSchema;
import org.spark_project.dmg.pmml.NumericPredictor;
import org.spark_project.dmg.pmml.OpType;
import org.spark_project.dmg.pmml.PMML;
import org.spark_project.dmg.pmml.RegressionModel;
import org.spark_project.dmg.pmml.RegressionNormalizationMethodType;
import org.spark_project.dmg.pmml.RegressionTable;
import scala.Double$;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001-3Q!\u0001\u0002\u0001\r9\u00111EQ5oCJL8\t\\1tg&4\u0017nY1uS>t\u0007+T'M\u001b>$W\r\\#ya>\u0014HO\u0003\u0002\u0004\t\u00051Q\r\u001f9peRT!!\u0002\u0004\u0002\tAlW\u000e\u001c\u0006\u0003\u000f!\tQ!\u001c7mS\nT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\t!!\u0003\u0002\u0019\u0005\ty\u0001+T'M\u001b>$W\r\\#ya>\u0014H\u000f\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0015iw\u000eZ3m\u0007\u0001\u0001\"!\b\u0011\u000e\u0003yQ!a\b\u0004\u0002\u0015I,wM]3tg&|g.\u0003\u0002\"=\t1r)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:N_\u0012,G\u000e\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003-!Wm]2sSB$\u0018n\u001c8\u0011\u0005\u0015bcB\u0001\u0014+!\t9\u0013#D\u0001)\u0015\tI3$\u0001\u0004=e>|GOP\u0005\u0003WE\ta\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111&\u0005\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005\u0019bn\u001c:nC2L'0\u0019;j_:lU\r\u001e5pIB\u0011!GN\u0007\u0002g)\u0011Q\u0001\u000e\u0006\u0003k1\t1\u0001Z7h\u0013\t94GA\u0011SK\u001e\u0014Xm]:j_:tuN]7bY&T\u0018\r^5p]6+G\u000f[8e)f\u0004X\r\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0003%!\bN]3tQ>dG\r\u0005\u0002\u0011w%\u0011A(\u0005\u0002\u0007\t>,(\r\\3\t\u000by\u0002A\u0011A \u0002\rqJg.\u001b;?)\u0015\u0001\u0015IQ\"E!\t1\u0002\u0001C\u0003\u001b{\u0001\u0007A\u0004C\u0003${\u0001\u0007A\u0005C\u00031{\u0001\u0007\u0011\u0007C\u0003:{\u0001\u0007!\bC\u0003G\u0001\u0011%q)\u0001\u0011q_B,H.\u0019;f\u0005&t\u0017M]=DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8Q\u001b6cE#\u0001%\u0011\u0005AI\u0015B\u0001&\u0012\u0005\u0011)f.\u001b;")
public class BinaryClassificationPMMLModelExport
implements PMMLModelExport {
    private final GeneralizedLinearModel model;
    private final String description;
    private final RegressionNormalizationMethodType normalizationMethod;
    private final double threshold;
    private final PMML pmml;

    @Override
    public PMML getPmml() {
        return PMMLModelExport.getPmml$(this);
    }

    @Override
    public PMML pmml() {
        return this.pmml;
    }

    @Override
    public void org$apache$spark$mllib$pmml$export$PMMLModelExport$_setter_$pmml_$eq(PMML x$1) {
        this.pmml = x$1;
    }

    private void populateBinaryClassificationPMML() {
        block1: {
            this.pmml().getHeader().setDescription(this.description);
            if (this.model.weights().size() <= 0) break block1;
            FieldName[] fields = new FieldName[this.model.weights().size()];
            DataDictionary dataDictionary = new DataDictionary();
            MiningSchema miningSchema = new MiningSchema();
            RegressionTable regressionTableYES = new RegressionTable(this.model.intercept()).setTargetCategory("1");
            double interceptNO = this.threshold;
            if (((Object)((Object)RegressionNormalizationMethodType.LOGIT)).equals((Object)this.normalizationMethod)) {
                interceptNO = this.threshold <= 0.0 ? Double$.MODULE$.MinValue() : (this.threshold >= 1.0 ? Double.MAX_VALUE : -package$.MODULE$.log(1.0 / this.threshold - 1.0));
            }
            RegressionTable regressionTableNO = new RegressionTable(interceptNO).setTargetCategory("0");
            RegressionModel regressionModel = new RegressionModel().setFunctionName(MiningFunctionType.CLASSIFICATION).setMiningSchema(miningSchema).setModelName(this.description).setNormalizationMethod(this.normalizationMethod).addRegressionTables(regressionTableYES, regressionTableNO);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.model.weights().size()).foreach((Function1 & Serializable & scala.Serializable)i -> BinaryClassificationPMMLModelExport.$anonfun$populateBinaryClassificationPMML$1(this, fields, dataDictionary, miningSchema, regressionTableYES, BoxesRunTime.unboxToInt((Object)i)));
            FieldName targetField = FieldName.create("target");
            dataDictionary.addDataFields(new DataField(targetField, OpType.CATEGORICAL, DataType.STRING));
            miningSchema.addMiningFields(new MiningField(targetField).setUsageType(FieldUsageType.TARGET));
            dataDictionary.setNumberOfFields(Predef$.MODULE$.int2Integer(dataDictionary.getDataFields().size()));
            this.pmml().setDataDictionary(dataDictionary);
            this.pmml().addModels(regressionModel);
        }
    }

    public static final /* synthetic */ RegressionTable $anonfun$populateBinaryClassificationPMML$1(BinaryClassificationPMMLModelExport $this, FieldName[] fields$1, DataDictionary dataDictionary$1, MiningSchema miningSchema$1, RegressionTable regressionTableYES$1, int i) {
        fields$1[i] = FieldName.create(new StringBuilder(6).append("field_").append(i).toString());
        dataDictionary$1.addDataFields(new DataField(fields$1[i], OpType.CONTINUOUS, DataType.DOUBLE));
        miningSchema$1.addMiningFields(new MiningField(fields$1[i]).setUsageType(FieldUsageType.ACTIVE));
        return regressionTableYES$1.addNumericPredictors(new NumericPredictor(fields$1[i], $this.model.weights().apply(i)));
    }

    public BinaryClassificationPMMLModelExport(GeneralizedLinearModel model, String description, RegressionNormalizationMethodType normalizationMethod, double threshold) {
        this.model = model;
        this.description = description;
        this.normalizationMethod = normalizationMethod;
        this.threshold = threshold;
        PMMLModelExport.$init$(this);
        this.populateBinaryClassificationPMML();
    }
}

