/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALS$Rating$mcI$sp;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r=a\u0001B\u0001\u0003\u00015\u00111!\u0011'T\u0015\t\u0019A!\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001H\r\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001BA\u0002\u0013%q$A\u0007ok6,6/\u001a:CY>\u001c7n]\u000b\u0002AA\u0011q\"I\u0005\u0003EA\u00111!\u00138u\u0011!!\u0003A!a\u0001\n\u0013)\u0013!\u00058v[V\u001bXM\u001d\"m_\u000e\\7o\u0018\u0013fcR\u0011a%\u000b\t\u0003\u001f\u001dJ!\u0001\u000b\t\u0003\tUs\u0017\u000e\u001e\u0005\bU\r\n\t\u00111\u0001!\u0003\rAH%\r\u0005\tY\u0001\u0011\t\u0011)Q\u0005A\u0005qa.^7Vg\u0016\u0014(\t\\8dWN\u0004\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0007I\u0011B\u0010\u0002!9,X\u000e\u0015:pIV\u001cGO\u00117pG.\u001c\b\u0002\u0003\u0019\u0001\u0005\u0003\u0007I\u0011B\u0019\u0002)9,X\u000e\u0015:pIV\u001cGO\u00117pG.\u001cx\fJ3r)\t1#\u0007C\u0004+_\u0005\u0005\t\u0019\u0001\u0011\t\u0011Q\u0002!\u0011!Q!\n\u0001\n\u0011C\\;n!J|G-^2u\u00052|7m[:!\u0011!1\u0004A!a\u0001\n\u0013y\u0012\u0001\u0002:b].D\u0001\u0002\u000f\u0001\u0003\u0002\u0004%I!O\u0001\te\u0006t7n\u0018\u0013fcR\u0011aE\u000f\u0005\bU]\n\t\u00111\u0001!\u0011!a\u0004A!A!B\u0013\u0001\u0013!\u0002:b].\u0004\u0003\u0002\u0003 \u0001\u0005\u0003\u0007I\u0011B\u0010\u0002\u0015%$XM]1uS>t7\u000f\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0003B\u00039IG/\u001a:bi&|gn]0%KF$\"A\n\"\t\u000f)z\u0014\u0011!a\u0001A!AA\t\u0001B\u0001B\u0003&\u0001%A\u0006ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003$\u0001\u0005\u0003\u0007I\u0011B$\u0002\r1\fWN\u00193b+\u0005A\u0005CA\bJ\u0013\tQ\u0005C\u0001\u0004E_V\u0014G.\u001a\u0005\t\u0019\u0002\u0011\t\u0019!C\u0005\u001b\u0006QA.Y7cI\u0006|F%Z9\u0015\u0005\u0019r\u0005b\u0002\u0016L\u0003\u0003\u0005\r\u0001\u0013\u0005\t!\u0002\u0011\t\u0011)Q\u0005\u0011\u00069A.Y7cI\u0006\u0004\u0003\u0002\u0003*\u0001\u0005\u0003\u0007I\u0011B*\u0002\u001b%l\u0007\u000f\\5dSR\u0004&/\u001a4t+\u0005!\u0006CA\bV\u0013\t1\u0006CA\u0004C_>dW-\u00198\t\u0011a\u0003!\u00111A\u0005\ne\u000b\u0011#[7qY&\u001c\u0017\u000e\u001e)sK\u001a\u001cx\fJ3r)\t1#\fC\u0004+/\u0006\u0005\t\u0019\u0001+\t\u0011q\u0003!\u0011!Q!\nQ\u000ba\"[7qY&\u001c\u0017\u000e\u001e)sK\u001a\u001c\b\u0005\u0003\u0005_\u0001\t\u0005\r\u0011\"\u0003H\u0003\u0015\tG\u000e\u001d5b\u0011!\u0001\u0007A!a\u0001\n\u0013\t\u0017!C1ma\"\fw\fJ3r)\t1#\rC\u0004+?\u0006\u0005\t\u0019\u0001%\t\u0011\u0011\u0004!\u0011!Q!\n!\u000ba!\u00197qQ\u0006\u0004\u0003\u0002\u00034\u0001\u0005\u0003\u0007I\u0011B4\u0002\tM,W\rZ\u000b\u0002QB\u0011q\"[\u0005\u0003UB\u0011A\u0001T8oO\"AA\u000e\u0001BA\u0002\u0013%Q.\u0001\u0005tK\u0016$w\fJ3r)\t1c\u000eC\u0004+W\u0006\u0005\t\u0019\u00015\t\u0011A\u0004!\u0011!Q!\n!\fQa]3fI\u0002BQA\u001d\u0001\u0005\nM\fa\u0001P5oSRtD#\u0003;wobL(p\u001f?~!\t)\b!D\u0001\u0003\u0011\u0015q\u0012\u000f1\u0001!\u0011\u0015q\u0013\u000f1\u0001!\u0011\u00151\u0014\u000f1\u0001!\u0011\u0015q\u0014\u000f1\u0001!\u0011\u00151\u0015\u000f1\u0001I\u0011\u0015\u0011\u0016\u000f1\u0001U\u0011\u0015q\u0016\u000f1\u0001I\u0011\u001d1\u0017\u000f%AA\u0002!DQA\u001d\u0001\u0005\u0002}$\u0012\u0001\u001e\u0015\u0006}\u0006\r\u0011q\u0002\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0005\u001d!!B*j]\u000e,\u0017EAA\t\u0003\u0015\u0001d\u0006\u000f\u00181\u0011!\t)\u0002\u0001a\u0001\n\u0013\u0019\u0016a\u00038p]:,w-\u0019;jm\u0016D\u0011\"!\u0007\u0001\u0001\u0004%I!a\u0007\u0002\u001f9|gN\\3hCRLg/Z0%KF$2AJA\u000f\u0011!Q\u0013qCA\u0001\u0002\u0004!\u0006bBA\u0011\u0001\u0001\u0006K\u0001V\u0001\r]>tg.Z4bi&4X\r\t\u0005\n\u0003K\u0001\u0001\u0019!C\u0005\u0003O\t1$\u001b8uKJlW\rZ5bi\u0016\u0014F\tR*u_J\fw-\u001a'fm\u0016dWCAA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\r\u000591\u000f^8sC\u001e,\u0017\u0002BA\u001a\u0003[\u0011Ab\u0015;pe\u0006<W\rT3wK2D\u0011\"a\u000e\u0001\u0001\u0004%I!!\u000f\u0002?%tG/\u001a:nK\u0012L\u0017\r^3S\t\u0012\u001bFo\u001c:bO\u0016dUM^3m?\u0012*\u0017\u000fF\u0002'\u0003wA\u0011BKA\u001b\u0003\u0003\u0005\r!!\u000b\t\u0011\u0005}\u0002\u0001)Q\u0005\u0003S\tA$\u001b8uKJlW\rZ5bi\u0016\u0014F\tR*u_J\fw-\u001a'fm\u0016d\u0007\u0005C\u0005\u0002D\u0001\u0001\r\u0011\"\u0003\u0002(\u0005!b-\u001b8bYJ#Ei\u0015;pe\u0006<W\rT3wK2D\u0011\"a\u0012\u0001\u0001\u0004%I!!\u0013\u00021\u0019Lg.\u00197S\t\u0012\u001bFo\u001c:bO\u0016dUM^3m?\u0012*\u0017\u000fF\u0002'\u0003\u0017B\u0011BKA#\u0003\u0003\u0005\r!!\u000b\t\u0011\u0005=\u0003\u0001)Q\u0005\u0003S\tQCZ5oC2\u0014F\tR*u_J\fw-\u001a'fm\u0016d\u0007\u0005\u0003\u0005\u0002T\u0001\u0001\r\u0011\"\u0003 \u0003I\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197\t\u0013\u0005]\u0003\u00011A\u0005\n\u0005e\u0013AF2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2|F%Z9\u0015\u0007\u0019\nY\u0006\u0003\u0005+\u0003+\n\t\u00111\u0001!\u0011\u001d\ty\u0006\u0001Q!\n\u0001\n1c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY\u0002Bq!a\u0019\u0001\t\u0003\t)'A\u0005tKR\u0014En\\2lgR!\u0011qMA5\u001b\u0005\u0001\u0001bBA6\u0003C\u0002\r\u0001I\u0001\n]Vl'\t\\8dWNDc!!\u0019\u0002\u0004\u0005=\u0001bBA9\u0001\u0011\u0005\u00111O\u0001\u000eg\u0016$Xk]3s\u00052|7m[:\u0015\t\u0005\u001d\u0014Q\u000f\u0005\u0007=\u0005=\u0004\u0019\u0001\u0011)\r\u0005=\u00141AA=C\t\tY(A\u00032]Er\u0003\u0007C\u0004\u0002\u0000\u0001!\t!!!\u0002!M,G\u000f\u0015:pIV\u001cGO\u00117pG.\u001cH\u0003BA4\u0003\u0007CaALA?\u0001\u0004\u0001\u0003FBA?\u0003\u0007\tI\bC\u0004\u0002\n\u0002!\t!a#\u0002\u000fM,GOU1oWR!\u0011qMAG\u0011\u00191\u0014q\u0011a\u0001A!2\u0011qQA\u0002\u0003\u001fAq!a%\u0001\t\u0003\t)*A\u0007tKRLE/\u001a:bi&|gn\u001d\u000b\u0005\u0003O\n9\n\u0003\u0004?\u0003#\u0003\r\u0001\t\u0015\u0007\u0003#\u000b\u0019!a\u0004\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \u0006I1/\u001a;MC6\u0014G-\u0019\u000b\u0005\u0003O\n\t\u000b\u0003\u0004G\u00037\u0003\r\u0001\u0013\u0015\u0007\u00037\u000b\u0019!a\u0004\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006\u00012/\u001a;J[Bd\u0017nY5u!J,gm\u001d\u000b\u0005\u0003O\nY\u000b\u0003\u0004S\u0003K\u0003\r\u0001\u0016\u0015\u0007\u0003K\u000b\u0019!a,\"\u0005\u0005E\u0016!\u0002\u0019/q9\n\u0004bBA[\u0001\u0011\u0005\u0011qW\u0001\tg\u0016$\u0018\t\u001c9iCR!\u0011qMA]\u0011\u0019q\u00161\u0017a\u0001\u0011\"2\u00111WA\u0002\u0003_Cq!a0\u0001\t\u0003\t\t-A\u0004tKR\u001cV-\u001a3\u0015\t\u0005\u001d\u00141\u0019\u0005\u0007M\u0006u\u0006\u0019\u00015)\r\u0005u\u00161AAdC\t\tI-A\u00032]Ar\u0003\u0007C\u0004\u0002N\u0002!\t!a4\u0002\u001dM,GOT8o]\u0016<\u0017\r^5wKR!\u0011qMAi\u0011\u001d\t\u0019.a3A\u0002Q\u000b\u0011A\u0019\u0015\u0007\u0003\u0017\f\u0019!!\u001f\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\u0006q2/\u001a;J]R,'/\\3eS\u0006$XM\u0015#E'R|'/Y4f\u0019\u00164X\r\u001c\u000b\u0005\u0003O\ni\u000e\u0003\u0005\u0002`\u0006]\u0007\u0019AA\u0015\u00031\u0019Ho\u001c:bO\u0016dUM^3mQ\u0019\t9.a\u0001\u0002z!\"\u0011q[As!\u0011\t)!a:\n\t\u0005%\u0018q\u0001\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0005\b\u0003[\u0004A\u0011AAx\u0003]\u0019X\r\u001e$j]\u0006d'\u000b\u0012#Ti>\u0014\u0018mZ3MKZ,G\u000e\u0006\u0003\u0002h\u0005E\b\u0002CAp\u0003W\u0004\r!!\u000b)\r\u0005-\u00181AA{C\t\t90A\u00032]Mr\u0003\u0007\u000b\u0003\u0002l\u0006\u0015\bbBA\u007f\u0001\u0011\u0005\u0011q`\u0001\u0016g\u0016$8\t[3dWB|\u0017N\u001c;J]R,'O^1m)\u0011\t9G!\u0001\t\u000f\u0005M\u00131 a\u0001A!2\u00111`A\u0002\u0005\u000b\t#Aa\u0002\u0002\u000bErCG\f\u0019)\t\u0005m\u0018Q\u001d\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0003\r\u0011XO\u001c\u000b\u0005\u0005#\u00119\u0002E\u0002v\u0005'I1A!\u0006\u0003\u0005ai\u0015\r\u001e:jq\u001a\u000b7\r^8sSj\fG/[8o\u001b>$W\r\u001c\u0005\t\u00053\u0011Y\u00011\u0001\u0003\u001c\u00059!/\u0019;j]\u001e\u001c\bC\u0002B\u000f\u0005G\u00119#\u0004\u0002\u0003 )\u0019!\u0011\u0005\u0004\u0002\u0007I$G-\u0003\u0003\u0003&\t}!a\u0001*E\tB\u0019QO!\u000b\n\u0007\t-\"A\u0001\u0004SCRLgn\u001a\u0015\u0007\u0005\u0017\t\u0019!a\u0004\t\u000f\t5\u0001\u0001\"\u0001\u00032Q!!\u0011\u0003B\u001a\u0011!\u0011IBa\fA\u0002\tU\u0002C\u0002B\u001c\u0005\u0003\u00129#\u0004\u0002\u0003:)!!1\bB\u001f\u0003\u0011Q\u0017M^1\u000b\u0007\t}b!A\u0002ba&LAAa\u0011\u0003:\t9!*\u0019<b%\u0012#\u0005F\u0002B\u0018\u0003\u0007\t)\u0010K\u0003\u0001\u0003\u0007\tyaB\u0004\u0003L\tA\tA!\u0014\u0002\u0007\u0005c5\u000bE\u0002v\u0005\u001f2a!\u0001\u0002\t\u0002\tE3\u0003\u0002B(\u001dQAqA\u001dB(\t\u0003\u0011)\u0006\u0006\u0002\u0003N!A!\u0011\fB(\t\u0003\u0011Y&A\u0003ue\u0006Lg\u000e\u0006\b\u0003\u0012\tu#q\fB1\u0005G\u0012)G!\u001b\t\u0011\te!q\u000ba\u0001\u00057AaA\u000eB,\u0001\u0004\u0001\u0003B\u0002 \u0003X\u0001\u0007\u0001\u0005\u0003\u0004G\u0005/\u0002\r\u0001\u0013\u0005\b\u0005O\u00129\u00061\u0001!\u0003\u0019\u0011Gn\\2lg\"1aMa\u0016A\u0002!DcAa\u0016\u0002\u0004\t5\u0014E\u0001B8\u0003\u0015\u0001d&\u000f\u00182\u0011!\u0011IFa\u0014\u0005\u0002\tMD\u0003\u0004B\t\u0005k\u00129H!\u001f\u0003|\tu\u0004\u0002\u0003B\r\u0005c\u0002\rAa\u0007\t\rY\u0012\t\b1\u0001!\u0011\u0019q$\u0011\u000fa\u0001A!1aI!\u001dA\u0002!CqAa\u001a\u0003r\u0001\u0007\u0001\u0005\u000b\u0004\u0003r\u0005\r\u0011q\u0002\u0005\t\u00053\u0012y\u0005\"\u0001\u0003\u0004RQ!\u0011\u0003BC\u0005\u000f\u0013IIa#\t\u0011\te!\u0011\u0011a\u0001\u00057AaA\u000eBA\u0001\u0004\u0001\u0003B\u0002 \u0003\u0002\u0002\u0007\u0001\u0005\u0003\u0004G\u0005\u0003\u0003\r\u0001\u0013\u0015\u0007\u0005\u0003\u000b\u0019!a\u0004\t\u0011\te#q\nC\u0001\u0005##\u0002B!\u0005\u0003\u0014\nU%q\u0013\u0005\t\u00053\u0011y\t1\u0001\u0003\u001c!1aGa$A\u0002\u0001BaA\u0010BH\u0001\u0004\u0001\u0003F\u0002BH\u0003\u0007\ty\u0001\u0003\u0005\u0003\u001e\n=C\u0011\u0001BP\u00035!(/Y5o\u00136\u0004H.[2jiR\u0001\"\u0011\u0003BQ\u0005G\u0013)Ka*\u0003*\n-&Q\u0016\u0005\t\u00053\u0011Y\n1\u0001\u0003\u001c!1aGa'A\u0002\u0001BaA\u0010BN\u0001\u0004\u0001\u0003B\u0002$\u0003\u001c\u0002\u0007\u0001\nC\u0004\u0003h\tm\u0005\u0019\u0001\u0011\t\ry\u0013Y\n1\u0001I\u0011\u00191'1\u0014a\u0001Q\"2!1TA\u0002\u0003_C\u0001B!(\u0003P\u0011\u0005!1\u0017\u000b\u000f\u0005#\u0011)La.\u0003:\nm&Q\u0018B`\u0011!\u0011IB!-A\u0002\tm\u0001B\u0002\u001c\u00032\u0002\u0007\u0001\u0005\u0003\u0004?\u0005c\u0003\r\u0001\t\u0005\u0007\r\nE\u0006\u0019\u0001%\t\u000f\t\u001d$\u0011\u0017a\u0001A!1aL!-A\u0002!CcA!-\u0002\u0004\u0005=\u0006\u0002\u0003BO\u0005\u001f\"\tA!2\u0015\u0019\tE!q\u0019Be\u0005\u0017\u0014iMa4\t\u0011\te!1\u0019a\u0001\u00057AaA\u000eBb\u0001\u0004\u0001\u0003B\u0002 \u0003D\u0002\u0007\u0001\u0005\u0003\u0004G\u0005\u0007\u0004\r\u0001\u0013\u0005\u0007=\n\r\u0007\u0019\u0001%)\r\t\r\u00171AAX\u0011!\u0011iJa\u0014\u0005\u0002\tUG\u0003\u0003B\t\u0005/\u0014INa7\t\u0011\te!1\u001ba\u0001\u00057AaA\u000eBj\u0001\u0004\u0001\u0003B\u0002 \u0003T\u0002\u0007\u0001\u0005\u000b\u0004\u0003T\u0006\r\u0011q\u0016\u0005\u000b\u0005C\u0014y%%A\u0005\n\t\r\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003f*\u001a\u0001Na:,\u0005\t%\b\u0003\u0002Bv\u0005gl!A!<\u000b\t\t=(\u0011_\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0003\u0011\u0013\u0011\u0011)P!<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0003z\n=\u0013\u0011!C\u0005\u0005w\f1B]3bIJ+7o\u001c7wKR\u0011!Q \t\u0005\u0005\u007f\u001c9!\u0004\u0002\u0004\u0002)!11AB\u0003\u0003\u0011a\u0017M\\4\u000b\u0005\tm\u0012\u0002BB\u0005\u0007\u0003\u0011aa\u00142kK\u000e$\bF\u0002B(\u0003\u0007\ty\u0001\u000b\u0004\u0003J\u0005\r\u0011q\u0002")
public class ALS
implements scala.Serializable,
Logging {
    private int numUserBlocks;
    private int numProductBlocks;
    private int rank;
    private int iterations;
    private double lambda;
    private boolean implicitPrefs;
    private double alpha;
    private long seed;
    private boolean nonnegative;
    private StorageLevel intermediateRDDStorageLevel;
    private StorageLevel finalRDDStorageLevel;
    private int checkpointInterval;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MatrixFactorizationModel trainImplicit(RDD<Rating> rDD, int n, int n2) {
        return ALS$.MODULE$.trainImplicit(rDD, n, n2);
    }

    public static MatrixFactorizationModel trainImplicit(RDD<Rating> rDD, int n, int n2, double d, double d2) {
        return ALS$.MODULE$.trainImplicit(rDD, n, n2, d, d2);
    }

    public static MatrixFactorizationModel trainImplicit(RDD<Rating> rDD, int n, int n2, double d, int n3, double d2) {
        return ALS$.MODULE$.trainImplicit(rDD, n, n2, d, n3, d2);
    }

    public static MatrixFactorizationModel trainImplicit(RDD<Rating> rDD, int n, int n2, double d, int n3, double d2, long l) {
        return ALS$.MODULE$.trainImplicit(rDD, n, n2, d, n3, d2, l);
    }

    public static MatrixFactorizationModel train(RDD<Rating> rDD, int n, int n2) {
        return ALS$.MODULE$.train(rDD, n, n2);
    }

    public static MatrixFactorizationModel train(RDD<Rating> rDD, int n, int n2, double d) {
        return ALS$.MODULE$.train(rDD, n, n2, d);
    }

    public static MatrixFactorizationModel train(RDD<Rating> rDD, int n, int n2, double d, int n3) {
        return ALS$.MODULE$.train(rDD, n, n2, d, n3);
    }

    public static MatrixFactorizationModel train(RDD<Rating> rDD, int n, int n2, double d, int n3, long l) {
        return ALS$.MODULE$.train(rDD, n, n2, d, n3, l);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int numUserBlocks() {
        return this.numUserBlocks;
    }

    private void numUserBlocks_$eq(int x$1) {
        this.numUserBlocks = x$1;
    }

    private int numProductBlocks() {
        return this.numProductBlocks;
    }

    private void numProductBlocks_$eq(int x$1) {
        this.numProductBlocks = x$1;
    }

    private int rank() {
        return this.rank;
    }

    private void rank_$eq(int x$1) {
        this.rank = x$1;
    }

    private int iterations() {
        return this.iterations;
    }

    private void iterations_$eq(int x$1) {
        this.iterations = x$1;
    }

    private double lambda() {
        return this.lambda;
    }

    private void lambda_$eq(double x$1) {
        this.lambda = x$1;
    }

    private boolean implicitPrefs() {
        return this.implicitPrefs;
    }

    private void implicitPrefs_$eq(boolean x$1) {
        this.implicitPrefs = x$1;
    }

    private double alpha() {
        return this.alpha;
    }

    private void alpha_$eq(double x$1) {
        this.alpha = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private boolean nonnegative() {
        return this.nonnegative;
    }

    private void nonnegative_$eq(boolean x$1) {
        this.nonnegative = x$1;
    }

    private StorageLevel intermediateRDDStorageLevel() {
        return this.intermediateRDDStorageLevel;
    }

    private void intermediateRDDStorageLevel_$eq(StorageLevel x$1) {
        this.intermediateRDDStorageLevel = x$1;
    }

    private StorageLevel finalRDDStorageLevel() {
        return this.finalRDDStorageLevel;
    }

    private void finalRDDStorageLevel_$eq(StorageLevel x$1) {
        this.finalRDDStorageLevel = x$1;
    }

    private int checkpointInterval() {
        return this.checkpointInterval;
    }

    private void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    public ALS setBlocks(int numBlocks) {
        Predef$.MODULE$.require(numBlocks == -1 || numBlocks > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Number of blocks must be -1 or positive but got ").append(numBlocks).toString());
        this.numUserBlocks_$eq(numBlocks);
        this.numProductBlocks_$eq(numBlocks);
        return this;
    }

    public ALS setUserBlocks(int numUserBlocks) {
        Predef$.MODULE$.require(numUserBlocks == -1 || numUserBlocks > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Number of blocks must be -1 or positive but got ").append(numUserBlocks).toString());
        this.numUserBlocks_$eq(numUserBlocks);
        return this;
    }

    public ALS setProductBlocks(int numProductBlocks) {
        Predef$.MODULE$.require(numProductBlocks == -1 || numProductBlocks > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Number of product blocks must be -1 or positive but got ").append(numProductBlocks).toString());
        this.numProductBlocks_$eq(numProductBlocks);
        return this;
    }

    public ALS setRank(int rank) {
        Predef$.MODULE$.require(rank > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Rank of the feature matrices must be positive but got ").append(rank).toString());
        this.rank_$eq(rank);
        return this;
    }

    public ALS setIterations(int iterations) {
        Predef$.MODULE$.require(iterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Number of iterations must be nonnegative but got ").append(iterations).toString());
        this.iterations_$eq(iterations);
        return this;
    }

    public ALS setLambda(double lambda) {
        Predef$.MODULE$.require(lambda >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Regularization parameter must be nonnegative but got ").append(lambda).toString());
        this.lambda_$eq(lambda);
        return this;
    }

    public ALS setImplicitPrefs(boolean implicitPrefs) {
        this.implicitPrefs_$eq(implicitPrefs);
        return this;
    }

    public ALS setAlpha(double alpha) {
        this.alpha_$eq(alpha);
        return this;
    }

    public ALS setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public ALS setNonnegative(boolean b) {
        this.nonnegative_$eq(b);
        return this;
    }

    @DeveloperApi
    public ALS setIntermediateRDDStorageLevel(StorageLevel storageLevel) {
        StorageLevel storageLevel2 = storageLevel;
        StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
        Predef$.MODULE$.require(storageLevel2 == null ? storageLevel3 != null : !storageLevel2.equals(storageLevel3), (Function0 & Serializable & scala.Serializable)() -> "ALS is not designed to run without persisting intermediate RDDs.");
        this.intermediateRDDStorageLevel_$eq(storageLevel);
        return this;
    }

    @DeveloperApi
    public ALS setFinalRDDStorageLevel(StorageLevel storageLevel) {
        this.finalRDDStorageLevel_$eq(storageLevel);
        return this;
    }

    @DeveloperApi
    public ALS setCheckpointInterval(int checkpointInterval) {
        this.checkpointInterval_$eq(checkpointInterval);
        return this;
    }

    public MatrixFactorizationModel run(RDD<Rating> ratings) {
        Object object;
        Predef$.MODULE$.require(!ratings.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("No ratings available from ").append(ratings).toString());
        SparkContext sc = ratings.context();
        int numUserBlocks = this.numUserBlocks() == -1 ? package$.MODULE$.max(sc.defaultParallelism(), ratings.partitions().length / 2) : this.numUserBlocks();
        int numProductBlocks = this.numProductBlocks() == -1 ? package$.MODULE$.max(sc.defaultParallelism(), ratings.partitions().length / 2) : this.numProductBlocks();
        Tuple2 tuple2 = org.apache.spark.ml.recommendation.ALS$.MODULE$.train(ratings.map((Function1 & Serializable & scala.Serializable)r -> new ALS$Rating$mcI$sp(r.user(), r.product(), (float)r.rating()), ClassTag$.MODULE$.apply(ALS.Rating.class)), this.rank(), numUserBlocks, numProductBlocks, this.iterations(), this.lambda(), this.implicitPrefs(), this.alpha(), this.nonnegative(), this.intermediateRDDStorageLevel(), StorageLevel$.MODULE$.NONE(), this.checkpointInterval(), this.seed(), ClassTag$.MODULE$.Int(), Ordering.Int$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RDD floatUserFactors = (RDD)tuple2._1();
        RDD floatProdFactors = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)floatUserFactors, (Object)floatProdFactors);
        Tuple2 tuple23 = tuple22;
        RDD floatUserFactors2 = (RDD)tuple23._1();
        RDD floatProdFactors2 = (RDD)tuple23._2();
        RDD userFactors = RDD$.MODULE$.rddToPairRDDFunctions(floatUserFactors2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$2)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$3 -> x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).setName("users").persist(this.finalRDDStorageLevel());
        RDD prodFactors = RDD$.MODULE$.rddToPairRDDFunctions(floatProdFactors2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$4)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$5 -> x$5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).setName("products").persist(this.finalRDDStorageLevel());
        StorageLevel storageLevel = this.finalRDDStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
            userFactors.count();
            object = BoxesRunTime.boxToLong((long)prodFactors.count());
        } else {
            object = BoxedUnit.UNIT;
        }
        return new MatrixFactorizationModel(this.rank(), (RDD<Tuple2<Object, double[]>>)userFactors, (RDD<Tuple2<Object, double[]>>)prodFactors);
    }

    public MatrixFactorizationModel run(JavaRDD<Rating> ratings) {
        return this.run((RDD<Rating>)ratings.rdd());
    }

    public ALS(int numUserBlocks, int numProductBlocks, int rank, int iterations, double lambda, boolean implicitPrefs, double alpha, long seed) {
        this.numUserBlocks = numUserBlocks;
        this.numProductBlocks = numProductBlocks;
        this.rank = rank;
        this.iterations = iterations;
        this.lambda = lambda;
        this.implicitPrefs = implicitPrefs;
        this.alpha = alpha;
        this.seed = seed;
        Logging.$init$((Logging)this);
        this.nonnegative = false;
        this.intermediateRDDStorageLevel = StorageLevel$.MODULE$.MEMORY_AND_DISK();
        this.finalRDDStorageLevel = StorageLevel$.MODULE$.MEMORY_AND_DISK();
        this.checkpointInterval = 10;
    }

    public ALS() {
        this(-1, -1, 10, 10, 0.01, false, 1.0, ALS$.MODULE$.org$apache$spark$mllib$recommendation$ALS$$$lessinit$greater$default$8());
    }
}

