/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.rdd.MLPairRDDFunctions$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.BoundedPriorityQueue;
import org.json4s.JsonAST;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class MatrixFactorizationModel$
implements Loader<MatrixFactorizationModel>,
scala.Serializable {
    public static MatrixFactorizationModel$ MODULE$;

    static {
        new MatrixFactorizationModel$();
    }

    public Tuple2<Object, Object>[] org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend(double[] recommendToFeatures, RDD<Tuple2<Object, double[]>> recommendableFeatures, int num) {
        RDD scored = recommendableFeatures.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            double[] features = (double[])tuple2._2();
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(id, BLAS.getInstance().ddot(features.length, recommendToFeatures, 1, features, 1));
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])scored.top(num, scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$));
    }

    public RDD<Tuple2<Object, Tuple2<Object, Object>[]>> org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(int rank, RDD<Tuple2<Object, double[]>> srcFeatures, RDD<Tuple2<Object, double[]>> dstFeatures, int num) {
        RDD<Seq<Tuple2<Object, double[]>>> srcBlocks = this.blockify(srcFeatures, this.blockify$default$2());
        RDD<Seq<Tuple2<Object, double[]>>> dstBlocks = this.blockify(dstFeatures, this.blockify$default$2());
        RDD ratings = srcBlocks.cartesian(dstBlocks, ClassTag$.MODULE$.apply(Seq.class)).flatMap((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq srcIter = (Seq)tuple2._1();
            Seq dstIter = (Seq)tuple2._2();
            int m = srcIter.size();
            int n = package$.MODULE$.min(dstIter.size(), num);
            Tuple2[] output = new Tuple2[m * n];
            IntRef i = IntRef.create((int)0);
            BoundedPriorityQueue pq = new BoundedPriorityQueue(n, scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$));
            srcIter.foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
                MatrixFactorizationModel$.$anonfun$recommendForAll$3(rank, dstIter, output, i, pq, x0$11);
                return BoxedUnit.UNIT;
            });
            Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output)).toSeq();
            return seq;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return MLPairRDDFunctions$.MODULE$.fromPairRDD(ratings, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class)).topByKey(num, scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$));
    }

    private RDD<Seq<Tuple2<Object, double[]>>> blockify(RDD<Tuple2<Object, double[]>> features, int blockSize) {
        return features.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.grouped(blockSize), features.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Seq.class));
    }

    private int blockify$default$2() {
        return 4096;
    }

    @Override
    public MatrixFactorizationModel load(SparkContext sc, String path) {
        block5: {
            String classNameV1_0;
            String formatVersion;
            String loadedClassName;
            block4: {
                Tuple3<String, String, JsonAST.JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                String loadedClassName2 = (String)tuple3._1();
                String formatVersion2 = (String)tuple3._2();
                Tuple2 tuple2 = new Tuple2((Object)loadedClassName2, (Object)formatVersion2);
                Tuple2 tuple22 = tuple2;
                loadedClassName = (String)tuple22._1();
                formatVersion = (String)tuple22._2();
                classNameV1_0 = MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.thisClassName();
                Tuple2 tuple23 = new Tuple2((Object)loadedClassName, (Object)formatVersion);
                if (tuple23 == null) break block4;
                String className = (String)tuple23._1();
                String string = (String)tuple23._2();
                if (!"1.0".equals(string)) break block4;
                String string2 = className;
                String string3 = classNameV1_0;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) break block5;
            }
            throw new IOException(new StringBuilder(58).append("MatrixFactorizationModel.load did not recognize model with").append(new StringBuilder(33).append("(class: ").append(loadedClassName).append(", version: ").append(formatVersion).append("). Supported:\n").toString()).append(new StringBuilder(9).append("  (").append(classNameV1_0).append(", 1.0)").toString()).toString());
        }
        MatrixFactorizationModel matrixFactorizationModel = MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.load(sc, path);
        return matrixFactorizationModel;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$recommendForAll$5(Tuple2[] output$1, IntRef i$1, int srcId$1, Tuple2 x0$13) {
        Tuple2 tuple2 = x0$13;
        if (tuple2 != null) {
            int dstId = tuple2._1$mcI$sp();
            double score = tuple2._2$mcD$sp();
            output$1[i$1.elem] = new Tuple2((Object)BoxesRunTime.boxToInteger((int)srcId$1), (Object)new Tuple2.mcID.sp(dstId, score));
            ++i$1.elem;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$recommendForAll$3(int rank$1, Seq dstIter$1, Tuple2[] output$1, IntRef i$1, BoundedPriorityQueue pq$1, Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int srcId = tuple2._1$mcI$sp();
        double[] srcFactor = (double[])tuple2._2();
        dstIter$1.foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Tuple2 tuple2 = x0$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int dstId = tuple2._1$mcI$sp();
            double[] dstFactor = (double[])tuple2._2();
            double score = BLAS$.MODULE$.f2jBLAS().ddot(rank$1, srcFactor, 1, dstFactor, 1);
            BoundedPriorityQueue boundedPriorityQueue = pq$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)dstId)), (Object)BoxesRunTime.boxToDouble((double)score)));
            return boundedPriorityQueue;
        });
        pq$1.foreach((Function1 & Serializable & scala.Serializable)x0$13 -> {
            MatrixFactorizationModel$.$anonfun$recommendForAll$5(output$1, i$1, srcId, x0$13);
            return BoxedUnit.UNIT;
        });
        pq$1.clear();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private MatrixFactorizationModel$() {
        MODULE$ = this;
    }
}

